/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class CidrLauncher {
    public ProcessHandler startProcess(@NotNull CommandLineState state) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(0);
        }
        ProcessHandler result = this.createProcess(state);
        this.configProcessHandler(state, result, false, true);
        return result;
    }

    protected abstract ProcessHandler createProcess(@NotNull CommandLineState var1) throws ExecutionException;

    @NotNull
    public CidrDebugProcess startDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(1);
        }
        if (session == null) {
            CidrLauncher.$$$reportNull$$$0(2);
        }
        CidrDebugProcess result = this.createDebugProcess(state, session);
        ((XDebugSessionImpl)session).addRestartActions(this.getAdditionalActions(state, result.getProcessHandler(), (ExecutionConsole)result.getConsole()));
        this.configProcessHandler(state, result.getProcessHandler(), result.isDetachDefault(), true);
        result.start();
        CidrDebugProcess cidrDebugProcess = result;
        if (cidrDebugProcess == null) {
            CidrLauncher.$$$reportNull$$$0(3);
        }
        return cidrDebugProcess;
    }

    @NotNull
    protected abstract CidrDebugProcess createDebugProcess(@NotNull CommandLineState var1, @NotNull XDebugSession var2) throws ExecutionException;

    protected void configProcessHandler(@NotNull CommandLineState state, @NotNull ProcessHandler handler, boolean detachSupported, boolean reportExitCode) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(4);
        }
        if (handler == null) {
            CidrLauncher.$$$reportNull$$$0(5);
        }
        if (!detachSupported) {
            handler.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)Boolean.TRUE);
        }
        if (reportExitCode) {
            ProcessTerminatedListener.attach((ProcessHandler)handler, (Project)this.getProject());
        }
    }

    @NotNull
    protected abstract Project getProject();

    public void configureExecutionResult(@NotNull CommandLineState state, @NotNull DefaultExecutionResult executionResult) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(6);
        }
        if (executionResult == null) {
            CidrLauncher.$$$reportNull$$$0(7);
        }
        executionResult.setRestartActions(this.getAdditionalActions(state, executionResult.getProcessHandler(), executionResult.getExecutionConsole()));
    }

    @NotNull
    private AnAction[] getAdditionalActions(@NotNull CommandLineState state, ProcessHandler handler, ExecutionConsole console) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(8);
        }
        ArrayList<AnAction> actions = new ArrayList<AnAction>();
        this.collectAdditionalActions(state, handler, console, actions);
        AnAction[] anActionArray = actions.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CidrLauncher.$$$reportNull$$$0(9);
        }
        return anActionArray;
    }

    protected void collectAdditionalActions(@NotNull CommandLineState state, @NotNull ProcessHandler processHandler, @NotNull ExecutionConsole console, @NotNull List<AnAction> actions) throws ExecutionException {
        if (state == null) {
            CidrLauncher.$$$reportNull$$$0(10);
        }
        if (processHandler == null) {
            CidrLauncher.$$$reportNull$$$0(11);
        }
        if (console == null) {
            CidrLauncher.$$$reportNull$$$0(12);
        }
        if (actions == null) {
            CidrLauncher.$$$reportNull$$$0(13);
        }
        if (state instanceof CidrTestCommandLineState) {
            actions.add((AnAction)((CidrTestCommandLineState)state).createRerunFailedTestsAction(console));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrLauncher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionResult";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrLauncher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "startDebugProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startDebugProcess";
                break;
            }
            case 3: 
            case 9: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configProcessHandler";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "configureExecutionResult";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalActions";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "collectAdditionalActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

