/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.console.ConsoleViewWrapperBase;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.Producer;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsActionEx;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrCommandLineState {
    @NotNull
    private final Executor myExecutor;
    @NotNull
    protected final CONFIGURATION myConfiguration;
    @Nullable
    protected final CidrTestScope myFailedTests;
    @NotNull
    private final Producer<CidrTestScope> myEmptyTestScopeProducer;

    public CidrTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests, @NotNull Producer<CidrTestScope> emptyTestScopeProducer) {
        if (configuration == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(3);
        }
        if (emptyTestScopeProducer == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(4);
        }
        super(env, launcher);
        this.myConfiguration = configuration;
        this.myExecutor = executor;
        this.myFailedTests = failedTests;
        this.myEmptyTestScopeProducer = emptyTestScopeProducer;
    }

    @NotNull
    public Executor getExecutor() {
        Executor executor = this.myExecutor;
        if (executor == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(5);
        }
        return executor;
    }

    @NotNull
    public CONFIGURATION getConfiguration() {
        CONFIGURATION CONFIGURATION = this.myConfiguration;
        if (CONFIGURATION == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(6);
        }
        return CONFIGURATION;
    }

    @NotNull
    public CidrRerunFailedTestsAction createRerunFailedTestsAction(@NotNull ExecutionConsole console) {
        if (console == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(7);
        }
        SMTRunnerConsoleView consoleView = CidrTestCommandLineState.getConsole(console);
        CidrRerunFailedTestsAction rerunFailedTestsAction = this.doCreateRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.init(consoleView.getProperties());
        rerunFailedTestsAction.setModelProvider(() -> consoleView.getResultsViewer());
        CidrRerunFailedTestsAction cidrRerunFailedTestsAction = rerunFailedTestsAction;
        if (cidrRerunFailedTestsAction == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(8);
        }
        return cidrRerunFailedTestsAction;
    }

    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            CidrTestScope cidrTestScope = this.myFailedTests;
            if (cidrTestScope == null) {
                CidrTestCommandLineState.$$$reportNull$$$0(9);
            }
            return cidrTestScope;
        }
        CidrTestRunConfigurationData delegate = this.myConfiguration.getTestData();
        String pattern = StringUtil.notNullize((String)delegate.getTestPattern());
        CidrTestScope testScope = this.createEmptyTestScope();
        CidrTestScope cidrTestScope = delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN && !pattern.isEmpty() ? testScope.configureForPreRenderedScope(pattern) : testScope.addScopeElement(this.createTestScopeElement(delegate.getTestSuite(), delegate.getTestName()));
        if (cidrTestScope == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(10);
        }
        return cidrTestScope;
    }

    @Contract(pure=true)
    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(11);
        }
        return cl;
    }

    @NotNull
    public ConsoleView createConsole(@NotNull CidrConsoleBuilder builder) {
        if (builder == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(12);
        }
        ConsoleView consoleView = builder.createConsole(this.myConfiguration.getType(), this.myConfiguration.getTestData().createTestConsoleProperties(this.getExecutor(), this.getExecutionTarget()));
        if (consoleView == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(13);
        }
        return consoleView;
    }

    protected CidrTestScope createEmptyTestScope() {
        return (CidrTestScope)this.myEmptyTestScopeProducer.produce();
    }

    @NotNull
    protected abstract CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView var1);

    @NotNull
    protected static CidrRerunFailedTestsAction doCreateRerunFailedTestsActionStandard(@NotNull CidrTestCommandLineState<?> self, @NotNull SMTRunnerConsoleView consoleView, @NotNull String protocolPrefix) {
        if (self == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(14);
        }
        if (consoleView == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(15);
        }
        if (protocolPrefix == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(16);
        }
        CidrRerunFailedTestsActionEx cidrRerunFailedTestsActionEx = new CidrRerunFailedTestsActionEx((ComponentContainer)consoleView, (Function<Pair<AbstractTestProxy, Project>, String>)((Function)testContext -> {
            String url;
            if (protocolPrefix == null) {
                CidrTestCommandLineState.$$$reportNull$$$0(20);
            }
            if ((url = ((AbstractTestProxy)testContext.first).getLocationUrl()) != null && url.startsWith(protocolPrefix)) {
                return url.substring(protocolPrefix.length());
            }
            return null;
        }), self);
        if (cidrRerunFailedTestsActionEx == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(17);
        }
        return cidrRerunFailedTestsActionEx;
    }

    @NotNull
    protected abstract CidrTestScopeElement createTestScopeElement(@Nullable String var1, @Nullable String var2);

    @NotNull
    private static SMTRunnerConsoleView getConsole(@NotNull ExecutionConsole console) {
        if (console == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(18);
        }
        SMTRunnerConsoleView sMTRunnerConsoleView = console instanceof ConsoleViewWrapperBase ? (SMTRunnerConsoleView)((ConsoleViewWrapperBase)console).getDelegate() : (SMTRunnerConsoleView)console;
        if (sMTRunnerConsoleView == null) {
            CidrTestCommandLineState.$$$reportNull$$$0(19);
        }
        return sMTRunnerConsoleView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyTestScopeProducer";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestCommandLineState";
                break;
            }
            case 7: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 16: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestCommandLineState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createRerunFailedTestsAction";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "testScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsole";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRerunFailedTestsActionStandard";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getConsole";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createRerunFailedTestsAction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsActionStandard";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getConsole";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doCreateRerunFailedTestsActionStandard$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 17: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

