/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.OCTestFramework;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.AbstractGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestFrameworkBase<TEST_OBJECT>
extends OCTestFramework {
    private static BooleanSupplier ourIsNotInEDT = () -> {
        Application application = ApplicationManager.getApplication();
        return !application.isDispatchThread() || application.isUnitTestMode();
    };
    protected final NotNullLazyKey<CachedValue<CidrTestFrameworkVersion>, PsiFile> myFrameworkVersionInFileKey;
    protected final NotNullLazyKey<CachedValue<TEST_OBJECT>, PsiElement> myIsTestKey;
    protected final Class<? extends PsiFile> myFrameworkFileClass;
    protected final Collection<Class<? extends PsiElement>> myTestHolderClass;
    protected static final Map<String, CidrTestScopeElement> EMPTY_MAP = new HashMap<String, CidrTestScopeElement>();

    @Contract(pure=true)
    @NotNull
    protected static Function<PsiFile, ModificationTracker> getCidrTopLevelChangesModificationTracker() {
        Function function = file -> FileSymbolTablesCache.getInstance(file.getProject()).getOCOutOfBlockModificationTracker();
        if (function == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(0);
        }
        return function;
    }

    protected CidrTestFrameworkBase(@NonNls @NotNull String testFrameworkId, @NotNull Function<PsiFile, ModificationTracker> modificationTrackerProducer, @NotNull Class<? extends PsiFile> fileClass, Class<? extends PsiElement> ... testHolderClass) {
        if (testFrameworkId == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(1);
        }
        if (modificationTrackerProducer == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(2);
        }
        if (fileClass == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(3);
        }
        if (testHolderClass == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(4);
        }
        this.myTestHolderClass = Arrays.asList(testHolderClass);
        this.myFrameworkFileClass = fileClass;
        this.myFrameworkVersionInFileKey = NotNullLazyKey.create((String)(testFrameworkId + " in File"), file -> {
            if (modificationTrackerProducer == null) {
                CidrTestFrameworkBase.$$$reportNull$$$0(23);
            }
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                if (modificationTrackerProducer == null) {
                    CidrTestFrameworkBase.$$$reportNull$$$0(24);
                }
                return new CachedValueProvider.Result((Object)this.createFrameworkVersionDirectly((PsiFile)file), new Object[]{modificationTrackerProducer.fun(file)});
            }, false);
        });
        this.myIsTestKey = NotNullLazyKey.create((String)(testFrameworkId + " test"), element -> {
            if (modificationTrackerProducer == null) {
                CidrTestFrameworkBase.$$$reportNull$$$0(21);
            }
            return CachedValuesManager.getManager((Project)element.getProject()).createCachedValue(() -> {
                if (modificationTrackerProducer == null) {
                    CidrTestFrameworkBase.$$$reportNull$$$0(22);
                }
                return new CachedValueProvider.Result(this.extractTest((PsiElement)element), new Object[]{modificationTrackerProducer.fun((Object)element.getContainingFile())});
            }, false);
        });
    }

    @Contract(value="null -> null")
    public TEST_OBJECT getTestObject(@Nullable PsiElement element) {
        return (TEST_OBJECT)(element != null && this.isAvailable(element.getContainingFile()) && this.canBeTestHolder(element) && CidrTestFrameworkBase.hasPrecalculatedValueInEDT((UserDataHolder)element, this.myIsTestKey) ? ((CachedValue)this.myIsTestKey.getValue((UserDataHolder)element)).getValue() : null);
    }

    @Nullable
    public TEST_OBJECT findTestObject(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(5);
        }
        PsiElement prev = element;
        for (PsiElement current = element; current != null; current = current.getParent()) {
            if (current instanceof PsiFile) {
                return (TEST_OBJECT)(prev instanceof PsiWhiteSpace || prev instanceof PsiComment || prev instanceof PsiFile || this.isNeutralNode(prev) ? this.createFileTestObjectIfPossible((PsiFile)current) : null);
            }
            TEST_OBJECT testObject = this.getTestObject(current);
            if (testObject != null) {
                return testObject;
            }
            if (this.isScopeDelimiter(current)) continue;
            prev = current;
        }
        return null;
    }

    @Contract(pure=true)
    protected boolean isScopeDelimiter(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(6);
        }
        return element instanceof OCCppNamespace;
    }

    @Contract(pure=true)
    protected boolean isNeutralNode(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(7);
        }
        return element instanceof OCDirective || element.getParent() instanceof OCCppNamespace && (element == ((OCCppNamespace)element.getParent()).getNameIdentifier() || PsiTreeUtil.findSiblingBackward((PsiElement)element, (IElementType)OCTokenTypes.LBRACE, (boolean)true, null) == null);
    }

    @Nullable
    protected abstract TEST_OBJECT createFileTestObjectIfPossible(@NotNull PsiFile var1);

    private static <T, H extends UserDataHolder> boolean hasPrecalculatedValueInEDT(@NotNull UserDataHolder holder, @NotNull NotNullLazyKey<T, H> key) {
        if (holder == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(8);
        }
        if (key == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(9);
        }
        return ourIsNotInEDT.getAsBoolean() || key.isIn(holder);
    }

    public static void checkPrecalculatedSymbolsInEDT(@NotNull Project project2) {
        if (project2 == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(10);
        }
        if (ourIsNotInEDT.getAsBoolean() || FileSymbolTablesCache.areSymbolsLoaded(project2)) {
            return;
        }
        throw IndexNotReadyException.create();
    }

    private boolean canBeTestHolder(@NotNull PsiElement element) {
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(11);
        }
        for (Class<? extends PsiElement> aClass : this.myTestHolderClass) {
            if (!aClass.isInstance(element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    protected abstract TEST_OBJECT extractTest(@NotNull PsiElement var1);

    @Override
    public boolean isAvailable(@Nullable PsiFile file) {
        try {
            return file == null || FileSymbolTablesCache.areSymbolsLoaded(file.getProject()) && this.getFrameworkVersion(file) != CidrTestFrameworkVersion.NOT_AVAILABLE;
        }
        catch (IndexNotReadyException ignore) {
            return false;
        }
    }

    @NotNull
    public CidrTestFrameworkVersion getFrameworkVersion(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(12);
        }
        CidrTestFrameworkVersion cidrTestFrameworkVersion = this.myFrameworkFileClass.isInstance(file) ? (CidrTestFrameworkVersion)((CachedValue)this.myFrameworkVersionInFileKey.getValue((UserDataHolder)file)).getValue() : CidrTestFrameworkVersion.NOT_AVAILABLE;
        if (cidrTestFrameworkVersion == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(13);
        }
        return cidrTestFrameworkVersion;
    }

    @NotNull
    protected abstract CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile var1);

    @NotNull
    protected static CidrTestFrameworkVersion getFrameworkVersionUsingImportedMacro(@NotNull PsiFile file, @NotNull String macroName) {
        if (file == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(14);
        }
        if (macroName == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(15);
        }
        CidrTestFrameworkBase.checkPrecalculatedSymbolsInEDT(file.getProject());
        Ref symbolFromFrameworkWasFound = new Ref((Object)CidrTestFrameworkVersion.NOT_AVAILABLE);
        AbstractGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(OCGlobalProjectSymbolsCache.class, file.getProject(), symbol -> {
            if (file == null) {
                CidrTestFrameworkBase.$$$reportNull$$$0(20);
            }
            if (symbol instanceof OCMacroSymbol && OCFileSymbols.isSymbolImported((OCFile)file, symbol)) {
                symbolFromFrameworkWasFound.set((Object)CidrTestFrameworkVersion.DEFAULT);
                return false;
            }
            return true;
        }, macroName, true);
        CidrTestFrameworkVersion cidrTestFrameworkVersion = (CidrTestFrameworkVersion)symbolFromFrameworkWasFound.get();
        if (cidrTestFrameworkVersion == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(16);
        }
        return cidrTestFrameworkVersion;
    }

    @NotNull
    public abstract String getPatternSeparatorInCommandLine();

    @NotNull
    public static <T extends OCTestFramework> T findExtension(@NotNull Class<T> extClass) {
        if (extClass == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(17);
        }
        OCTestFramework oCTestFramework = (OCTestFramework)Extensions.findExtension(OCTestFramework.EP_NAME, extClass);
        if (oCTestFramework == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(18);
        }
        return (T)oCTestFramework;
    }

    public static boolean isMacroInjected(@NotNull PsiElement element) {
        PsiElement identifier;
        if (element == null) {
            CidrTestFrameworkBase.$$$reportNull$$$0(19);
        }
        if (element.getTextLength() == 0) {
            return true;
        }
        if (element instanceof OCFunctionDeclaration) {
            identifier = ((OCFunctionDeclaration)element).getNameIdentifier();
        } else if (element instanceof PsiNameIdentifierOwner) {
            identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier();
        } else {
            return false;
        }
        return identifier == null || identifier.getTextLength() == 0;
    }

    public static void forceIsNotInEDT(@Nullable BooleanSupplier force) {
        ourIsNotInEDT = force;
    }

    @Contract(pure=true)
    public static BooleanSupplier getIsNotInEDT() {
        return ourIsNotInEDT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestFrameworkBase";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkId";
                break;
            }
            case 2: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationTrackerProducer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testHolderClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCidrTopLevelChangesModificationTracker";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestFrameworkBase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkVersion";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getFrameworkVersionUsingImportedMacro";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findExtension";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findTestObject";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isScopeDelimiter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isNeutralNode";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "hasPrecalculatedValueInEDT";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkPrecalculatedSymbolsInEDT";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "canBeTestHolder";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkVersion";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFrameworkVersionUsingImportedMacro";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isMacroInjected";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getFrameworkVersionUsingImportedMacro$6";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$5";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$4";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$3";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class FrameworkHolder<TEST_FRAMEWORK extends CidrTestFrameworkBase> {
        private final Class<TEST_FRAMEWORK> myFrameworkClass;
        private final NotNullLazyValue<TEST_FRAMEWORK> myTestFramework = new NotNullLazyValue<TEST_FRAMEWORK>(){

            @NotNull
            @Contract(pure=true)
            protected TEST_FRAMEWORK compute() {
                CidrTestFrameworkBase cidrTestFrameworkBase = (CidrTestFrameworkBase)CidrTestFrameworkBase.findExtension(myFrameworkClass);
                if (cidrTestFrameworkBase == null) {
                    1.$$$reportNull$$$0(0);
                }
                return cidrTestFrameworkBase;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestFrameworkBase$FrameworkHolder$1", "compute"));
            }
        };

        public FrameworkHolder(Class<TEST_FRAMEWORK> frameworkClass) {
            this.myFrameworkClass = frameworkClass;
        }

        public TEST_FRAMEWORK getInstance() {
            return (TEST_FRAMEWORK)((CidrTestFrameworkBase)this.myTestFramework.getValue());
        }
    }
}

