/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import java.lang.reflect.Modifier;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationData<CONFIGURATION extends CidrTestRunConfiguration>
implements JDOMExternalizable,
Cloneable {
    @Nullable
    public String myTestSuite;
    @Nullable
    public String myTestName;
    @Nullable
    protected String myTestPattern;
    @NotNull
    protected Mode myTestMode;
    @NotNull
    protected CONFIGURATION myConfiguration;

    public void checkData() throws RuntimeConfigurationException {
        CidrTestFrameworkBase.checkPrecalculatedSymbolsInEDT(this.myConfiguration.getProject());
    }

    public CidrTestRunConfigurationData(@NotNull CONFIGURATION configuration) {
        if (configuration == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(0);
        }
        this.myTestMode = Mode.SUITE_TEST;
        this.myConfiguration = configuration;
        assert (!CidrTestRunConfigurationData.isPotentiallyThisCapturing(this.getClass())) : "TestData must not be initialized from an inner/anonymous (non-static) class. Otherwise it will leak in clone() and cause unexpected behavior";
    }

    static boolean isPotentiallyThisCapturing(Class<?> clazz) {
        return clazz.getEnclosingClass() != null && !Modifier.isStatic(clazz.getModifiers());
    }

    @Nullable
    public String getTestSuite() {
        return this.myTestSuite;
    }

    public void setSuiteName(@Nullable String testSuite) {
        this.myTestSuite = StringUtil.nullize((String)testSuite, (boolean)true);
    }

    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    public void setTestName(@Nullable String testName) {
        this.myTestName = StringUtil.nullize((String)testName, (boolean)true);
    }

    @Nullable
    public String getTestPattern() {
        return this.myTestPattern;
    }

    public void setTestPattern(@Nullable String testPattern) {
        this.myTestPattern = testPattern;
    }

    @NotNull
    public Mode getTestMode() {
        Mode mode = this.myTestMode;
        if (mode == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(1);
        }
        return mode;
    }

    public void setTestMode(@NotNull Mode mode) {
        if (mode == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(2);
        }
        this.myTestMode = mode;
    }

    @NotNull
    public String suggestedName(@Nullable String fallbackName) {
        if (this.myTestSuite != null && this.myTestName != null) {
            String string = this.formatTestMethod();
            if (string == null) {
                CidrTestRunConfigurationData.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (this.myTestMode == Mode.PATTERN) {
            if ("Pattern" == null) {
                CidrTestRunConfigurationData.$$$reportNull$$$0(4);
            }
            return "Pattern";
        }
        String scopeName = this.myTestSuite != null ? this.myTestSuite : fallbackName;
        String string = scopeName == null ? CidrBundle.message("test.defaultName.allTests", new Object[0]) : CidrBundle.message("test.defaultName.allTestsIn", scopeName);
        if (string == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    protected abstract String formatTestMethod();

    public void readExternal(Element element) throws InvalidDataException {
        this.setSuiteName(element.getAttributeValue("TEST_CLASS"));
        this.setTestName(element.getAttributeValue("TEST_METHOD"));
        this.setTestPattern(element.getAttributeValue("TEST_PATTERN"));
        String modeValue = element.getAttributeValue("TEST_MODE");
        this.setTestMode(modeValue == null || modeValue.equals("SUITE_TEST") ? Mode.SUITE_TEST : Mode.PATTERN);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        switch (this.myTestMode) {
            case SUITE_TEST: {
                if (this.myTestSuite != null) {
                    element.setAttribute("TEST_CLASS", this.myTestSuite);
                }
                if (this.myTestName == null) break;
                element.setAttribute("TEST_METHOD", this.myTestName);
                break;
            }
            case PATTERN: {
                if (this.myTestPattern == null) break;
                element.setAttribute("TEST_PATTERN", this.myTestPattern);
            }
        }
        element.setAttribute("TEST_MODE", this.myTestMode.name());
    }

    public CidrTestRunConfigurationData cloneForConfiguration(@NotNull CidrTestRunConfiguration configuration) {
        if (configuration == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(6);
        }
        try {
            CidrTestRunConfigurationData result = this.clone();
            result.myConfiguration = configuration;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    protected CidrTestRunConfigurationData clone() throws CloneNotSupportedException {
        CidrTestRunConfigurationData result = (CidrTestRunConfigurationData)super.clone();
        result.myTestSuite = this.myTestSuite;
        result.myTestName = this.myTestName;
        result.myTestPattern = this.myTestPattern;
        result.myTestMode = this.myTestMode;
        return result;
    }

    public boolean equalTo(@NotNull CidrTestScopeElement scope) {
        if (scope == null) {
            CidrTestRunConfigurationData.$$$reportNull$$$0(7);
        }
        return scope.isPatternLike() ? this.getTestMode() == Mode.PATTERN && Comparing.equal((String)this.getTestPattern(), (String)scope.getPatternForCommandLine()) : this.getTestMode() == Mode.SUITE_TEST && Comparing.equal((String)this.getTestSuite(), (String)scope.getSuiteName()) && Comparing.equal((String)this.getTestName(), (String)scope.getTestName());
    }

    @Nullable
    public abstract SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor var1, @NotNull ExecutionTarget var2);

    @NonNls
    @Nullable
    public abstract String getTestingFrameworkId();

    public abstract CidrCommandLineState createState(@NotNull ExecutionEnvironment var1, @NotNull Executor var2, @Nullable CidrTestScope var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMode";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setTestMode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cloneForConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "equalTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum Mode {
        SUITE_TEST,
        PATTERN;

    }
}

