/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrTargetRunConfigurationBinder;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, TEST_FRAMEWORK extends CidrTestFrameworkBase<TEST_OBJECT>, TEST_OBJECT>
extends CidrContextRunConfigurationProducer<BC, TARGET, CONFIGURATION> {
    protected CidrTestRunConfigurationProducer(@NotNull ConfigurationType configurationType, @NotNull CidrTargetRunConfigurationBinder<BC, TARGET, ? super CONFIGURATION> binder) {
        if (configurationType == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (binder == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        super(configurationType, binder);
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<TEST_OBJECT> objects;
        if (configuration == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if (sourceElement == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if ((objects = this.findTestObjects(context)).isEmpty()) {
            return false;
        }
        CidrTestScopeElement scope = this.determineScope((TEST_OBJECT)objects);
        if (scope == null) {
            return false;
        }
        TEST_OBJECT testObj = objects.get(0);
        this.setupTarget(configuration, this.getTargetsForFile(this.getElement(testObj).getContainingFile(), target -> this.isTestTarget(target)));
        this.setupConfiguration(configuration, scope);
        sourceElement.set((Object)this.getElement(testObj));
        return true;
    }

    @NotNull
    protected abstract PsiElement getElement(@NotNull TEST_OBJECT var1);

    protected abstract boolean isTestTarget(@NotNull TARGET var1);

    @Nullable
    protected CidrTestScopeElement determineScope(@NotNull List<TEST_OBJECT> objects) {
        if (objects == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        return this.foldScope(ContainerUtil.mapNotNull(objects, e -> this.containingFileCanUseFramework(this.getElement(e)) ? this.determineScope(e) : null));
    }

    @Nullable
    protected CidrTestScopeElement determineScope(@NotNull ConfigurationContext context) {
        if (context == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        return this.determineScope((TEST_OBJECT)this.findTestObjects(context));
    }

    @Nullable
    protected abstract CidrTestScopeElement determineScope(@NotNull TEST_OBJECT var1);

    @NotNull
    protected List<TEST_OBJECT> findTestObjects(@NotNull ConfigurationContext context) {
        if (context == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.mapNotNull(this.getLocations(context), e -> this.containingFileCanUseFramework(e.getPsiElement()) ? this.findTestObject((Location)e) : null);
        if (list == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    protected TEST_OBJECT findTestObject(@NotNull Location location) {
        if (location == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        return ((CidrTestFrameworkBase)this.getTestFramework()).findTestObject(location.getPsiElement());
    }

    public boolean isConfigurationFromContext(CONFIGURATION configuration, ConfigurationContext context) {
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return false;
        }
        CidrTestScopeElement scope = this.determineScope(context);
        if (scope == null) {
            return false;
        }
        return delegate.equalTo(scope);
    }

    @Contract(value="null -> null")
    @Nullable
    private CidrTestRunConfigurationData getDelegate(CONFIGURATION configuration) {
        return configuration instanceof CidrTestRunConfiguration ? ((CidrTestRunConfiguration)configuration).getTestData() : null;
    }

    protected void setupConfiguration(CONFIGURATION configuration, CidrTestScopeElement scope) {
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return;
        }
        if (scope.isPatternLike()) {
            delegate.setSuiteName(null);
            delegate.setTestName(null);
            delegate.setTestPattern(scope.getPatternForCommandLine());
            delegate.setTestMode(CidrTestRunConfigurationData.Mode.PATTERN);
        } else {
            delegate.setSuiteName(scope.getSuiteName());
            delegate.setTestName(scope.getTestName());
            delegate.setTestPattern(null);
            delegate.setTestMode(CidrTestRunConfigurationData.Mode.SUITE_TEST);
        }
        String configurationName = scope.getConfigurationName();
        configuration.setName(configurationName == null ? delegate.suggestedName(((CidrRunConfiguration)configuration).suggestNameForTarget()) : configurationName);
    }

    @NotNull
    protected List<Location> getLocations(@NotNull ConfigurationContext context) {
        Object[] psiElements;
        Object[] paths;
        SMTRunnerTestTreeView treeView;
        if (context == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if ((treeView = (SMTRunnerTestTreeView)SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW.getData(context.getDataContext())) != null && (paths = treeView.getSelectionPaths()) != null && paths.length > 1) {
            GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(context.getProject());
            List list = ContainerUtil.mapNotNull((Object[])paths, path -> {
                if (context == null) {
                    CidrTestRunConfigurationProducer.$$$reportNull$$$0(18);
                }
                if (treeView.isPathSelected(path.getParentPath())) {
                    return null;
                }
                SMTestProxy test = treeView.getSelectedTest(path);
                return test == null ? null : test.getLocation(context.getProject(), scope);
            });
            if (list == null) {
                CidrTestRunConfigurationProducer.$$$reportNull$$$0(11);
            }
            return list;
        }
        if (context.containsMultipleSelection() && (psiElements = (PsiElement[])LangDataKeys.PSI_ELEMENT_ARRAY.getData(context.getDataContext())) != null) {
            List list = ContainerUtil.mapNotNull((Object[])psiElements, e -> {
                if (context == null) {
                    CidrTestRunConfigurationProducer.$$$reportNull$$$0(17);
                }
                return new PsiLocation(context.getProject(), e);
            });
            if (list == null) {
                CidrTestRunConfigurationProducer.$$$reportNull$$$0(12);
            }
            return list;
        }
        Location location = context.getLocation();
        if (location == null) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                CidrTestRunConfigurationProducer.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<Location> list = Collections.singletonList(location);
        if (list == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        return list;
    }

    @Nullable
    protected CidrTestScopeElement foldScope(@NotNull List<CidrTestScopeElement> elements) {
        if (elements == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        Ref firstName = new Ref();
        List res = ContainerUtil.map(elements, scope -> {
            firstName.setIfNull((Object)scope.getConfigurationName());
            return scope.getPatternForCommandLine();
        });
        if (res.isEmpty()) {
            return null;
        }
        String name2 = (String)firstName.get();
        if (res.size() > 1) {
            name2 = name2 + String.format(" and %d more", res.size() - 1);
        }
        return CidrTestScopeElement.createTestScopeWithPatternAndConfigurationName(name2, StringUtil.join(new LinkedHashSet(res), (String)((CidrTestFrameworkBase)this.getTestFramework()).getPatternSeparatorInCommandLine()));
    }

    @Contract(pure=true)
    protected boolean containingFileCanUseFramework(@NotNull PsiElement context) {
        if (context == null) {
            CidrTestRunConfigurationProducer.$$$reportNull$$$0(16);
        }
        return ((CidrTestFrameworkBase)this.getTestFramework()).isAvailable(context.getContainingFile());
    }

    @NotNull
    protected abstract TEST_FRAMEWORK getTestFramework();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objects";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationProducer";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestRunConfigurationProducer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findTestObjects";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "determineScope";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findTestObjects";
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTestObject";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getLocations";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "foldScope";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "containingFileCanUseFramework";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLocations$4";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getLocations$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

