/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.OCLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class CidrTestScope {
    private final String mySeparator;
    private List<CidrTestScopeElement> myElements;
    private String myPreRenderedScope;

    private CidrTestScope(@NotNull String separator) {
        if (separator == null) {
            CidrTestScope.$$$reportNull$$$0(0);
        }
        this.mySeparator = String.valueOf(separator);
    }

    public List<CidrTestScopeElement> getElements() {
        OCLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.createElementCollectionIfNull();
        return Collections.unmodifiableList(this.myElements.stream().sorted().distinct().collect(Collectors.toList()));
    }

    @NotNull
    public static CidrTestScope createEmptyTestScope(@NotNull String separator) {
        if (separator == null) {
            CidrTestScope.$$$reportNull$$$0(1);
        }
        CidrTestScope cidrTestScope = new CidrTestScope(separator);
        if (cidrTestScope == null) {
            CidrTestScope.$$$reportNull$$$0(2);
        }
        return cidrTestScope;
    }

    @NotNull
    public CidrTestScope configureForPreRenderedScope(@NotNull String switches2) {
        if (switches2 == null) {
            CidrTestScope.$$$reportNull$$$0(3);
        }
        OCLog.LOG.assertTrue(this.myPreRenderedScope == null && this.myElements == null);
        this.myPreRenderedScope = switches2;
        CidrTestScope cidrTestScope = this;
        if (cidrTestScope == null) {
            CidrTestScope.$$$reportNull$$$0(4);
        }
        return cidrTestScope;
    }

    public CidrTestScope addScopeElement(@NotNull CidrTestScopeElement element) {
        if (element == null) {
            CidrTestScope.$$$reportNull$$$0(5);
        }
        OCLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.createElementCollectionIfNull();
        this.myElements.add(element);
        return this;
    }

    public String toString() {
        return this.getAsPattern();
    }

    public String getAsPattern() {
        return this.myPreRenderedScope != null ? this.myPreRenderedScope : StringUtil.join(this.getAsPatternList(), (String)this.mySeparator);
    }

    public List<String> getAsPatternList() {
        if (this.myPreRenderedScope != null) {
            return StringUtil.split((String)this.myPreRenderedScope, (String)this.mySeparator);
        }
        this.createElementCollectionIfNull();
        return this.myElements.stream().sorted(Comparator.comparingLong(CidrTestScopeElement::getSortIndex)).distinct().map(scope -> scope.getPatternForCommandLine()).collect(Collectors.toList());
    }

    private void createElementCollectionIfNull() {
        if (this.myElements == null) {
            this.myElements = new ArrayList<CidrTestScopeElement>();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScope";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switches";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScope";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyTestScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "configureForPreRenderedScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createEmptyTestScope";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "configureForPreRenderedScope";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addScopeElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

