/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Producer;
import com.intellij.util.SofterReference;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReference;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestScopeElement
implements Comparable<CidrTestScopeElement> {
    @Nullable
    protected final String mySuiteName;
    @Nullable
    protected final String myTestName;
    @Nullable
    protected final ProtertiesGenerator myDelegate;
    public static final char PATH_SEPARATOR = '/';
    public static final long DEFAULT_TEST_ORDER = -1L;
    public static final String SEPARATOR = String.valueOf('/');

    protected CidrTestScopeElement(@Nullable String suiteName, @Nullable String testName) {
        this(suiteName, testName, (Function<CidrTestScopeElement, ProtertiesGenerator>)((Function)self -> new DefaultPropertiesGenerator((CidrTestScopeElement)self)));
    }

    public CidrTestScopeElement(@Nullable String suiteName, @Nullable String testName, @Nullable Function<CidrTestScopeElement, ProtertiesGenerator> factory2) {
        this.mySuiteName = StringUtil.nullize((String)suiteName, (boolean)true);
        this.myTestName = StringUtil.nullize((String)testName, (boolean)true);
        this.myDelegate = factory2 == null ? null : (ProtertiesGenerator)factory2.fun((Object)this);
    }

    public CidrTestScopeElement() {
        this(null, null, null);
    }

    @Nullable
    public String getSuiteName() {
        return this.mySuiteName;
    }

    @Nullable
    public String getTestName() {
        return this.myTestName;
    }

    public boolean isTest() {
        return this.myTestName != null;
    }

    public boolean isPatternLike() {
        return false;
    }

    @NotNull
    public PsiElement getElement() {
        CidrTestScopeElement.throwNotDefined();
        if (null == null) {
            CidrTestScopeElement.$$$reportNull$$$0(0);
        }
        return null;
    }

    public long getSortIndex() {
        return -1L;
    }

    @Contract(value=" -> fail")
    private static void throwNotDefined() {
        throw new RuntimeException("Not defined");
    }

    @NotNull
    public String getTestPath() {
        this.checkDelegateNotNull();
        String string = this.myDelegate.getTestPath();
        if (string == null) {
            CidrTestScopeElement.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getPatternForCommandLine() {
        this.checkDelegateNotNull();
        String string = this.myDelegate.getPatternForCommandLine();
        if (string == null) {
            CidrTestScopeElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public String getConfigurationName() {
        this.checkDelegateNotNull();
        return this.myDelegate.getConfigurationName();
    }

    private void checkDelegateNotNull() {
        if (this.myDelegate == null) {
            CidrTestScopeElement.throwNotDefined();
        }
    }

    @NotNull
    public String toString() {
        String string = this.getPatternForCommandLine();
        if (string == null) {
            CidrTestScopeElement.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CidrTestScopeElement)) {
            return false;
        }
        return this.getPatternForCommandLine().equals(((CidrTestScopeElement)o).getPatternForCommandLine());
    }

    public int hashCode() {
        return this.getPatternForCommandLine().hashCode();
    }

    @Override
    public int compareTo(CidrTestScopeElement o) {
        return StringUtil.compare((String)this.getPatternForCommandLine(), (String)o.getPatternForCommandLine(), (boolean)false);
    }

    @NotNull
    public static String createPathFromParts(Collection<String> suites) {
        String string = CidrTestScopeElement.createPathFromParts(ArrayUtil.toStringArray(suites));
        if (string == null) {
            CidrTestScopeElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String createPathFromParts(String ... suites) {
        StringBuilder path = new StringBuilder();
        for (String suite : suites) {
            if (path.length() != 0) {
                path.append('/');
            }
            path.append(suite);
        }
        String string = path.toString();
        if (string == null) {
            CidrTestScopeElement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public static List<String> splitPath(@NotNull String pathWithoutProtololPrefix) {
        if (pathWithoutProtololPrefix == null) {
            CidrTestScopeElement.$$$reportNull$$$0(6);
        }
        List list = StringUtil.split((String)pathWithoutProtololPrefix, (String)SEPARATOR);
        if (list == null) {
            CidrTestScopeElement.$$$reportNull$$$0(7);
        }
        return list;
    }

    @NotNull
    @Contract(pure=true)
    public static CidrTestScopeElement createFileTestScopeElement(final @NotNull PsiFile file, final @NotNull Producer<String> patternForCommandLine) {
        if (file == null) {
            CidrTestScopeElement.$$$reportNull$$$0(8);
        }
        if (patternForCommandLine == null) {
            CidrTestScopeElement.$$$reportNull$$$0(9);
        }
        CidrTestScopeElement cidrTestScopeElement = new CidrTestScopeElement(){

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public String getConfigurationName() {
                String string = CidrBundle.message("test.defaultName.allTestsIn", file.getName());
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getPatternForCommandLine() {
                String string = StringUtil.notNullize((String)((String)patternForCommandLine.produce()));
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiFile psiFile = file;
                if (psiFile == null) {
                    1.$$$reportNull$$$0(2);
                }
                return psiFile;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElement$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConfigurationName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPatternForCommandLine";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (cidrTestScopeElement == null) {
            CidrTestScopeElement.$$$reportNull$$$0(10);
        }
        return cidrTestScopeElement;
    }

    @NotNull
    @Contract(pure=true)
    public static CidrTestScopeElement createTestScopeElementForVirtualTestPath(final @NotNull String virtualTestPath, final @NotNull String configurationName, final @NotNull CidrTestScopeElement realElement, @Nullable Function<CidrTestScopeElement, ProtertiesGenerator> factory2) {
        if (virtualTestPath == null) {
            CidrTestScopeElement.$$$reportNull$$$0(11);
        }
        if (configurationName == null) {
            CidrTestScopeElement.$$$reportNull$$$0(12);
        }
        if (realElement == null) {
            CidrTestScopeElement.$$$reportNull$$$0(13);
        }
        CidrTestScopeElement cidrTestScopeElement = new CidrTestScopeElement(null, null, factory2){

            @Override
            public boolean isPatternLike() {
                return true;
            }

            @Override
            @NotNull
            public String getConfigurationName() {
                String string = configurationName;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getTestPath() {
                String string = virtualTestPath;
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiElement psiElement = realElement.getElement();
                if (psiElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElement$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConfigurationName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTestPath";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (cidrTestScopeElement == null) {
            CidrTestScopeElement.$$$reportNull$$$0(14);
        }
        return cidrTestScopeElement;
    }

    /*
     * WARNING - void declaration
     */
    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeElementForCaching(@Nullable String testName, @Nullable String suiteName, final long offsetAsNaturalOrder, final @NotNull String uniqueTestBodyElementId, final @NotNull PsiFile file, final @NotNull OCSymbolKind kind, @NotNull Function<CidrTestScopeElement, ProtertiesGenerator> function) {
        void generator;
        if (uniqueTestBodyElementId == null) {
            CidrTestScopeElement.$$$reportNull$$$0(15);
        }
        if (file == null) {
            CidrTestScopeElement.$$$reportNull$$$0(16);
        }
        if (kind == null) {
            CidrTestScopeElement.$$$reportNull$$$0(17);
        }
        if (function == null) {
            CidrTestScopeElement.$$$reportNull$$$0(18);
        }
        CidrTestScopeElement cidrTestScopeElement = new CidrTestScopeElement(suiteName, testName, (Function)generator){
            @Nullable
            SofterReference<PsiElement> myPsiElement;

            @Override
            public long getSortIndex() {
                return offsetAsNaturalOrder;
            }

            @Override
            @NotNull
            public PsiElement getElement() {
                PsiElement element;
                if (this.myPsiElement != null && (element = (PsiElement)this.myPsiElement.get()) != null && element.isValid()) {
                    PsiElement psiElement = element;
                    if (psiElement == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return psiElement;
                }
                if (file instanceof OCFile) {
                    PsiElement element2;
                    OCFile realSource;
                    OCSymbolReference.GlobalReference version = OCSymbolReference.getDummyGlobalReference(OCQualifiedName.parse(uniqueTestBodyElementId));
                    OCFile source = (OCFile)file;
                    if (OCInclusionContextUtil.isNeedToFindRoot(file) && (realSource = ((OCFile)file).getAssociatedFile()) != null) {
                        source = realSource;
                    }
                    List<OCSymbol> symbols = version.resolveToSymbols(OCResolveContext.forPsi(source));
                    OCSymbol preDeclaration = null;
                    for (OCSymbol symbol : symbols) {
                        PsiElement element3 = this.extractElement(symbol);
                        if (element3 != null) {
                            PsiElement psiElement = element3;
                            if (psiElement == null) {
                                3.$$$reportNull$$$0(1);
                            }
                            return psiElement;
                        }
                        if (preDeclaration != null || symbol.getKind() != OCSymbolKind.FUNCTION_PREDECLARATION) continue;
                        preDeclaration = symbol;
                    }
                    if (preDeclaration != null && (element2 = this.extractElement(preDeclaration.getDefinitionSymbol(source.getProject()))) != null) {
                        PsiElement psiElement = element2;
                        if (psiElement == null) {
                            3.$$$reportNull$$$0(2);
                        }
                        return psiElement;
                    }
                }
                PsiFile psiFile = file;
                if (psiFile == null) {
                    3.$$$reportNull$$$0(3);
                }
                return psiFile;
            }

            @Contract(value="null -> null")
            @Nullable
            private PsiElement extractElement(@Nullable OCSymbol symbol) {
                Object element;
                if (symbol != null && symbol.getKind() == kind && (element = symbol.locateDefinition(file.getProject())) != null) {
                    this.myPsiElement = new SofterReference(element);
                    return element;
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestScopeElement$3", "getElement"));
            }
        };
        if (cidrTestScopeElement == null) {
            CidrTestScopeElement.$$$reportNull$$$0(19);
        }
        return cidrTestScopeElement;
    }

    @Contract(pure=true)
    @NotNull
    public static CidrTestScopeElement createTestScopeWithPatternAndConfigurationName(final @NotNull String configurationName, final @NotNull String pattern) {
        if (configurationName == null) {
            CidrTestScopeElement.$$$reportNull$$$0(20);
        }
        if (pattern == null) {
            CidrTestScopeElement.$$$reportNull$$$0(21);
        }
        CidrTestScopeElement cidrTestScopeElement = new CidrTestScopeElement(){

            @Override
            @NotNull
            public String getConfigurationName() {
                String string = configurationName;
                if (string == null) {
                    4.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public String getPatternForCommandLine() {
                String string = pattern;
                if (string == null) {
                    4.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            public boolean isPatternLike() {
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElement$4";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getConfigurationName";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPatternForCommandLine";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (cidrTestScopeElement == null) {
            CidrTestScopeElement.$$$reportNull$$$0(22);
        }
        return cidrTestScopeElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathWithoutProtololPrefix";
                break;
            }
            case 8: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternForCommandLine";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualTestPath";
                break;
            }
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurationName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realElement";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uniqueTestBodyElementId";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternForCommandLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createPathFromParts";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "splitPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileTestScopeElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElementForVirtualTestPath";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElementForCaching";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeWithPatternAndConfigurationName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "splitPath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileTestScopeElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createTestScopeElementForVirtualTestPath";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTestScopeElementForCaching";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createTestScopeWithPatternAndConfigurationName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DefaultPropertiesGenerator
    implements ProtertiesGenerator {
        protected CidrTestScopeElement myOwner;

        public DefaultPropertiesGenerator(CidrTestScopeElement owner2) {
            this.myOwner = owner2;
        }

        @Override
        @NotNull
        public String getTestPath() {
            StringBuilder testName = new StringBuilder();
            if (this.myOwner.mySuiteName != null) {
                testName.append(this.myOwner.mySuiteName);
            }
            if (this.myOwner.myTestName != null) {
                if (testName.length() != 0) {
                    testName.append('/');
                }
                testName.append(this.myOwner.myTestName);
            }
            String string = testName.toString();
            if (string == null) {
                DefaultPropertiesGenerator.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        public String getPatternForCommandLine() {
            String string = this.getTestPath();
            if (string == null) {
                DefaultPropertiesGenerator.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public String getConfigurationName() {
            if (this.myOwner.myTestName != null) {
                String string = this.myOwner.myTestName;
                if (string == null) {
                    DefaultPropertiesGenerator.$$$reportNull$$$0(2);
                }
                return string;
            }
            if (this.myOwner.mySuiteName != null) {
                int index = this.myOwner.mySuiteName.lastIndexOf(47);
                String string = index < 0 ? this.myOwner.mySuiteName : this.myOwner.mySuiteName.substring(index + 1);
                if (string == null) {
                    DefaultPropertiesGenerator.$$$reportNull$$$0(3);
                }
                return string;
            }
            if ("" == null) {
                DefaultPropertiesGenerator.$$$reportNull$$$0(4);
            }
            return "";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/execution/testing/CidrTestScopeElement$DefaultPropertiesGenerator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTestPath";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatternForCommandLine";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getConfigurationName";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static interface ProtertiesGenerator {
        @NotNull
        public String getTestPath();

        @NotNull
        public String getPatternForCommandLine();

        @NotNull
        public String getConfigurationName();
    }
}

