/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestWithScopeElementsFramework
extends CidrTestFrameworkBase<CidrTestScopeElement> {
    private final NotNullLazyKey<CachedValue<Map<String, CidrTestScopeElement>>, PsiFile> myTestLinks;
    protected final Class<? extends PsiElement>[] myTestHolderClassWithoutMacroCall;
    protected final boolean myCanHaveMacroAsTest;
    protected final boolean myCanHaveNamespaceAsTest;
    protected final boolean myCanHaveFunctionAsTest;
    protected final boolean myCanHaveDeclaratorAsTest;

    protected CidrTestWithScopeElementsFramework(@NonNls @NotNull String testFrameworkId, @NotNull Function<PsiFile, ModificationTracker> modificationTrackerProducer, @NotNull Class<? extends PsiFile> fileClass, Class<? extends PsiElement> ... testHolderClass) {
        if (testFrameworkId == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(0);
        }
        if (modificationTrackerProducer == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(1);
        }
        if (fileClass == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(2);
        }
        if (testHolderClass == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(3);
        }
        super(testFrameworkId, modificationTrackerProducer, fileClass, testHolderClass);
        this.myTestLinks = NotNullLazyKey.create((String)(testFrameworkId + " links in File"), file -> {
            if (modificationTrackerProducer == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(29);
            }
            return CachedValuesManager.getManager((Project)file.getProject()).createCachedValue(() -> {
                if (modificationTrackerProducer == null) {
                    CidrTestWithScopeElementsFramework.$$$reportNull$$$0(30);
                }
                return new CachedValueProvider.Result(this.createTestLinksDirectly((PsiFile)file), new Object[]{modificationTrackerProducer.fun(file)});
            }, false);
        });
        this.myTestHolderClassWithoutMacroCall = this.myTestHolderClass.stream().filter(clazz -> !clazz.equals(OCMacroCall.class)).collect(Collectors.toList()).toArray(ArrayUtil.EMPTY_CLASS_ARRAY);
        this.myCanHaveMacroAsTest = this.myTestHolderClass.contains(OCMacroCall.class);
        this.myCanHaveNamespaceAsTest = this.myTestHolderClass.contains(OCCppNamespace.class);
        this.myCanHaveFunctionAsTest = this.myTestHolderClass.contains(OCFunctionDefinition.class);
        this.myCanHaveDeclaratorAsTest = this.myTestHolderClass.contains(OCDeclarator.class);
    }

    @NotNull
    public Map<String, CidrTestScopeElement> getTestLinks(@NotNull PsiFile file) {
        if (file == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(4);
        }
        Map map2 = this.myFrameworkFileClass.isInstance(file) ? (Map)((CachedValue)this.myTestLinks.getValue((UserDataHolder)file)).getValue() : EMPTY_MAP;
        if (map2 == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(5);
        }
        return map2;
    }

    @NotNull
    protected abstract Map<String, CidrTestScopeElement> createTestLinksDirectly(@NotNull PsiFile var1);

    public abstract CidrTestScopeElement createTestScopeElementForSuiteAndTest(@Nullable String var1, @Nullable String var2);

    protected CidrTestScopeElement getTestObjectFromTestHolder(@NotNull PsiElement maybeTestHolder, @NotNull Set<String> macroNames) {
        CidrTestScopeElement ret;
        if (maybeTestHolder == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(6);
        }
        if (macroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(7);
        }
        if ((ret = this.findTestFromMacro(maybeTestHolder, macroNames)) == null && this.myCanHaveNamespaceAsTest && maybeTestHolder instanceof OCCppNamespace) {
            ret = this.extractTestObject(((OCCppNamespace)maybeTestHolder).getSymbol(), OCSymbolKind.NAMESPACE, maybeTestHolder.getProject());
        }
        if (ret == null && this.myCanHaveFunctionAsTest && maybeTestHolder instanceof OCFunctionDefinition) {
            ret = this.extractTestObject(((OCFunctionDefinition)maybeTestHolder).getSymbol(), OCSymbolKind.FUNCTION_DECLARATION, maybeTestHolder.getProject());
        }
        if (ret == null && this.myCanHaveDeclaratorAsTest && maybeTestHolder instanceof OCDeclarator) {
            ret = this.extractTestObject(((OCDeclarator)maybeTestHolder).getSymbol(), OCSymbolKind.GLOBAL_VARIABLE, maybeTestHolder.getProject());
        }
        return ret;
    }

    protected CidrTestScopeElement extractTestObject(@Nullable OCSymbol symbol, @NotNull OCSymbolKind kind, @NotNull Project project2) {
        if (kind == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(9);
        }
        if (symbol == null) {
            return null;
        }
        if (symbol instanceof OCSymbolWithQualifiedName && symbol.getKind() == kind && this.isAvailable(symbol.getContainingPsiFile(project2))) {
            OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
            return this.getTestLinks(symbol.getContainingPsiFile(project2)).get(CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)symbol, context));
        }
        return null;
    }

    protected boolean standardProbe(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Class<?> clazz, @NotNull OCSymbolKind symbolKind, @NotNull Project project2) {
        if (clazz == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(10);
        }
        if (symbolKind == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(11);
        }
        if (project2 == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(12);
        }
        if (symbol == null && clazz.isInstance(element)) {
            symbol = ((OCSymbolDeclarator)element).getSymbol();
        }
        return this.extractTestObject(symbol, symbolKind, project2) != null;
    }

    protected CidrTestScopeElement findTestFromMacro(@NotNull PsiElement maybeMacro, @NotNull Set<String> testMacroNames) {
        if (maybeMacro == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(13);
        }
        if (testMacroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(14);
        }
        if (CidrTestWithScopeElementsFramework.isTestMacroCandidate(maybeMacro, testMacroNames)) {
            Ref ref = new Ref();
            ((OCMacroCall)maybeMacro).processExpansionLeaves((Processor<PsiElement>)((Processor)leaf -> {
                CidrTestScopeElement ret;
                OCElement testHolder;
                if (maybeMacro == null) {
                    CidrTestWithScopeElementsFramework.$$$reportNull$$$0(27);
                }
                if (testMacroNames == null) {
                    CidrTestWithScopeElementsFramework.$$$reportNull$$$0(28);
                }
                if ((testHolder = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)leaf, (Class[])this.myTestHolderClassWithoutMacroCall)) != null && testHolder.getComplexOffset() > ((OCMacroCall)maybeMacro).getComplexOffset() && (ret = this.getTestObjectFromTestHolder(testHolder, testMacroNames)) != null) {
                    ref.set((Object)ret);
                    return false;
                }
                return true;
            }));
            return (CidrTestScopeElement)ref.get();
        }
        return null;
    }

    public static boolean isTestMacroCandidate(@NotNull PsiElement element, @NotNull Set<String> testMacroNames) {
        OCReferenceElement referenceElement;
        if (element == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(15);
        }
        if (testMacroNames == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(16);
        }
        if (element instanceof OCMacroCall && (referenceElement = ((OCMacroCall)element).getMacroReferenceElement()) != null) {
            return testMacroNames.contains(referenceElement.getName());
        }
        return false;
    }

    @Nullable
    public static CidrTestScopeElement findTestSymbol(@NotNull String pathToFind, @NotNull Project project2, @Nullable GlobalSearchScope scope, @NotNull CidrTestWithScopeElementsFramework framework) {
        if (pathToFind == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(17);
        }
        if (project2 == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(18);
        }
        if (framework == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(19);
        }
        Ref result = new Ref();
        CidrTestWithScopeElementsFramework.consumeTestSymbols(project2, OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2), (SearchScope)scope, testInfo -> {
            if (pathToFind == null) {
                CidrTestWithScopeElementsFramework.$$$reportNull$$$0(26);
            }
            if (pathToFind.equals(testInfo.getTestPath())) {
                result.set(testInfo);
                CidrTestWithScopeElementsFramework.stopIteration();
            }
        }, framework);
        return (CidrTestScopeElement)result.get();
    }

    @Contract(value=" -> fail")
    public static void stopIteration() throws StopException {
        throw new StopException();
    }

    public static void consumeTestSymbols(@NotNull Project project2, @NotNull Collection<VirtualFile> potentialTestHolders, @Nullable SearchScope scope, @NotNull Consumer<CidrTestScopeElement> consumer, @NotNull CidrTestWithScopeElementsFramework framework) {
        if (project2 == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(20);
        }
        if (potentialTestHolders == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(21);
        }
        if (consumer == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(22);
        }
        if (framework == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(23);
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        try {
            for (VirtualFile file : potentialTestHolders) {
                PsiFile psiFile;
                ProgressManager.checkCanceled();
                if (scope != null && !scope.contains(file) || !OCFileTypeHelpers.isSourceFile(file.getName()) || (psiFile = psiManager.findFile(file)) == null || framework.getFrameworkVersion(psiFile) == CidrTestFrameworkVersion.NOT_AVAILABLE) continue;
                Map<String, CidrTestScopeElement> links = framework.getTestLinks(psiFile);
                for (CidrTestScopeElement linker : links.values()) {
                    consumer.accept(linker);
                }
            }
        }
        catch (StopException stopException) {
            // empty catch block
        }
    }

    @Nullable
    protected static OCTestLineMarkInfo getTestLineMarkInfoStandard(@Nullable PsiElement testElement, @NotNull CidrTestFrameworkBase<CidrTestScopeElement> framework, final @NotNull String protocolPrefix) {
        CidrTestScopeElement testObject;
        if (framework == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(24);
        }
        if (protocolPrefix == null) {
            CidrTestWithScopeElementsFramework.$$$reportNull$$$0(25);
        }
        if ((testObject = framework.getTestObject(testElement)) != null && !CidrTestWithScopeElementsFramework.isMacroInjected(testElement)) {
            return new OCTestLineMarkInfo(){

                @Override
                @NotNull
                public String getUrlInTestTree() {
                    String string = protocolPrefix + testObject.getTestPath();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public boolean isSuite() {
                    return !testObject.isTest();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework$1", "getUrlInTestTree"));
                }
            };
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkId";
                break;
            }
            case 1: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationTrackerProducer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileClass";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testHolderClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeTestHolder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroNames";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 9: 
            case 12: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolKind";
                break;
            }
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeMacro";
                break;
            }
            case 14: 
            case 16: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testMacroNames";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathToFind";
                break;
            }
            case 19: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "framework";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "potentialTestHolders";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocolPrefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/CidrTestWithScopeElementsFramework";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getTestLinks";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestObjectFromTestHolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "extractTestObject";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "standardProbe";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findTestFromMacro";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTestMacroCandidate";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findTestSymbol";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "consumeTestSymbols";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getTestLineMarkInfoStandard";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findTestSymbol$4";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findTestFromMacro$3";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class StopException
    extends RuntimeException {
        public StopException() {
            super("stop iteration", null, false, false);
        }
    }
}

