/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.boost;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrBoostOutputToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    @RegExp
    private static final String TEST_TIME = "(?:; testing time: (\\d+.+))?\n";
    private final CidrTestEventProcessor myEventProcessor;
    private volatile String myProcessFinishedMessage;
    private volatile String myFinalTestReport;
    private volatile ExecutionConsole myConsole;
    private volatile ServiceMessageVisitor myVisitor;
    final Stack<String> myTestNameStack;
    final Stack<Boolean> myTestResultStack;
    final Stack<TagWithAttr> myDebugTags;
    static final String ROOT_NODE_ID = "0";
    boolean myCurrentTestSuccessful;
    boolean myFirstSuiteIsModule;
    boolean myInitialized;

    public CidrBoostOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console) {
        if (testFrameworkName == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (console == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties);
        this.myTestNameStack = new Stack();
        this.myTestResultStack = new Stack();
        this.myDebugTags = new Stack();
        this.myFirstSuiteIsModule = true;
        this.myInitialized = false;
        this.myConsole = console;
        this.myEventProcessor = new CidrTestEventProcessor("boost");
    }

    protected void process(@NotNull List<ServiceMessageBuilder> messages) {
        if (messages == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        try {
            for (ServiceMessageBuilder each : messages) {
                super.processServiceMessages(each.toString(), ProcessOutputTypes.STDOUT, this.myVisitor);
            }
        }
        catch (Exception e) {
            CidrTestLog.LOG.error(e.getMessage());
        }
    }

    protected boolean processServiceMessages(@Nullable String text, @Nullable Key outputType, @NotNull ServiceMessageVisitor visitor) throws ParseException {
        if (visitor == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        CidrOutputToGeneralTestEventsConverter.logOutput(text, outputType);
        this.myVisitor = visitor;
        if (outputType == ProcessOutputTypes.STDOUT || outputType == ProcessOutputTypes.STDERR) {
            this.processLine(outputType, text);
            return true;
        }
        if (outputType == ProcessOutputTypes.SYSTEM && text != null) {
            if (CidrOutputToGeneralTestEventsConverter.PROCESS_FINISHED_PATTERN.matcher(text).matches()) {
                this.myProcessFinishedMessage = text;
                return true;
            }
            if (text.equals("\n")) {
                return true;
            }
        }
        return false;
    }

    @NotNull
    private String getCurrentNodeId() {
        StringBuilder path = new StringBuilder();
        path.append(ROOT_NODE_ID);
        this.myTestNameStack.forEach(testName -> path.append('/').append((String)testName));
        String string = path.toString();
        if (string == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void processLine(Key outputType, String text) throws ParseException {
        if (outputType == ProcessOutputTypes.STDERR && text.startsWith("*** ")) {
            this.myFinalTestReport = text;
            return;
        }
        TagWithAttr tag = outputType == ProcessOutputTypes.STDOUT ? Tag.parse(text) : null;
        GeneralTestEventsProcessor processor2 = this.getProcessor();
        if (tag == null) {
            String testName = this.myTestNameStack.isEmpty() ? "" : this.myTestNameStack.peek();
            String nodeId = this.getCurrentNodeId();
            if (nodeId.equals(ROOT_NODE_ID)) {
                processor2.onUncapturedOutput(text, outputType);
                return;
            }
            processor2.addToInvokeLater(() -> this.process(outputType == ProcessOutputTypes.STDOUT ? this.myEventProcessor.testStdOut(testName, nodeId, text) : this.myEventProcessor.testErrOut(testName, nodeId, text)));
            return;
        }
        this.myDebugTags.add(tag);
        Tag etag = tag.getTag();
        Runnable init = () -> {
            processor2.onTestsReporterAttached();
            processor2.onUncapturedOutput(String.format("Entering test module %s\n", tag.getAttr(Attr.NAME)), ProcessOutputTypes.STDOUT);
            this.myInitialized = true;
        };
        Runnable done = () -> processor2.onUncapturedOutput(String.format("Leaving test module %s\n", tag.getAttr(Attr.NAME)), ProcessOutputTypes.STDOUT);
        switch (etag) {
            case MODULE_START: {
                this.myFirstSuiteIsModule = false;
                init.run();
                break;
            }
            case SUITE_START: {
                if (this.myFirstSuiteIsModule && !this.myInitialized) {
                    init.run();
                    break;
                }
            }
            case TEST_START: {
                String nodeName = tag.getAttr(Attr.NAME);
                String parentId = this.getCurrentNodeId();
                this.myTestNameStack.push(nodeName);
                this.myTestResultStack.push(Boolean.TRUE);
                String nodeId = this.getCurrentNodeId();
                String location = this.getCurrentNodeId().substring(ROOT_NODE_ID.length() + 1);
                String metainfo = tag.getAttr(Attr.LINE_NUM);
                processor2.addToInvokeLater(() -> this.process(etag == Tag.TEST_START ? this.myEventProcessor.testStarted(nodeName, parentId, nodeId, location, metainfo) : this.myEventProcessor.suiteStarted(nodeName, parentId, nodeId, location, metainfo)));
                break;
            }
            case MODULE_END: {
                done.run();
                break;
            }
            case SUITE_END: {
                if (this.myFirstSuiteIsModule && this.myTestNameStack.isEmpty()) {
                    done.run();
                    break;
                }
            }
            case TEST_END: {
                String nodeName = tag.getAttr(Attr.NAME);
                String durationInMs = tag.getAttr(Attr.TIME);
                String nodeId = this.getCurrentNodeId();
                this.myTestNameStack.pop();
                Boolean succeeded = this.myTestResultStack.pop();
                if (!this.myTestResultStack.isEmpty()) {
                    this.myTestResultStack.push(this.myTestResultStack.pop() != false && succeeded != false);
                }
                processor2.addToInvokeLater(() -> this.process(etag == Tag.TEST_END ? this.myEventProcessor.testFinished(nodeName, nodeId, CidrBoostOutputToGeneralTestEventsConverter.getTimeInMs(durationInMs), succeeded) : this.myEventProcessor.suiteFinished(nodeName, nodeId)));
                break;
            }
            case EXCEPTION: 
            case ERROR: 
            case FATAL_ERROR: {
                this.myCurrentTestSuccessful = false;
                if (!this.myTestResultStack.isEmpty()) {
                    this.myTestResultStack.pop();
                }
                this.myTestResultStack.push(Boolean.FALSE);
                ((GeneralIdBasedToSMTRunnerEventsConvertor)processor2).onError(this.getCurrentNodeId(), "", text, false);
            }
        }
    }

    @NotNull
    private static String getTimeInMs(@Nullable String timeStringWithSuffix) {
        block8: {
            if (timeStringWithSuffix != null) {
                String string;
                int length;
                block7: {
                    length = timeStringWithSuffix.length();
                    if (!timeStringWithSuffix.endsWith("us")) break block7;
                    String string2 = String.valueOf(Math.round((double)Long.parseLong(timeStringWithSuffix.substring(0, length - 2)) / 1000.0));
                    if (string2 == null) {
                        CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(6);
                    }
                    return string2;
                }
                try {
                    if (!timeStringWithSuffix.endsWith("ms")) break block8;
                    string = String.valueOf(Long.parseLong(timeStringWithSuffix.substring(0, length - 2)));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (string == null) {
                    CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(7);
                }
                return string;
            }
        }
        if (ROOT_NODE_ID == null) {
            CidrBoostOutputToGeneralTestEventsConverter.$$$reportNull$$$0(8);
        }
        return ROOT_NODE_ID;
    }

    public void flushBufferOnProcessTermination(int exitCode) {
        GeneralTestEventsProcessor processor2 = this.getProcessor();
        if (processor2 != null) {
            if (this.myFinalTestReport != null) {
                processor2.onUncapturedOutput(this.myFinalTestReport, ProcessOutputTypes.STDERR);
            }
            if (this.myProcessFinishedMessage != null) {
                processor2.onUncapturedOutput(this.myProcessFinishedMessage, ProcessOutputTypes.SYSTEM);
            }
        }
        this.transferTextToConsoleViewInTest();
        super.flushBufferOnProcessTermination(exitCode);
    }

    private void transferTextToConsoleViewInTest() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ((ConsoleViewImpl)((SMTRunnerConsoleView)this.myConsole).getConsole()).waitAllRequests());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostOutputToGeneralTestEventsConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostOutputToGeneralTestEventsConverter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNodeId";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeInMs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processServiceMessages";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TagWithAttr {
        private final Map<Attr, String> myAttrs;
        private final Tag myTag;

        TagWithAttr(@NotNull Tag tag, @NotNull Map<Attr, String> attrs) {
            if (tag == null) {
                TagWithAttr.$$$reportNull$$$0(0);
            }
            if (attrs == null) {
                TagWithAttr.$$$reportNull$$$0(1);
            }
            this.myAttrs = attrs;
            this.myTag = tag;
        }

        @Nullable
        public String getAttr(Attr attrId) {
            return this.myAttrs.get((Object)attrId);
        }

        @NotNull
        public Tag getTag() {
            Tag tag = this.myTag;
            if (tag == null) {
                TagWithAttr.$$$reportNull$$$0(2);
            }
            return tag;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tag";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attrs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostOutputToGeneralTestEventsConverter$TagWithAttr";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostOutputToGeneralTestEventsConverter$TagWithAttr";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTag";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum Tag {
        MODULE_START("Entering test module \"(.+)\"\n"),
        MODULE_END("Leaving test module \"(.+)\"(?:; testing time: (\\d+.+))?\n"),
        SUITE_START("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)\\)?: )?Entering test suite \"(.*)\"\n"),
        SUITE_END("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)\\)?: )?Leaving test suite \"(.*)\"(?:; testing time: (\\d+.+))?\n"),
        TEST_START("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)\\)?: )?Entering test case \"(.*)\"\n"),
        TEST_END("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)\\)?: )?Leaving test case \"(.*)\"(?:; testing time: (\\d+.+))?\n"),
        EXCEPTION("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)\\)?: )?last checkpoint: \"(.*)\" entry."),
        FATAL_ERROR("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)\\)?: )?fatal error: in \"(.*)\": (.*)\n"),
        ERROR("(?:((?:[a-z,A-Z]:)?[^(:]*)[(:]?(\\d+)\\)?: )?error: in \"(.*)\": (.*)\n");

        private final Pattern myTagPattern;

        private Tag(String pattern) {
            if (pattern == null) {
                Tag.$$$reportNull$$$0(0);
            }
            this.myTagPattern = Pattern.compile(pattern);
        }

        @Nullable
        public static TagWithAttr parse(@NotNull String line) {
            if (line == null) {
                Tag.$$$reportNull$$$0(1);
            }
            for (Tag tag : Tag.values()) {
                Matcher matcher = tag.myTagPattern.matcher(line);
                if (!matcher.find()) continue;
                HashMap<Attr, String> attrs = new HashMap<Attr, String>();
                switch (tag) {
                    case MODULE_END: {
                        attrs.put(Attr.TIME, matcher.group(2));
                    }
                    case MODULE_START: {
                        attrs.put(Attr.NAME, matcher.group(1));
                        break;
                    }
                    case SUITE_END: 
                    case TEST_END: {
                        attrs.put(Attr.TIME, matcher.group(4));
                    }
                    case SUITE_START: 
                    case TEST_START: 
                    case EXCEPTION: {
                        attrs.put(Attr.SOURCE_PATH, matcher.group(1));
                        attrs.put(Attr.LINE_NUM, matcher.group(2));
                        attrs.put(Attr.NAME, matcher.group(3));
                        break;
                    }
                    case ERROR: 
                    case FATAL_ERROR: {
                        attrs.put(Attr.SOURCE_PATH, matcher.group(1));
                        attrs.put(Attr.LINE_NUM, matcher.group(2));
                        attrs.put(Attr.NAME, matcher.group(3));
                        attrs.put(Attr.MESSAGE, matcher.group(4));
                    }
                }
                return new TagWithAttr(tag, attrs);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/execution/testing/boost/CidrBoostOutputToGeneralTestEventsConverter$Tag";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "parse";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static enum Attr {
        SOURCE_PATH,
        LINE_NUM,
        NAME,
        MESSAGE,
        TIME;

    }
}

