/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CidrGoogleOutputToGeneralTestEventsConverter
extends CidrOutputToGeneralTestEventsConverter {
    private static final Pattern TEST_PATTERN = Pattern.compile("\\[\\s*(OK|RUN|FAILED)\\s*]\\s*(.*?)(\\s+\\((\\d+) ms\\))?\n");
    private static final Pattern SUITE_PATTERN = Pattern.compile("\\[----------] \\d+ tests? from (.*?)(\\s+\\(\\d+ ms total\\))?\n");
    private static final Pattern GLOBAL_ENVIRONMENT_PATTERN = Pattern.compile("\\[----------] Global test environment (set-up|tear-down)");
    private static final Pattern STARTING_PATTERN = Pattern.compile("\\[==========] Running \\d+ tests? from \\d+ test cases?\\.");
    private static final String FILTER_NOTE_PREFIX = "Note: Google Test filter = ";
    private static final String ZERO_TESTS_FINISHED_PREFIX = "[==========] 0 tests from 0 test cases ran.";
    private boolean myTornDown = false;
    @Nullable
    private String myPotentiallyFinishedInstantiation = null;
    @Nullable
    private String myOpenType = null;

    public CidrGoogleOutputToGeneralTestEventsConverter(String testFrameworkName, TestConsoleProperties consoleProperties) {
        super(testFrameworkName, consoleProperties);
        this.myEventProcessor = new CidrTestEventProcessor("gtest");
    }

    protected boolean processServiceMessages(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        CidrGoogleOutputToGeneralTestEventsConverter.logOutput(text, outputType);
        this.attachTestFramework(outputType, visitor);
        if (outputType == ProcessOutputTypes.STDOUT) {
            if (this.myTornDown || STARTING_PATTERN.matcher(text).find() || text.startsWith(FILTER_NOTE_PREFIX)) {
                return true;
            }
            if (text.startsWith(ZERO_TESTS_FINISHED_PREFIX)) {
                this.myTornDown = true;
                return true;
            }
            Matcher m = GLOBAL_ENVIRONMENT_PATTERN.matcher(text);
            if (m.find()) {
                this.myTornDown = m.group(1).equals("tear-down");
                this.reopenInstantiationIfAppropriate(outputType, visitor, null, null, null);
                this.reopenSuiteIfAppropriate(outputType, visitor, null, null);
                return true;
            }
            m = TEST_PATTERN.matcher(text);
            if (m.matches()) {
                String presentationName;
                String state = m.group(1);
                String duration = StringUtil.notNullize((String)m.group(4));
                CidrGoogleTestLinker testInfo = CidrGoogleTestLinker.parseInfo(m.group(2));
                if (testInfo == null) {
                    return false;
                }
                String string = presentationName = testInfo.isValueParameterized ? testInfo.param : testInfo.name;
                if ("RUN".equals(state)) {
                    this.myRunningTest = presentationName;
                    String location = testInfo.instantiationLocation();
                    if (testInfo.isValueParameterized) {
                        location = location + "." + testInfo.name;
                    }
                    this.reopenSuiteIfAppropriate(outputType, visitor, testInfo.isValueParameterized ? testInfo.name : null, location);
                    this.myPotentiallyFinishedSuite = null;
                    this.doProcessMessages(outputType, visitor, this.myEventProcessor.testStarted(presentationName, testInfo.testLocation()));
                } else {
                    boolean failed = "FAILED".equals(state);
                    this.processCollectedAssertionOutput(outputType, visitor, presentationName, failed);
                    this.doProcessMessages(outputType, visitor, this.myEventProcessor.testFinished(presentationName, duration, !failed));
                    if (testInfo.isValueParameterized) {
                        this.myPotentiallyFinishedSuite = testInfo.name;
                    }
                    this.myRunningTest = null;
                }
                return true;
            }
            m = SUITE_PATTERN.matcher(text);
            if (m.matches()) {
                boolean finished = StringUtil.isNotEmpty((String)m.group(2));
                CidrGoogleTestLinker testInfo = CidrGoogleTestLinker.parseInfo(m.group(1));
                if (testInfo == null) {
                    return false;
                }
                if (finished) {
                    if (this.myOpenType != null) {
                        this.suiteFinished(outputType, visitor, this.myOpenType);
                        this.myOpenType = null;
                    }
                    this.reopenSuiteIfAppropriate(outputType, visitor, null, null);
                    if (testInfo.instantiation != null) {
                        this.myPotentiallyFinishedInstantiation = testInfo.instantiation;
                    }
                    this.myPotentiallyFinishedSuite = testInfo.suite;
                } else {
                    this.reopenInstantiationIfAppropriate(outputType, visitor, testInfo.instantiation, testInfo.instantiationLocation(), testInfo.suite);
                    if (testInfo.isTyped) {
                        this.myOpenType = testInfo.param + " - " + testInfo.type;
                        this.suiteStarted(outputType, visitor, this.myOpenType, testInfo.instantiationLocation() + "=" + testInfo.param);
                    }
                }
                return true;
            }
            Boolean res = this.processAssertion(outputType, visitor, text, CidrGoogleTestConsoleProperties.FAILURE_PATTERN);
            if (res != null) {
                return res;
            }
            if (this.myPotentiallyFinishedSuite != null && this.myRunningTest == null && "\n".equals(text)) {
                return true;
            }
        } else {
            this.checkForTermination(text, outputType, visitor);
        }
        return false;
    }

    @Override
    protected void processCollectedAssertionOutput(Key outputType, ServiceMessageVisitor visitor, @NotNull String testName, boolean failed) throws ParseException {
        if (testName == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (this.myAssertionOutput.length() > 0) {
            String assertionText = this.myAssertionOutput.toString();
            if (failed) {
                this.fireOnErrorMsg("", assertionText, false);
            } else {
                this.doProcessMessages(outputType, visitor, this.myEventProcessor.testErrOut(testName, assertionText));
            }
            this.myAssertionOutput.setLength(0);
        }
    }

    private void reopenInstantiationIfAppropriate(Key outputType, ServiceMessageVisitor visitor, @Nullable String instantiation, String location, @Nullable String suiteName) throws ParseException {
        boolean open;
        boolean sameSuite = suiteName == null || suiteName.equals(this.myPotentiallyFinishedSuite);
        boolean bl = open = instantiation != null && (!instantiation.equals(this.myPotentiallyFinishedInstantiation) || !sameSuite);
        if (this.myPotentiallyFinishedInstantiation != null && (open || instantiation == null)) {
            this.suiteFinished(outputType, visitor, this.myPotentiallyFinishedInstantiation);
        }
        if (suiteName != null) {
            this.reopenSuiteIfAppropriate(outputType, visitor, suiteName, suiteName);
        }
        if (open) {
            this.suiteStarted(outputType, visitor, instantiation, location);
        }
        this.myPotentiallyFinishedInstantiation = null;
    }

    @Override
    protected void suiteStarted(Key outputType, ServiceMessageVisitor visitor, @NotNull String name2, @NotNull String location) throws ParseException {
        if (name2 == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (location == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        this.doProcessMessages(outputType, visitor, this.myEventProcessor.suiteStarted(name2, location));
    }

    @Override
    protected void suiteFinished(Key outputType, ServiceMessageVisitor visitor, @NotNull String name2) throws ParseException {
        if (name2 == null) {
            CidrGoogleOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        this.doProcessMessages(outputType, visitor, this.myEventProcessor.suiteFinished(name2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleOutputToGeneralTestEventsConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processCollectedAssertionOutput";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "suiteStarted";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "suiteFinished";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

