/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import com.intellij.util.Producer;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsActionEx;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestFramework;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLocation;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final Producer<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope(CidrGoogleTestFramework.getInstance().getPatternSeparatorInCommandLine());

    public CidrGoogleTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        if (configuration == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(3);
        }
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @Override
    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        if (consoleView == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(4);
        }
        CidrRerunFailedTestsActionEx cidrRerunFailedTestsActionEx = new CidrRerunFailedTestsActionEx((ComponentContainer)consoleView, (Function<Pair<AbstractTestProxy, Project>, String>)((Function)testContext -> CidrGoogleTestCommandLineState.getTestSwitch((AbstractTestProxy)testContext.first, (Project)testContext.second)), this);
        if (cidrRerunFailedTestsActionEx == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(5);
        }
        return cidrRerunFailedTestsActionEx;
    }

    @Nullable
    private static String getTestSwitch(@NotNull AbstractTestProxy test, @NotNull Project project2) {
        String scope;
        CidrGoogleTestLocation location;
        if (test == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(6);
        }
        if (project2 == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(7);
        }
        String param = (location = CidrGoogleTestCommandLineState.getLocation(test, project2)) != null ? location.getParam() : null;
        int depth = CidrGoogleTestCommandLineState.getTestDepth(test);
        switch (depth) {
            case 2: {
                scope = String.format("%s.%s", test.getParent().getName(), test.getName());
                break;
            }
            case 3: {
                AbstractTestProxy suite = test.getParent().getParent();
                scope = String.format("%s/%s.%s", suite.getName(), param, test.getName());
                break;
            }
            case 4: {
                if (location == null) {
                    return null;
                }
                PsiElement element = location.getPsiElement();
                if (!(element instanceof OCStruct)) {
                    return null;
                }
                Couple<String> testName = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)((OCStruct)element).getSymbol(), project2);
                if (testName == null) {
                    return null;
                }
                if (location.isTyped()) {
                    scope = String.format("%s/%s/%s.%s", location.getInstantiation(), testName.first, param, testName.second);
                    break;
                }
                scope = String.format("%s/%s.%s/%s", location.getInstantiation(), testName.first, testName.second, param);
                break;
            }
            default: {
                scope = null;
            }
        }
        return scope;
    }

    @Nullable
    private static CidrGoogleTestLocation getLocation(@NotNull AbstractTestProxy test, @NotNull Project project2) {
        Location location;
        if (test == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(8);
        }
        if (project2 == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(9);
        }
        return (location = test.getLocation(project2, OCSearchScope.getProjectSourcesScope(project2))) instanceof CidrGoogleTestLocation ? (CidrGoogleTestLocation)location : null;
    }

    private static int getTestDepth(@NotNull AbstractTestProxy test) {
        if (test == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(10);
        }
        int count = 0;
        while (test.getParent() != null) {
            test = test.getParent();
            ++count;
        }
        return count;
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String testClass, @Nullable String testMethod) {
        CidrGoogleTestScopeElement cidrGoogleTestScopeElement = new CidrGoogleTestScopeElement(testClass, testMethod, null, null);
        if (cidrGoogleTestScopeElement == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(11);
        }
        return cidrGoogleTestScopeElement;
    }

    @Override
    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CidrGoogleTestCommandLineState.$$$reportNull$$$0(12);
        }
        cl.addParameters(new String[]{"--gtest_filter=" + this.testScope().getAsPattern(), "--gtest_color=no"});
        return cl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestCommandLineState";
                break;
            }
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "test";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestCommandLineState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 5: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTestSwitch";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestDepth";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

