/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkBase;
import com.jetbrains.cidr.execution.testing.CidrTestFrameworkVersion;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLinker;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestObject;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.OCTestLineMarkInfo;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestFramework
extends CidrTestFrameworkBase<CidrGoogleTestObject> {
    private static CidrTestFrameworkBase.FrameworkHolder<CidrGoogleTestFramework> ourHolder = new CidrTestFrameworkBase.FrameworkHolder<CidrGoogleTestFramework>(CidrGoogleTestFramework.class);

    public static CidrGoogleTestFramework getInstance() {
        return ourHolder.getInstance();
    }

    public CidrGoogleTestFramework() {
        super("Google Test", CidrGoogleTestFramework.getCidrTopLevelChangesModificationTracker(), OCFile.class, OCMacroCall.class, OCMacroCallArgument.class, OCStruct.class, OCFunctionDeclaration.class);
    }

    @Override
    @NotNull
    protected CidrTestFrameworkVersion createFrameworkVersionDirectly(@NotNull PsiFile file) {
        if (file == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(0);
        }
        CidrTestFrameworkVersion cidrTestFrameworkVersion = CidrGoogleTestFramework.getFrameworkVersionUsingImportedMacro(file, "GTEST_TEST");
        if (cidrTestFrameworkVersion == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(1);
        }
        return cidrTestFrameworkVersion;
    }

    @Override
    @NotNull
    public String getPatternSeparatorInCommandLine() {
        if (":" == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(2);
        }
        return ":";
    }

    @Override
    @Contract(value="null, null, _ -> false")
    public boolean isTestClassOrStruct(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project2) {
        if (project2 == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(3);
        }
        if (element != null) {
            return element instanceof OCStruct && this.getTestObject(element) != null;
        }
        return symbol instanceof OCStructSymbol && this.isAvailable(symbol.getContainingPsiFile(project2)) && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol, project2);
    }

    @Override
    @Contract(value="null, null, _ -> false")
    public boolean isTestMethodOrFunction(@Nullable OCSymbol symbol, @Nullable PsiElement element, @NotNull Project project2) {
        if (project2 == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(4);
        }
        if (element != null) {
            return element instanceof OCFunctionDeclaration && this.getTestObject(element) != null;
        }
        return symbol instanceof OCFunctionSymbol && this.isAvailable(symbol.getContainingPsiFile(project2)) && CidrGoogleTestUtil.getGoogleTestClassSymbolFromBody(symbol, project2) != null;
    }

    @Override
    @Contract(value="null -> null")
    public OCTestLineMarkInfo getTestLineMarkInfo(@Nullable PsiElement element) {
        final CidrGoogleTestObject testObject = (CidrGoogleTestObject)this.getTestObject(element);
        if (testObject != null && !(element instanceof OCMacroCallArgument) && !CidrGoogleTestFramework.isMacroInjected(element)) {
            boolean isSuite;
            String test;
            String suite;
            OCStruct struct = (OCStruct)testObject.element;
            Couple<String> couple = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)struct.getSymbol(), element.getProject());
            if (couple != null) {
                suite = (String)couple.first;
                test = (String)couple.second;
                isSuite = testObject.kind == CidrGoogleTestObject.KIND.SUITE;
            } else {
                suite = struct.getName();
                test = null;
                isSuite = true;
            }
            return new OCTestLineMarkInfo(){

                @Override
                @NotNull
                public String getUrlInTestTree() {
                    String string = "gtest://" + CidrGoogleTestLinker.create(suite, test, testObject.instantiation, testObject.param).testLocation();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }

                @Override
                public boolean isSuite() {
                    return isSuite;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestFramework$1", "getUrlInTestTree"));
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    protected CidrGoogleTestObject extractTest(@NotNull PsiElement element) {
        if (element == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(5);
        }
        return CidrGoogleTestUtil.getTestObjectFromTestHolder(element);
    }

    @Override
    @NotNull
    protected CidrGoogleTestObject createFileTestObjectIfPossible(@NotNull PsiFile element) {
        if (element == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(6);
        }
        CidrGoogleTestObject cidrGoogleTestObject = new CidrGoogleTestObject(CidrGoogleTestObject.KIND.FILE, (PsiElement)element);
        if (cidrGoogleTestObject == null) {
            CidrGoogleTestFramework.$$$reportNull$$$0(7);
        }
        return cidrGoogleTestObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestFramework";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestFramework";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFrameworkVersionDirectly";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPatternSeparatorInCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileTestObjectIfPossible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFrameworkVersionDirectly";
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isTestClassOrStruct";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTestMethodOrFunction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractTest";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createFileTestObjectIfPossible";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

