/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CidrGoogleTestLinker {
    private static final Pattern NAME_PATTERN = Pattern.compile("(\\w+)(/(\\d+))?(\\.(\\w+))?(/(\\d+))?((, where TypeParam = (.*))|(, where GetParam\\(\\) = .*))?");
    private static final Pattern INSTANTIATION_PATTERN = Pattern.compile("(\\w+)/(.*)");
    String instantiation;
    String suite;
    String name;
    String param;
    String type;
    boolean isTyped;
    boolean isValueParameterized;

    CidrGoogleTestLinker() {
    }

    public String instantiationLocation() {
        String res = this.suite;
        if (this.instantiation != null) {
            res = this.instantiation + "/" + res;
        }
        return res;
    }

    public String testLocation() {
        String res = this.instantiationLocation() + "." + this.name;
        if (this.param != null) {
            res = res + "=" + this.param;
        }
        if (this.isTyped) {
            res = res + "?typed";
        }
        return res;
    }

    @Nullable
    static CidrGoogleTestLinker parseInfo(String text) {
        CidrGoogleTestLinker testInfo = new CidrGoogleTestLinker();
        Matcher m = NAME_PATTERN.matcher(text);
        if (!m.matches()) {
            boolean ok = false;
            m = INSTANTIATION_PATTERN.matcher(text);
            if (m.find()) {
                testInfo.instantiation = m.group(1);
                m = NAME_PATTERN.matcher(m.group(2));
                ok = m.matches();
            }
            if (!ok) {
                return null;
            }
        }
        testInfo.suite = m.group(1);
        testInfo.name = m.group(5);
        testInfo.param = m.group(7);
        if (testInfo.param == null) {
            testInfo.param = m.group(3);
            testInfo.isTyped = testInfo.param != null;
        } else {
            testInfo.isValueParameterized = testInfo.instantiation != null;
        }
        testInfo.type = m.group(10);
        return testInfo;
    }

    @NotNull
    static CidrGoogleTestLinker create(@Nullable String suite, @Nullable String test, @Nullable String instantiation, @Nullable String param) {
        CidrGoogleTestLinker testInfo = new CidrGoogleTestLinker();
        testInfo.suite = suite;
        testInfo.name = test;
        testInfo.instantiation = instantiation;
        testInfo.param = param;
        testInfo.isTyped = testInfo.param != null;
        testInfo.isValueParameterized = !testInfo.isTyped && testInfo.instantiation != null;
        CidrGoogleTestLinker cidrGoogleTestLinker = testInfo;
        if (cidrGoogleTestLinker == null) {
            CidrGoogleTestLinker.$$$reportNull$$$0(0);
        }
        return cidrGoogleTestLinker;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestLinker", "create"));
    }
}

