/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestLocation;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestLocationProvider
implements SMTestLocator {
    public static final String PROTOCOL = "gtest";
    public static final String PROTOCOL_PREFIX = "gtest://";
    public static final CidrGoogleTestLocationProvider INSTANCE = new CidrGoogleTestLocationProvider();
    private static final Pattern METHOD_PATTERN = Pattern.compile("((\\w+)/)?(\\w+)(\\.(\\w+))?(=(\\d+))?(\\?typed)?");

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        if (protocol == null) {
            CidrGoogleTestLocationProvider.$$$reportNull$$$0(0);
        }
        if (path == null) {
            CidrGoogleTestLocationProvider.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            CidrGoogleTestLocationProvider.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            CidrGoogleTestLocationProvider.$$$reportNull$$$0(3);
        }
        if (!PROTOCOL.equals(protocol)) {
            List<Location> list = Collections.emptyList();
            if (list == null) {
                CidrGoogleTestLocationProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        Matcher matcher = METHOD_PATTERN.matcher(path);
        if (matcher.matches()) {
            boolean typed;
            String instantiationName = matcher.group(2);
            String suiteName = matcher.group(3);
            String testName = matcher.group(5);
            String param = matcher.group(7);
            boolean bl = typed = matcher.group(8) != null;
            OCSymbol<PsiElement> symbol = testName != null ? CidrGoogleTestUtil.findGoogleTestSymbol(project2, suiteName, testName) : (instantiationName != null ? CidrGoogleTestUtil.findGoogleTestInstantiationSymbol(project2, suiteName, instantiationName) : CidrGoogleTestLocationProvider.findSuiteSymbol(project2, suiteName));
            if (symbol == null) {
                List<Location> list = Collections.emptyList();
                if (list == null) {
                    CidrGoogleTestLocationProvider.$$$reportNull$$$0(5);
                }
                return list;
            }
            PsiElement psiElement = symbol.locateDefinition(project2);
            while (!(psiElement instanceof OCStruct) && !(psiElement instanceof OCMacroCall) && psiElement != null) {
                PsiElement prev = psiElement.getPrevSibling();
                psiElement = prev == null ? psiElement.getParent() : prev;
            }
            if (psiElement == null) {
                List<Location> list = Collections.emptyList();
                if (list == null) {
                    CidrGoogleTestLocationProvider.$$$reportNull$$$0(6);
                }
                return list;
            }
            List<CidrGoogleTestLocation> list = Collections.singletonList(new CidrGoogleTestLocation(project2, psiElement, param, instantiationName, testName == null, typed));
            if (list == null) {
                CidrGoogleTestLocationProvider.$$$reportNull$$$0(7);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            CidrGoogleTestLocationProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    private static OCStructSymbol findSuiteSymbol(final Project project2, String suiteName) {
        CommonProcessors.FindProcessor<OCSymbol> processor2 = new CommonProcessors.FindProcessor<OCSymbol>(){

            @Contract(value="null -> false")
            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol, project2);
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)processor2, suiteName);
        if (processor2.isFound()) {
            return (OCStructSymbol)processor2.getFoundValue();
        }
        Collection<OCStructSymbol> symbolsForSuite = CidrGoogleTestUtil.findGoogleTestSymbolsForSuiteSorted(project2, suiteName);
        return symbolsForSuite.isEmpty() ? null : symbolsForSuite.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestLocationProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestLocationProvider";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

