/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.google.common.collect.Maps;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.ui.OCFieldAdapterForSymbolName;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestRunConfigurationEditor<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTarget<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrTestRunConfigurationEditorWithLWValidation<OCSymbol, BC, TARGET, CONFIGURATION, BCH> {
    private final NavigableMap<String, OCStructSymbol> myTestSymbols;
    private AtomicReference<String> myCollectingSuiteName;

    public CidrGoogleTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        if (project2 == null) {
            CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(0);
        }
        if (configHelper == null) {
            CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(1);
        }
        super(project2, configHelper);
        this.myTestSymbols = Maps.synchronizedNavigableMap(new TreeMap());
        this.myCollectingSuiteName = new AtomicReference();
    }

    @Override
    @NotNull
    protected Condition<OCSymbol> createSuiteCompletionCondition() {
        Condition condition = symbol -> symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol, this.myProject);
        if (condition == null) {
            CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(2);
        }
        return condition;
    }

    private boolean collectTestSymbols(final @NotNull String suiteName) {
        if (suiteName == null) {
            CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(3);
        }
        if (this.getAnySymbolForSuite(suiteName) != null) {
            return false;
        }
        String alreadyRunning = this.myCollectingSuiteName.getAndSet(suiteName);
        if (!suiteName.equals(alreadyRunning)) {
            final Computable action = () -> {
                if (suiteName == null) {
                    CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(9);
                }
                Collection<OCStructSymbol> symbols = CidrGoogleTestUtil.findGoogleTestSymbolsForSuiteSorted(this.myProject, suiteName);
                Pattern simpleTestPattern = CidrGoogleTestUtil.getSimpleTestPattern(suiteName);
                for (OCStructSymbol s : symbols) {
                    String name2;
                    if (simpleTestPattern.matcher(s.getName()).matches()) {
                        name2 = s.getName();
                    } else {
                        Couple<String> res = CidrGoogleTestUtil.extractGoogleTestName(s, this.myProject);
                        CidrTestLog.LOG.assertTrue(res != null);
                        name2 = (String)res.first + "_" + (String)res.second + "_Test";
                    }
                    this.myTestSymbols.put(name2, s);
                }
                return () -> {
                    if (suiteName == null) {
                        CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(10);
                    }
                    if (suiteName.equals(this.getTestSuiteText())) {
                        this.scheduleSuiteAndTestsUpdate();
                    }
                };
            };
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode()) {
                ((Runnable)app.runReadAction(action)).run();
            } else {
                ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)new ReadTask(){

                    public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return new ReadTask.Continuation((Runnable)action.compute(), ModalityState.any());
                    }

                    public void onCanceled(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        if (!CidrGoogleTestRunConfigurationEditor.this.myProject.isDisposed() && CidrGoogleTestRunConfigurationEditor.this.getAnySymbolForSuite(suiteName) == null) {
                            ProgressIndicatorUtils.scheduleWithWriteActionPriority((ReadTask)this);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        objectArray2[0] = "indicator";
                        objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestRunConfigurationEditor$1";
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "performInReadAction";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "onCanceled";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }
        }
        return true;
    }

    @NotNull
    protected OCFieldAdapterForSymbolName createSuiteAdapter() {
        OCFieldAdapterForSymbolName oCFieldAdapterForSymbolName = new OCFieldAdapterForSymbolName(){

            @Override
            protected boolean isTopLevelOnly() {
                return false;
            }

            @Override
            @NotNull
            public String getReadableName(@NotNull OCSymbol symbol) {
                Couple<String> pair2;
                if (symbol == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (symbol instanceof OCStructSymbol && (pair2 = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)symbol, CidrGoogleTestRunConfigurationEditor.this.myProject)) != null) {
                    String string = (String)pair2.first;
                    if (string == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = super.getReadableName(symbol);
                if (string == null) {
                    2.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "symbol";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestRunConfigurationEditor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestRunConfigurationEditor$2";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReadableName";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getReadableName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (oCFieldAdapterForSymbolName == null) {
            CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(4);
        }
        return oCFieldAdapterForSymbolName;
    }

    @Nullable
    private OCStructSymbol getAnySymbolForSuite(@NotNull String suiteName) {
        String prefix;
        Map.Entry<String, OCStructSymbol> entry;
        if (suiteName == null) {
            CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(5);
        }
        return (entry = this.myTestSymbols.ceilingEntry(prefix = suiteName + "_")) != null && entry.getKey().startsWith(prefix) ? entry.getValue() : null;
    }

    @Override
    public boolean isValidSuiteName() {
        String className = this.getTestSuiteText();
        if (className == null || this.collectTestSymbols(className)) {
            return false;
        }
        OCStructSymbol symbol = this.getAnySymbolForSuite(className);
        return symbol != null && CidrGoogleTestUtil.googleTestNameMatches(symbol, className, this.myProject);
    }

    @Override
    @NotNull
    public Set<String> collectSuiteTests() {
        String className = this.getTestSuiteText();
        if (className == null || this.collectTestSymbols(className)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(6);
            }
            return set;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String prefix = className + "_";
        for (Map.Entry<String, OCStructSymbol> each : this.myTestSymbols.tailMap(prefix).entrySet()) {
            if (!each.getKey().startsWith(prefix)) break;
            Couple<String> name2 = CidrGoogleTestUtil.extractGoogleTestName(each.getValue(), this.myProject);
            if (name2 == null || !((String)name2.getFirst()).equals(className)) continue;
            result.add((String)name2.second);
        }
        LinkedHashSet<String> linkedHashSet = result;
        if (linkedHashSet == null) {
            CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    @Override
    @NotNull
    protected List<TARGET> getTargets() {
        List list = ContainerUtil.filter(this.myConfigHelper.getTargets(), target -> target.isExecutable());
        if (list == null) {
            CidrGoogleTestRunConfigurationEditor.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Override
    protected String getSuitePlaceholder() {
        return CidrBundle.message("test.allTestSuites", new Object[0]);
    }

    @Override
    protected String getSuitesTipMessage() {
        return CidrBundle.message("gtest.testSuitesTip", new Object[0]);
    }

    @Override
    protected String getTestFieldLabelName() {
        return CidrBundle.message("test.configuration.test", new Object[0]);
    }

    @Override
    protected String getSuiteFieldLabelName() {
        return CidrBundle.message("test.configuration.suite", new Object[0]);
    }

    @Override
    protected String getAllTestsMessage() {
        return CidrBundle.message("test.allTestsInSuite", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configHelper";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestRunConfigurationEditor";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestRunConfigurationEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuiteCompletionCondition";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSuiteAdapter";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "collectSuiteTests";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectTestSymbols";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAnySymbolForSuite";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectTestSymbols$2";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

