/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestScopeElement
extends CidrTestScopeElement {
    private final String myInstantiation;
    private final String myParam;

    public CidrGoogleTestScopeElement(@Nullable String clazz, @Nullable String method, @Nullable String instantiation, @Nullable String param) {
        super(clazz, method);
        this.myInstantiation = instantiation;
        this.myParam = param;
    }

    @Override
    public boolean isPatternLike() {
        return this.myParam != null || this.myInstantiation != null;
    }

    @Override
    @Nullable
    public String getConfigurationName() {
        String configurationName = this.mySuiteName;
        if (this.myTestName != null) {
            configurationName = configurationName + "." + this.myTestName;
        }
        if (this.myInstantiation != null) {
            configurationName = this.myInstantiation + "-" + configurationName;
        }
        return configurationName;
    }

    @Override
    @NotNull
    public String getPatternForCommandLine() {
        String method = StringUtil.notNullize((String)this.myTestName, (String)"*");
        String clazz = StringUtil.notNullize((String)this.mySuiteName, (String)"*");
        String param = StringUtil.notNullize((String)this.myParam, (String)"*");
        if (this.myInstantiation != null) {
            String string = String.format("%s/%s.%s/%s:%s/%s/%s.%s", this.myInstantiation, clazz, method, param, this.myInstantiation, clazz, param, method);
            if (string == null) {
                CidrGoogleTestScopeElement.$$$reportNull$$$0(0);
            }
            return string;
        }
        if (this.mySuiteName == null) {
            if ("*" == null) {
                CidrGoogleTestScopeElement.$$$reportNull$$$0(1);
            }
            return "*";
        }
        String string = String.format("%s.%s:%s/%s.%s:*/%s.%s/*:*/%s/*.%s", clazz, method, clazz, param, method, clazz, method, clazz, method);
        if (string == null) {
            CidrGoogleTestScopeElement.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestScopeElement", "getPatternForCommandLine"));
    }
}

