/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.google;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.Producer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestCommandLineState;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestObject;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestScopeElement;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestUtil {
    private static final Pattern namePattern = Pattern.compile("\\w+_\\w+_Test");
    private static final Set<String> GOOGLE_TEST_MACRO_NAMES = ContainerUtil.newHashSet((Object[])new String[]{"GTEST_TEST_", "TEST_P", "TYPED_TEST", "TYPED_TEST_P"});
    private static final String TEST_METHOD_NAME = "TestBody";

    @Nullable
    public static OCStructSymbol findGoogleTestSymbol(@NotNull Project project2, @NotNull String suiteName, @NotNull String testName) {
        Ref result;
        boolean found;
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(0);
        }
        if (suiteName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(1);
        }
        if (testName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(2);
        }
        boolean bl = found = !OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)((Processor)arg_0 -> CidrGoogleTestUtil.lambda$findGoogleTestSymbol$0(suiteName, testName, project2, result = new Ref(), arg_0)), suiteName + "_" + testName + "_Test");
        if (!found) {
            OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)((Processor)symbol -> {
                OCSymbol res;
                if (testName == null) {
                    CidrGoogleTestUtil.$$$reportNull$$$0(54);
                }
                OCSymbol oCSymbol = res = symbol instanceof OCNamespaceSymbol ? ((OCNamespaceSymbol)symbol).findMember(testName) : null;
                if (res instanceof OCStructSymbol) {
                    result.set((Object)((OCStructSymbol)res));
                }
                return true;
            }), "gtest_case_" + suiteName + "_");
        }
        return (OCStructSymbol)result.get();
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbols(Project project2) {
        Collection<OCStructSymbol> collection = CidrGoogleTestUtil.findGoogleTestSymbolsForSuite(project2, null, false, true);
        if (collection == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(3);
        }
        return collection;
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbolsForSuiteRandomly(Project project2, @Nullable String suiteName, boolean onlyFirst) {
        Collection<OCStructSymbol> collection = CidrGoogleTestUtil.findGoogleTestSymbolsForSuite(project2, suiteName, onlyFirst, false);
        if (collection == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public static Collection<OCStructSymbol> findGoogleTestSymbolsForSuiteSorted(Project project2, @Nullable String suiteName) {
        Collection<OCStructSymbol> collection = CidrGoogleTestUtil.findGoogleTestSymbolsForSuite(project2, suiteName, false, true);
        if (collection == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    private static Collection<OCStructSymbol> findGoogleTestSymbolsForSuite(final Project project2, final @Nullable String suiteName, boolean onlyFirst, boolean sorted) {
        Pattern suiteNamePattern = suiteName == null ? namePattern : CidrGoogleTestUtil.getSimpleTestPattern(suiteName);
        ArrayList<OCStructSymbol> result = new ArrayList<OCStructSymbol>();
        CommonProcessors.CollectProcessor<OCSymbol> allNamespaceCollector = new CommonProcessors.CollectProcessor<OCSymbol>(){

            @Contract(value="null -> false")
            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCNamespaceSymbol && (suiteName == null || symbol.getName().contains(suiteName));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)allNamespaceCollector, null);
        Processor processor2 = symbol -> {
            OCStructSymbol foundSymbol = null;
            if (symbol instanceof OCStructSymbol) {
                boolean ok;
                OCStructSymbol s = (OCStructSymbol)symbol;
                boolean bl = ok = suiteNamePattern.matcher(s.getName()).matches() && (suiteName == null || CidrGoogleTestUtil.googleTestNameMatches(s, suiteName, project2)) && CidrGoogleTestUtil.isGoogleTestClass(s, project2) && !CidrGoogleTestUtil.isTypeParameterizedTest(s, project2);
                if (ok) {
                    foundSymbol = s;
                }
            } else {
                boolean ok;
                boolean bl = suiteName == null ? symbol.getName().startsWith("gtest_case_") && symbol.getName().endsWith("_") : (ok = symbol.getName().equals("gtest_case_" + suiteName + "_"));
                if (ok) {
                    CommonProcessors.FindFirstProcessor<OCSymbol> processor1 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

                        @Contract(value="null -> false")
                        protected boolean accept(OCSymbol symbol) {
                            return symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol, project2);
                        }
                    };
                    ((OCNamespaceSymbol)symbol).processMembers((String)null, (Processor<OCSymbol>)processor1);
                    if (processor1.isFound()) {
                        foundSymbol = (OCStructSymbol)processor1.getFoundValue();
                    }
                }
            }
            if (foundSymbol != null) {
                result.add(foundSymbol);
                return !onlyFirst;
            }
            return true;
        };
        ContainerUtil.process((Iterable)allNamespaceCollector.getResults(), (Processor)processor2);
        if (!onlyFirst && sorted) {
            ContainerUtil.sort(result, (s1, s2) -> {
                int res = s1.getName().compareTo(s2.getName());
                if (res != 0) {
                    return res;
                }
                res = s1.getOffset() - s2.getOffset();
                if (res != 0) {
                    return res;
                }
                return s1.getContainingFile() == null || s2.getContainingFile() == null ? 0 : FileUtil.comparePaths((String)s1.getContainingFile().getPath(), (String)s2.getContainingFile().getPath());
            });
        }
        ArrayList<OCStructSymbol> arrayList = result;
        if (arrayList == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @NotNull
    public static Pattern getSimpleTestPattern(@NotNull String suiteName) {
        if (suiteName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(7);
        }
        Pattern pattern = Pattern.compile(Pattern.quote(suiteName) + "_\\w+_Test");
        if (pattern == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(8);
        }
        return pattern;
    }

    private static boolean isTypeParameterizedTest(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(9);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(10);
        }
        return !CidrGoogleTestUtil.extractTypeParameterizedArguments(symbol, project2).isEmpty();
    }

    @Contract(value="null, _, _ -> false")
    public static boolean isGoogleTestFixture(@Nullable OCStructSymbol symbol, boolean recursively, @NotNull Project project2) {
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(11);
        }
        return symbol != null && CidrGoogleTestUtil.findGoogleTestFixture(symbol, recursively, project2) != null;
    }

    @Nullable
    public static OCStructSymbol findGoogleTestFixture(@NotNull OCStructSymbol symbol, boolean recursively, @NotNull Project project2) {
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(12);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(13);
        }
        if (CidrGoogleTestUtil.isGoogleTestClass(symbol, project2) && CidrGoogleTestUtil.extractGoogleTestName(symbol, project2) == null) {
            return symbol;
        }
        if (!recursively) {
            return null;
        }
        Ref found = Ref.create();
        OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
        symbol.processAllBaseClasses(context, (symbol1, visibility) -> {
            boolean ok;
            if (project2 == null) {
                CidrGoogleTestUtil.$$$reportNull$$$0(53);
            }
            boolean bl = ok = symbol1 instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestFixture((OCStructSymbol)symbol1, false, project2);
            if (ok) {
                found.set((Object)((OCStructSymbol)symbol1));
            }
            return !ok;
        }, false);
        return (OCStructSymbol)found.get();
    }

    public static boolean isGoogleTestClass(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(14);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(15);
        }
        OCResolveContext context = OCResolveContext.forSymbol(symbol, project2);
        return symbol.getKind() == OCSymbolKind.STRUCT && CidrGoogleTestUtil.isGoogleTestClassWithAnyAncestor(symbol, context, "Test");
    }

    @Contract(value="null, _ -> null")
    public static OCStruct getGoogleTestClassSymbolFromBody(@Nullable OCSymbol symbol, @NotNull Project project2) {
        OCSymbol owner2;
        OCSymbolWithQualifiedName resolvedOwner;
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(16);
        }
        if (symbol instanceof OCFunctionSymbol && symbol.getName().equals(TEST_METHOD_NAME) && (resolvedOwner = ((OCFunctionSymbol)symbol).getResolvedOwner(OCResolveContext.forSymbol(symbol, project2))) != null && (owner2 = resolvedOwner.getDefinitionSymbol(project2)) instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)owner2, project2)) {
            return (OCStruct)owner2.locateDefinition(project2);
        }
        return null;
    }

    public static boolean isGoogleTestClassWithAnyAncestor(@NotNull OCStructSymbol symbol, @NotNull OCResolveContext context, String ... ancestorNames) {
        Set canonicalNames;
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(17);
        }
        if (context == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(18);
        }
        if (ancestorNames == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(19);
        }
        return !symbol.processAllBaseClasses((arg_0, arg_1) -> CidrGoogleTestUtil.lambda$isGoogleTestClassWithAnyAncestor$6(context, canonicalNames = ContainerUtil.map2Set((Object[])ancestorNames, s -> "::testing::" + s), arg_0, arg_1), context);
    }

    @Nullable
    public static Couple<String> extractGoogleTestName(@Nullable OCStructSymbol symbol, @NotNull Project project2) {
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(20);
        }
        List<Object> arguments = Collections.emptyList();
        if (symbol != null) {
            OCDeclarator varDeclarator;
            OCDeclaration declaration;
            String name2 = symbol.getName();
            if (name2.endsWith("_Test") && (declaration = (OCDeclaration)PsiTreeUtil.getParentOfType(symbol.locateDefinition(project2), OCDeclaration.class)) != null && (varDeclarator = (OCDeclarator)PsiTreeUtil.getChildOfType((PsiElement)(declaration = (OCDeclaration)PsiTreeUtil.getNextSiblingOfType((PsiElement)declaration, OCDeclaration.class)), OCDeclarator.class)) != null) {
                if ("test_info_".equals(varDeclarator.getName())) {
                    arguments = CidrGoogleTestUtil.extractMethodArguments(varDeclarator);
                } else {
                    String varName = "gtest_" + name2.substring(0, name2.length() - "_Test".length()) + "_registered_";
                    if (varName.equals(varDeclarator.getName())) {
                        List<OCExpression> result = CidrGoogleTestUtil.extractMethodArguments(varDeclarator);
                        if (result.size() >= 5) {
                            arguments = result.subList(2, 4);
                        } else if (result.size() >= 3) {
                            arguments = result.subList(1, 3);
                        }
                    }
                }
            }
            if (arguments.isEmpty()) {
                arguments = CidrGoogleTestUtil.extractMethodArguments(symbol, "AddToRegistry", project2);
            }
            if (arguments.isEmpty()) {
                arguments = CidrGoogleTestUtil.extractTypeParameterizedArguments(symbol, project2);
            }
        }
        if (arguments.size() >= 2) {
            String className = StringUtil.unquoteString((String)CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(0)));
            String methodName = StringUtil.unquoteString((String)CidrGoogleTestUtil.extractArgumentValue((PsiElement)arguments.get(1)));
            return Couple.of((Object)className, (Object)methodName);
        }
        return null;
    }

    private static List<OCExpression> extractTypeParameterizedArguments(@NotNull OCStructSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(21);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(22);
        }
        List<OCExpression> arguments = Collections.emptyList();
        if (symbol.getParent() instanceof OCNamespaceSymbol && (arguments = CidrGoogleTestUtil.extractMethodArguments((OCNamespaceSymbol)symbol.getParent(), "gtest_" + symbol.getName() + "_defined_", project2)).size() >= 4) {
            arguments = arguments.subList(2, 4);
        }
        return arguments;
    }

    public static boolean googleTestNameMatches(@NotNull OCStructSymbol symbol, @NotNull String suiteName, @NotNull Project project2) {
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(23);
        }
        if (suiteName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(24);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(25);
        }
        return CidrGoogleTestUtil.googleTestNameMatches(symbol, suiteName, null, project2);
    }

    public static boolean googleTestNameMatches(@NotNull OCStructSymbol symbol, @NotNull String suiteName, @Nullable String testName, @NotNull Project project2) {
        Couple<String> name2;
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(26);
        }
        if (suiteName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(27);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(28);
        }
        return (name2 = CidrGoogleTestUtil.extractGoogleTestName(symbol, project2)) != null && suiteName.equals(name2.first) && (testName == null || testName.equals(name2.second));
    }

    @Nullable
    public static OCMacroCall findGoogleTestMacros(@Nullable PsiElement element) {
        return CidrGoogleTestUtil.findMacros(element, GOOGLE_TEST_MACRO_NAMES);
    }

    @Nullable
    private static OCMacroCall findMacros(@Nullable PsiElement element, @NotNull Set<String> macroNames) {
        if (macroNames == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(29);
        }
        element = PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class});
        while (element instanceof OCMacroCall) {
            String referenceName;
            OCReferenceElement referenceElement = ((OCMacroCall)element).getMacroReferenceElement();
            String string = referenceName = referenceElement == null ? null : referenceElement.getName();
            if (macroNames.contains(referenceName)) {
                return (OCMacroCall)element;
            }
            element = element.getNextSibling();
        }
        return null;
    }

    @Nullable
    public static Couple<String> extractFullSuiteNameFromMacro(@NotNull PsiElement element) {
        Pair<String, List<String>> result;
        if (element == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(30);
        }
        if ((result = CidrGoogleTestUtil.extractMacroArgumentValues(element, ContainerUtil.newHashSet((Object[])new String[]{"TYPED_TEST", "INSTANTIATE_TEST_CASE_P", "INSTANTIATE_TYPED_TEST_CASE_P"}), 0, 1)) == null) {
            result = CidrGoogleTestUtil.extractMacroArgumentValues(element, ContainerUtil.newHashSet((Object[])new String[]{"TYPED_TEST_CASE", "TYPED_TEST_CASE_P", "REGISTER_TYPED_TEST_CASE_P"}), 0, 0);
            return result == null ? null : Couple.of(((List)result.second).get(0), null);
        }
        return "TYPED_TEST".equals(result.first) ? Couple.of(((List)result.second).get(0), ((List)result.second).get(1)) : Couple.of(((List)result.second).get(1), ((List)result.second).get(0));
    }

    @Nullable
    private static Pair<String, List<String>> extractMacroArgumentValues(@NotNull PsiElement element, @NotNull Set<String> macroNames, int beginIndex, int endIndex) {
        OCMacroCall macroCall;
        if (element == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(31);
        }
        if (macroNames == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(32);
        }
        if ((macroCall = CidrGoogleTestUtil.findMacros(element, macroNames)) != null) {
            OCReferenceElement referenceElement = macroCall.getMacroReferenceElement();
            String macroName = referenceElement == null ? "" : referenceElement.getName();
            List<OCMacroCallArgument> arguments = macroCall.getArguments();
            if (arguments.size() > endIndex) {
                ArrayList<String> result = new ArrayList<String>();
                while (beginIndex <= endIndex) {
                    result.add(CidrGoogleTestUtil.extractArgumentValue(arguments.get(beginIndex++)));
                }
                return Pair.create((Object)macroName, result);
            }
        }
        return null;
    }

    @NotNull
    public static String extractArgumentValue(@Nullable PsiElement element) {
        LeafPsiElement leafPsiElement = (LeafPsiElement)PsiTreeUtil.findChildOfType((PsiElement)element, LeafPsiElement.class);
        String string = leafPsiElement == null ? "" : StringUtil.notNullize((String)leafPsiElement.getText());
        if (string == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(33);
        }
        return string;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCNamespaceSymbol parent, @NotNull String methodName, @NotNull Project project2) {
        OCSymbol member;
        if (parent == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(34);
        }
        if (methodName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(35);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(36);
        }
        List<OCExpression> list = (member = parent.findMember(methodName)) != null ? CidrGoogleTestUtil.extractMethodArguments(member, project2) : Collections.emptyList();
        if (list == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(37);
        }
        return list;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@Nullable PsiElement psiElement) {
        PsiElement parent;
        OCCallExpression expression;
        if (psiElement != null && (expression = (OCCallExpression)PsiTreeUtil.findChildOfType((PsiElement)(parent = psiElement.getParent()), OCCallExpression.class)) != null) {
            List<OCExpression> list = expression.getArguments();
            if (list == null) {
                CidrGoogleTestUtil.$$$reportNull$$$0(38);
            }
            return list;
        }
        List<OCExpression> list = Collections.emptyList();
        if (list == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(39);
        }
        return list;
    }

    @NotNull
    private static List<OCExpression> extractMethodArguments(@NotNull OCSymbol symbol, @NotNull Project project2) {
        if (symbol == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(40);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(41);
        }
        List<OCExpression> list = CidrGoogleTestUtil.extractMethodArguments(symbol.locateDefinition(project2));
        if (list == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(42);
        }
        return list;
    }

    @Nullable
    public static OCSymbol findGoogleTestInstantiationSymbol(@NotNull Project project2, @NotNull String suiteName, @NotNull String instantiationName) {
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(43);
        }
        if (suiteName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(44);
        }
        if (instantiationName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(45);
        }
        CommonProcessors.FindFirstProcessor processor2 = new CommonProcessors.FindFirstProcessor();
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)processor2, "gtest_" + instantiationName + suiteName + "_dummy_");
        if (processor2.isFound()) {
            return (OCSymbol)processor2.getFoundValue();
        }
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)processor2, "gtest_" + instantiationName + "_" + suiteName);
        return (OCSymbol)processor2.getFoundValue();
    }

    public static boolean fileIncludesGoogleTest(final @NotNull PsiFile file) {
        if (file == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(46);
        }
        CommonProcessors.CollectProcessor<OCSymbol> processor2 = new CommonProcessors.CollectProcessor<OCSymbol>(){

            @Contract(value="null -> false")
            protected boolean accept(OCSymbol symbol) {
                return symbol instanceof OCStructSymbol && "::testing::TestCase".equals(symbol.getType().getCanonicalName(OCResolveContext.forPsi((PsiElement)file)));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(file.getProject(), (Processor<OCSymbol>)processor2, "TestCase");
        for (OCSymbol testSymbol : processor2.getResults()) {
            Collection<VirtualFile> roots;
            if (testSymbol.getContainingFile() == null || !(roots = OCImportGraph.getAllHeaderRoots(file.getProject(), testSymbol.getContainingFile())).contains(file.getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> null")
    static CidrGoogleTestObject findTestFromStruct(@Nullable PsiElement maybeStruct) {
        OCSymbol structSymbol;
        if (maybeStruct instanceof OCStruct && (structSymbol = ((OCStruct)maybeStruct).getSymbol()) != null && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)structSymbol, maybeStruct.getProject())) {
            return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.TEST, maybeStruct);
        }
        return null;
    }

    @Contract(value="null -> null")
    static CidrGoogleTestObject findTestFromFunction(@Nullable PsiElement maybeFunction) {
        OCStruct struct;
        if (maybeFunction instanceof OCFunctionDeclaration && (struct = CidrGoogleTestUtil.getGoogleTestClassSymbolFromBody(((OCFunctionDeclaration)maybeFunction).getSymbol(), maybeFunction.getProject())) != null) {
            return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.TEST, struct);
        }
        return null;
    }

    @Contract(value="null -> null")
    static CidrGoogleTestObject findTestFromMacroOrFirstMacroArg(@Nullable PsiElement maybeMacroOrFirstMacroArg) {
        boolean isSuite;
        boolean bl = isSuite = maybeMacroOrFirstMacroArg instanceof OCMacroCallArgument && PsiTreeUtil.findChildOfType((PsiElement)maybeMacroOrFirstMacroArg.getParent(), OCMacroCallArgument.class) == maybeMacroOrFirstMacroArg;
        if (isSuite) {
            maybeMacroOrFirstMacroArg = PsiTreeUtil.getNonStrictParentOfType((PsiElement)maybeMacroOrFirstMacroArg, (Class[])new Class[]{OCMacroCall.class});
        }
        if (maybeMacroOrFirstMacroArg instanceof OCMacroCall) {
            Collection<OCStructSymbol> res;
            Couple<String> suite;
            List<OCMacroCallArgument> arguments;
            Project project2 = maybeMacroOrFirstMacroArg.getProject();
            OCMacroCall gtestMacro = CidrGoogleTestUtil.findGoogleTestMacros(maybeMacroOrFirstMacroArg);
            if (gtestMacro != null && (arguments = gtestMacro.getArguments()).size() >= 2) {
                OCStruct targetElement;
                String testName;
                OCMacroCallArgument suiteArg = arguments.get(0);
                OCMacroCallArgument testArg = arguments.get(1);
                String suiteName = CidrGoogleTestUtil.extractArgumentValue(suiteArg);
                OCStructSymbol symbol = CidrGoogleTestUtil.findGoogleTestSymbol(project2, suiteName, testName = CidrGoogleTestUtil.extractArgumentValue(testArg));
                if (symbol != null && (targetElement = (OCStruct)symbol.locateDefinition(project2)) != null) {
                    return new CidrGoogleTestObject(isSuite ? CidrGoogleTestObject.KIND.SUITE : CidrGoogleTestObject.KIND.TEST, targetElement);
                }
            }
            if ((suite = CidrGoogleTestUtil.extractFullSuiteNameFromMacro(maybeMacroOrFirstMacroArg)) != null && (res = CidrGoogleTestUtil.findGoogleTestSymbolsForSuiteRandomly(project2, (String)suite.first, true)).size() != 0) {
                OCStruct struct = (OCStruct)res.iterator().next().locateDefinition(project2);
                if (struct == null) {
                    return null;
                }
                return new CidrGoogleTestObject(CidrGoogleTestObject.KIND.SUITE, struct, (String)suite.second, null);
            }
        }
        return null;
    }

    @Contract(value="null -> null")
    static CidrGoogleTestObject getTestObjectFromTestHolder(@Nullable PsiElement maybeTestHolder) {
        CidrGoogleTestObject ret = CidrGoogleTestUtil.findTestFromStruct(maybeTestHolder);
        if (ret == null) {
            ret = CidrGoogleTestUtil.findTestFromFunction(maybeTestHolder);
        }
        if (ret == null) {
            ret = CidrGoogleTestUtil.findTestFromMacroOrFirstMacroArg(maybeTestHolder);
        }
        return ret;
    }

    @NotNull
    protected static CidrTestScopeElement determineScope(@NotNull CidrGoogleTestObject object) {
        if (object == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(47);
        }
        if (object.kind == CidrGoogleTestObject.KIND.FILE) {
            OCFile file = (OCFile)object.element;
            CidrTestScopeElement cidrTestScopeElement = CidrTestScopeElement.createFileTestScopeElement(file, (Producer<String>)((Producer)() -> {
                if (object == null) {
                    CidrGoogleTestUtil.$$$reportNull$$$0(51);
                }
                CidrTestScope testScope = (CidrTestScope)CidrGoogleTestCommandLineState.EMPTY_TEST_SCOPE_PRODUCER.produce();
                Collection classes = PsiTreeUtil.findChildrenOfType((PsiElement)file, OCStruct.class);
                for (OCStruct s : classes) {
                    OCStructSymbol symbol = (OCStructSymbol)s.getSymbol();
                    if (symbol == null || !CidrGoogleTestUtil.isGoogleTestClass(symbol, s.getProject())) continue;
                    Couple<String> pair2 = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)s.getSymbol(), object.element.getProject());
                    testScope.addScopeElement(new CidrGoogleTestScopeElement(pair2 == null ? s.getName() : (String)pair2.first, null, null, null));
                }
                return testScope.getAsPattern();
            }));
            if (cidrTestScopeElement == null) {
                CidrGoogleTestUtil.$$$reportNull$$$0(48);
            }
            return cidrTestScopeElement;
        }
        Couple<String> res = CidrGoogleTestUtil.extractGoogleTestName((OCStructSymbol)((OCStruct)object.element).getSymbol(), object.element.getProject());
        if (res == null) {
            String suiteName = ((OCStruct)object.element).getName();
            CidrGoogleTestScopeElement cidrGoogleTestScopeElement = new CidrGoogleTestScopeElement(suiteName, null, null, object.param);
            if (cidrGoogleTestScopeElement == null) {
                CidrGoogleTestUtil.$$$reportNull$$$0(49);
            }
            return cidrGoogleTestScopeElement;
        }
        CidrGoogleTestScopeElement cidrGoogleTestScopeElement = new CidrGoogleTestScopeElement((String)res.first, object.kind == CidrGoogleTestObject.KIND.TEST ? (String)res.second : null, object.instantiation, object.param);
        if (cidrGoogleTestScopeElement == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(50);
        }
        return cidrGoogleTestScopeElement;
    }

    private static /* synthetic */ boolean lambda$isGoogleTestClassWithAnyAncestor$6(@NotNull OCResolveContext context, Set canonicalNames, OCSymbol symbol1, OCVisibility visibility) {
        if (context == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(52);
        }
        if (!(symbol1 instanceof OCSymbolWithQualifiedName)) {
            return true;
        }
        OCQualifiedName qualifiedName = ((OCSymbolWithQualifiedName)symbol1).getResolvedQualifiedNameWithoutArguments(context);
        return qualifiedName == null || !canonicalNames.contains(qualifiedName.getFullName(context));
    }

    private static /* synthetic */ boolean lambda$findGoogleTestSymbol$0(@NotNull String suiteName, @NotNull String testName, @NotNull Project project2, Ref result, OCSymbol ocSymbol) {
        if (suiteName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(55);
        }
        if (testName == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(56);
        }
        if (project2 == null) {
            CidrGoogleTestUtil.$$$reportNull$$$0(57);
        }
        if (ocSymbol instanceof OCStructSymbol && CidrGoogleTestUtil.googleTestNameMatches((OCStructSymbol)ocSymbol, suiteName, testName, project2)) {
            result.set((Object)((OCStructSymbol)ocSymbol));
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 50: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 50: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: 
            case 24: 
            case 27: 
            case 44: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 2: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestUtil";
                break;
            }
            case 9: 
            case 12: 
            case 14: 
            case 17: 
            case 21: 
            case 23: 
            case 26: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 18: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestorNames";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "macroNames";
                break;
            }
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instantiationName";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/google/CidrGoogleTestUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoogleTestSymbols";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoogleTestSymbolsForSuiteRandomly";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoogleTestSymbolsForSuiteSorted";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findGoogleTestSymbolsForSuite";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSimpleTestPattern";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "extractArgumentValue";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMethodArguments";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "determineScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findGoogleTestSymbol";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 50: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSimpleTestPattern";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isTypeParameterizedTest";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isGoogleTestFixture";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findGoogleTestFixture";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isGoogleTestClass";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getGoogleTestClassSymbolFromBody";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isGoogleTestClassWithAnyAncestor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "extractGoogleTestName";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "extractTypeParameterizedArguments";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "googleTestNameMatches";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "findMacros";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "extractFullSuiteNameFromMacro";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "extractMacroArgumentValues";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "extractMethodArguments";
                break;
            }
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "findGoogleTestInstantiationSymbol";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "fileIncludesGoogleTest";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "determineScope";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "lambda$determineScope$7";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isGoogleTestClassWithAnyAncestor$6";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findGoogleTestFixture$4";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findGoogleTestSymbol$1";
                break;
            }
            case 55: 
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findGoogleTestSymbol$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 33: 
            case 37: 
            case 38: 
            case 39: 
            case 42: 
            case 48: 
            case 49: 
            case 50: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

