/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import com.intellij.execution.testframework.sm.runner.GeneralIdBasedToSMTRunnerEventsConvertor;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.CidrTestLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class CidrCatchOutputToGeneralTestEventsConverter
extends OutputToGeneralTestEventsConverter {
    private static final String CATCH_TAG = "Catch";
    private static final String STDOUT_TAG = "StdOut";
    private static final String STDERR_TAG = "StdErr";
    private static final String ORIGINAL_TAG = "Original";
    private static final String EXPANDED_TAG = "Expanded";
    private static final String GROUP_TAG = "Group";
    private static final String TEST_CASE_TAG = "TestCase";
    private static final String SECTION_TAG = "Section";
    private static final String OVERALL_RESULT_TAG = "OverallResult";
    private static final String OVERALL_RESULTS_TAG = "OverallResults";
    private static final String EXPRESSION_TAG = "Expression";
    private static final String INFO_TAG = "Info";
    private static final String WARNING_TAG = "Warning";
    private static final String FAILURE_TAG = "Failure";
    private static final String FATAL_ERROR_CONDITION_TAG = "FatalErrorCondition";
    private static final String EXCEPTION_TAG = "Exception";
    private static final String NAME_ATTR = "name";
    private static final String TAGS_ATTR = "tags";
    private static final String DURATION_IN_SECONDS_ATTR = "durationInSeconds";
    private static final String SUCCESS_ATTR = "success";
    private static final String SUCCESSES_ATTR = "successes";
    private static final String FAILURES_ATTR = "failures";
    private static final String DESCRIPTION_ATTR = "description";
    private static final String EXPECTED_FAILURES_ATTR = "expectedFailures";
    private static final String FILE_NAME_ATTR = "filename";
    private static final String LINE_ATTR = "line";
    private static final String TYPE_ATTR = "type";
    private static final String OUT_INDENT = "  ";
    private static final String[] ALL_TAGS = new String[]{"Catch", "StdOut", "StdErr", "Original", "Expanded", "Group", "TestCase", "Section", "OverallResult", "OverallResults", "Expression", "Info", "Warning", "Failure", "FatalErrorCondition", "Exception"};
    private static final String[] ALL_ATTRS = new String[]{"name", "description", "tags", "durationInSeconds", "success", "successes", "failures", "expectedFailures", "filename", "line", "type"};
    private volatile Future<Boolean> myXMLParser;
    private volatile PipedOutputStream myPipedOutStream;
    private volatile ServiceMessageVisitor myVisitor;
    private final CidrTestEventProcessor myEventProcessor;
    private volatile boolean myXMLStarted;
    private volatile boolean myXMLParserInAction;
    private volatile String myProcessFinishedMessage;
    private volatile ExecutionConsole myConsole;
    private static final String TAGS = StringUtil.join((String[])ALL_TAGS, (String)"|");
    private static final Pattern OPEN_TAG = Pattern.compile(String.format("([^\\n]*)(\\s*<(%s)(?: (?:%s)\\=\"[^\"]*\")*\\/?>\\n)", TAGS, StringUtil.join((String[])ALL_ATTRS, (String)"|")));
    private static final Pattern CLOSE_TAG = Pattern.compile(String.format("([^\\n]*)(\\s*</(%s)>\\n)", TAGS));
    private final Stack<Boolean> myPrintfHolderStack;

    public CidrCatchOutputToGeneralTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties, @NotNull ExecutionConsole console) {
        if (testFrameworkName == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(0);
        }
        if (consoleProperties == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(1);
        }
        if (console == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(2);
        }
        super(testFrameworkName, consoleProperties);
        this.myXMLStarted = false;
        this.myXMLParserInAction = true;
        this.myPrintfHolderStack = new Stack();
        this.myConsole = console;
        this.myEventProcessor = new CidrTestEventProcessor("catch");
    }

    protected void process(@NotNull List<ServiceMessageBuilder> messages) {
        if (messages == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(3);
        }
        try {
            for (ServiceMessageBuilder each : messages) {
                super.processServiceMessages(each.toString(), ProcessOutputTypes.STDOUT, this.myVisitor);
            }
        }
        catch (Exception e) {
            CidrTestLog.LOG.error(e.getMessage());
        }
    }

    protected boolean processServiceMessages(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
        CidrOutputToGeneralTestEventsConverter.logOutput(text, outputType);
        this.myVisitor = visitor;
        if (!this.myXMLStarted && CidrCatchOutputToGeneralTestEventsConverter.isXMLHeader(text)) {
            this.myXMLStarted = true;
        }
        if (outputType == ProcessOutputTypes.STDOUT && this.myXMLStarted && this.myXMLParserInAction) {
            try {
                if (this.myXMLParser == null) {
                    this.myPipedOutStream = new PipedOutputStream();
                    PipedInputStream pipedInStream = new PipedInputStream(this.myPipedOutStream);
                    this.myXMLParser = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        boolean success = false;
                        try {
                            SAXParserFactory.newInstance().newSAXParser().parse((InputStream)pipedInStream, this.createHandler());
                            success = true;
                        }
                        catch (SAXParseException sax) {
                            if ("XML document structures must start and end within the same entity.".equals(sax.getMessage())) {
                                CidrTestLog.LOG.debug((Throwable)sax);
                            } else {
                                CidrTestLog.LOG.error((Throwable)sax);
                            }
                        }
                        catch (IOException | ParserConfigurationException e) {
                            CidrTestLog.LOG.error((Throwable)e);
                        }
                        finally {
                            try {
                                pipedInStream.close();
                            }
                            catch (IOException e) {
                                CidrTestLog.LOG.debug((Throwable)e);
                            }
                            this.myXMLParserInAction = false;
                        }
                        return success;
                    });
                }
                this.processLine(text);
                return true;
            }
            catch (IOException e) {
                this.myXMLParserInAction = false;
                CidrTestLog.LOG.error((Throwable)e);
            }
        } else if (outputType == ProcessOutputTypes.SYSTEM) {
            if (CidrOutputToGeneralTestEventsConverter.PROCESS_FINISHED_PATTERN.matcher(text).matches()) {
                this.myProcessFinishedMessage = text;
                return true;
            }
            if (text.equals("\n")) {
                return true;
            }
        }
        return false;
    }

    private void processLine(String text) throws IOException {
        if (CidrCatchOutputToGeneralTestEventsConverter.isXMLHeader(text)) {
            this.passToParser(text);
        } else {
            boolean isInPrinfTag = this.myPrintfHolderStack.size() == 0 ? false : this.myPrintfHolderStack.peek();
            Matcher m = OPEN_TAG.matcher(text);
            if (m.matches()) {
                this.processTag(isInPrinfTag, true, m);
            } else {
                m = CLOSE_TAG.matcher(text);
                if (m.matches()) {
                    this.processTag(isInPrinfTag, false, m);
                } else {
                    this.processFreeText(isInPrinfTag, text);
                }
            }
        }
        this.myPipedOutStream.flush();
    }

    @Contract(pure=true)
    private static boolean isXMLHeader(@Nullable String text) {
        return text != null && text.startsWith("<?xml version=");
    }

    private void processTag(boolean isInPrinfTag, boolean isOpenTag, Matcher m) throws IOException {
        String freeText = m.group(1);
        String tagContext = m.group(2);
        String tagName = m.group(3);
        this.processFreeText(isInPrinfTag, freeText.trim());
        if (isOpenTag) {
            this.myPrintfHolderStack.push(CidrCatchOutputToGeneralTestEventsConverter.isPrintfHolder(tagName));
        } else {
            this.myPrintfHolderStack.pop();
        }
        this.passToParser(tagContext);
    }

    private void processFreeText(boolean isInPrinfTag, @NotNull String freeText) throws IOException {
        if (freeText == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(4);
        }
        if (freeText.length() == 0) {
            return;
        }
        this.passToParser(isInPrinfTag ? String.format("<%s>%s</%s>", STDOUT_TAG, StringUtil.escapeXml((String)freeText), STDOUT_TAG) : freeText);
    }

    private static boolean isPrintfHolder(@NotNull String tag) {
        if (tag == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(5);
        }
        return TEST_CASE_TAG.equals(tag) || SECTION_TAG.equals(tag);
    }

    private void passToParser(String openTagContext) throws IOException {
        this.myPipedOutStream.write(openTagContext.getBytes("UTF-8"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBufferOnProcessTermination(int exitCode) {
        CidrTestLog.LOG.debug("flushBufferOnProcessTermination");
        if (this.myPipedOutStream != null) {
            try {
                this.myPipedOutStream.close();
            }
            catch (IOException e) {
                CidrTestLog.LOG.debug((Throwable)e);
            }
            finally {
                this.myPipedOutStream = null;
            }
        }
        if (this.myXMLParser != null) {
            try {
                GeneralTestEventsProcessor processor2;
                Boolean isSuccessXMLParsing = this.myXMLParser.get();
                if (CidrTestLog.LOG.isDebugEnabled()) {
                    CidrTestLog.LOG.debug("parsing finished:" + isSuccessXMLParsing.toString());
                }
                if ((processor2 = this.getProcessor()) != null && this.myProcessFinishedMessage != null) {
                    processor2.onUncapturedOutput(this.myProcessFinishedMessage, ProcessOutputTypes.SYSTEM);
                }
            }
            catch (InterruptedException | ExecutionException e) {
                CidrTestLog.LOG.error((Throwable)e);
            }
            finally {
                this.myXMLParser = null;
                this.myXMLParserInAction = false;
            }
        }
        this.transferTextToConsoleViewInTest();
        super.flushBufferOnProcessTermination(exitCode);
    }

    private void transferTextToConsoleViewInTest() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            UIUtil.invokeAndWaitIfNeeded(() -> ((ConsoleViewImpl)((SMTRunnerConsoleView)this.myConsole).getConsole()).waitAllRequests());
        }
    }

    @NotNull
    @Contract(pure=true)
    private DefaultHandler createHandler() {
        DefaultHandler defaultHandler = new DefaultHandler(){
            static final String ROOT_NODE_ID = "0";
            final Stack<String> myTestNameStack = new Stack();
            final HashMap<String, TestEnd> myTestResults = new HashMap();
            final StringBuilder myInfoMessageWithNewLineAndIndent = new StringBuilder();
            String myExpressionPrefix;
            final StringBuilder myText = new StringBuilder();
            boolean mySuccess;
            int myDuration;
            final Stack<String> mySectionsEndIdStack = new Stack();

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                GeneralTestEventsProcessor processor2 = CidrCatchOutputToGeneralTestEventsConverter.this.getProcessor();
                if (processor2 == null) {
                    CidrTestLog.LOG.debug("startElement: processor was disposed");
                    return;
                }
                this.myText.setLength(0);
                if (CidrTestLog.LOG.isDebugEnabled()) {
                    CidrTestLog.LOG.debug("{startElement" + qName);
                }
                if (CidrCatchOutputToGeneralTestEventsConverter.GROUP_TAG.equals(qName)) {
                    processor2.onTestsReporterAttached();
                } else if (CidrCatchOutputToGeneralTestEventsConverter.TEST_CASE_TAG.equals(qName) || CidrCatchOutputToGeneralTestEventsConverter.SECTION_TAG.equals(qName)) {
                    this.startTest(processor2, attributes);
                } else if (CidrCatchOutputToGeneralTestEventsConverter.OVERALL_RESULT_TAG.equals(qName)) {
                    String seconds = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.DURATION_IN_SECONDS_ATTR);
                    if (seconds != null) {
                        this.myDuration = (int)Math.round(Double.parseDouble(seconds) * 1000.0);
                    }
                    this.mySuccess = "true".equals(attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.SUCCESS_ATTR));
                } else if (CidrCatchOutputToGeneralTestEventsConverter.OVERALL_RESULTS_TAG.equals(qName)) {
                    String seconds = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.DURATION_IN_SECONDS_ATTR);
                    if (seconds != null) {
                        this.myDuration = (int)Math.round(Double.parseDouble(seconds) * 1000.0);
                    }
                    this.mySuccess = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.FAILURES_ATTR) != null && attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.EXPECTED_FAILURES_ATTR) != null && attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.FAILURES_ATTR).equals(attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.EXPECTED_FAILURES_ATTR));
                } else if (CidrCatchOutputToGeneralTestEventsConverter.EXPRESSION_TAG.equals(qName) && !"true".equals(attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.SUCCESS_ATTR))) {
                    this.reportError(processor2, attributes, "");
                    this.myExpressionPrefix = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.TYPE_ATTR);
                } else if (CidrCatchOutputToGeneralTestEventsConverter.EXCEPTION_TAG.equals(qName)) {
                    this.reportError(processor2, attributes, "\nunexpected exception");
                } else if (CidrCatchOutputToGeneralTestEventsConverter.FATAL_ERROR_CONDITION_TAG.equals(qName)) {
                    this.reportError(processor2, attributes, "\nfatal error");
                } else if (CidrCatchOutputToGeneralTestEventsConverter.FAILURE_TAG.equals(qName)) {
                    this.reportError(processor2, attributes, "");
                }
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this.myText.append(ch, start, length);
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                GeneralTestEventsProcessor processor2 = CidrCatchOutputToGeneralTestEventsConverter.this.getProcessor();
                if (processor2 == null) {
                    CidrTestLog.LOG.debug("endElement: processor was disposed");
                    return;
                }
                if (CidrTestLog.LOG.isDebugEnabled()) {
                    CidrTestLog.LOG.debug("}endElement " + qName);
                }
                if (!CidrCatchOutputToGeneralTestEventsConverter.GROUP_TAG.equals(qName)) {
                    if (CidrCatchOutputToGeneralTestEventsConverter.TEST_CASE_TAG.equals(qName) || CidrCatchOutputToGeneralTestEventsConverter.SECTION_TAG.equals(qName)) {
                        this.endTest(processor2);
                    } else if (CidrCatchOutputToGeneralTestEventsConverter.INFO_TAG.equals(qName)) {
                        this.addInfo(this.myText.toString());
                    } else if (CidrCatchOutputToGeneralTestEventsConverter.ORIGINAL_TAG.equals(qName)) {
                        this.outMessage(processor2, CidrCatchOutputToGeneralTestEventsConverter.OUT_INDENT + StringUtil.notNullize((String)this.myExpressionPrefix) + '(' + this.myText.toString().trim() + ')', false);
                    } else if (CidrCatchOutputToGeneralTestEventsConverter.WARNING_TAG.equals(qName)) {
                        this.outMessageWithInfoHeader(processor2, "\nwarning:", true);
                    } else if (CidrCatchOutputToGeneralTestEventsConverter.EXPANDED_TAG.equals(qName)) {
                        StringBuilder message = new StringBuilder();
                        String expansion = this.myText.toString().trim();
                        if (expansion.length() != 0) {
                            message.append("\nwith expansion:\n").append(CidrCatchOutputToGeneralTestEventsConverter.OUT_INDENT).append(expansion);
                        }
                        if (this.myInfoMessageWithNewLineAndIndent.length() != 0) {
                            message.append("\nwith message:").append((CharSequence)this.myInfoMessageWithNewLineAndIndent);
                            this.myInfoMessageWithNewLineAndIndent.setLength(0);
                        }
                        message.append('\n');
                        this.outMessage(processor2, message.toString(), false);
                    } else if (CidrCatchOutputToGeneralTestEventsConverter.FAILURE_TAG.equals(qName)) {
                        this.outMessageWithInfoHeader(processor2, "explicitly with messages:", false);
                    } else if (CidrCatchOutputToGeneralTestEventsConverter.STDOUT_TAG.equals(qName) || CidrCatchOutputToGeneralTestEventsConverter.STDERR_TAG.equals(qName)) {
                        this.outMessage(processor2, this.myText.toString().trim() + "\n", CidrCatchOutputToGeneralTestEventsConverter.STDOUT_TAG.equals(qName));
                    }
                }
            }

            private void addInfo(@NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.myInfoMessageWithNewLineAndIndent.append("\n").append(CidrCatchOutputToGeneralTestEventsConverter.OUT_INDENT).append(text.trim());
            }

            private void outMessageWithInfoHeader(GeneralTestEventsProcessor processor2, String header, boolean std) {
                this.addInfo(this.myText.toString());
                String message = header + this.myInfoMessageWithNewLineAndIndent + "\n";
                this.myInfoMessageWithNewLineAndIndent.setLength(0);
                this.outMessage(processor2, message, std);
            }

            private void outMessage(GeneralTestEventsProcessor processor2, String message, boolean toStd) {
                String testName = this.getCurrentNodeName();
                String nodeId = this.getCurrentNodeId();
                processor2.addToInvokeLater(() -> CidrCatchOutputToGeneralTestEventsConverter.this.process(toStd ? CidrCatchOutputToGeneralTestEventsConverter.this.myEventProcessor.testStdOut(testName, nodeId, message) : CidrCatchOutputToGeneralTestEventsConverter.this.myEventProcessor.testErrOut(testName, nodeId, message)));
            }

            private void reportError(@NotNull GeneralTestEventsProcessor processor2, Attributes attributes, @NotNull String message) {
                if (processor2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (message == null) {
                    1.$$$reportNull$$$0(2);
                }
                assert (processor2 instanceof GeneralIdBasedToSMTRunnerEventsConvertor);
                String file = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.FILE_NAME_ATTR);
                String line = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.LINE_ATTR);
                String prefix = file == null || line == null ? "Failure:" : String.format("%s:%s: Failure:", file, line);
                ((GeneralIdBasedToSMTRunnerEventsConvertor)processor2).onError(this.getCurrentNodeId(), "", prefix + message, false);
            }

            private void startTest(GeneralTestEventsProcessor processor2, Attributes attributes) {
                String testName = attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.NAME_ATTR);
                String parentId = this.getCurrentNodeId();
                this.myTestNameStack.push(testName);
                String nodeId = this.getCurrentNodeId();
                if (this.mySectionsEndIdStack.size() != 0) {
                    if (nodeId.equals(this.mySectionsEndIdStack.peek())) {
                        this.mySectionsEndIdStack.pop();
                        return;
                    }
                    this.closeAllOpenSections(processor2);
                }
                String location = this.getLocation(attributes);
                String metainfo = "line:" + StringUtil.notNullize((String)attributes.getValue(CidrCatchOutputToGeneralTestEventsConverter.LINE_ATTR));
                processor2.addToInvokeLater(() -> CidrCatchOutputToGeneralTestEventsConverter.this.process(CidrCatchOutputToGeneralTestEventsConverter.this.myEventProcessor.testStarted(testName, parentId, nodeId, location, metainfo)));
            }

            private void endTest(GeneralTestEventsProcessor processor2) {
                String nodeId = this.getCurrentNodeId();
                String testName = this.myTestNameStack.pop();
                TestEnd end = this.myTestResults.get(nodeId);
                if (end == null) {
                    this.myTestResults.put(nodeId, new TestEnd(testName, nodeId, this.myDuration, this.mySuccess));
                } else {
                    end.update(this.myDuration, this.mySuccess);
                }
                this.mySectionsEndIdStack.push(nodeId);
                String parentId = this.getCurrentNodeId();
                if (ROOT_NODE_ID.equals(parentId) && this.mySectionsEndIdStack.size() != 0) {
                    this.closeAllOpenSections(processor2);
                }
            }

            private void closeAllOpenSections(GeneralTestEventsProcessor processor2) {
                this.mySectionsEndIdStack.forEach(endNodeId -> {
                    TestEnd end = this.myTestResults.get(endNodeId);
                    assert (end != null);
                    end.processEnd(processor2);
                    this.myTestResults.remove(endNodeId);
                });
                this.mySectionsEndIdStack.clear();
            }

            @NotNull
            @Contract(pure=true)
            public String getLocation(Attributes attributes) {
                String string = this.getCurrentTopTestName();
                if (string == null) {
                    1.$$$reportNull$$$0(3);
                }
                return string;
            }

            private String getCurrentNodeName() {
                return this.myTestNameStack.peek();
            }

            private String getCurrentTopTestName() {
                return (String)this.myTestNameStack.firstElement();
            }

            @NotNull
            private String getCurrentNodeId() {
                StringBuilder path = new StringBuilder();
                path.append(ROOT_NODE_ID);
                this.myTestNameStack.forEach(testName -> path.append('[').append((String)testName).append(']'));
                String string = path.toString();
                if (string == null) {
                    1.$$$reportNull$$$0(4);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: 
                    case 4: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: 
                    case 4: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processor";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLocation";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCurrentNodeId";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "addInfo";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "reportError";
                        break;
                    }
                    case 3: 
                    case 4: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }

            class TestEnd {
                String testName;
                String nodeId;
                int durationInMs;
                boolean success;

                TestEnd(@NotNull String testName, String nodeId, int durationInMs, boolean success) {
                    if (testName == null) {
                        TestEnd.$$$reportNull$$$0(0);
                    }
                    if (nodeId == null) {
                        TestEnd.$$$reportNull$$$0(1);
                    }
                    this.testName = testName;
                    this.nodeId = nodeId;
                    this.durationInMs = durationInMs;
                    this.success = success;
                }

                void update(int durationInMs, boolean success) {
                    this.durationInMs += durationInMs;
                    this.success &= success;
                }

                void processEnd(GeneralTestEventsProcessor processor2) {
                    processor2.addToInvokeLater(() -> CidrCatchOutputToGeneralTestEventsConverter.this.process(CidrCatchOutputToGeneralTestEventsConverter.this.myEventProcessor.testFinished(this.testName, this.nodeId, Integer.toString(this.durationInMs), this.success)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "testName";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "nodeId";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter$1$TestEnd";
                    objectArray[2] = "<init>";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
        };
        if (defaultHandler == null) {
            CidrCatchOutputToGeneralTestEventsConverter.$$$reportNull$$$0(6);
        }
        return defaultHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "freeText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchOutputToGeneralTestEventsConverter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processFreeText";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isPrintfHolder";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

