/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Producer;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import com.jetbrains.cidr.lang.OCLog;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestCommandLineState<CONFIGURATION extends CidrTestRunConfiguration>
extends CidrTestCommandLineState<CONFIGURATION> {
    public static final Producer<CidrTestScope> EMPTY_TEST_SCOPE_PRODUCER = () -> CidrTestScope.createEmptyTestScope(CidrCatchTestFramework.getInstance().getPatternSeparatorInCommandLine());

    public CidrCatchTestCommandLineState(@NotNull CONFIGURATION configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        if (configuration == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(0);
        }
        if (launcher == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(1);
        }
        if (env == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(3);
        }
        super(configuration, launcher, env, executor, failedTests, EMPTY_TEST_SCOPE_PRODUCER);
    }

    @NotNull
    @Contract(value="_ -> !null")
    public CidrTestScope getFromString(@Nullable String arg) {
        CidrTestScope cidrTestScope = this.createEmptyTestScope().configureForPreRenderedScope(StringUtil.notNullize((String)arg));
        if (cidrTestScope == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(4);
        }
        return cidrTestScope;
    }

    @Override
    @NotNull
    public CidrTestScope testScope() {
        if (this.myFailedTests != null) {
            CidrTestScope cidrTestScope = this.myFailedTests;
            if (cidrTestScope == null) {
                CidrCatchTestCommandLineState.$$$reportNull$$$0(5);
            }
            return cidrTestScope;
        }
        CidrTestRunConfigurationData delegate = this.myConfiguration.getTestData();
        if (delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN) {
            CidrTestScope cidrTestScope = this.getFromString(delegate.getTestPattern());
            if (cidrTestScope == null) {
                CidrCatchTestCommandLineState.$$$reportNull$$$0(6);
            }
            return cidrTestScope;
        }
        if (delegate.getTestMode() == CidrTestRunConfigurationData.Mode.SUITE_TEST) {
            if (delegate.getTestName() == null && delegate.getTestSuite() == null) {
                CidrTestScope cidrTestScope = this.getFromString(null);
                if (cidrTestScope == null) {
                    CidrCatchTestCommandLineState.$$$reportNull$$$0(7);
                }
                return cidrTestScope;
            }
            if (delegate.getTestName() == null && delegate.getTestSuite() != null) {
                CidrTestScope cidrTestScope = this.getFromString(delegate.getTestSuite());
                if (cidrTestScope == null) {
                    CidrCatchTestCommandLineState.$$$reportNull$$$0(8);
                }
                return cidrTestScope;
            }
            CidrTestScope cidrTestScope = this.getFromString(this.prepareTestNameForScope(delegate.getTestName()));
            if (cidrTestScope == null) {
                CidrCatchTestCommandLineState.$$$reportNull$$$0(9);
            }
            return cidrTestScope;
        }
        OCLog.LOG.error("Unknown CidrTestRunConfigurationData.Mode: " + (Object)((Object)delegate.getTestMode()));
        CidrTestScope cidrTestScope = this.getFromString("*");
        if (cidrTestScope == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(10);
        }
        return cidrTestScope;
    }

    @NotNull
    protected String prepareTestNameForScope(String testName) {
        String string = StringUtil.escapeChars((String)testName, (char[])new char[]{',', '[', ']'});
        if (string == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(@NotNull SMTRunnerConsoleView consoleView) {
        if (consoleView == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(12);
        }
        CidrRerunFailedTestsAction cidrRerunFailedTestsAction = CidrCatchTestCommandLineState.doCreateRerunFailedTestsActionStandard(this, consoleView, "catch://");
        if (cidrRerunFailedTestsAction == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(13);
        }
        return cidrRerunFailedTestsAction;
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String testTags, @Nullable String testMethod) {
        CidrTestScopeElement cidrTestScopeElement = CidrCatchTestFramework.getInstance().createTestScopeElementForSuiteAndTest(testTags, testMethod);
        if (cidrTestScopeElement == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(14);
        }
        return cidrTestScopeElement;
    }

    @Override
    public GeneralCommandLine prepareCommandLine(@NotNull GeneralCommandLine cl) {
        if (cl == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(15);
        }
        cl.addParameters(new String[]{"-r", "xml", "-d", "yes"});
        String scope = this.testScope().getAsPattern();
        String testOrderSwitch = "--order";
        if (!cl.getParametersList().hasParameter("--order")) {
            cl.addParameters(new String[]{"--order", "lex"});
        }
        if (scope != null) {
            CidrCatchTestCommandLineState.fixtureForAllTestsInFile(cl, scope);
            cl.addParameter(scope);
        }
        return cl;
    }

    private static void fixtureForAllTestsInFile(@NotNull GeneralCommandLine cl, @NotNull String maybeRunAllInFileScope) {
        if (cl == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(16);
        }
        if (maybeRunAllInFileScope == null) {
            CidrCatchTestCommandLineState.$$$reportNull$$$0(17);
        }
        if (maybeRunAllInFileScope.startsWith("[#") && maybeRunAllInFileScope.endsWith("]")) {
            cl.addParameter("-#");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcher";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestCommandLineState";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "maybeRunAllInFileScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestCommandLineState";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFromString";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "testScope";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "prepareTestNameForScope";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestScopeElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCreateRerunFailedTestsAction";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "prepareCommandLine";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fixtureForAllTestsInFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

