/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationEditorWithLWValidation;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestWithScopeElementsFramework;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestCommandLineState;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestUtil;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestRunConfigurationData
extends CidrTestRunConfigurationData<CidrTestRunConfiguration> {
    public static final Function<CidrTestRunConfiguration, CidrTestRunConfigurationData> FACTORY = connection -> new CidrCatchTestRunConfigurationData((CidrTestRunConfiguration)connection);
    @NonNls
    public static final String FRAMEWORK_ID = "Catch Test";

    public CidrCatchTestRunConfigurationData(@NotNull CidrTestRunConfiguration configuration) {
        if (configuration == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(0);
        }
        super(configuration);
    }

    @Override
    @NotNull
    protected String formatTestMethod() {
        assert (this.myTestName != null);
        String string = this.myTestName;
        if (string == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    public void checkData() throws RuntimeConfigurationException {
        Project project2 = this.myConfiguration.getProject();
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || CidrTestRunConfigurationEditorWithLWValidation.isLWValidationOn(project2)) {
            return;
        }
        if (this.myTestName == null && this.myTestSuite == null) {
            return;
        }
        Set<String> configTags = CidrCatchTestUtil.splitTags(this.myTestSuite);
        int tagGrammarCount = configTags.size();
        if (!CidrCatchTestUtil.isValidStringOfTags(this.myTestSuite)) {
            throw new RuntimeConfigurationError(CidrBundle.message("catch.notValidTags", tagGrammarCount + 1, this.myTestSuite));
        }
        boolean[] validConfig = new boolean[]{false};
        CidrTestWithScopeElementsFramework.consumeTestSymbols(project2, OCSearchScope.getExplicitlySpecifiedProjectSourceFiles(project2), null, testInfo -> {
            Set<String> testTags = CidrCatchTestUtil.splitTags(testInfo.getSuiteName());
            if (testTags.containsAll(configTags) && (this.myTestName == null || this.myTestName.equals(testInfo.getTestPath()))) {
                validConfig[0] = true;
                CidrTestWithScopeElementsFramework.stopIteration();
            }
        }, CidrCatchTestFramework.getInstance());
        if (!validConfig[0]) {
            throw new RuntimeConfigurationError(this.myTestName == null ? CidrBundle.message("catch.noTestsWithTags", tagGrammarCount, this.myTestSuite) : (this.myTestSuite == null ? CidrBundle.message("test.testNotFound", this.myTestName) : CidrBundle.message("catch.testNotFound", this.myTestName, tagGrammarCount, this.myTestSuite)));
        }
    }

    @Override
    @Nullable
    public String getTestingFrameworkId() {
        return FRAMEWORK_ID;
    }

    @Override
    public CidrCommandLineState createState(@NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        if (env == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(2);
        }
        if (executor == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(3);
        }
        return new CidrCatchTestCommandLineState<CidrTestRunConfiguration>(this.myConfiguration, this.myConfiguration.createLauncher(env), failedTests, env, executor);
    }

    @Override
    public SMTRunnerConsoleProperties createTestConsoleProperties(@NotNull Executor executor, @NotNull ExecutionTarget target) {
        if (executor == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(4);
        }
        if (target == null) {
            CidrCatchTestRunConfigurationData.$$$reportNull$$$0(5);
        }
        return new CidrCatchTestConsoleProperties(this.myConfiguration, executor, target);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestRunConfigurationData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTestMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTestConsoleProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

