/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing.tcatch;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.CidrContextRunConfigurationProducer;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.execution.testing.tcatch.CidrCatchTestFramework;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCNamespaceSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCatchTestUtil {
    public static final String NULL_TAG_PRESENTATION_NAME = "non-tagged";
    private static final Pattern TAG = Pattern.compile("(\\[[^\\[\\]]*\\])");
    private static final Pattern TAGS_VALIDATION = Pattern.compile("(?:\\[[^\\[\\]]*\\]\\s*)*");
    static final String AUTO_REG = "AutoReg";
    static final String MAKE_TEST_INVOKER = "::Catch::makeTestInvoker";
    static final String NAME_AND_TAGS = "NameAndTags";
    static final String NAME_AND_DESC = "NameAndDesc";

    @Contract(value="null -> true")
    public static boolean isValidStringOfTags(@Nullable String tagsInLine) {
        if (tagsInLine == null || tagsInLine.equals(NULL_TAG_PRESENTATION_NAME)) {
            return true;
        }
        return TAGS_VALIDATION.matcher(tagsInLine.trim()).matches();
    }

    @NotNull
    public static Set<String> splitTags(@Nullable String tags) {
        if (tags == null || tags.equals(NULL_TAG_PRESENTATION_NAME)) {
            Set<String> set = Collections.singleton(NULL_TAG_PRESENTATION_NAME);
            if (set == null) {
                CidrCatchTestUtil.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<String> result = new HashSet<String>();
        Matcher matcher = TAG.matcher(tags);
        while (matcher.find()) {
            result.add(matcher.group());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            CidrCatchTestUtil.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static Map<String, CidrTestScopeElement> createTestLinks(@NotNull PsiFile file) {
        if (file == null) {
            CidrCatchTestUtil.$$$reportNull$$$0(2);
        }
        final HashMap<String, CidrTestScopeElement> links = new HashMap<String, CidrTestScopeElement>();
        final OCResolveContext context = OCResolveContext.forPsi((PsiElement)file);
        final Project project2 = file.getProject();
        Processor<OCSymbol> processor2 = new Processor<OCSymbol>(){

            public boolean process(OCSymbol symbol) {
                List<OCExpression> arguments;
                OCArgumentList argumentList;
                OCDeclarator declarator;
                if (symbol.getContainingPsiFile(project2) == null) {
                    return true;
                }
                ProgressManager.checkCanceled();
                if (symbol instanceof OCNamespaceSymbol && symbol.getKind() == OCSymbolKind.NAMESPACE) {
                    List<OCSymbol> membersList = ((OCNamespaceSymbol)symbol).getMembersList();
                    if (membersList != null) {
                        for (OCSymbol nsSymbol : membersList) {
                            this.process(nsSymbol);
                        }
                    }
                    return true;
                }
                if (symbol instanceof OCDeclaratorSymbol && symbol.getKind() == OCSymbolKind.GLOBAL_VARIABLE && CidrCatchTestUtil.AUTO_REG.equals(symbol.getType().getName()) && (declarator = (OCDeclarator)((OCDeclaratorSymbol)symbol).locateDefinition(project2)) != null && (argumentList = declarator.getArgumentList()) != null && !(arguments = argumentList.getArguments()).isEmpty()) {
                    List<OCExpression> invokerArguments;
                    String maybeInvoker;
                    OCExpression testRef = arguments.get(0);
                    if (testRef instanceof OCCallExpression && CidrCatchTestUtil.MAKE_TEST_INVOKER.equals(maybeInvoker = CidrCatchTestUtil.getFunctionName(((OCCallExpression)testRef).getFunctionReferenceExpression())) && !(invokerArguments = ((OCCallExpression)testRef).getArgumentList().getArguments()).isEmpty()) {
                        testRef = invokerArguments.get(0);
                    }
                    if (testRef instanceof OCUnaryExpression) {
                        final String testQNameDecl = CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)symbol, context);
                        final String testQNameBody = CidrCatchTestUtil.getFunctionName(((OCUnaryExpression)testRef).getOperand());
                        final long offsetAsNaturalOrder = symbol.getComplexOffset();
                        if (testQNameBody != null || testQNameDecl != null) {
                            argumentList.accept(new OCRecursiveVisitor(){

                                @Override
                                public void visitCastExpression(OCCastExpression expression) {
                                    if (CidrCatchTestUtil.NAME_AND_TAGS.equals(expression.getCastType().getName())) {
                                        OCCompoundInitializer initializer = expression.getCompoundInitializer();
                                        if (initializer != null) {
                                            this.checkArguments(initializer.getInitializerExpressions());
                                        }
                                    } else {
                                        super.visitCastExpression(expression);
                                    }
                                }

                                @Override
                                public void visitCallExpression(OCCallExpression lexpression) {
                                    OCSymbol lsymbol = OCGetSymbolVisitor.getSymbol(lexpression.getFunctionReferenceExpression());
                                    if (lsymbol != null && CidrCatchTestUtil.NAME_AND_DESC.equals(lsymbol.getName())) {
                                        List<OCExpression> arguments = lexpression.getArgumentList().getArguments();
                                        this.checkArguments(arguments);
                                    }
                                }

                                private void checkArguments(List<OCExpression> arguments) {
                                    if (arguments.size() >= 1) {
                                        OCExpression maybeTags;
                                        OCExpression maybeName = arguments.get(0);
                                        OCExpression oCExpression = maybeTags = arguments.size() > 1 ? arguments.get(1) : null;
                                        if (maybeName instanceof OCLiteralExpression && (maybeTags == null || maybeTags instanceof OCLiteralExpression)) {
                                            String suiteName;
                                            String testName = ((OCLiteralExpression)maybeName).getUnescapedLiteralText();
                                            String string = suiteName = maybeTags == null ? null : ((OCLiteralExpression)maybeTags).getUnescapedLiteralText();
                                            if (testQNameBody != null) {
                                                links.put(testQNameBody, CidrTestScopeElement.createTestScopeElementForCaching(testName, suiteName, offsetAsNaturalOrder, testQNameBody, declarator.getContainingFile(), OCSymbolKind.FUNCTION_DECLARATION, CidrCatchTestFramework.CATCH_PROPERTIES_GENERATOR));
                                            }
                                            if (testQNameDecl != null) {
                                                links.put(testQNameDecl, CidrTestScopeElement.createTestScopeElementForCaching(testName, suiteName, offsetAsNaturalOrder, testQNameDecl, declarator.getContainingFile(), OCSymbolKind.GLOBAL_VARIABLE, CidrCatchTestFramework.CATCH_PROPERTIES_GENERATOR));
                                            }
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
                return true;
            }
        };
        OCResolveUtil.processGlobalSymbols(null, (PsiElement)file, processor2);
        return links;
    }

    @Contract(value="null -> null")
    private static String getFunctionName(@Nullable OCExpression expression) {
        OCResolveContext context;
        OCSymbol symbol;
        if (expression instanceof OCReferenceExpression && (symbol = ((OCReferenceExpression)expression).resolveToSymbol(context = OCResolveContext.forPsi(expression))) instanceof OCSymbolWithQualifiedName && (symbol.getKind() == OCSymbolKind.FUNCTION_DECLARATION || symbol.getKind() == OCSymbolKind.FUNCTION_PREDECLARATION)) {
            return CidrContextRunConfigurationProducer.getCanonicalNameFromSymbol((OCSymbolWithQualifiedName)symbol, context);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "splitTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/testing/tcatch/CidrCatchTestUtil";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createTestLinks";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

