/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateEditingAdapter;
import com.intellij.codeInsight.template.TemplateEditingListener;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.cidr.lang.generate.actions.OCActionContext;
import com.jetbrains.cidr.lang.generate.handlers.OCClassActionHandlerBase;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithParent;
import com.jetbrains.cidr.lang.symbols.symtable.OCMembersContainer;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAbstractGenerateTestHandler<P extends OCMembersContainer, M extends OCSymbolWithParent<?, ?>, C extends OCActionContext<P, M>>
extends OCClassActionHandlerBase<P, M, C> {
    private static final Logger LOG = Logger.getInstance((String)OCAbstractGenerateTestHandler.class.getName());
    private final String myActionTitle;
    private final String myTemplateName;

    protected OCAbstractGenerateTestHandler(String actionTitle, String templateName) {
        this.myActionTitle = actionTitle;
        this.myTemplateName = templateName;
    }

    @Override
    protected String getActionTitle() {
        return this.myActionTitle;
    }

    @Override
    protected String getMembersChooserTitle() {
        return "";
    }

    @Override
    protected boolean enableChooseDialog(Collection<M> candidates) {
        return false;
    }

    @Override
    protected boolean allowEmptySelection(C context) {
        return true;
    }

    @NotNull
    private Template createTestMethodTemplate(@NotNull FileTemplateDescriptor templateDesc, Project project2) {
        if (templateDesc == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(0);
        }
        Template template = TemplateManager.getInstance((Project)project2).createTemplate("", "");
        String templateText = this.getTemplateText(templateDesc, project2);
        int from = 0;
        Pattern pattern = Pattern.compile("\\$\\{(\\w+)}");
        Matcher m = pattern.matcher(templateText);
        HashSet<String> createdVariables = new HashSet<String>();
        while (m.find()) {
            String name2 = m.group(1);
            template.addTextSegment(templateText.substring(from, m.start()));
            if (name2.equals("END")) {
                template.addEndVariable();
            } else if (createdVariables.contains(name2)) {
                template.addVariableSegment(name2);
            } else {
                ConstantNode nameExpr = new ConstantNode(name2);
                template.addVariable(name2, (Expression)nameExpr, (Expression)nameExpr, true);
                createdVariables.add(name2);
            }
            from = m.end();
        }
        template.addTextSegment(templateText.substring(from, templateText.length()));
        template.setToIndent(true);
        template.setToReformat(true);
        template.setToShortenLongNames(true);
        Template template2 = template;
        if (template2 == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(1);
        }
        return template2;
    }

    @NotNull
    protected String getTemplateText(@NotNull FileTemplateDescriptor templateDesc, Project project2) {
        String templateText;
        if (templateDesc == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(2);
        }
        String templateName = templateDesc.getFileName();
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project2).getCodeTemplate(templateName);
        try {
            templateText = fileTemplate.getText(new Properties());
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            templateText = fileTemplate.getText();
        }
        String string = templateText;
        if (string == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected abstract int getInsertPos(@NotNull PsiElement var1, int var2, @Nullable PsiElement var3, @NotNull List<M> var4, @NotNull C var5);

    protected boolean shouldSelectResult(@NotNull OCBlockStatement body) {
        if (body == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(4);
        }
        return false;
    }

    @Nullable
    protected PsiElement getElementToModify(@NotNull C context) {
        if (context == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(5);
        }
        List<OCSymbol> symbols = ((OCActionContext)context).getSymbolsToModify();
        PsiElement result = null;
        if (symbols.size() == 1) {
            result = (PsiElement)symbols.get(0).locateDefinition(((OCActionContext)context).getProject());
        }
        if (result == null) {
            LOG.warn("Can't locate element to modify");
        }
        return result;
    }

    @Override
    protected void performAction(final @NotNull Project project2, final @Nullable Editor editor, final @NotNull PsiFile file, @NotNull C actionContext, final @NotNull List<M> chosenCandidates) {
        PsiElement element;
        if (project2 == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(7);
        }
        if (actionContext == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(8);
        }
        if (chosenCandidates == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(9);
        }
        if ((element = this.getElementToModify(actionContext)) == null) {
            return;
        }
        final PsiFile elementFile = element.getContainingFile();
        new WriteCommandAction(project2, this.getActionTitle(), new PsiFile[]{elementFile}, (OCActionContext)actionContext){
            final /* synthetic */ OCActionContext val$actionContext;
            {
                this.val$actionContext = oCActionContext;
                super(arg0, arg1, arg2);
            }

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    1.$$$reportNull$$$0(0);
                }
                int caretPos = editor != null ? editor.getCaretModel().getOffset() : -1;
                PsiElement at = null;
                if (editor != null && (at = file.findElementAt(caretPos)) == null) {
                    at = file.getLastChild();
                }
                if (!FileModificationService.getInstance().prepareFileForWrite(elementFile)) {
                    return;
                }
                if (element.isValid()) {
                    VirtualFile virtualFile = elementFile.getVirtualFile();
                    if (virtualFile != null) {
                        CommandProcessor.getInstance().addAffectedFiles(project2, new VirtualFile[]{virtualFile});
                    }
                    final Editor elementEditor = EditorHelper.openInEditor((PsiElement)elementFile);
                    final int insertPosition = OCAbstractGenerateTestHandler.this.getInsertPos(element, caretPos, at, chosenCandidates, this.val$actionContext);
                    if (elementEditor == null || insertPosition == -1) {
                        CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)elementEditor, (String)"Action is invalid for the current caret position", (String)OCAbstractGenerateTestHandler.this.getActionTitle(), null);
                    } else {
                        elementEditor.getCaretModel().moveToOffset(insertPosition);
                        FileTemplateDescriptor fileTemplateDescriptor = new FileTemplateDescriptor(OCAbstractGenerateTestHandler.this.myTemplateName);
                        Template template = OCAbstractGenerateTestHandler.this.createTestMethodTemplate(fileTemplateDescriptor, project2);
                        TemplateManager.getInstance((Project)project2).startTemplate(elementEditor, template, (TemplateEditingListener)new TemplateEditingAdapter(){

                            public void templateFinished(Template template, boolean brokenOff) {
                                PsiElement element = elementFile.findElementAt(insertPosition);
                                if (element instanceof PsiWhiteSpace) {
                                    element = element.getNextSibling();
                                }
                                if (element != null) {
                                    RangeMarker rangeMarker = elementEditor.getDocument().createRangeMarker(element.getTextRange());
                                    OCAbstractGenerateTestHandler.this.onTemplateFinished(elementFile, rangeMarker);
                                    OCCodeInsightUtil.showCallableInEditorAndSelectBody(elementFile, (Segment)rangeMarker, (Condition<OCBlockStatement>)((Condition)OCAbstractGenerateTestHandler.this::shouldSelectResult));
                                }
                            }
                        });
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler$1", "run"));
            }
        }.execute();
    }

    protected void onTemplateFinished(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
        if (file == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(10);
        }
        if (rangeMarker == null) {
            OCAbstractGenerateTestHandler.$$$reportNull$$$0(11);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateDesc";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "body";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chosenCandidates";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/generate/handlers/OCAbstractGenerateTestHandler";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createTestMethodTemplate";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createTestMethodTemplate";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldSelectResult";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getElementToModify";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performAction";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onTemplateFinished";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

