/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.generate.handlers;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.testing.google.CidrGoogleTestUtil;
import com.jetbrains.cidr.generate.handlers.OCCppGenerateTestHandler;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.OCGlobalProjectSymbolsCache;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleGenerateTestHandler
extends OCCppGenerateTestHandler {
    public OCGoogleGenerateTestHandler(String actionTitle, String templateName) {
        super(actionTitle, templateName);
    }

    @Override
    public boolean isValidFor(Editor editor, PsiFile file) {
        return super.isValidFor(editor, file) && FileSymbolTablesCache.areSymbolsLoaded(file.getProject()) && CidrGoogleTestUtil.fileIncludesGoogleTest(file);
    }

    @Override
    @Nullable
    protected OCCppActionContext<OCStructSymbol, OCFunctionSymbol> evaluateActionContext(Project project2, @Nullable Editor editor, @NotNull PsiFile file) {
        if (file == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(0);
        }
        return this.evaluateActionContext((OCStructSymbol)null, (PsiElement)file);
    }

    @Override
    protected void onTemplateFinished(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
        PsiElement at;
        if (file == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(1);
        }
        if (rangeMarker == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(2);
        }
        if (!((at = OCGoogleGenerateTestHandler.getFirstInsertedElement(file, rangeMarker)) instanceof OCMacroCall)) {
            at = PsiTreeUtil.getNextSiblingOfType((PsiElement)at, OCMacroCall.class);
        }
        if (at instanceof OCMacroCall) {
            OCReferenceElement referenceElement = ((OCMacroCall)at).getMacroReferenceElement();
            List<OCMacroCallArgument> arguments = ((OCMacroCall)at).getArguments();
            if (referenceElement != null && referenceElement.getName().equals("TEST") && arguments.size() == 2) {
                String suiteName = CidrGoogleTestUtil.extractArgumentValue(arguments.get(0));
                String testName = CidrGoogleTestUtil.extractArgumentValue(arguments.get(1));
                if (OCGoogleGenerateTestHandler.migrateToParameterized(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTyped(referenceElement, suiteName)) {
                    return;
                }
                if (OCGoogleGenerateTestHandler.migrateToTypeParameterized(referenceElement, suiteName, testName)) {
                    return;
                }
                OCGoogleGenerateTestHandler.migrateToFixture(referenceElement, suiteName);
            }
        }
    }

    private static void migrateToFixture(@NotNull OCReferenceElement referenceElement, String suiteName) {
        if (referenceElement == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(3);
        }
        OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_F", (Condition<OCSymbol>)((Condition)symbol -> {
            if (referenceElement == null) {
                OCGoogleGenerateTestHandler.$$$reportNull$$$0(16);
            }
            return symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClass((OCStructSymbol)symbol, referenceElement.getProject());
        }), null);
    }

    private static boolean migrateToTypeParameterized(@NotNull OCReferenceElement referenceElement, String suiteName, String testName) {
        if (referenceElement == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(4);
        }
        Consumer consumer = symbol -> {
            OCReferenceElement macroReferenceElement;
            OCDeclaration declaration;
            OCMacroCall macroCall;
            if (referenceElement == null) {
                OCGoogleGenerateTestHandler.$$$reportNull$$$0(15);
            }
            if ((macroCall = (OCMacroCall)PsiTreeUtil.getPrevSiblingOfType((PsiElement)(declaration = (OCDeclaration)PsiTreeUtil.getParentOfType(symbol.locateDefinition(referenceElement.getProject()), OCDeclaration.class)), OCMacroCall.class)) != null && (macroReferenceElement = macroCall.getMacroReferenceElement()) != null && macroReferenceElement.getName().equals("REGISTER_TYPED_TEST_CASE_P")) {
                List<OCMacroCallArgument> arguments = macroCall.getArguments();
                OCMacroCallArgument lastArgument = arguments.get(arguments.size() - 1);
                PsiElement newElement = OCElementFactory.create(OCTokenTypes.COMMA, macroCall);
                PsiElement added = OCChangeUtil.addAfter(macroCall, newElement, lastArgument);
                OCChangeUtil.addAfter(macroCall, OCElementFactory.expressionFromText(testName, macroCall), added);
            }
        };
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_registered_test_names_" + suiteName + "_", referenceElement, "TYPED_TEST_P", null, (Consumer<OCSymbol>)consumer);
    }

    private static boolean migrateToTyped(OCReferenceElement referenceElement, String suiteName) {
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded("gtest_type_params_" + suiteName + "_", referenceElement, "TYPED_TEST", null, null);
    }

    private static boolean migrateToParameterized(@NotNull OCReferenceElement referenceElement, String suiteName) {
        if (referenceElement == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(5);
        }
        return OCGoogleGenerateTestHandler.correctMacroNameIfNeeded(suiteName, referenceElement, "TEST_P", (Condition<OCSymbol>)((Condition)symbol -> {
            if (referenceElement == null) {
                OCGoogleGenerateTestHandler.$$$reportNull$$$0(14);
            }
            OCResolveContext context = OCResolveContext.forPsi(referenceElement);
            return symbol instanceof OCStructSymbol && CidrGoogleTestUtil.isGoogleTestClassWithAnyAncestor((OCStructSymbol)symbol, context, "TestWithParam", "WithParamInterface");
        }), null);
    }

    private static boolean correctMacroNameIfNeeded(@NotNull String suiteName, @NotNull OCReferenceElement referenceElement, @NotNull String correctMacroName, final @Nullable Condition<OCSymbol> condition, final @Nullable Consumer<OCSymbol> onCorrection) {
        if (suiteName == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(6);
        }
        if (referenceElement == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(7);
        }
        if (correctMacroName == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(8);
        }
        final OCFile file = referenceElement.getContainingOCFile();
        final Project project2 = referenceElement.getProject();
        CommonProcessors.FindFirstProcessor<OCSymbol> processor2 = new CommonProcessors.FindFirstProcessor<OCSymbol>(){

            protected boolean accept(OCSymbol symbol) {
                return file.equals(symbol.getContainingOCFile(project2)) && (condition == null || condition.value((Object)symbol));
            }
        };
        OCGlobalProjectSymbolsCache.processTopLevelAndMemberSymbols(project2, (Processor<OCSymbol>)processor2, suiteName);
        if (processor2.isFound()) {
            new WriteAction((CommonProcessors.FindFirstProcessor)processor2, referenceElement, correctMacroName, file){
                final /* synthetic */ CommonProcessors.FindFirstProcessor val$processor;
                final /* synthetic */ OCReferenceElement val$referenceElement;
                final /* synthetic */ String val$correctMacroName;
                final /* synthetic */ OCFile val$file;
                {
                    this.val$processor = findFirstProcessor;
                    this.val$referenceElement = oCReferenceElement;
                    this.val$correctMacroName = string;
                    this.val$file = oCFile;
                }

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (onCorrection != null) {
                        onCorrection.consume(this.val$processor.getFoundValue());
                    }
                    this.val$referenceElement.setNameOfIdentifier(this.val$correctMacroName);
                    FileSymbolTablesCache.getInstance(this.val$file.getProject()).scheduleReparseFile(this.val$file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler$2", "run"));
                }
            }.execute();
        }
        return processor2.isFound();
    }

    @Nullable
    private static PsiElement getFirstInsertedElement(@NotNull PsiFile file, @NotNull RangeMarker rangeMarker) {
        if (file == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(9);
        }
        if (rangeMarker == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(10);
        }
        PsiElement at = file.findElementAt(rangeMarker.getStartOffset());
        while (at instanceof PsiWhiteSpace) {
            at = at.getNextSibling();
        }
        at = PsiTreeUtil.getContextOfType((PsiElement)at, (boolean)false, (Class[])new Class[]{OCMacroCall.class, OCDeclaration.class});
        return at;
    }

    @Override
    protected int getInsertPos(@NotNull PsiElement element, int caretOffset, @Nullable PsiElement at, @NotNull List<OCFunctionSymbol> members, @NotNull OCCppActionContext<OCStructSymbol, OCFunctionSymbol> actionContext) {
        if (element == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(11);
        }
        if (members == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(12);
        }
        if (actionContext == null) {
            OCGoogleGenerateTestHandler.$$$reportNull$$$0(13);
        }
        boolean insertAfter = false;
        Condition condition = element1 -> element1.getParent() instanceof OCFile || element1.getParent() instanceof OCCppNamespace;
        if (condition.value((Object)at)) {
            assert (at != null);
            return at.getTextRange().getEndOffset();
        }
        OCStruct struct = (OCStruct)PsiTreeUtil.getNonStrictParentOfType((PsiElement)at, (Class[])new Class[]{OCStruct.class});
        if (struct != null) {
            insertAfter = CidrGoogleTestUtil.isGoogleTestFixture((OCStructSymbol)struct.getSymbol(), false, element.getProject());
        }
        at = PsiTreeUtil.findFirstParent((PsiElement)at, (boolean)true, (Condition)condition);
        at = insertAfter ? PsiTreeUtil.getNextSiblingOfType((PsiElement)at, PsiWhiteSpace.class) : PsiTreeUtil.getPrevSiblingOfType((PsiElement)at, PsiWhiteSpace.class);
        if (at != null) {
            return at.getTextRange().getEndOffset();
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeMarker";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suiteName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "correctMacroName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionContext";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/generate/handlers/OCGoogleGenerateTestHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "evaluateActionContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "onTemplateFinished";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateToFixture";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateToTypeParameterized";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "migrateToParameterized";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "correctMacroNameIfNeeded";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getFirstInsertedElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "getInsertPos";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$migrateToParameterized$2";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$migrateToTypeParameterized$1";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$migrateToFixture$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

