/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.OCLanguageKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CLanguageKind implements OCLanguageKind
{
    C("C", "c"),
    OBJ_C("Objective-C", "m"),
    CPP("C++", "cpp"),
    OBJ_CPP("Objective-C++", "mm");

    private final String myDefaultSourceExtension;
    private final String myDisplayName;

    private CLanguageKind(String name2, String extension) {
        if (name2 == null) {
            CLanguageKind.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            CLanguageKind.$$$reportNull$$$0(1);
        }
        this.myDefaultSourceExtension = extension;
        this.myDisplayName = name2;
    }

    @NotNull
    public static CLanguageKind find(boolean isObjC, boolean isCpp) {
        if (isObjC) {
            CLanguageKind cLanguageKind = isCpp ? OBJ_CPP : OBJ_C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(2);
            }
            return cLanguageKind;
        }
        CLanguageKind cLanguageKind = isCpp ? CPP : C;
        if (cLanguageKind == null) {
            CLanguageKind.$$$reportNull$$$0(3);
        }
        return cLanguageKind;
    }

    @NotNull
    public static CLanguageKind maxLanguage(@Nullable Project project2) {
        CLanguageKind cLanguageKind = OBJ_CPP;
        if (cLanguageKind == null) {
            CLanguageKind.$$$reportNull$$$0(4);
        }
        return cLanguageKind;
    }

    @NotNull
    public static CLanguageKind min(@NotNull CLanguageKind a, @NotNull CLanguageKind b) {
        if (a == null) {
            CLanguageKind.$$$reportNull$$$0(5);
        }
        if (b == null) {
            CLanguageKind.$$$reportNull$$$0(6);
        }
        if (a == b) {
            CLanguageKind cLanguageKind = a;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(7);
            }
            return cLanguageKind;
        }
        if (a == C || b == C) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(8);
            }
            return cLanguageKind;
        }
        if (a == OBJ_C && b == CPP) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(9);
            }
            return cLanguageKind;
        }
        if (b == OBJ_C && a == CPP) {
            CLanguageKind cLanguageKind = C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(10);
            }
            return cLanguageKind;
        }
        if (a == OBJ_C && b == OBJ_CPP) {
            CLanguageKind cLanguageKind = OBJ_C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(11);
            }
            return cLanguageKind;
        }
        if (b == OBJ_C && a == OBJ_CPP) {
            CLanguageKind cLanguageKind = OBJ_C;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(12);
            }
            return cLanguageKind;
        }
        if (a == CPP && b == OBJ_CPP) {
            CLanguageKind cLanguageKind = CPP;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(13);
            }
            return cLanguageKind;
        }
        if (b == CPP && a == OBJ_CPP) {
            CLanguageKind cLanguageKind = CPP;
            if (cLanguageKind == null) {
                CLanguageKind.$$$reportNull$$$0(14);
            }
            return cLanguageKind;
        }
        CLanguageKind cLanguageKind = a;
        if (cLanguageKind == null) {
            CLanguageKind.$$$reportNull$$$0(15);
        }
        return cLanguageKind;
    }

    @Nullable
    public static CLanguageKind fromCompilerSetting(@Nullable String setting) {
        if ("objective-c".equals(setting)) {
            return OBJ_C;
        }
        if ("objective-c++".equals(setting)) {
            return OBJ_CPP;
        }
        if ("c".equals(setting)) {
            return C;
        }
        if ("c++".equals(setting)) {
            return CPP;
        }
        return null;
    }

    @Override
    public boolean isCpp() {
        return this == CPP || this == OBJ_CPP;
    }

    @Override
    public boolean isObjC() {
        return this == OBJ_C || this == OBJ_CPP;
    }

    @Override
    public boolean conforms(@NotNull OCLanguageKind requiredKind) {
        if (requiredKind == null) {
            CLanguageKind.$$$reportNull$$$0(16);
        }
        return !(!this.isObjC() && requiredKind.isObjC() || !this.isCpp() && requiredKind.isCpp());
    }

    @Override
    @NotNull
    public String getDefaultSourceExtension() {
        String string = this.myDefaultSourceExtension;
        if (string == null) {
            CLanguageKind.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        String string = this.myDisplayName;
        if (string == null) {
            CLanguageKind.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Override
    public boolean supportsPrecompiledHeaders() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/CLanguageKind";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/CLanguageKind";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "find";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "maxLanguage";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "min";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSourceExtension";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "min";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "conforms";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

