/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CustomHeaderProvider {
    public static ExtensionPointName<CustomHeaderProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.customHeaderProvider");
    private final Map<HeaderSearchStage, StageProvider> myStageProviders = ContainerUtil.newEnumMap(HeaderSearchStage.class);

    public abstract boolean accepts(@Nullable OCResolveRootAndConfiguration var1);

    @Nullable
    public abstract String provideSerializationPath(@NotNull VirtualFile var1);

    @Nullable
    public abstract VirtualFile getCustomSerializedHeaderFile(@NotNull String var1, @NotNull Project var2, @NotNull VirtualFile var3);

    @Nullable
    public VirtualFile getCustomHeaderFile(@NotNull String headerName, @NotNull HeaderSearchStage stage, @Nullable OCResolveConfiguration configuration) {
        StageProvider provider2;
        if (headerName == null) {
            CustomHeaderProvider.$$$reportNull$$$0(0);
        }
        if (stage == null) {
            CustomHeaderProvider.$$$reportNull$$$0(1);
        }
        if ((provider2 = this.myStageProviders.get((Object)stage)) != null) {
            return provider2.getHeader(headerName, configuration);
        }
        return null;
    }

    protected void registerProvider(@NotNull HeaderSearchStage stage, @NotNull StageProvider provider2) {
        if (stage == null) {
            CustomHeaderProvider.$$$reportNull$$$0(2);
        }
        if (provider2 == null) {
            CustomHeaderProvider.$$$reportNull$$$0(3);
        }
        this.myStageProviders.put(stage, provider2);
    }

    @NotNull
    public static Helper getProviders(@NotNull String headerName, @Nullable OCResolveRootAndConfiguration configuration) {
        if (headerName == null) {
            CustomHeaderProvider.$$$reportNull$$$0(4);
        }
        ArrayList helpers = ContainerUtil.newArrayList();
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            if (!provider2.accepts(configuration)) continue;
            helpers.add(provider2);
        }
        Helper helper = new Helper(ContainerUtil.trimToSize((List)helpers), headerName, configuration != null ? configuration.getConfiguration() : null);
        if (helper == null) {
            CustomHeaderProvider.$$$reportNull$$$0(5);
        }
        return helper;
    }

    @Nullable
    public static String provideSerializationPathForFile(@NotNull VirtualFile file) {
        if (file == null) {
            CustomHeaderProvider.$$$reportNull$$$0(6);
        }
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            String path = provider2.provideSerializationPath(file);
            if (path == null) continue;
            return path;
        }
        return null;
    }

    @Nullable
    public static VirtualFile getCustomHeaderFile(String serializationPath, Project project2, VirtualFile file) {
        for (CustomHeaderProvider provider2 : (CustomHeaderProvider[])EP_NAME.getExtensions()) {
            VirtualFile headerFile = provider2.getCustomSerializedHeaderFile(serializationPath, project2, file);
            if (headerFile == null) continue;
            return headerFile;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerName";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stage";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/CustomHeaderProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/CustomHeaderProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProviders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCustomHeaderFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerProvider";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProviders";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "provideSerializationPathForFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface StageProvider {
        public VirtualFile getHeader(@NotNull String var1, @Nullable OCResolveConfiguration var2);
    }

    public static class Helper {
        @NotNull
        private List<CustomHeaderProvider> myProviders;
        @NotNull
        private String myHeaderName;
        @Nullable
        private OCResolveConfiguration myConfiguration;

        public Helper(@NotNull List<CustomHeaderProvider> providers, @NotNull String headerName, @Nullable OCResolveConfiguration configuration) {
            if (providers == null) {
                Helper.$$$reportNull$$$0(0);
            }
            if (headerName == null) {
                Helper.$$$reportNull$$$0(1);
            }
            this.myProviders = providers;
            this.myHeaderName = headerName;
            this.myConfiguration = configuration;
        }

        @Nullable
        VirtualFile getCustomHeader(HeaderSearchStage stage) {
            for (CustomHeaderProvider provider2 : this.myProviders) {
                VirtualFile file = provider2.getCustomHeaderFile(this.myHeaderName, stage, this.myConfiguration);
                if (file == null) continue;
                return file;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "providers";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "headerName";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/CustomHeaderProvider$Helper";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum HeaderSearchStage {
        BEFORE_START,
        BEFORE_CURRENT,
        BEFORE_LIBRARIES,
        BEFORE_FRAMEWORKS,
        AFTER_END;

    }
}

