/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.ide.IconProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import icons.CidrLangIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileIconProvider
extends IconProvider
implements DumbAware {
    @Nullable
    public Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags) {
        if (element == null) {
            OCFileIconProvider.$$$reportNull$$$0(0);
        }
        if (!(element instanceof OCFile)) {
            return null;
        }
        OCFile ocFile = (OCFile)element;
        VirtualFile virtualFile = ocFile.getVirtualFile();
        Project project2 = element.getProject();
        return OCFileIconProvider.getIcon(virtualFile, project2);
    }

    @Nullable
    public static Icon getIcon(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        String name2;
        if (virtualFile == null) {
            OCFileIconProvider.$$$reportNull$$$0(1);
        }
        if (project2 == null) {
            OCFileIconProvider.$$$reportNull$$$0(2);
        }
        if (OCFileTypeHelpers.isHeaderFile(name2 = virtualFile.getName())) {
            return CidrLangIcons.FileType_h;
        }
        OCLanguageKind kind = OCLanguageKindCalculator.tryFileTypeAndExtension(project2, virtualFile);
        if (kind instanceof CLanguageKind) {
            switch ((CLanguageKind)kind) {
                case C: {
                    return CidrLangIcons.FileType_c;
                }
                case CPP: {
                    return CidrLangIcons.FileType_cpp;
                }
                case OBJ_C: 
                case OBJ_CPP: {
                    return CidrLangIcons.FileType_m;
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "virtualFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/OCFileIconProvider";
        objectArray[2] = "getIcon";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

