/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import com.jetbrains.cidr.lang.OCLanguageKind;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCFileTypeHelpers {
    private static final Map<String, ExtensionDescriptor> EXTENSIONS = ContainerUtil.newTroveMap();
    private static final Set<String> HEADER_EXTENSIONS;
    private static final Set<String> SOURCE_EXTENSIONS;
    private static final Set<String> ALL_EXTENSIONS;

    @NotNull
    public static OCFileTypeHelper[] getHelpers() {
        ExtensionsArea rootArea;
        Application application = ApplicationManager.getApplication();
        if ((application == null || application.isUnitTestMode()) && !(rootArea = Extensions.getRootArea()).hasExtensionPoint(OCFileTypeHelper.EP_NAME.getName())) {
            OCFileTypeHelper[] oCFileTypeHelperArray = new OCFileTypeHelper[]{};
            if (oCFileTypeHelperArray == null) {
                OCFileTypeHelpers.$$$reportNull$$$0(0);
            }
            return oCFileTypeHelperArray;
        }
        OCFileTypeHelper[] oCFileTypeHelperArray = (OCFileTypeHelper[])Extensions.getExtensions(OCFileTypeHelper.EP_NAME);
        if (oCFileTypeHelperArray == null) {
            OCFileTypeHelpers.$$$reportNull$$$0(1);
        }
        return oCFileTypeHelperArray;
    }

    @Nullable
    private static ExtensionDescriptor getDescriptor(@NotNull String extension) {
        if (extension == null) {
            OCFileTypeHelpers.$$$reportNull$$$0(2);
        }
        String lower = extension.toLowerCase(Locale.getDefault());
        ExtensionDescriptor descriptor2 = EXTENSIONS.get(lower);
        if (lower.equals(extension) || descriptor2 != null && !descriptor2.myIsCaseSensitive) {
            return descriptor2;
        }
        return EXTENSIONS.get(extension);
    }

    public static boolean isHeaderFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor2 = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor2 != null) {
            return descriptor2.myIsHeader;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (!each.isHeaderFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSourceFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor2 = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor2 != null) {
            return !descriptor2.myIsHeader;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            if (each.isHeaderFile(filename)) {
                return false;
            }
            if (!each.isSourceFile(filename)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCppFile(@Nullable String filename) {
        if (filename == null) {
            return false;
        }
        ExtensionDescriptor descriptor2 = OCFileTypeHelpers.getDescriptor(FileUtilRt.getExtension((String)filename));
        if (descriptor2 != null) {
            return descriptor2.myLanguageKind.isCpp();
        }
        return false;
    }

    private static Set<String> collectExtensions(Predicate<? super Map.Entry<String, ExtensionDescriptor>> predicate) {
        THashSet extensionsSet = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        return EXTENSIONS.entrySet().stream().filter(predicate).map(entry -> ((String)entry.getKey()).toLowerCase(Locale.getDefault())).collect(Collectors.toCollection(() -> OCFileTypeHelpers.lambda$collectExtensions$4((Set)extensionsSet)));
    }

    public static Set<String> headerExtensions() {
        return HEADER_EXTENSIONS;
    }

    public static Set<String> sourceExtensions() {
        return SOURCE_EXTENSIONS;
    }

    public static Set<String> allExtensions() {
        return ALL_EXTENSIONS;
    }

    private static /* synthetic */ Set lambda$collectExtensions$4(Set extensionsSet) {
        return extensionsSet;
    }

    static {
        EXTENSIONS.put("c", new ExtensionDescriptor(OCLanguageKind.C, false, true));
        EXTENSIONS.put("i", new ExtensionDescriptor(OCLanguageKind.C, false));
        EXTENSIONS.put("h", new ExtensionDescriptor(OCLanguageKind.C, true, true));
        EXTENSIONS.put("inl", new ExtensionDescriptor(OCLanguageKind.C, true));
        EXTENSIONS.put("", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("ii", new ExtensionDescriptor(OCLanguageKind.CPP, false));
        EXTENSIONS.put("cc", new ExtensionDescriptor(OCLanguageKind.CPP, false));
        EXTENSIONS.put("cp", new ExtensionDescriptor(OCLanguageKind.CPP, false));
        EXTENSIONS.put("cxx", new ExtensionDescriptor(OCLanguageKind.CPP, false));
        EXTENSIONS.put("cpp", new ExtensionDescriptor(OCLanguageKind.CPP, false));
        EXTENSIONS.put("c++", new ExtensionDescriptor(OCLanguageKind.CPP, false));
        EXTENSIONS.put("hh", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("hp", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("hxx", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("hpp", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("h++", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("tcc", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("icc", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("pch", new ExtensionDescriptor(OCLanguageKind.CPP, true));
        EXTENSIONS.put("m", new ExtensionDescriptor(OCLanguageKind.OBJ_C, false, true));
        EXTENSIONS.put("mm", new ExtensionDescriptor(OCLanguageKind.OBJ_CPP, false));
        EXTENSIONS.put("C", new ExtensionDescriptor(OCLanguageKind.CPP, false, true));
        EXTENSIONS.put("H", new ExtensionDescriptor(OCLanguageKind.CPP, true, true));
        EXTENSIONS.put("M", new ExtensionDescriptor(OCLanguageKind.OBJ_CPP, false, true));
        HEADER_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> ((ExtensionDescriptor)entry.getValue()).myIsHeader));
        SOURCE_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> !((ExtensionDescriptor)entry.getValue()).myIsHeader));
        ALL_EXTENSIONS = Collections.unmodifiableSet(OCFileTypeHelpers.collectExtensions(entry -> true));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCFileTypeHelpers";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCFileTypeHelpers";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ExtensionDescriptor {
        @NotNull
        public final OCLanguageKind myLanguageKind;
        public final boolean myIsHeader;
        public final boolean myIsCaseSensitive;

        public ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader, boolean isCaseSensitive) {
            if (languageKind == null) {
                ExtensionDescriptor.$$$reportNull$$$0(0);
            }
            this.myLanguageKind = languageKind;
            this.myIsHeader = isHeader;
            this.myIsCaseSensitive = isCaseSensitive;
        }

        public ExtensionDescriptor(@NotNull OCLanguageKind languageKind, boolean isHeader) {
            if (languageKind == null) {
                ExtensionDescriptor.$$$reportNull$$$0(1);
            }
            this(languageKind, isHeader, false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageKind", "com/jetbrains/cidr/lang/OCFileTypeHelpers$ExtensionDescriptor", "<init>"));
        }
    }
}

