/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.util.io.ByteSequence;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelper;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.lexer.OCLexer;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import gnu.trove.TObjectHashingStrategy;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderFileTypeDetector
implements FileTypeRegistry.FileTypeDetector {
    public static final Set<String> LOOK_LIKE_OC_FILE_BUT_ARE_NOT = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE, (Object[])new String[]{"y", "yy", "ypp", "y++", "yxx", "l", "ll", "lpp", "l++", "lxx"});

    public FileType detect(@NotNull VirtualFile file, @NotNull ByteSequence firstBytes, @Nullable CharSequence firstCharsIfText) {
        IElementType tt;
        if (file == null) {
            OCHeaderFileTypeDetector.$$$reportNull$$$0(0);
        }
        if (firstBytes == null) {
            OCHeaderFileTypeDetector.$$$reportNull$$$0(1);
        }
        if (firstCharsIfText == null) {
            return null;
        }
        for (OCFileTypeHelper each : OCFileTypeHelpers.getHelpers()) {
            FileType type = each.getFileType(file);
            if (type == null) {
                return null;
            }
            if (type == FileTypes.UNKNOWN) continue;
            return type;
        }
        String extension = file.getExtension();
        if (extension != null && LOOK_LIKE_OC_FILE_BUT_ARE_NOT.contains(extension)) {
            return null;
        }
        OCLexer lexer = new OCLexer(OCLexerSettings.forPreprocessor().build());
        lexer.start(firstCharsIfText);
        boolean atNewLine = true;
        boolean wasDirective = false;
        int identsInSequence = 0;
        while ((tt = lexer.getTokenType()) != null) {
            if (tt == OCTokenTypes.UNKNOWN_DIRECTIVE || tt == TokenType.BAD_CHARACTER) {
                lexer.advance();
                if (lexer.getTokenType() == null) break;
                return null;
            }
            if (OCTokenTypes.COMMENTS.contains(tt)) {
                identsInSequence = 0;
            } else if (OCTokenTypes.WHITESPACES.contains(tt)) {
                if (lexer.getTokenText().contains("\n")) {
                    atNewLine = true;
                }
            } else if (tt == OCTokenTypes.IDENTIFIER) {
                if (++identsInSequence > 7) {
                    return null;
                }
                atNewLine = false;
            } else if (OCTokenTypes.DIRECTIVES.contains(tt) && atNewLine) {
                wasDirective = true;
                atNewLine = false;
                identsInSequence = 0;
            } else {
                atNewLine = false;
                identsInSequence = 0;
            }
            lexer.advance();
        }
        return wasDirective ? OCFileType.INSTANCE : null;
    }

    public int getVersion() {
        return 1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "firstBytes";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/OCHeaderFileTypeDetector";
        objectArray[2] = "detect";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

