/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SpecificNameItemProcessor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FilteringIterator;
import com.jetbrains.cidr.lang.CustomHeaderProvider;
import com.jetbrains.cidr.lang.OCIncludeHelper;
import com.jetbrains.cidr.lang.OCIncludeHelpersKt;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.symbols.cpp.OCIncludeSymbol;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.RealFramework;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCIncludeHelpers {
    public static OCIncludeHelper[] getIncludeHelpers() {
        return (OCIncludeHelper[])Extensions.getExtensions(OCIncludeHelper.EP_NAME);
    }

    public static ShowInCompletion showInCompletion(@Nullable PsiFileSystemItem item) {
        if (item == null) {
            return ShowInCompletion.DEFAULT;
        }
        ShowInCompletion result = ShowInCompletion.DEFAULT;
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            ShowInCompletion eachResult = each.showInCompletion(item);
            if (eachResult == ShowInCompletion.DEFAULT) continue;
            if (eachResult == ShowInCompletion.SHOW) {
                return ShowInCompletion.SHOW;
            }
            result = eachResult;
        }
        if (result == ShowInCompletion.DEFAULT && item instanceof AppleFramework) {
            return ShowInCompletion.SHOW;
        }
        return result;
    }

    @Nullable
    public static VirtualFile resolveIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project2) {
        if (include == null) {
            OCIncludeHelpers.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(1);
        }
        Ref result = new Ref();
        OCIncludeHelpers.resolveNextIncludedFile(rootAndConfiguration, context, null, include, project2, (Ref<VirtualFile>)result);
        return (VirtualFile)result.get();
    }

    public static void resolveNextIncludedFile(@Nullable OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile context, @Nullable VirtualFile after2, @NotNull OCIncludeSymbol.IncludePath include, @NotNull Project project2, @NotNull Ref<VirtualFile> result) {
        List<PsiFileSystemItem> firstSegmentElements;
        PsiFileSystemItem item;
        String path;
        List pathElements;
        if (include == null) {
            OCIncludeHelpers.$$$reportNull$$$0(2);
        }
        if (project2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(3);
        }
        if (result == null) {
            OCIncludeHelpers.$$$reportNull$$$0(4);
        }
        if (project2.isDisposed()) {
            return;
        }
        if (context == null || !context.isValid()) {
            return;
        }
        char[] separators = OCResolveConfiguration.DEFAULT_FILE_SEPARATORS;
        OCResolveConfiguration configuration = null;
        if (rootAndConfiguration != null && (configuration = rootAndConfiguration.getConfiguration()) != null) {
            separators = configuration.getFileSeparators();
            VirtualFile mappedInclude = configuration.getMappedInclude(rootAndConfiguration.getKind(), rootAndConfiguration.getRootFile(), include.getPath());
            if (mappedInclude != null) {
                result.set((Object)mappedInclude);
                return;
            }
        }
        if ((pathElements = StringsKt.split((CharSequence)(path = include.getPath()), (char[])separators, (boolean)false, (int)0)).size() == 0) {
            return;
        }
        CustomHeaderProvider.Helper customHeaderProviders = CustomHeaderProvider.getProviders(path, rootAndConfiguration);
        VirtualFile customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_START);
        if (customHeader != null) {
            result.set((Object)customHeader);
            return;
        }
        String first = (String)pathElements.get(0);
        if (OCIncludeHelpers.findAbsoluteHeader(path, first, result)) {
            return;
        }
        customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_CURRENT);
        if (customHeader != null) {
            result.set((Object)customHeader);
            return;
        }
        boolean searchInCurrent = after2 == null && !include.isAngleBrackets() && !FileUtil.namesEqual((String)context.getName(), (String)path);
        Ref afterDirRef = new Ref((Object)(after2 == null ? null : after2.getParent()));
        if (searchInCurrent && (item = FileReferenceHelper.getPsiFileSystemItem((PsiManager)PsiManager.getInstance((Project)project2), (VirtualFile)context)) != null && item.getParent() != null && OCIncludeHelpers.findHeader(firstSegmentElements = OCIncludeHelpers.findChild(item.getParent(), first), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
            return;
        }
        customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_LIBRARIES);
        if (customHeader != null) {
            result.set((Object)customHeader);
            return;
        }
        if (configuration != null) {
            if (!include.isAngleBrackets() && OCIncludeHelpersKt.findHeaderUsingSegmentCache(rootAndConfiguration, HeaderRootsSegmentCache.getProjectHeaderRootsCache(project2), configuration.getProjectHeadersRoots(), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
                return;
            }
            if (OCIncludeHelpersKt.findHeaderUsingSegmentCache(rootAndConfiguration, HeaderRootsSegmentCache.getLibraryHeaderRootsCache(project2), configuration.getLibraryHeadersRoots(rootAndConfiguration.getKind(), rootAndConfiguration.getRootFile()), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
                return;
            }
        }
        if ((customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.BEFORE_FRAMEWORKS)) != null) {
            result.set((Object)customHeader);
            return;
        }
        if (!OCIncludeHelpers.processContainingFramework(project2, context, (Processor<PsiFileSystemItem>)((Processor)framework -> {
            if (result == null) {
                OCIncludeHelpers.$$$reportNull$$$0(27);
            }
            if (framework.getName().equals(first) && OCIncludeHelpers.findHeader(Collections.singletonList(framework), pathElements, (Ref<VirtualFile>)afterDirRef, result)) {
                return false;
            }
            return !OCIncludeHelpers.findHeader(OCIncludeHelpers.findChild(framework, first), pathElements, (Ref<VirtualFile>)afterDirRef, result);
        }))) {
            return;
        }
        customHeader = customHeaderProviders.getCustomHeader(CustomHeaderProvider.HeaderSearchStage.AFTER_END);
        if (customHeader != null) {
            result.set((Object)customHeader);
        }
    }

    static boolean findAbsoluteHeader(@NotNull String path, @NotNull String first, @NotNull Ref<VirtualFile> result) {
        if (path == null) {
            OCIncludeHelpers.$$$reportNull$$$0(5);
        }
        if (first == null) {
            OCIncludeHelpers.$$$reportNull$$$0(6);
        }
        if (result == null) {
            OCIncludeHelpers.$$$reportNull$$$0(7);
        }
        if (first.isEmpty() || FileUtil.isWindowsAbsolutePath((String)path)) {
            VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
            result.set(file == null || file.isDirectory() ? null : file);
            return true;
        }
        return false;
    }

    @Nullable
    public static AppleFramework getFramework(@NotNull OCResolveRootAndConfiguration headerResolveCtx, @NotNull String name2) {
        OCResolveConfiguration configuration;
        if (headerResolveCtx == null) {
            OCIncludeHelpers.$$$reportNull$$$0(8);
        }
        if (name2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(9);
        }
        if ((configuration = headerResolveCtx.getConfiguration()) == null) {
            return null;
        }
        List<PsiFileSystemItem> libHeaders = HeaderRootsSegmentCache.getLibraryHeaderRootsCache(configuration.getProject()).getFirstSegmentCache(configuration.getLibraryHeadersRoots(headerResolveCtx.getKind(), headerResolveCtx.getRootFile())).getFiles(name2);
        return (AppleFramework)((Object)ContainerUtil.find(libHeaders, (Condition)new FilteringIterator.InstanceOf(AppleFramework.class)));
    }

    static boolean findHeader(@NotNull List<PsiFileSystemItem> firstSegmentElements, @NotNull List<String> pathElements, @NotNull Ref<VirtualFile> afterDirRef, @NotNull Ref<VirtualFile> result) {
        if (firstSegmentElements == null) {
            OCIncludeHelpers.$$$reportNull$$$0(10);
        }
        if (pathElements == null) {
            OCIncludeHelpers.$$$reportNull$$$0(11);
        }
        if (afterDirRef == null) {
            OCIncludeHelpers.$$$reportNull$$$0(12);
        }
        if (result == null) {
            OCIncludeHelpers.$$$reportNull$$$0(13);
        }
        for (PsiFileSystemItem segment : firstSegmentElements) {
            VirtualFile file;
            PsiFile candidate = null;
            if (pathElements.size() != 1) {
                candidate = OCIncludeHelpers.find(segment, pathElements, 1);
            } else if (segment instanceof PsiFile) {
                candidate = (PsiFile)segment;
            }
            if (candidate == null || (file = candidate.getVirtualFile()) == null) continue;
            VirtualFile after2 = (VirtualFile)afterDirRef.get();
            if (after2 == null) {
                result.set((Object)file);
                return true;
            }
            if (!Comparing.equal((Object)file.getParent(), (Object)after2)) continue;
            afterDirRef.set(null);
        }
        return false;
    }

    public static boolean processContainingFramework(@NotNull Project project2, @Nullable VirtualFile forFile, @NotNull Processor<PsiFileSystemItem> processor2) {
        if (project2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(14);
        }
        if (processor2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(15);
        }
        if (forFile == null) {
            return true;
        }
        for (OCIncludeHelper each : OCIncludeHelpers.getIncludeHelpers()) {
            if (each.processContainingFramework(project2, forFile, processor2)) continue;
            return false;
        }
        for (VirtualFile parent = forFile; parent != null; parent = parent.getParent()) {
            if (!parent.getName().endsWith(".framework") || processor2.process((Object)new RealFramework(project2, parent, null))) continue;
            return false;
        }
        return true;
    }

    public static boolean processImportSpecifications(@NotNull Project project2, @NotNull OCResolveRootAndConfiguration rootAndConfiguration, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor2) {
        OCAutoImportHelper[] extensions;
        if (project2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(16);
        }
        if (rootAndConfiguration == null) {
            OCIncludeHelpers.$$$reportNull$$$0(17);
        }
        if (fileToImport == null) {
            OCIncludeHelpers.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            OCIncludeHelpers.$$$reportNull$$$0(19);
        }
        for (OCAutoImportHelper each : extensions = (OCAutoImportHelper[])Extensions.getExtensions(OCAutoImportHelper.EP_NAME)) {
            if (!each.supports(rootAndConfiguration) || each.processPathSpecificationToInclude(project2, targetFile, fileToImport, rootAndConfiguration, processor2)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PsiFile find(PsiFileSystemItem root, List<String> pathElements, int cur) {
        if (root == null || cur >= pathElements.size()) {
            return null;
        }
        String name2 = pathElements.get(cur);
        if (name2.isEmpty()) {
            return OCIncludeHelpers.find(root, pathElements, cur + 1);
        }
        for (PsiFileSystemItem item : OCIncludeHelpers.findChild(root, name2)) {
            if (cur == pathElements.size() - 1) {
                if (!(item instanceof PsiFile)) continue;
                return (PsiFile)item;
            }
            PsiFile element = OCIncludeHelpers.find(item, pathElements, cur + 1);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @NotNull
    private static List<PsiFileSystemItem> findChild(PsiFileSystemItem parent, String childName) {
        PsiFile found;
        if (parent == null || !parent.isValid()) {
            List<PsiFileSystemItem> list = Collections.emptyList();
            if (list == null) {
                OCIncludeHelpers.$$$reportNull$$$0(20);
            }
            return list;
        }
        if ("..".equals(childName)) {
            VirtualFile vFile = parent.getVirtualFile();
            if (parent instanceof AppleFramework) {
                VirtualFile headersRoot;
                VirtualFile frameworkRoot = parent.getVirtualFile();
                VirtualFile virtualFile = headersRoot = frameworkRoot != null ? frameworkRoot.findChild("Headers") : null;
                if (headersRoot != null) {
                    vFile = headersRoot;
                }
            }
            if (vFile == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    OCIncludeHelpers.$$$reportNull$$$0(21);
                }
                return list;
            }
            VirtualFile vParent = vFile.getParent();
            if (vParent == null) {
                List<PsiFileSystemItem> list = Collections.emptyList();
                if (list == null) {
                    OCIncludeHelpers.$$$reportNull$$$0(22);
                }
                return list;
            }
            PsiDirectory directory = parent.getManager().findDirectory(vParent);
            List<Object> list = directory != null ? Collections.singletonList(directory) : Collections.emptyList();
            if (list == null) {
                OCIncludeHelpers.$$$reportNull$$$0(23);
            }
            return list;
        }
        if (".".equals(childName)) {
            List<PsiFileSystemItem> list = Collections.singletonList(parent);
            if (list == null) {
                OCIncludeHelpers.$$$reportNull$$$0(24);
            }
            return list;
        }
        if (parent instanceof PsiDirectory && (found = ((PsiDirectory)parent).findFile(childName)) != null) {
            List<PsiFile> list = Collections.singletonList(found);
            if (list == null) {
                OCIncludeHelpers.$$$reportNull$$$0(25);
            }
            return list;
        }
        final SmartList result = new SmartList();
        parent.processChildren((PsiElementProcessor)new SpecificNameItemProcessor(childName){

            public boolean execute(@NotNull PsiFileSystemItem element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                result.add((Object)element);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/OCIncludeHelpers$1", "execute"));
            }
        });
        SmartList smartList = result;
        if (smartList == null) {
            OCIncludeHelpers.$$$reportNull$$$0(26);
        }
        return smartList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "include";
                break;
            }
            case 1: 
            case 3: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: 
            case 13: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headerResolveCtx";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstSegmentElements";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathElements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterDirRef";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootAndConfiguration";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/OCIncludeHelpers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/OCIncludeHelpers";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "findChild";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveIncludedFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveNextIncludedFile";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findAbsoluteHeader";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFramework";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findHeader";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processContainingFramework";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processImportSpecifications";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveNextIncludedFile$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class FirstSegmentCache {
        @NotNull
        private final List<HeadersSearchRoot> myRoots;
        private final boolean mySupportsRelative;
        private Map<String, List<PsiFileSystemItem>> myCache;

        private FirstSegmentCache(@NotNull List<HeadersSearchRoot> roots, boolean relative) {
            if (roots == null) {
                FirstSegmentCache.$$$reportNull$$$0(0);
            }
            this.mySupportsRelative = relative;
            this.myRoots = roots;
        }

        private void prepareCache() {
            if (this.myCache != null) {
                return;
            }
            this.myCache = new THashMap(FileUtil.PATH_HASHING_STRATEGY);
            for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                if (!psiFileSystemItem.isValid()) continue;
                psiFileSystemItem.processChildren((PsiElementProcessor)new PsiElementProcessor<PsiFileSystemItem>(){

                    public boolean execute(@NotNull PsiFileSystemItem element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        String segment = element.getName();
                        ArrayList<PsiFileSystemItem> items = (ArrayList<PsiFileSystemItem>)myCache.get(segment);
                        if (items == null) {
                            items = new ArrayList<PsiFileSystemItem>();
                            myCache.put(segment, items);
                        }
                        items.add(element);
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/cidr/lang/OCIncludeHelpers$FirstSegmentCache$1", "execute"));
                    }
                });
            }
        }

        @NotNull
        synchronized List<PsiFileSystemItem> getFiles(@NotNull String segment) {
            if (segment == null) {
                FirstSegmentCache.$$$reportNull$$$0(1);
            }
            this.prepareCache();
            List<Object> items = this.myCache.get(segment);
            if (items == null) {
                if (this.mySupportsRelative) {
                    items = new ArrayList<PsiFileSystemItem>();
                    for (PsiFileSystemItem psiFileSystemItem : this.myRoots) {
                        if (!psiFileSystemItem.isValid()) continue;
                        items.addAll(OCIncludeHelpers.findChild(psiFileSystemItem, segment));
                    }
                    this.myCache.put(segment, items);
                } else {
                    items = Collections.emptyList();
                }
            }
            List<PsiFileSystemItem> list = items;
            if (list == null) {
                FirstSegmentCache.$$$reportNull$$$0(2);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "segment";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/OCIncludeHelpers$FirstSegmentCache";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/OCIncludeHelpers$FirstSegmentCache";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getFiles";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class HeaderRootsSegmentCache {
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE", false);
        private static final NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> RESOLVE_INCLUDE_CACHE = HeaderRootsSegmentCache.createCacheKey("RESOLVE_INCLUDE_CACHE", true);
        @NotNull
        private final HashMap<List<HeadersSearchRoot>, FirstSegmentCache> myCache = new HashMap();
        private final boolean mySupportsRelative;

        private HeaderRootsSegmentCache(boolean supportsRelative) {
            this.mySupportsRelative = supportsRelative;
        }

        static HeaderRootsSegmentCache getProjectHeaderRootsCache(@NotNull Project project2) {
            if (project2 == null) {
                HeaderRootsSegmentCache.$$$reportNull$$$0(0);
            }
            return (HeaderRootsSegmentCache)((CachedValue)RESOLVE_INCLUDE_IN_PROJECT_HEADERS_CACHE.getValue((UserDataHolder)project2)).getValue();
        }

        static HeaderRootsSegmentCache getLibraryHeaderRootsCache(@NotNull Project project2) {
            if (project2 == null) {
                HeaderRootsSegmentCache.$$$reportNull$$$0(1);
            }
            return (HeaderRootsSegmentCache)((CachedValue)RESOLVE_INCLUDE_CACHE.getValue((UserDataHolder)project2)).getValue();
        }

        synchronized FirstSegmentCache getFirstSegmentCache(@NotNull List<HeadersSearchRoot> roots) {
            FirstSegmentCache cache;
            if (roots == null) {
                HeaderRootsSegmentCache.$$$reportNull$$$0(2);
            }
            if ((cache = this.myCache.get(roots)) == null) {
                cache = new FirstSegmentCache(roots, this.mySupportsRelative);
                this.myCache.put(new ArrayList<HeadersSearchRoot>(roots), cache);
            }
            return cache;
        }

        private static NotNullLazyKey<CachedValue<HeaderRootsSegmentCache>, Project> createCacheKey(@NotNull String name2, boolean supportsRelative) {
            if (name2 == null) {
                HeaderRootsSegmentCache.$$$reportNull$$$0(3);
            }
            return NotNullLazyKey.create((String)name2, project2 -> CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
                OCWorkspaceModificationTrackers tracker = OCWorkspaceModificationTrackers.getInstance(project2);
                return new CachedValueProvider.Result((Object)new HeaderRootsSegmentCache(supportsRelative), new Object[]{tracker.getProjectsListTracker(), tracker.getProjectFilesListTracker(), tracker.getSourceFilesListTracker(), tracker.getSelectedResolveConfigurationTracker()});
            }, false));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "roots";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/OCIncludeHelpers$HeaderRootsSegmentCache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getProjectHeaderRootsCache";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getLibraryHeaderRootsCache";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getFirstSegmentCache";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCacheKey";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static enum ShowInCompletion {
        SHOW,
        DON_NOT_SHOW,
        DEFAULT;

    }
}

