/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.FactoryMap;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.editor.colors.OCFileHighlighter;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCLanguage
extends Language {
    public static final Key<Boolean> LANGUAGE_SUPPORT_DISABLED = Key.create((String)"CPP_SUPPORT_DISABLED");
    private static final OCLanguage ourInstance = new OCLanguage();

    public static boolean enableObjectiveCSettings() {
        return PlatformUtils.isAppCode() || Registry.is((String)"clion.enable.objc.settings");
    }

    @NotNull
    public static OCLanguage getInstance() {
        OCLanguage oCLanguage = ourInstance;
        if (oCLanguage == null) {
            OCLanguage.$$$reportNull$$$0(0);
        }
        return oCLanguage;
    }

    public OCLanguage() {
        super("ObjectiveC");
        SyntaxHighlighterFactory.LANGUAGE_FACTORY.addExplicitExtension((Object)this, (Object)new SyntaxHighlighterFactory(){
            private Map<OCLexerSettings, OCFileHighlighter> myHighlighters = FactoryMap.create(key -> new OCFileHighlighter((OCLexerSettings)key));

            @NotNull
            public SyntaxHighlighter getSyntaxHighlighter(Project project2, VirtualFile virtualFile) {
                OCLanguageKind languageKind = CLanguageKind.maxLanguage(project2);
                if (virtualFile != null && !(virtualFile instanceof VirtualFileWindow) && virtualFile.isValid() && project2 != null) {
                    OCFile file;
                    PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
                    OCFile oCFile = file = psiFile instanceof OCFile ? (OCFile)psiFile : null;
                    if (file != null) {
                        languageKind = OCLanguageKindCalculator.calculateLanguageKindFast(file);
                    }
                }
                OCLexerSettings settings = OCLexerSettings.forLanguage(languageKind).forHighlighting().allowNullabilityKeywords().allowGccAutoType().allowAvailabilityExpression().allowMsvcExtensions().build();
                SyntaxHighlighter syntaxHighlighter = (SyntaxHighlighter)this.myHighlighters.get(settings);
                if (syntaxHighlighter == null) {
                    1.$$$reportNull$$$0(0);
                }
                return syntaxHighlighter;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/OCLanguage$1", "getSyntaxHighlighter"));
            }
        });
    }

    public boolean isCaseSensitive() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        String string = OCLanguage.enableObjectiveCSettings() ? "C/C++/Objective-C" : "C/C++";
        if (string == null) {
            OCLanguage.$$$reportNull$$$0(1);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/cidr/lang/OCLanguage";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

