/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.settings.OCNewClassSettings;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OCNewClassAction<T extends CreateClassDialog>
extends OCNewFileActionBase<T> {
    private static final String PUT_IVARS_TO_IMPLEMENTATION_TEMPLATE_PROPERTY = "PUT_IVARS_TO_IMPLEMENTATION";
    public static final String DEFAULT_M_EXT = ".m";
    public static final String DEFAULT_MM_EXT = ".mm";
    public static final String DEFAULT_H_EXT = ".h";

    public OCNewClassAction() {
        this(OCBundle.message("create.class.title", new Object[0]), OCBundle.message("create.class.description", new Object[0]), CidrLangIcons.CodeAssistantClass);
    }

    public OCNewClassAction(String text, String description, Icon icon) {
        super((FileType)OCFileType.INSTANCE, text, description, icon);
    }

    @Override
    @NotNull
    protected String getDefaultName() {
        String string = this.getDefaultClassPrefix();
        if (string == null) {
            OCNewClassAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(selectedName + ((CreateClassDialog)((Object)this.myState.dialogPeer)).getImplementationExtension(), selectedName + DEFAULT_H_EXT);
        if (newFileNames == null) {
            OCNewClassAction.$$$reportNull$$$0(1);
        }
        return newFileNames;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            OCNewClassAction.$$$reportNull$$$0(2);
        }
        OCFile implFile = ((OCFile)sampleFile).isHeader() ? ((OCFile)sampleFile).getAssociatedFile() : (OCFile)sampleFile;
        String extension = implFile != null && implFile.getName().endsWith(DEFAULT_MM_EXT) ? DEFAULT_MM_EXT : DEFAULT_M_EXT;
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(selectedName + extension, selectedName + DEFAULT_H_EXT);
        if (newFileNames == null) {
            OCNewClassAction.$$$reportNull$$$0(3);
        }
        return newFileNames;
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (fileName.endsWith(DEFAULT_M_EXT) || fileName.endsWith(DEFAULT_MM_EXT)) {
            return "Objective-C Class.m";
        }
        if (fileName.endsWith(DEFAULT_H_EXT)) {
            return "Objective-C Header File.h";
        }
        assert (false);
        return null;
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project2) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project2).getCustomSettings(OCCodeStyleSettings.class);
        properties.setProperty("HEADER_FILENAME", this.mySelectedName + DEFAULT_H_EXT);
        boolean putToImplementation = OCCompilerFeatures.supportsIvarsInImplementation() && (settings == null || settings.PUT_IVARS_TO_IMPLEMENTATION);
        properties.setProperty(PUT_IVARS_TO_IMPLEMENTATION_TEMPLATE_PROPERTY, putToImplementation ? "true" : "false");
    }

    @Override
    @NotNull
    protected T createDialog(@NotNull String defaultName) {
        if (defaultName == null) {
            OCNewClassAction.$$$reportNull$$$0(4);
        }
        CreateClassDialog createClassDialog = new CreateClassDialog(defaultName);
        if (createClassDialog == null) {
            OCNewClassAction.$$$reportNull$$$0(5);
        }
        return (T)((Object)createClassDialog);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewClassAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultName";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFileNames";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewClassAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class CreateClassDialog
    extends OCNewFileActionBase.CreateFileDialogBase {
        private JComboBox myLanguageCombo;

        public CreateClassDialog(String defaultName) {
            super(OCNewClassAction.this, OCBundle.message("create.class.dialog.title", new Object[0]), defaultName, null);
        }

        public CreateClassDialog(String title, String nameFieldTitle, String defaultName) {
            super(OCNewClassAction.this, title, nameFieldTitle, defaultName, null);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            this.myLanguageCombo = new ComboBox((Object[])new String[]{"Objective-C (.m)", "Objective-C++ (.mm)"});
            formBuilder.addLabeledComponent(OCBundle.message("create.field.language", new Object[0]), (JComponent)this.myLanguageCombo);
            this.myLanguageCombo.setSelectedIndex(OCNewClassSettings.getInstance().myLanguageIndex);
            this.myLanguageCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    OCNewClassSettings.getInstance().myLanguageIndex = CreateClassDialog.this.myLanguageCombo.getSelectedIndex();
                    CreateClassDialog.this.validateOkAction();
                }
            });
        }

        protected String getImplementationExtension() {
            return this.myLanguageCombo.getSelectedIndex() == 0 ? OCNewClassAction.DEFAULT_M_EXT : OCNewClassAction.DEFAULT_MM_EXT;
        }
    }
}

