/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.NamingConvention;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewCppClassAction<T extends MyCreateClassDialog>
extends OCNewFileWithSelectedExtensionAction<T> {
    protected static final String NAMESPACES_OPEN_PROPERTY = "NAMESPACES_OPEN";
    protected static final String NAMESPACES_CLOSE_PROPERTY = "NAMESPACES_CLOSE";
    private OCQualifiedName myNamespace;

    public OCNewCppClassAction() {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.cpp.class.title", new Object[0]), OCBundle.message("create.cpp.class.description", new Object[0]), CidrLangIcons.CodeAssistantStruct);
    }

    public OCNewCppClassAction(@Nullable OCQualifiedName namespace) {
        this();
        this.myNamespace = namespace;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        OCLog.LOG.assertTrue(this.myState != null, (Object)"state");
        OCLog.LOG.assertTrue(selectedName != null, (Object)"name");
        MyCreateClassDialog dialog = (MyCreateClassDialog)((Object)this.myState.dialogPeer);
        OCCodeStyleSettings.FileExtensionPair extensionPair = dialog.myFileExtensionPair;
        OCLog.LOG.assertTrue(extensionPair != null, (Object)"extension pair");
        OCNewFileActionBase.NewFileNames newFileNames = OCNewCppClassAction.getNewFileNames(selectedName, extensionPair, dialog.myHeaderOnly);
        if (newFileNames == null) {
            OCNewCppClassAction.$$$reportNull$$$0(0);
        }
        return newFileNames;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            OCNewCppClassAction.$$$reportNull$$$0(1);
        }
        Couple<String> detectedEp = this.determineExtensions((OCFile)sampleFile);
        OCCodeStyleSettings.FileExtensionPair extensionPair = null;
        for (OCCodeStyleSettings.FileExtensionPair ep : this.getExtensions(sampleFile.getProject())) {
            if (!ep.mySourceExt.equals(detectedEp.first) || !ep.myHeaderExt.equals(detectedEp.second)) continue;
            extensionPair = ep;
            break;
        }
        if (extensionPair == null) {
            extensionPair = new OCCodeStyleSettings.FileExtensionPair((String)detectedEp.first, (String)detectedEp.second, NamingConvention.NONE);
        }
        OCLog.LOG.assertTrue(selectedName != null, (Object)"name");
        OCNewFileActionBase.NewFileNames newFileNames = OCNewCppClassAction.getNewFileNames(selectedName, extensionPair, false);
        if (newFileNames == null) {
            OCNewCppClassAction.$$$reportNull$$$0(2);
        }
        return newFileNames;
    }

    @NotNull
    private static OCNewFileActionBase.NewFileNames getNewFileNames(@NotNull String selectedName, @NotNull OCCodeStyleSettings.FileExtensionPair extensionPair, boolean headerOnly) {
        if (selectedName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(3);
        }
        if (extensionPair == null) {
            OCNewCppClassAction.$$$reportNull$$$0(4);
        }
        NamingConvention convention = extensionPair.myFileNamingConvention;
        String name2 = convention.apply(selectedName);
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(headerOnly ? null : name2 + "." + extensionPair.mySourceExt, name2 + "." + extensionPair.myHeaderExt);
        if (newFileNames == null) {
            OCNewCppClassAction.$$$reportNull$$$0(5);
        }
        return newFileNames;
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (selectedName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(6);
        }
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project2) {
        String headerName;
        String name2;
        String namespacesOpenText = "";
        String namespacesCloseText = "";
        for (OCQualifiedName curNamespace = this.myNamespace; curNamespace != null && (name2 = curNamespace.getName()) != null && !name2.isEmpty(); curNamespace = curNamespace.getQualifier()) {
            namespacesOpenText = "namespace " + name2 + " {" + namespacesOpenText + "\n";
            namespacesCloseText = namespacesCloseText + "}\n";
        }
        if (this.myState != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        properties.setProperty("HEADER_FILENAME", headerName);
        properties.setProperty(NAMESPACES_OPEN_PROPERTY, namespacesOpenText);
        properties.setProperty(NAMESPACES_CLOSE_PROPERTY, namespacesCloseText);
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isSourceFile(fileName)) {
            return "C++ Class.cc";
        }
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return "C++ Class Header.h";
        }
        assert (false);
        return null;
    }

    @Override
    @NotNull
    protected T createDialog(@NotNull String defaultName) {
        if (defaultName == null) {
            OCNewCppClassAction.$$$reportNull$$$0(7);
        }
        MyCreateClassDialog myCreateClassDialog = new MyCreateClassDialog(defaultName);
        if (myCreateClassDialog == null) {
            OCNewCppClassAction.$$$reportNull$$$0(8);
        }
        return (T)((Object)myCreateClassDialog);
    }

    @Override
    @NotNull
    protected ImmutableList<OCCodeStyleSettings.FileExtensionPair> getExtensions(@NotNull Project project2) {
        if (project2 == null) {
            OCNewCppClassAction.$$$reportNull$$$0(9);
        }
        List filtered = ContainerUtil.filter(super.getExtensions(project2), pair2 -> {
            OCLanguageKind kind;
            if (project2 == null) {
                OCNewCppClassAction.$$$reportNull$$$0(11);
            }
            return (kind = OCLanguageKindCalculator.tryFileExtension(project2, "." + pair2.mySourceExt)) != null && kind.isCpp();
        });
        ImmutableList immutableList = ContainerUtil.immutableList((List)filtered);
        if (immutableList == null) {
            OCNewCppClassAction.$$$reportNull$$$0(10);
        }
        return immutableList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPair";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFileNames";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialog";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExtensions";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExtensions$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class MyCreateClassDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        boolean myHeaderOnly;

        public MyCreateClassDialog(String defaultName) {
            super(OCNewCppClassAction.this, OCBundle.message("create.cpp.class.dialog.title", new Object[0]), defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(OCBundle.message("create.checkbox.cpp.class.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener((JCheckBox)headerCheckBox){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateClassDialog.this.myHeaderOnly = this.val$headerCheckBox.isSelected();
                    if (MyCreateClassDialog.this.myKindCombo != null) {
                        MyCreateClassDialog.this.reloadExtensions();
                    }
                    MyCreateClassDialog.this.validateOkAction();
                }
            });
            OCNewCppClassAction.this.addAuxAction(createdElements -> {
                UsageTrigger.trigger((String)"cidr.newFile.cppClass");
                if (this.myHeaderOnly) {
                    UsageTrigger.trigger((String)"cidr.newFile.cppClass.headerOnly");
                }
            });
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair2) {
            if (pair2 == null) {
                MyCreateClassDialog.$$$reportNull$$$0(0);
            }
            String name2 = this.myHeaderOnly ? "." + pair2.myHeaderExt : super.getPresentableName(pair2);
            NamingConvention nc = pair2.myFileNamingConvention;
            String string = nc == NamingConvention.NONE ? name2 : name2 + "  [" + (Object)((Object)nc) + "]";
            if (string == null) {
                MyCreateClassDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction$MyCreateClassDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewCppClassAction$MyCreateClassDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

