/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.actions.newFile.OCNewHeaderFileAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewSourceFileAction
extends OCNewFileWithSelectedExtensionAction<OCNewFileWithSelectedExtensionAction.CreateFileDialog> {
    public OCNewSourceFileAction() {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.cpp.source.title", new Object[0]), OCBundle.message("create.cpp.source.title", new Object[0]), CidrLangIcons.FileType_cpp);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        Pair<String, OCCodeStyleSettings.FileExtensionPair> nameAndExtension = this.determineNameAndExtension(selectedName, false);
        String name2 = (String)nameAndExtension.first;
        OCCodeStyleSettings.FileExtensionPair ext = (OCCodeStyleSettings.FileExtensionPair)nameAndExtension.second;
        String sourceName = name2 + "." + ext.mySourceExt;
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(sourceName, this.shouldAddHeader() ? name2 + '.' + ext.myHeaderExt : null);
        if (newFileNames == null) {
            OCNewSourceFileAction.$$$reportNull$$$0(0);
        }
        return newFileNames;
    }

    private boolean shouldAddHeader() {
        return ((MyCreateFileDialog)((Object)this.myState.dialogPeer)).myShouldAddHeader;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, @NotNull PsiFile sampleFile) {
        if (sampleFile == null) {
            OCNewSourceFileAction.$$$reportNull$$$0(1);
        }
        String headerExt = null;
        String sourceExt = null;
        String selectedExt = FileUtilRt.getExtension((String)selectedName);
        if (selectedExt.length() > 0) {
            if (OCFileTypeHelpers.isHeaderFile(selectedName)) {
                headerExt = selectedExt;
            } else if (OCFileTypeHelpers.isSourceFile(selectedName)) {
                sourceExt = selectedExt;
            }
        }
        String nameWithoutExtension = FileUtilRt.getNameWithoutExtension((String)selectedName);
        Couple<String> extensions = this.determineExtensions((OCFile)sampleFile, sourceExt, headerExt);
        OCNewFileActionBase.NewFileNames newFileNames = new OCNewFileActionBase.NewFileNames(nameWithoutExtension + '.' + (String)extensions.first, nameWithoutExtension + '.' + (String)extensions.second);
        if (newFileNames == null) {
            OCNewSourceFileAction.$$$reportNull$$$0(2);
        }
        return newFileNames;
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, @Nullable PsiFile sampleFile, Project project2) {
        String headerName;
        if (this.myState != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        if (headerName != null) {
            properties.setProperty("HEADER_FILENAME", headerName);
        }
    }

    @Override
    protected boolean isValidName(@NotNull String selectedName) {
        if (selectedName == null) {
            OCNewSourceFileAction.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)FileUtilRt.getNameWithoutExtension((String)selectedName))) {
            return false;
        }
        String sourceName = this.getNewFileNames(selectedName).getSourceName();
        return sourceName != null && super.isValidName(sourceName) && OCFileImpl.isSourceCodeFile(sourceName);
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileImpl.isHeaderFile(fileName)) {
            return OCNewHeaderFileAction.headerTemplate();
        }
        return "C Source File.c";
    }

    @Override
    @NotNull
    protected MyCreateFileDialog createDialog(@NotNull String defaultName) {
        if (defaultName == null) {
            OCNewSourceFileAction.$$$reportNull$$$0(4);
        }
        MyCreateFileDialog myCreateFileDialog = new MyCreateFileDialog(defaultName);
        if (myCreateFileDialog == null) {
            OCNewSourceFileAction.$$$reportNull$$$0(5);
        }
        return myCreateFileDialog;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewSourceFileAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sampleFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewFileNames";
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewSourceFileAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createDialog";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getNewFileNames";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class MyCreateFileDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        protected boolean myShouldAddHeader;

        public MyCreateFileDialog(String defaultName) {
            super(defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(OCBundle.message("create.checkbox.source.associated.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener((JCheckBox)headerCheckBox){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateFileDialog.this.myShouldAddHeader = this.val$headerCheckBox.isSelected();
                    if (MyCreateFileDialog.this.myKindCombo != null) {
                        MyCreateFileDialog.this.reloadExtensions();
                    }
                    MyCreateFileDialog.this.validateOkAction();
                }
            });
            OCNewSourceFileAction.this.addAuxAction(createdElements -> {
                UsageTrigger.trigger((String)"cidr.newFile.source");
                if (this.myShouldAddHeader) {
                    UsageTrigger.trigger((String)"cidr.newFile.source.withHeader");
                }
            });
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair2) {
            if (pair2 == null) {
                MyCreateFileDialog.$$$reportNull$$$0(0);
            }
            String string = this.myShouldAddHeader ? super.getPresentableName(pair2) : "." + pair2.mySourceExt;
            if (string == null) {
                MyCreateFileDialog.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pair";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/actions/newFile/OCNewSourceFileAction$MyCreateFileDialog";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewSourceFileAction$MyCreateFileDialog";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getPresentableName";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

