/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.autoImport;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCAutoImportHelper {
    public static final ExtensionPointName<OCAutoImportHelper> EP_NAME = ExtensionPointName.create((String)"cidr.lang.autoImportHelper");

    public boolean supports(@NotNull OCResolveRootAndConfiguration var1);

    public boolean processPathSpecificationToInclude(@NotNull Project var1, @Nullable VirtualFile var2, @NotNull VirtualFile var3, @NotNull OCResolveRootAndConfiguration var4, @NotNull Processor<ImportSpecification> var5);

    public void addHeaderSearchPath(@NotNull Project var1, @Nullable VirtualFile var2, @NotNull VirtualFile var3);

    @NotNull
    public Iterable<IntentionAction> getAddHeaderSearchPathFixes(@NotNull Project var1, @NotNull VirtualFile var2, @NotNull String var3);

    public static class ImportSpecification {
        @NotNull
        private final String myPath;
        @NotNull
        private final Kind myKind;
        @NotNull
        private final EnumSet<OCIncludeDirective.Delimiters> myPossibleDelimiters;

        public ImportSpecification(@NotNull String path, @NotNull Kind kind) {
            if (path == null) {
                ImportSpecification.$$$reportNull$$$0(0);
            }
            if (kind == null) {
                ImportSpecification.$$$reportNull$$$0(1);
            }
            this.myPath = path;
            this.myKind = kind;
            EnumSet<OCIncludeDirective.Delimiters> possibleDelimiters = kind == Kind.SYSTEM_HEADER_SEARCH_PATH ? EnumSet.of(OCIncludeDirective.Delimiters.ANGLE_BRACKETS, OCIncludeDirective.Delimiters.QUOTES) : EnumSet.of(OCIncludeDirective.Delimiters.QUOTES);
            possibleDelimiters.add(OCIncludeDirective.Delimiters.NONE);
            this.myPossibleDelimiters = possibleDelimiters;
            assert (this.myPossibleDelimiters.contains((Object)this.getPreferredDelimiters()));
        }

        @NotNull
        public String getImportText() {
            String string = this.getImportText(this.getPreferredDelimiters());
            if (string == null) {
                ImportSpecification.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getImportText(@NotNull OCIncludeDirective.Delimiters delimiters) {
            int dotIndex;
            if (delimiters == null) {
                ImportSpecification.$$$reportNull$$$0(3);
            }
            String importText = this.getImportPath();
            if (delimiters == OCIncludeDirective.Delimiters.NONE && (dotIndex = importText.lastIndexOf(46)) > 0) {
                importText = importText.substring(0, dotIndex);
            }
            String string = delimiters.getBeforeText() + importText + delimiters.getAfterText();
            if (string == null) {
                ImportSpecification.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getImportPath() {
            String string = this.myPath;
            if (string == null) {
                ImportSpecification.$$$reportNull$$$0(5);
            }
            return string;
        }

        @NotNull
        public Kind getKind() {
            Kind kind = this.myKind;
            if (kind == null) {
                ImportSpecification.$$$reportNull$$$0(6);
            }
            return kind;
        }

        public boolean areDelimitersAllowed(OCIncludeDirective.Delimiters d) {
            return this.myPossibleDelimiters.contains((Object)d);
        }

        @NotNull
        public OCIncludeDirective.Delimiters getPreferredDelimiters() {
            OCIncludeDirective.Delimiters delimiters = this.myKind == Kind.SYSTEM_HEADER_SEARCH_PATH ? OCIncludeDirective.Delimiters.ANGLE_BRACKETS : OCIncludeDirective.Delimiters.QUOTES;
            if (delimiters == null) {
                ImportSpecification.$$$reportNull$$$0(7);
            }
            return delimiters;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kind";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delimiters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/autoImport/OCAutoImportHelper$ImportSpecification";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportPath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredDelimiters";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getImportText";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }

        public static enum Kind {
            PROJECT_HEADER,
            USER_HEADER_SEARCH_PATH,
            SYSTEM_HEADER_SEARCH_PATH;

        }
    }
}

