/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCErrorAnnotator;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.OCResolveAnnotator;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageDescriptor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPragma;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCAnnotator
extends OCVisitor
implements Annotator,
OCAnnotatorSink {
    public static final Key<AnnotationHolder> TEST_ANNOTATION_HOLDER_KEY = Key.create((String)"TEST_ANNOTATION_HOLDER_KEY");
    private static final String ERROR_AFTER_MACRO_SUBSTITUTION = "Error after macro substitution: ";
    public static final String CIDR_DIAG = "CIDR";
    @Nullable
    private AnnotationHolder myHolder;
    private PsiElement myAnnotatingElement;

    @NotNull
    public static OCAnnotator[] getAnnotators() {
        OCAnnotator[] oCAnnotatorArray = new OCAnnotator[]{new OCErrorAnnotator(), new OCResolveAnnotator()};
        if (oCAnnotatorArray == null) {
            OCAnnotator.$$$reportNull$$$0(0);
        }
        return oCAnnotatorArray;
    }

    @NotNull
    public static OCAnnotatorHelper[] getAnnotatorHelpers() {
        OCAnnotatorHelper[] oCAnnotatorHelperArray = (OCAnnotatorHelper[])Extensions.getExtensions(OCAnnotatorHelper.EP_NAME);
        if (oCAnnotatorHelperArray == null) {
            OCAnnotator.$$$reportNull$$$0(1);
        }
        return oCAnnotatorHelperArray;
    }

    @Nullable
    public AnnotationHolder getHolder() {
        return this.myHolder;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            OCAnnotator.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            OCAnnotator.$$$reportNull$$$0(3);
        }
        this.annotate(psiElement, holder, holder.getCurrentAnnotationSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement psiElement, @Nullable AnnotationHolder holder, @NotNull AnnotationSession session) {
        PsiFile file;
        if (psiElement == null) {
            OCAnnotator.$$$reportNull$$$0(4);
        }
        if (session == null) {
            OCAnnotator.$$$reportNull$$$0(5);
        }
        if (!((file = session.getFile()) instanceof OCFile)) {
            return;
        }
        OCFile ocFile = (OCFile)file;
        if (!OCAnnotator.isAnnotated(file.getProject(), ocFile.getVirtualFile())) {
            return;
        }
        ocFile.pushAnnotationSession(session);
        this.myHolder = holder;
        this.myAnnotatingElement = psiElement;
        try {
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.myHolder = null;
            this.myAnnotatingElement = null;
            ocFile.popAnnotationSession();
        }
    }

    public static boolean isAnnotated(@NotNull Project project2, @Nullable VirtualFile file) {
        if (project2 == null) {
            OCAnnotator.$$$reportNull$$$0(6);
        }
        return OCAnnotator.doIsAnnotated(project2, file, true);
    }

    public static boolean isAnnotatedAsUserCode(@NotNull Project project2, @Nullable VirtualFile file) {
        if (project2 == null) {
            OCAnnotator.$$$reportNull$$$0(7);
        }
        return OCAnnotator.doIsAnnotated(project2, file, false);
    }

    private static boolean doIsAnnotated(@NotNull Project project2, @Nullable VirtualFile file, boolean includingLibraries) {
        if (project2 == null) {
            OCAnnotator.$$$reportNull$$$0(8);
        }
        if (file == null || file.getFileType() != OCFileType.INSTANCE) {
            return false;
        }
        return includingLibraries ? OCSearchScope.isInProjectSourcesOrLibraries(project2, file) : OCSearchScope.isInProjectSources(project2, file);
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(9);
        }
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addErrorAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(10);
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCElement context = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCallArgument.class, OCDirective.class});
        if (context != null) {
            if (context instanceof OCDirective) {
                PsiElement headerToken = ((OCDirective)context).getHeaderToken();
                IElementType type = headerToken.getNode().getElementType();
                if (type != OCTokenTypes.ERROR_DIRECTIVE && type != OCTokenTypes.WARNING_DIRECTIVE) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (macroRange == null) {
            return this.addErrorAnnotation(range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addErrorAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (!message.startsWith(ERROR_AFTER_MACRO_SUBSTITUTION)) {
                message = ERROR_AFTER_MACRO_SUBSTITUTION + message;
            }
            return this.addErrorAnnotation(macroCall, macroCall.getTextRange(), inspectionClass, clangID, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return this.addErrorAnnotation(macroRange.getArgumentRange(), inspectionClass, clangID, message, highlightType);
    }

    @Override
    @Nullable
    public Annotation addErrorAnnotation(@Nullable TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        AnnotationHolder testHolder;
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(11);
        }
        if (this.myHolder == null || range == null || range.isEmpty()) {
            return null;
        }
        OCFile file = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, inspectionClass, clangID);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case WARNING: {
                    highlightType = ProblemHighlightType.WEAK_WARNING;
                    break;
                }
            }
        }
        Annotation annotation = this.myHolder.createErrorAnnotation(range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        AnnotationHolder annotationHolder = testHolder = file != null ? (AnnotationHolder)file.getProject().getUserData(TEST_ANNOTATION_HOLDER_KEY) : null;
        if (testHolder != null) {
            testHolder.createErrorAnnotation(range, message);
        }
        return annotation;
    }

    @Override
    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(12);
        }
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Override
    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(13);
        }
        if (element == null) {
            return null;
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        if (macroRange == null) {
            return this.doAddWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addWarningAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            if (OCElementUtil.getRangeInMacroCall(this.myAnnotatingElement) == null) {
                return this.doAddWarningAnnotation(macroRange.getMacroCall(), macroRange.getMacroCall().getTextRange(), inspectionClass, clangID, message, highlightType);
            }
            return null;
        }
        return this.doAddWarningAnnotation(element, macroRange.getTextRange(), inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    private Annotation doAddWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        AnnotationHolder testHolder;
        if (message == null) {
            OCAnnotator.$$$reportNull$$$0(14);
        }
        if (range == null || range.isEmpty()) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class) != null) {
            return null;
        }
        if (this.myHolder == null) {
            return null;
        }
        HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(inspectionClass, element, HighlightSeverity.WARNING);
        if (highlightSeverity == null) {
            return null;
        }
        highlightType = OCAnnotator.getProblemHighlightType(highlightSeverity, highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        OCFile file = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file, range, inspectionClass, clangID);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragma.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        Annotation annotation = this.myHolder.createAnnotation(highlightSeverity, range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        AnnotationHolder annotationHolder = testHolder = file != null ? (AnnotationHolder)file.getProject().getUserData(TEST_ANNOTATION_HOLDER_KEY) : null;
        if (testHolder != null) {
            testHolder.createWarningAnnotation(range, message);
        }
        return annotation;
    }

    @Nullable
    public static OCProblemGroup getProblemGroup(@Nullable OCFile file, @NotNull TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String problemID) {
        OCClangMessageDescriptor descriptor2;
        if (range == null) {
            OCAnnotator.$$$reportNull$$$0(15);
        }
        if (inspectionClass == null || problemID == null) {
            return null;
        }
        OCSuppressionGroup suppressionGroup = problemID.startsWith(CIDR_DIAG) ? new OCSuppressionGroup("ide", problemID.equals(CIDR_DIAG) ? inspectionClass.getSimpleName() : problemID.substring(CIDR_DIAG.length())) : ((descriptor2 = OCClangMessageFinder.getInstance().getSupportedMessageDescriptor(problemID)) != null ? descriptor2.getSuppressionGroup() : null);
        return new OCProblemGroup(inspectionClass.getSimpleName(), suppressionGroup, file, range);
    }

    private void setupAnnotation(@Nullable Annotation annotation, @Nullable ProblemHighlightType highlightType, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable OCProblemGroup problemGroup) {
        if (annotation != null) {
            if (inspectionClass != null) {
                this.registerQuickFix(annotation, (IntentionAction)new EmptyIntentionAction(OCCodeInsightUtil.getPrettyNameFromClassName(inspectionClass)));
            }
            if (problemGroup != null) {
                annotation.setProblemGroup((ProblemGroup)problemGroup);
                if (this.myHolder instanceof AnnotationAndQuickFixHolder) {
                    for (SuppressIntentionAction action : problemGroup.getSuppressActions(null)) {
                        ((AnnotationAndQuickFixHolder)this.myHolder).createQuickFix(annotation, (IntentionAction)action);
                    }
                }
            }
            annotation.setHighlightType(highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    @NotNull
    public static ProblemHighlightType getProblemHighlightType(@NotNull HighlightSeverity highlightSeverity, @NotNull ProblemHighlightType defaultHighlightType) {
        if (highlightSeverity == null) {
            OCAnnotator.$$$reportNull$$$0(16);
        }
        if (defaultHighlightType == null) {
            OCAnnotator.$$$reportNull$$$0(17);
        }
        ProblemHighlightType highlightType = defaultHighlightType;
        if (!highlightSeverity.equals((Object)HighlightSeverity.WARNING)) {
            if (highlightSeverity.equals((Object)HighlightSeverity.ERROR)) {
                highlightType = ProblemHighlightType.ERROR;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING)) {
                highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.INFORMATION)) {
                highlightType = ProblemHighlightType.INFORMATION;
            } else if (highlightSeverity.equals((Object)HighlightSeverity.WEAK_WARNING)) {
                highlightType = ProblemHighlightType.WEAK_WARNING;
            }
        }
        ProblemHighlightType problemHighlightType = highlightType;
        if (problemHighlightType == null) {
            OCAnnotator.$$$reportNull$$$0(18);
        }
        return problemHighlightType;
    }

    @Override
    public void registerQuickFix(@Nullable Annotation annotation, @NotNull IntentionAction intentionAction) {
        if (intentionAction == null) {
            OCAnnotator.$$$reportNull$$$0(19);
        }
        if (annotation != null) {
            if (intentionAction instanceof SuppressIntentionAction) {
                OCProblemGroup problemGroup = (OCProblemGroup)annotation.getProblemGroup();
                if (problemGroup != null) {
                    problemGroup.addSuppressAction((SuppressIntentionAction)intentionAction);
                }
            } else {
                Annotation.QuickFixInfo emptyFix;
                List quickFixes = annotation.getQuickFixes();
                Annotation.QuickFixInfo quickFixInfo = emptyFix = quickFixes != null ? (Annotation.QuickFixInfo)ContainerUtil.find((Iterable)quickFixes, info -> info.quickFix instanceof EmptyIntentionAction) : null;
                if (emptyFix != null) {
                    quickFixes.remove(emptyFix);
                }
                annotation.registerFix(intentionAction);
                if (intentionAction instanceof OCQuickFix && ((OCQuickFix)intentionAction).isSupportedInBatchMode() && ((OCQuickFix)intentionAction).isAvailable()) {
                    annotation.registerBatchFix((IntentionAction)((OCQuickFix)intentionAction), null, null);
                }
            }
            if (this.myHolder instanceof AnnotationAndQuickFixHolder) {
                ((AnnotationAndQuickFixHolder)this.myHolder).createQuickFix(annotation, intentionAction);
            }
        }
    }

    @Override
    @Nullable
    public Annotation highlight(@Nullable PsiElement element, @Nullable TextAttributesKey key) {
        if (element != null && element.getTextLength() != 0 && this.myHolder != null && key != null) {
            Annotation ann = this.myHolder.createInfoAnnotation(element, null);
            ann.setTextAttributes(key);
            return ann;
        }
        return null;
    }

    @Override
    public void highlight(@NotNull TextRange range, @Nullable TextAttributesKey key) {
        if (range == null) {
            OCAnnotator.$$$reportNull$$$0(20);
        }
        if (range.getLength() != 0 && this.myHolder != null && key != null) {
            Annotation ann = this.myHolder.createInfoAnnotation(range, null);
            ann.setTextAttributes(key);
        }
    }

    protected void highlight(@NotNull PsiReference reference, @Nullable TextAttributesKey key) {
        if (reference == null) {
            OCAnnotator.$$$reportNull$$$0(21);
        }
        PsiElement psiElement = reference.getElement();
        int offset = psiElement.getTextRange().getStartOffset();
        if (reference instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)reference).getRanges()) {
                this.highlight(range.shiftRight(offset), key);
            }
        } else {
            this.highlight(reference.getRangeInElement().shiftRight(offset), key);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCAnnotator";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightSeverity";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultHighlightType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentionAction";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotators";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotatorHelpers";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCAnnotator";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemHighlightType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAnnotatedAsUserCode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doIsAnnotated";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addErrorAnnotation";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addWarningAnnotation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doAddWarningAnnotation";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getProblemGroup";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getProblemHighlightType";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "registerQuickFix";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "highlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface AnnotationAndQuickFixHolder
    extends AnnotationHolder {
        public void createQuickFix(@NotNull Annotation var1, @NotNull IntentionAction var2);
    }
}

