/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class OCAnnotatorProfiler
extends OCVisitor
implements Annotator {
    private Map<Class<? extends PsiElement>, Long> stats = new HashMap<Class<? extends PsiElement>, Long>();

    public abstract void doAnnotate(@NotNull PsiElement var1, @NotNull AnnotationHolder var2);

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            OCAnnotatorProfiler.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            OCAnnotatorProfiler.$$$reportNull$$$0(1);
        }
        long startTime = System.currentTimeMillis();
        this.doAnnotate(psiElement, holder);
        long curTime = System.currentTimeMillis() - startTime;
        Long value = this.stats.get(psiElement.getClass());
        if (value == null) {
            value = new Long(0L);
        }
        this.stats.put(psiElement.getClass(), value + curTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void printStats() {
        ArrayList<Class<? extends PsiElement>> classes = new ArrayList<Class<? extends PsiElement>>(this.stats.keySet());
        Collections.sort(classes, (o1, o2) -> -this.stats.get(o1).compareTo((long)this.stats.get(o2)));
        long totTime = 0L;
        for (Class clazz : classes) {
            totTime += this.stats.get(clazz).longValue();
        }
        Class<OCAnnotatorProfiler> clazz = OCAnnotatorProfiler.class;
        synchronized (OCAnnotatorProfiler.class) {
            void var5_6;
            System.out.println("\n" + ((Object)((Object)this)).getClass().getSimpleName() + ": Total time: " + totTime);
            boolean bl = false;
            while (var5_6 < 7 && var5_6 < classes.size()) {
                long time = this.stats.get(classes.get((int)var5_6));
                System.out.println("  " + ((Class)classes.get((int)var5_6)).getSimpleName() + ": " + time + " (" + new Double((double)time * 100.0 / (double)totTime).intValue() + "%)");
                ++var5_6;
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void visitOCFile(OCFile file) {
        this.printStats();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/cidr/lang/daemon/OCAnnotatorProfiler";
        objectArray[2] = "annotate";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

