/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCConstantExpressionVisitor;
import com.jetbrains.cidr.lang.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.daemon.OCDeclaratorChecker;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.daemon.OCImplementationChecker;
import com.jetbrains.cidr.lang.daemon.OCOperatorsChecker;
import com.jetbrains.cidr.lang.daemon.OCStructuredBindingChecker;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAnalyzer;
import com.jetbrains.cidr.lang.inspections.OCGlobalUnusedInspection;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCAttributesList;
import com.jetbrains.cidr.lang.psi.OCBinaryExpression;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBoxedExpression;
import com.jetbrains.cidr.lang.psi.OCBreakStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCClassDeclaration;
import com.jetbrains.cidr.lang.psi.OCClassPredeclaration;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCConstructorFieldInitializer;
import com.jetbrains.cidr.lang.psi.OCContinueStatement;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceQualifier;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCDoWhileStatement;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionAssociation;
import com.jetbrains.cidr.lang.psi.OCGenericSelectionExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCImplementation;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCInterface;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCNSArrayLiteral;
import com.jetbrains.cidr.lang.psi.OCNSDictionaryLiteral;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCPostfixExpression;
import com.jetbrains.cidr.lang.psi.OCPrefixExpression;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCPropertyAttributesList;
import com.jetbrains.cidr.lang.psi.OCProtocol;
import com.jetbrains.cidr.lang.psi.OCProtocolExpression;
import com.jetbrains.cidr.lang.psi.OCQualifiedDesignator;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCResolvesToSymbol;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.OCSelectorExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSizeofExpression;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStruct;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCSynchronizedStatement;
import com.jetbrains.cidr.lang.psi.OCSynthesizePropertiesList;
import com.jetbrains.cidr.lang.psi.OCSynthesizeProperty;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentList;
import com.jetbrains.cidr.lang.psi.OCTemplateArgumentsOwner;
import com.jetbrains.cidr.lang.psi.OCThrowExpression;
import com.jetbrains.cidr.lang.psi.OCTryStatement;
import com.jetbrains.cidr.lang.psi.OCTypeArgumentList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCUnaryExpression;
import com.jetbrains.cidr.lang.psi.OCUnion;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCConditionalExpressionImpl;
import com.jetbrains.cidr.lang.psi.impl.OCDefineDirectiveImpl;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbols;
import com.jetbrains.cidr.lang.psi.impl.symbols.OCFileGlobalSymbolsCache;
import com.jetbrains.cidr.lang.quickfixes.OCAddInitializerIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCAddRawStringSuffix;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCCreateNewDefinitionIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCImportSymbolFix;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveDeclarationIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.refactoring.OCImportsOptimizer;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCFunctionGroupSymbol;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolBase;
import com.jetbrains.cidr.lang.symbols.OCSymbolImpl;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCSymbolReferenceResolver;
import com.jetbrains.cidr.lang.symbols.OCTypeParameterSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.cpp.OCTemplateSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterTypeSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCTypeParameterValueSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCUsingSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.symtable.OCFileSymbols;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCBracedInitListType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSimpleTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeatures;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCErrorAnnotator
extends OCAnnotator {
    @NotNull
    private final OCOperatorsChecker myOperatorsChecker;
    @NotNull
    private final OCCppChecker myCppChecker = new OCCppChecker(this);
    @NotNull
    private final OCDeclaratorChecker myDeclaratorChecker;
    @NotNull
    private final OCImplementationChecker myImplementationChecker;
    @NotNull
    private final OCStructuredBindingChecker myStructuredBindingChecker;

    public OCErrorAnnotator() {
        this.myOperatorsChecker = new OCOperatorsChecker(this, this.myCppChecker);
        this.myDeclaratorChecker = new OCDeclaratorChecker(this, this.myCppChecker);
        this.myImplementationChecker = new OCImplementationChecker(this, this.myDeclaratorChecker, this.myOperatorsChecker);
        this.myStructuredBindingChecker = new OCStructuredBindingChecker(this);
    }

    public void visitElement(PsiElement element) {
        OCClassSymbol symbol;
        super.visitElement(element);
        PsiElement parent = element.getParent();
        if (parent instanceof OCStruct && element == ((OCStruct)parent).getNameIdentifier() && ((OCFile)element.getContainingFile()).isCpp()) {
            this.myCppChecker.checkClass((OCStruct)parent);
        }
        if (!(parent instanceof OCClassDeclaration) || element != ((OCClassDeclaration)parent).getNameIdentifier()) {
            return;
        }
        if (parent instanceof OCInterface) {
            if (this.myDeclaratorChecker.checkDuplicates((OCInterface)parent)) {
                this.myImplementationChecker.checkInterfaceDeclaration((OCInterface)parent);
            }
        } else if (parent instanceof OCImplementation) {
            if (this.myDeclaratorChecker.checkDuplicates((OCImplementation)parent)) {
                this.myImplementationChecker.checkInterfaceImplementation((OCImplementation)parent);
            }
        } else if (parent instanceof OCProtocol) {
            if (this.myDeclaratorChecker.checkDuplicates((OCProtocol)parent)) {
                this.myImplementationChecker.checkProtocolDeclaration((OCProtocol)parent);
            }
        } else if (parent instanceof OCClassPredeclaration && (symbol = ((OCClassPredeclaration)parent).getSymbol()) != null) {
            Project project2 = element.getProject();
            OCClassSymbol definitionSymbol = symbol.getDefinitionSymbol(project2);
            if (definitionSymbol != null) {
                OCGlobalUnusedInspection.markSymbolAsUsed(definitionSymbol, null, project2);
            } else if (OCCodeInsightUtil.isValid((PsiElement)element.getContainingFile())) {
                Annotation annotation = this.addWarningAnnotation(((OCClassPredeclaration)parent).getNameIdentifier(), OCInspections.NoClassDefinition.class, "warn_undef_protocolref", "Can't find " + symbol.getNameWithKindLowercase(OCCompilationContext.create(element)) + " in the project and external files");
                this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.INTERFACE, element, null, symbol.getName(), null));
                this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(OCSymbolKind.PROTOCOL, element, null, symbol.getName(), null));
                this.registerQuickFix(annotation, new OCRemoveDeclarationIntentionAction(symbol, project2));
            }
        }
    }

    @Override
    public void visitReferenceExpression(OCReferenceExpression expr) {
        PsiElement parent;
        super.visitReferenceExpression(expr);
        PsiElement nonParethesizedParent = parent = expr.getParent();
        while (nonParethesizedParent instanceof OCParenthesizedExpression) {
            nonParethesizedParent = nonParethesizedParent.getParent();
        }
        boolean nonExprPossible = parent instanceof OCSendMessageExpression && ((OCSendMessageExpression)parent).getReceiverExpression() == expr || parent instanceof OCQualifiedExpression && ((OCQualifiedExpression)parent).getQualifier() == expr || nonParethesizedParent instanceof OCSizeofExpression || parent instanceof OCCallExpression && expr.getContainingOCFile().isCpp() || parent instanceof OCTemplateArgumentList || expr.isParameterOfBuiltInTrait();
        OCElementTypes.SelfSuperToken token = expr.getSelfSuperToken();
        if (token != null) {
            OCMethod method;
            if (new OCReadWriteAccessDetector().getExpressionAccess(expr) == ReadWriteAccessDetector.Access.Write && (method = (OCMethod)PsiTreeUtil.getParentOfType((PsiElement)expr, OCMethod.class)) != null && !method.getSelector().startsWith("init")) {
                this.addErrorAnnotation(expr, OCInspections.NotAssignable.class, "err_typecheck_arc_assign_self", "Assignment to self is allowed only in init methods");
                return;
            }
            if (token == OCElementTypes.SelfSuperToken.SELF) {
                return;
            }
            OCClassDeclaration clazz = (OCClassDeclaration)PsiTreeUtil.getContextOfType((PsiElement)expr, (Class[])new Class[]{OCClassDeclaration.class});
            if (clazz == null) {
                return;
            }
            OCObjectType type = clazz.getType();
            if (type != null && type.getSuperType() == null) {
                this.addErrorAnnotation(expr, "CIDR", "Class '" + type.getName(expr) + "' doesn't have a superclass");
            }
            return;
        }
        OCSymbol symbol = expr.resolveToSymbol();
        if (symbol != null) {
            List<OCSymbol> symbols;
            if (symbol.getKind() == OCSymbolKind.SYMBOL_USING_SYMBOL && (symbols = ((OCUsingSymbol)symbol).getSymbolReference().resolveToSymbols(OCResolveContext.forPsi(expr))).size() != 0) {
                symbol = symbols.get(0);
            }
            if (!nonExprPossible && !symbol.getKind().isExpression() && symbol.getKind() != OCSymbolKind.MACRO) {
                this.addErrorAnnotation(expr, "CIDR", "Expression expected");
            }
        }
    }

    @Override
    public void visitReferenceElement(OCReferenceElement referenceElement) {
        super.visitReferenceElement(referenceElement);
        this.myDeclaratorChecker.checkReferenceElement(referenceElement);
    }

    @Override
    public void visitLabeledStatement(OCLabeledStatement stmt) {
        super.visitLabeledStatement(stmt);
        this.myDeclaratorChecker.checkDuplicates(stmt);
    }

    private void checkCaseType(OCExpression caseExpr, OCType switchType) {
        if (caseExpr == null) {
            return;
        }
        OCResolveContext context = OCResolveContext.forPsi(caseExpr);
        OCType caseType = caseExpr.getResolvedType(context);
        if (switchType instanceof OCCppReferenceType) {
            switchType = ((OCCppReferenceType)switchType).getRefType();
        }
        if (caseType.isUnknown()) {
            return;
        }
        if (!(caseType.isIntegerCompatible(context) || caseType instanceof OCStructType && ((OCStructType)caseType).isEnumClass())) {
            String message = "Integer expression is required in 'case' statement instead of '" + caseType.getName(caseExpr) + "'";
            Annotation annotation = this.addErrorAnnotation(caseExpr, OCInspections.IntegerTypeRequired.class, "err_expr_not_ice", message);
            OCChangeTypeIntentionAction.registerChangeTypeFix(caseExpr, OCIntType.CHAR, annotation, this);
            return;
        }
        if (!new OCConstantExpressionVisitor().isConstant(caseExpr)) {
            this.addErrorAnnotation(caseExpr, OCInspections.IntegerTypeRequired.class, "err_expr_not_ice", "Constant expression is required");
            return;
        }
        String prefix = "Case expression type '" + caseType.getName(context) + "' is incompatible with switch expression type '" + switchType.getName(context) + "': ";
        switchType.checkCompatible(caseType, caseExpr, caseExpr, context).setMessagePrefix(prefix).annotate(this.myCppChecker);
    }

    @Override
    public void visitCaseStatement(OCCaseStatement stmt) {
        super.visitCaseStatement(stmt);
        OCSwitchStatement switchStmt = (OCSwitchStatement)PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCSwitchStatement.class});
        if (switchStmt == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_case_not_in_switch", "Case label is outside of a switch");
            return;
        }
        OCCondition switchExpr = switchStmt.getExpression();
        if (switchExpr == null) {
            return;
        }
        OCType switchType = OCTypeUtils.doSwitchImplicitConversion(switchStmt, switchExpr.getResolvedType());
        if (stmt.isRange()) {
            this.checkCaseType(stmt.getRangeFirst(), switchType);
            this.checkCaseType(stmt.getRangeSecond(), switchType);
        } else {
            this.checkCaseType(stmt.getExpression(), switchType);
        }
    }

    private void checkConditionalStatement(@Nullable OCElement condition, @Nullable OCType conditionType, String elementName, @NotNull OCResolveContext context, OCStatement ... statementBlocks) {
        OCCondition declOrExpr;
        OCDeclaration declaration;
        if (context == null) {
            OCErrorAnnotator.$$$reportNull$$$0(0);
        }
        for (OCStatement statement2 : statementBlocks) {
            if (!(statement2 instanceof OCDeclarationStatement) || !OCCodeInsightUtil.isInPlainOldC(statement2)) continue;
            Annotation annotation = this.addErrorAnnotation(statement2, "CIDR", "Declaration is not allowed here");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)statement2, "Remove statement"));
        }
        if (condition instanceof OCCondition && (declaration = (declOrExpr = (OCCondition)condition).getDeclaration()) != null && declOrExpr.getExpression() == null) {
            if (!condition.getContainingOCFile().isCpp()) {
                this.addErrorAnnotation(condition, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Declaration is not allowed here");
            } else if (declaration.getDeclarators().isEmpty()) {
                this.addErrorAnnotation(condition, "err_expected_unqualified_id", "Declaration or expression is expected");
            } else if (declaration.getDeclarators().size() > 1) {
                this.addErrorAnnotation(condition, "CIDR", "Only one declarator is allowed here");
            } else {
                OCDeclarator declarator = declaration.getDeclarators().get(0);
                if (declarator.getArgumentList() != null) {
                    this.addErrorAnnotation(condition, "err_expected_init_in_condition_lparen", "Parenthesized initializer is not allowed here");
                } else if (declarator.getInitializer() == null && declarator.getInitializerList() == null) {
                    Annotation annotation = this.addErrorAnnotation(condition, OCInspections.InitializerIssues.class, "err_expected_init_in_condition", "Initializer is expected");
                    this.registerQuickFix(annotation, new OCAddInitializerIntentionAction(declarator, declarator.getSymbol()));
                }
            }
        }
        if (conditionType == null || conditionType.isUnknown()) {
            return;
        }
        if (!conditionType.isScalarOrConvertibleToScalar(context) && condition != null) {
            String message = "Type '" + conditionType.getName(condition) + "' used in '" + elementName + "' condition is not scalar";
            this.addErrorAnnotation(condition, OCInspections.ScalarTypeRequired.class, "err_typecheck_statement_requires_scalar", message);
        }
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        super.visitIfStatement(stmt);
        OCCondition condition = stmt.getCondition();
        if (condition != null) {
            OCResolveContext context = OCResolveContext.forPsi(stmt);
            this.checkConditionalStatement(condition, condition.getResolvedType(), "if", context, stmt.getThenBranch(), stmt.getElseBranch());
        }
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        super.visitWhileStatement(stmt);
        OCCondition condition = stmt.getCondition();
        if (condition != null) {
            this.checkConditionalStatement(condition, condition.getResolvedType(), "while", OCResolveContext.forPsi(stmt), stmt.getBody());
        }
    }

    @Override
    public void visitDoWhileStatement(OCDoWhileStatement stmt) {
        super.visitDoWhileStatement(stmt);
        OCExpression condition = stmt.getCondition();
        if (condition != null) {
            OCType conditionType = condition.getResolvedType();
            this.checkConditionalStatement(condition, conditionType, "do-while", OCResolveContext.forPsi(stmt), stmt.getBody());
        }
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        super.visitForStatement(stmt);
        OCCondition condition = stmt.getCondition();
        this.checkConditionalStatement(condition, condition != null ? condition.getResolvedType() : null, "for", OCResolveContext.forPsi(stmt), stmt.getBody());
    }

    @Override
    public void visitForeachStatement(OCForeachStatement statement2) {
        super.visitForeachStatement(statement2);
        this.myOperatorsChecker.checkForeach(statement2);
        this.checkConditionalStatement(null, null, "foreach", OCResolveContext.forPsi(statement2), statement2.getBody());
    }

    @Override
    public void visitReturnStatement(OCReturnStatement stmt) {
        super.visitReturnStatement(stmt);
        this.myOperatorsChecker.checkReturnStatement(stmt);
    }

    @Override
    public void visitBreakStatement(OCBreakStatement stmt) {
        super.visitBreakStatement(stmt);
        if (PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCLoopStatement.class, OCSwitchStatement.class}) == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_break_not_in_loop_or_switch", "'break' statement is outside of a loop or switch");
        }
    }

    @Override
    public void visitContinueStatement(OCContinueStatement stmt) {
        super.visitContinueStatement(stmt);
        if (PsiTreeUtil.getContextOfType((PsiElement)stmt, (Class[])new Class[]{OCLoopStatement.class}) == null) {
            this.addErrorAnnotation(stmt, OCInspections.ConstructionIsNotAllowed.class, "err_continue_not_in_loop", "'continue' statement is outside of a loop");
        }
    }

    @Override
    public void visitSwitchStatement(OCSwitchStatement stmt) {
        super.visitSwitchStatement(stmt);
        OCCondition condition = stmt.getExpression();
        if (condition != null) {
            OCType conditionType = OCTypeUtils.doSwitchImplicitConversion(stmt, condition.getResolvedType());
            this.checkConditionalStatement(condition, conditionType, "switch", OCResolveContext.forPsi(stmt), new OCStatement[0]);
        }
        this.myOperatorsChecker.checkSwitchStatement(stmt);
    }

    private void checkExceptionExpression(OCExpression expression) {
        if (expression == null) {
            return;
        }
        OCType type = expression.getResolvedType();
        if (!(type.isUnknown() || type.isPointerToObject() || type.isClassType())) {
            this.addErrorAnnotation(expression, OCInspections.PointerTypeRequired.class, OCClangMessageFinder.getInstance().getObjcThrowExpectsObject(), "Expression type '" + type.getName(expression) + "' is not a pointer to object");
        }
    }

    @Override
    public void visitSynchronizedStatement(OCSynchronizedStatement stmt) {
        super.visitSynchronizedStatement(stmt);
        this.checkExceptionExpression(stmt.getLockExpression());
    }

    @Override
    public void visitThrowExpression(OCThrowExpression expression) {
        super.visitThrowExpression(expression);
        if (expression.isCppStatement()) {
            return;
        }
        this.checkExceptionExpression(expression.getExceptionExpression());
        if (expression.getExceptionExpression() == null && PsiTreeUtil.getParentOfType((PsiElement)expression, OCCatchSection.class, (boolean)true, (Class[])new Class[]{OCCallable.class}) == null) {
            this.addErrorAnnotation(expression, OCClangMessageFinder.getInstance().getRethrowUsedOutsideCatch(), "@throw (rethrow) is used outside of a @catch block");
        }
    }

    @Override
    public void visitTryStatement(OCTryStatement stmt) {
        if (stmt.getCatchSections().isEmpty() && stmt.getFinallySection() == null) {
            this.addErrorAnnotation(stmt, "err_missing_catch_finally", stmt.getContainingOCFile().isCpp() ? "Missing catch or finally" : "Missing @catch or @finally");
        }
    }

    @Override
    public void visitCatchSection(OCCatchSection catchSection) {
        super.visitCatchSection(catchSection);
        OCParameterList paramList = catchSection.getParameters();
        if (paramList == null) {
            return;
        }
        if (paramList.getParameterDeclarations().size() != 1) {
            Annotation annotation = this.addErrorAnnotation(paramList, "CIDR", "Only one variable declaration is allowed");
            for (int i = paramList.getParameterDeclarations().size() - 1; i >= 1; --i) {
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)paramList.getParameterDeclarations().get(i), "Remove extra declarators"));
            }
            return;
        }
        OCDeclarator declarator = paramList.getParameterDeclarations().get(0).getDeclarator();
        if (declarator == null || catchSection.isCppStatement()) {
            return;
        }
        OCType type = declarator.getResolvedType();
        if (!(type.isUnknown() || type.isPointerToObject() || type.isClassType())) {
            this.addErrorAnnotation(declarator.getNameIdentifier(), OCInspections.PointerTypeRequired.class, "err_catch_param_not_objc_type", "Variable type ('" + type.getName(catchSection) + "') is not a pointer to object");
        }
    }

    @Override
    public void visitProperty(OCProperty property) {
        super.visitProperty(property);
        if (PsiTreeUtil.getContextOfType((PsiElement)property, (Class[])new Class[]{OCInterface.class, OCProtocol.class}) == null) {
            Annotation annotation = this.addErrorAnnotation(property, OCInspections.ConstructionIsNotAllowed.class, "CIDR", "Property is declared outside of an interface/protocol");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)property, "Remove property"));
        }
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        super.visitDeclarator(declarator);
        this.myDeclaratorChecker.checkDeclarator(declarator.getType(), declarator, declarator, declarator.getSymbol());
    }

    @Override
    public void visitDefineDirective(OCDefineDirectiveImpl directive) {
        this.myDeclaratorChecker.checkDuplicates(directive.getName(), directive, Collections.singletonList(directive));
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        super.visitStructLike(struct);
        if (struct.getContainingOCFile().isCpp()) {
            this.myDeclaratorChecker.checkDuplicates(struct);
        } else {
            List<PsiElement> navigationElements = Collections.singletonList(struct.getNameIdentifier());
            String structName = OCSymbolKind.STRUCT.getNameLowercase() + " " + struct.getName();
            String enumName = OCSymbolKind.ENUM.getNameLowercase() + " " + struct.getName();
            String unionName = OCSymbolKind.UNION.getNameLowercase() + " " + struct.getName();
            boolean bl = this.myDeclaratorChecker.checkDuplicates(structName, struct.getSymbol(), struct, navigationElements) && this.myDeclaratorChecker.checkDuplicates(enumName, struct.getSymbol(), struct, navigationElements) && this.myDeclaratorChecker.checkDuplicates(unionName, struct.getSymbol(), struct, navigationElements);
        }
    }

    @Override
    public void visitDeclaration(OCDeclaration declaration) {
        OCDeclarator declarator;
        OCSymbol symbol;
        super.visitDeclaration(declaration);
        PsiElement parent = declaration.getParent();
        if (!(!(parent instanceof OCInterface) && !(parent instanceof OCProtocol) || declaration.getDeclarators().isEmpty() || declaration.isTypedef() || declaration instanceof OCFunctionDeclaration || (symbol = (declarator = declaration.getDeclarators().get(0)).getSymbol()) instanceof OCDeclaratorSymbol && ((OCDeclaratorSymbol)symbol).isExtern())) {
            Annotation annotation = this.addErrorAnnotation(declaration, OCInspections.ConstructionIsNotAllowed.class, "err_objc_var_decl_inclass", "Can't declare variables inside @interface or @protocol");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)declaration, "Remove declaration"));
            return;
        }
        OCTypeElement typeElement = declaration.getTypeElement();
        if (declaration.getDeclarators().isEmpty()) {
            OCType type;
            OCType oCType = type = typeElement != null ? typeElement.getType().resolve(declaration) : null;
            if (type == null || !(type instanceof OCStructType) && !type.isUnknown()) {
                Annotation annotation = this.addWarningAnnotation(declaration, OCInspections.UnusedExpressionResult.class, "ext_no_declarators", "Useless type name in empty declaration");
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)declaration, "Remove statement"));
            }
        } else if ((typeElement == null || typeElement.isEmpty()) && (parent instanceof OCProperty || parent instanceof OCInstanceVariablesList || parent instanceof OCStruct || parent instanceof OCUnion || !OCCodeInsightUtil.isInPlainOldC(parent) && (parent instanceof OCFile || parent instanceof OCCppNamespace))) {
            OCFunctionSymbol functionSymbol;
            if (declaration instanceof OCFunctionDeclaration && (symbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)declaration).getSymbol()) instanceof OCFunctionSymbol && ((functionSymbol = (OCFunctionSymbol)symbol).isCppConstructor() || functionSymbol.isCppDestructor() || functionSymbol.isCppConversionOperator())) {
                return;
            }
            OCElement annotationRange = null;
            if (!declaration.getDeclarators().isEmpty()) {
                OCDeclarator declarator2 = declaration.getDeclarators().get(0);
                if (declarator2.getNamespaceQualifier() == null) {
                    annotationRange = declarator2.getNameIdentifier() != null ? declarator2.getNameIdentifier() : declarator2;
                }
            } else {
                annotationRange = declaration;
            }
            this.addErrorAnnotation(annotationRange, "CIDR", "Explicit type is required here");
        }
        if (typeElement != null && declaration instanceof OCFunctionDeclaration && typeElement.getType() instanceof OCAutoType && ((OCFunctionDeclaration)declaration).getTrailingReturnTypeElement() == null && !OCCompilerFeatures.supportsCxxReturnTypeDeduction(typeElement.getContainingFile())) {
            this.addErrorAnnotation(typeElement, "err_auto_missing_trailing_return", "Return type deduction is not supported by the compiler");
        }
        if (declaration instanceof OCStructuredBindingDeclaration) {
            this.myStructuredBindingChecker.checkStructuredBindingDeclaration((OCStructuredBindingDeclaration)declaration);
        }
    }

    @Override
    public void visitMethod(OCMethod method) {
        super.visitMethod(method);
        this.myImplementationChecker.checkMethod(method);
    }

    @Override
    public void visitExpressionStatement(OCExpressionStatement stmt) {
        PsiReference reference;
        super.visitExpressionStatement(stmt);
        OCExpression expr = stmt.getExpression();
        if ((expr instanceof OCUnaryExpression || expr instanceof OCBinaryExpression || expr instanceof OCArraySelectionExpression) && (!((reference = expr.getReference()) instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0 && !((OCOperatorReference)reference).hasMagicOperands())) {
            Annotation annotation = this.addWarningAnnotation(expr, OCInspections.UnusedExpressionResult.class, "warn_unused_expr", "Expression result is unused");
            if (!OCCodeInsightUtil.hasSideEffects(expr)) {
                this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)stmt, "Remove statement"));
            }
        }
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        super.visitMethodSelectorPart(part);
        this.myDeclaratorChecker.checkDeclarator(part.getType(), part, null, part.getLocalSymbol());
    }

    @Override
    public void visitAssignmentExpression(OCAssignmentExpression expression) {
        super.visitAssignmentExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkBinaryOperatorApplicable(expression.getReceiverExpression(), expression.getSourceExpression(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitBinaryExpression(OCBinaryExpression expression) {
        super.visitBinaryExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkBinaryOperatorApplicable(expression.getLeft(), expression.getRight(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitUnaryExpression(OCUnaryExpression expression) {
        super.visitUnaryExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression.getOperand(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitPrefixExpression(OCPrefixExpression expression) {
        super.visitPrefixExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression.getOperand(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    @Override
    public void visitPostfixExpression(OCPostfixExpression expression) {
        super.visitPostfixExpression(expression);
        PsiReference reference = expression.getReference();
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            this.myOperatorsChecker.checkUnaryOperatorApplicable(expression.getOperand(), expression.getOperationSign(), expression);
        } else {
            this.checkOperatorVisibility(expression, (OCOperatorReference)reference);
        }
    }

    private void checkOperatorVisibility(OCExpression expression, OCOperatorReference reference) {
        OCSymbol operator = reference.resolveToSymbols().get(0);
        OCVisibility.checkFieldVisibility(operator, expression, null, this);
    }

    @Override
    public void visitLiteralExpression(OCLiteralExpression expression) {
        String typeName;
        OCType type;
        super.visitLiteralExpression(expression);
        ASTNode child = expression.getNode().getFirstChildNode();
        if (!OCCompilerFeatures.supportsObjectLiterals(expression.getContainingOCFile()) && (type = expression.getResolvedType()) instanceof OCPointerType && ("NSNumber".equals(typeName = ((OCPointerType)type).getRefType().getName()) || "NSArray".equals(typeName) || "NSDictionary".equals(typeName)) && this.getHolder() != null) {
            this.getHolder().createErrorAnnotation((PsiElement)expression, typeName + " literals are not supported by the compiler");
        }
        while (child != null) {
            type = child.getElementType();
            if (type == OCTokenTypes.STRING_LITERAL) {
                String text = child.getText();
                if (text.startsWith("\"") && (text.length() == 1 || !text.endsWith("\"")) && this.getHolder() != null) {
                    this.getHolder().createErrorAnnotation(child, "Unterminated string literal").setAfterEndOfLine(true);
                }
            } else {
                PsiElement psi = child.getPsi();
                if (psi != null) {
                    if (type == OCTokenTypes.WRONG_RAW_STRING_LITERAL) {
                        Annotation annotation = this.getHolder().createErrorAnnotation(child, "Invalid suffix on raw string");
                        annotation.setNeedsUpdateOnTyping(true);
                        this.registerQuickFix(annotation, new OCAddRawStringSuffix(psi));
                    } else if (type == OCTokenTypes.WRONG_INTEGER_LITERAL) {
                        this.addErrorAnnotation(psi, OCClangMessageFinder.getInstance().getInvalidIntSuffix(), "Invalid suffix on integer constant");
                    } else if (type == OCTokenTypes.WRONG_FLOAT_LITERAL) {
                        this.addErrorAnnotation(psi, OCClangMessageFinder.getInstance().getInvalidFloatSuffix(), "Invalid suffix on floating constant");
                    }
                }
            }
            child = child.getTreeNext();
        }
    }

    @Override
    public void visitArrayLiteral(OCNSArrayLiteral literal) {
        super.visitArrayLiteral(literal);
        OCResolveContext context = OCResolveContext.forPsi(literal);
        for (OCExpression expression : literal.getElements()) {
            OCIdType.pointerToID(literal.getProject()).checkCompatible(expression.getResolvedType(), expression, expression, context).annotate(this.myCppChecker);
        }
    }

    @Override
    public void visitDictionaryLiteral(OCNSDictionaryLiteral literal) {
        super.visitDictionaryLiteral(literal);
        OCResolveContext context = OCResolveContext.forPsi(literal);
        for (OCExpression expression : literal.getElements()) {
            OCIdType.pointerToID(literal.getProject()).checkCompatible(expression.getResolvedType(), expression, expression, context).annotate(this.myCppChecker);
        }
    }

    @Override
    public void visitCastExpression(OCCastExpression expression) {
        super.visitCastExpression(expression);
        this.myOperatorsChecker.checkCastExperssion(expression);
    }

    @Override
    public void visitArraySelectionExpression(OCArraySelectionExpression expression) {
        super.visitArraySelectionExpression(expression);
        OCExpression arrayExpr = expression.getArrayExpression();
        OCExpression indexExpr = expression.getIndexExpression();
        if (indexExpr == null) {
            return;
        }
        OCType arrayType = arrayExpr.getResolvedType();
        OCType indexType = indexExpr.getResolvedType();
        PsiReference reference = expression.getReference();
        OCResolveContext context = OCResolveContext.forPsi(expression);
        if (!(reference instanceof OCOperatorReference) || ((OCOperatorReference)reference).resolveToSymbols().size() == 0) {
            if (arrayType instanceof OCCppReferenceType) {
                arrayType = ((OCCppReferenceType)arrayType).getRefType();
            }
            if (arrayType.isPointerToObject() && OCCompilerFeatures.supportsSubscripting(expression.getContainingOCFile())) {
                ReadWriteAccessDetector.Access accessType = new OCReadWriteAccessDetector().getExpressionAccess(expression);
                String accessorName = expression.getArraySubscriptAccessorName(indexType, accessType);
                if (accessorName != null) {
                    OCSymbol symbol;
                    String message = "Type '" + arrayType.getName(context) + "' doesn't respond to '-" + accessorName + "'";
                    Annotation annotation = this.addErrorAnnotation(expression.getArrayExpression(), OCInspections.UnresolvedMessage.class, "err_objc_subscript_method_not_found", message);
                    OCObjectType receiverType = (OCObjectType)arrayType.getTerminalType();
                    OCClassSymbol parentClass = receiverType.getClassSymbol();
                    String signature = expression.getArraySubscriptMethodSignature(indexType, accessType);
                    OCVoidType returnType = accessType == ReadWriteAccessDetector.Access.Read ? OCIdType.pointerToID(expression.getProject()) : OCVoidType.instance();
                    this.registerQuickFix(annotation, new OCCreateNewDefinitionIntentionAction(expression, parentClass, "-" + accessorName, signature, returnType, receiverType));
                    if (arrayType.getName().equals("NSArray *") && accessorName.equals("setObject:atIndexedSubscript:")) {
                        OCSymbol symbol2 = OCGetSymbolVisitor.getSymbol(arrayExpr);
                        if (symbol2 != null && symbol2.getResolvedType(context).equals(arrayType, context)) {
                            OCPointerType newType = OCPointerType.to(OCReferenceType.resolvedFromText("NSMutableArray", arrayExpr));
                            this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol2, newType, context));
                        }
                    } else if (arrayType.getName().equals("NSDictionary *") && accessorName.equals("setObject:forKeyedSubscript:") && (symbol = OCGetSymbolVisitor.getSymbol(arrayExpr)) != null && symbol.getResolvedType(context).equals(arrayType, context)) {
                        OCPointerType newType = OCPointerType.to(OCReferenceType.resolvedFromText("NSMutableDictionary", arrayExpr));
                        this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(symbol, newType, context));
                    }
                } else {
                    this.addErrorAnnotation(indexExpr, OCInspections.ArrayIssues.class, "err_objc_subscript_index_type", "Index expression must be an integer or an object pointer");
                }
            } else if (!arrayType.isSubclassOfMagic(context)) {
                if (!arrayType.isUnknown() && !(arrayType instanceof OCPointerType)) {
                    this.addErrorAnnotation(expression.getArrayExpression(), OCInspections.ArrayIssues.class, "err_typecheck_subscript_value", "Subscripted value is not an array");
                    ((OCOperatorReference)reference).resolveToSymbols();
                } else if (!(indexType.isUnknown() || indexType.isIntegerCompatible(context) || arrayType.isMagicInside(context))) {
                    Annotation annotation = this.addErrorAnnotation(expression.getIndexExpression(), OCInspections.ArrayIssues.class, "err_objc_subscript_index_type", "Array index is not integer");
                    OCChangeTypeIntentionAction.registerChangeTypeFix(expression.getIndexExpression(), OCIntType.CHAR, annotation, this);
                }
            }
        } else {
            OCSymbol operator = ((OCOperatorReference)reference).resolveToSymbols().get(0);
            OCVisibility.checkFieldVisibility(operator, expression, null, this);
            if (operator instanceof OCMethodSymbol) {
                List<OCMethodSymbol.SelectorPartSymbol> selectors = ((OCMethodSymbol)operator).getSelectors();
                OCType indexRequiredType = selectors.get(selectors.size() - 1).getParameter().getType().resolve(context);
                indexRequiredType.checkCompatible(indexType, indexExpr, indexExpr, context).setMessagePrefix("Index type mismatch: ").annotate(this.myCppChecker);
                OCExpression parentExpr = OCParenthesesUtils.topmostParenthesized(expression);
                if (parentExpr.getParent() instanceof OCAssignmentExpression && ((OCAssignmentExpression)parentExpr.getParent()).getReceiverExpression() == parentExpr) {
                    OCExpression sourceExpr = ((OCAssignmentExpression)parentExpr.getParent()).getSourceExpression();
                    OCType sourceRequiredType = selectors.get(0).getParameter().getType().resolve(expression);
                    if (sourceExpr != null) {
                        sourceRequiredType.checkCompatible(sourceExpr.getResolvedType(), sourceExpr, sourceExpr, context).annotate(this.myCppChecker);
                    }
                }
            }
        }
    }

    @Override
    public void visitCallExpression(OCCallExpression expression) {
        super.visitCallExpression(expression);
        this.myOperatorsChecker.checkCallExpression(expression);
    }

    @Override
    public void visitMacroCall(OCMacroCall macroCall) {
        super.visitMacroCall(macroCall);
        this.myOperatorsChecker.checkMacroCall(macroCall);
    }

    @Override
    public void visitSendMessageExpression(OCSendMessageExpression expression) {
        super.visitSendMessageExpression(expression);
        this.myOperatorsChecker.checkSendMessageExpression(expression);
    }

    @Override
    public void visitSelectorExpression(OCSelectorExpression expression) {
        super.visitSelectorExpression(expression);
        for (OCMethodSymbol method : expression.getReference().resolveToSymbols()) {
            OCFileSymbols.markSymbolAsUsed(expression.getContainingOCFile(), method, expression);
        }
    }

    @Override
    public void visitConditionalExpression(OCConditionalExpression expression) {
        super.visitConditionalExpression(expression);
        OCResolveContext context = OCResolveContext.forPsi(expression);
        OCType type = expression.getCondition().getResolvedType(context);
        if (!type.isUnknown() && !type.isScalarOrConvertibleToScalar(context)) {
            this.addErrorAnnotation(expression.getCondition(), OCInspections.ScalarTypeRequired.class, OCClangMessageFinder.getInstance().getConditionShouldBeScalar(), "Type '" + type.getName(expression) + "' used in '?:' operator condition is not scalar");
        }
        OCExpression lExpr = expression.getPositiveExpression(true);
        OCExpression rExpr = expression.getNegativeExpression();
        if (lExpr == null || rExpr == null) {
            return;
        }
        OCConditionalExpressionImpl.calcAndAnnotateConditionalExprType(lExpr.getResolvedType(context), lExpr, rExpr.getResolvedType(context), rExpr, expression, this, context);
    }

    @Override
    public void visitQualifiedExpression(OCQualifiedExpression expression) {
        super.visitQualifiedExpression(expression);
        this.myOperatorsChecker.checkQualifiedExpression(expression);
    }

    @Override
    public void visitPropertyAttributesList(OCPropertyAttributesList attributes) {
        super.visitPropertyAttributesList(attributes);
        HashSet<OCPropertySymbol.PropertyAttribute> processedAttrs = new HashSet<OCPropertySymbol.PropertyAttribute>();
        for (OCPropertyAttribute attributeNode : attributes.getAttributes()) {
            String name2 = attributeNode.getName();
            if (name2 == null) continue;
            Annotation annotation = null;
            OCPropertySymbol.PropertyAttribute attribute = OCPropertySymbolImpl.parseAttribute(name2);
            if (!OCCompilerFeatures.supportsNullability(attributes.getContainingFile()) && attribute != null && attribute.getGroup() == 5) {
                attribute = null;
            }
            if (!OCCompilerFeatures.supportsClassProperty(attributes.getContainingFile()) && attribute != null && attribute.getGroup() == 6) {
                attribute = null;
            }
            if (attributes.getParent() instanceof OCSynthesizePropertiesList && attribute != OCPropertySymbol.PropertyAttribute.CLASS) {
                attribute = null;
            }
            if (attribute != null) {
                List<OCDeclarator> declarators;
                OCProperty property;
                OCDeclaration declaration;
                for (OCPropertySymbol.PropertyAttribute processedAttr : processedAttrs) {
                    if (processedAttr == attribute) {
                        annotation = this.addWarningAnnotation(attributeNode.getNameIdentifier(), OCInspections.DuplicateAttribute.class, "CIDR", "Attribute '" + name2 + "' was already declared");
                        continue;
                    }
                    if (processedAttr.getGroup() != attribute.getGroup()) continue;
                    annotation = this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_property_attr_mutually_exclusive", "Attributes '" + StringUtil.toLowerCase((String)processedAttr.name()) + "' and '" + name2 + "' are mutually exclusive");
                }
                if (OCPropertySymbol.PROPERTY_ATTRIBUTES_WITH_VALUE.contains((Object)attribute) && attributeNode.getValue() == null) {
                    this.addErrorAnnotation(attributeNode.getNameIdentifier(), "CIDR", "Attribute '" + name2 + "' requires a value");
                } else if (!OCPropertySymbol.PROPERTY_ATTRIBUTES_WITH_VALUE.contains((Object)attribute) && attributeNode.getValue() != null) {
                    this.addErrorAnnotation(attributeNode.getNameIdentifier(), "CIDR", "Attribute '" + name2 + "' mustn't have a value");
                } else if (OCPropertySymbol.PROPERTY_ATTRIBUTES_FOR_OBJECT.contains((Object)attribute) && attributeNode.getParent().getParent() instanceof OCProperty && (declaration = (property = (OCProperty)attributeNode.getParent().getParent()).getDeclaration()) != null && !(declarators = declaration.getDeclarators()).isEmpty()) {
                    OCDeclarator declarator = declarators.get(0);
                    OCType type = declarator.getResolvedType();
                    OCSymbol symbol = declarator.getSymbol();
                    if (!(declarators.size() <= 0 || type.isPointerToObjectCompatible() || symbol != null && symbol.hasAttribute("NSObject"))) {
                        String message = "Attribute '" + name2 + "' requires the property of object type instead of '" + type.getName(attributes) + "'";
                        this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_property_requires_object", message);
                    }
                }
                processedAttrs.add(attribute);
            } else {
                annotation = this.addErrorAnnotation(attributeNode.getNameIdentifier(), "err_objc_expected_property_attr", "Unknown attribute '" + name2 + "'");
            }
            if (attributeNode.getColon() != null) {
                if ("getter".equals(name2)) {
                    this.addErrorAnnotation(attributeNode.getColon(), "CIDR", "Colon is only allowed for 'setter' attribute");
                }
            } else if ("setter".equals(name2)) {
                this.addErrorAnnotation(attributeNode.getValueElement(), "CIDR", "Colon is required for 'setter' attribute");
            }
            if (annotation == null) continue;
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)attributeNode, "Remove attribute"));
        }
    }

    @Override
    public void visitAttributeList(OCAttributesList list) {
        super.visitAttributeList(list);
        if (list.isMicrosoftAttributes() && !OCCompilerFeatures.supportsMsvcExtensions(list.getContainingOCFile())) {
            this.addErrorAnnotation(list, "CIDR", "Microsoft attributes are not supported by the compiler");
        }
    }

    @Override
    public void visitTypeElement(OCTypeElement typeElement) {
        super.visitTypeElement(typeElement);
        for (ASTNode child : typeElement.getNode().getChildren(null)) {
            if (child.getElementType() != OCTokenTypes.UNDERLYING_TYPE_KEYWORD || OCCompilerFeatures.isFeatureEnabled(typeElement.getContainingFile(), OCCompilerFeatures.Feature.UNDERLYING_TYPE)) continue;
            this.addErrorAnnotation(child.getPsi(), "CIDR", "__underlying_type is not supported by the compiler");
        }
    }

    @Override
    public void visitQualifiedDesignator(OCQualifiedDesignator designator) {
        if (designator.getArrayStartIndexer() != null) {
            OCType parent = designator.getParentType();
            if (parent instanceof OCArrayType) {
                OCExpression arrayStopIndexer;
                OCArrayType arrayParent = (OCArrayType)parent;
                int length = arrayParent.getLength(OCResolveContext.forPsi(designator));
                Number index = OCExpressionEvaluator.evaluate(designator.getArrayStartIndexer());
                if (index != null && (index.intValue() < 0 || length != -1 && index.intValue() >= length)) {
                    this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "CIDR", "Array index in initializer exceeds array bounds");
                }
                if ((arrayStopIndexer = designator.getArrayStopIndexer()) != null) {
                    Number stopIndex = OCExpressionEvaluator.evaluate(arrayStopIndexer);
                    if (stopIndex != null && (stopIndex.intValue() < 0 || length != -1 && stopIndex.intValue() >= length)) {
                        this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "CIDR", "Array index in initializer exceeds array bounds");
                    } else if (index != null && stopIndex != null && index.intValue() > stopIndex.intValue()) {
                        this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "err_array_designator_empty_range", "Empty index range in initializer");
                    }
                }
            } else {
                this.addErrorAnnotation(designator, OCInspections.ArrayIssues.class, "err_designator_for_scalar_init", "Subscripted value is not an array");
            }
        }
    }

    @Override
    public void visitSynthesizeProperty(OCSynthesizeProperty property) {
        super.visitSynthesizeProperty(property);
        this.myImplementationChecker.checkSynthesize(property);
    }

    @Override
    public void visitProtocolExpression(OCProtocolExpression expression) {
        OCType type;
        super.visitProtocolExpression(expression);
        OCTypeElement typeElement = expression.getTypeElement();
        if (typeElement != null && !((type = typeElement.getType().resolve(expression)) instanceof OCObjectType) && !type.isUnknown()) {
            this.addErrorAnnotation(typeElement, "CIDR", "'" + type.getName(expression) + "' isn't a protocol");
        }
    }

    @Override
    public void visitOCFile(OCFile file) {
        super.visitOCFile(file);
        this.annotateUnusedImports(file);
    }

    private void annotateUnusedImports(@NotNull OCFile file) {
        if (file == null) {
            OCErrorAnnotator.$$$reportNull$$$0(1);
        }
        Class<? extends OCInspection> inspectionClass = OCErrorAnnotator.getUnusedImportClass(file);
        if (!ApplicationManager.getApplication().isUnitTestMode() && !OCErrorAnnotator.isInspectionEnabled(file, inspectionClass) || !OCImportsOptimizer.shouldOptimizeImports(file)) {
            return;
        }
        OCFileGlobalSymbols symbols = OCFileGlobalSymbolsCache.getInstance(file.getProject()).forFile(file);
        this.processUndefinedClasses(file, symbols.getUndefinedClasses(), OCSymbolKind.INTERFACE);
        this.processUndefinedClasses(file, symbols.getUndefinedProtocols(), OCSymbolKind.PROTOCOL);
        List<OCIncludeDirective> imports = OCImportsOptimizer.doGetImports(file, false, true);
        for (OCIncludeDirective directive : imports) {
            Annotation annotation = this.addWarningAnnotation(directive, inspectionClass, "CIDR", OCErrorAnnotator.getUnusedImportText(file), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction((PsiElement)directive, OCErrorAnnotator.getRemoveImportText(file)));
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(imports, OCErrorAnnotator.getOptimizeImportsText(file), OCErrorAnnotator.getOptimizeImportsText(file)));
        }
    }

    @NotNull
    private static Class<? extends OCInspection> getUnusedImportClass(OCFile file) {
        Class clazz = file.getKind().isObjC() ? OCInspections.UnusedImportStatement.class : OCInspections.UnusedIncludeDirective.class;
        if (clazz == null) {
            OCErrorAnnotator.$$$reportNull$$$0(2);
        }
        return clazz;
    }

    @NotNull
    private static String getUnusedImportText(OCFile file) {
        String string = file.getKind().isObjC() ? "Unused import directive" : "Unused include directive";
        if (string == null) {
            OCErrorAnnotator.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String getRemoveImportText(OCFile file) {
        String string = file.getKind().isObjC() ? "Remove useless import" : "Remove useless include";
        if (string == null) {
            OCErrorAnnotator.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private static String getOptimizeImportsText(OCFile file) {
        String string = file.getKind().isObjC() ? "Optimize imports" : "Optimize includes";
        if (string == null) {
            OCErrorAnnotator.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static boolean isInspectionEnabled(@NotNull OCFile file, @NotNull Class inspectionClass) {
        if (file == null) {
            OCErrorAnnotator.$$$reportNull$$$0(6);
        }
        if (inspectionClass == null) {
            OCErrorAnnotator.$$$reportNull$$$0(7);
        }
        HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionClass.getSimpleName());
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        return inspectionProfile.isToolEnabled(key, (PsiElement)file);
    }

    private void processUndefinedClasses(OCFile file, Map<String, Pair<OCSymbol, VirtualFile>> undefinedClasses, OCSymbolKind symbolKind) {
        for (String className : undefinedClasses.keySet()) {
            OCClassSymbol definition;
            String message;
            Pair<OCSymbol, VirtualFile> pair2 = undefinedClasses.get(className);
            OCIncludeDirective directive = file.findIncludeDirective((VirtualFile)pair2.getSecond());
            OCSymbol symbol = (OCSymbol)pair2.getFirst();
            if (directive == null || !OCAnnotator.isAnnotatedAsUserCode(file.getProject(), symbol.getContainingFile())) continue;
            Annotation annotation = null;
            if (symbolKind == OCSymbolKind.INTERFACE) {
                message = "Cannot find class '" + className + "', superclass of " + symbol.getNameWithKindLowercase(OCCompilationContext.create(file));
                annotation = this.addErrorAnnotation(directive, OCInspections.CannotResolve.class, "CIDR", message);
            } else if (symbolKind == OCSymbolKind.PROTOCOL) {
                message = "Cannot find protocol '" + className + "', conformed by " + symbol.getNameWithKindLowercase(OCCompilationContext.create(file));
                annotation = this.addWarningAnnotation(directive, OCInspections.NotVisibleClass.class, "CIDR", message);
            }
            if ((definition = (OCClassSymbol)OCSymbolImpl.findSymbolDefinition(className, symbolKind, file.getProject(), file.getVirtualFile())) == null || annotation == null) continue;
            this.registerQuickFix(annotation, (IntentionAction)new OCImportSymbolFix(directive, definition));
        }
    }

    @Override
    public void visitCallable(OCCallable callable) {
        super.visitCallable(callable);
        if (!(callable instanceof OCBlockExpression) && !(callable instanceof OCLambdaExpression) || PsiTreeUtil.getContextOfType((PsiElement)callable, (Class[])new Class[]{OCCallable.class}) == null) {
            OCDataFlowAnalyzer analyzer = new OCDataFlowAnalyzer(callable, this, null);
            analyzer.buildControlFlowGraph();
            analyzer.analyze();
        }
    }

    @Override
    public void visitDirective(OCDirective directive) {
        PsiElement token = directive.getHeaderToken();
        IElementType header = token.getNode().getElementType();
        if (header == OCTokenTypes.ERROR_DIRECTIVE || header == OCTokenTypes.WARNING_DIRECTIVE) {
            Pair<String, TextRange> content = directive.getContent(true);
            if (header == OCTokenTypes.ERROR_DIRECTIVE) {
                this.addErrorAnnotation(directive, (TextRange)content.getSecond(), null, "CIDR", (String)content.getFirst(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            } else {
                this.addWarningAnnotation(directive, (TextRange)content.getSecond(), null, "CIDR", (String)content.getFirst(), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }
    }

    @Override
    public void visitCppNewExpression(OCCppNewExpression expression) {
        super.visitCppNewExpression(expression);
        OCType type = expression.getConstructingType().resolve(expression);
        OCCompoundInitializer list = expression.getInitializerList();
        OCType arrayElementType = type.getArrayElementType();
        if (arrayElementType instanceof OCStructType) {
            for (OCStructSymbol structSymbol : ((OCStructType)arrayElementType).getStructs()) {
                OCFileSymbols.markSymbolAsUsed(expression.getContainingOCFile(), structSymbol, expression);
            }
            if (((OCStructType)arrayElementType).isAbstract()) {
                String message = "Instantiating the abstract " + ((OCStructType)arrayElementType).getSymbol().getNameWithKindLowercase(OCCompilationContext.create(expression));
                this.addErrorAnnotation(expression, "err_allocation_of_abstract_type", message);
            }
            if (list == null) {
                OCArgumentsList<OCExpression> arguments = OCArgumentsList.getArgumentList(expression.getArguments());
                OCFunctionSymbol constructor = ((OCStructType)arrayElementType).findConstructor(arguments, OCResolveContext.forPsi(expression), true, null, false).getSymbol();
                this.myCppChecker.checkConstructorCall(expression, expression.getInitializers(), constructor, null);
            }
        }
        if (list != null) {
            type.checkCompatible(OCBracedInitListType.INSTANCE, list, expression, OCResolveContext.forPsi(expression)).annotate(this.myCppChecker);
        }
    }

    @Override
    public void visitConstructorFieldInitializer(OCConstructorFieldInitializer initializer) {
        super.visitConstructorFieldInitializer(initializer);
        OCReferenceElement refElement = initializer.getReferenceElement();
        OCSymbol symbol = refElement != null ? refElement.resolveToSymbol() : null;
        OCCompoundInitializer list = initializer.getInitializerList();
        OCResolveContext context = OCResolveContext.forPsi(initializer);
        if (list != null && symbol != null) {
            OCType type = null;
            if (symbol instanceof OCFunctionSymbol && ((OCFunctionSymbol)symbol).isCppConstructor()) {
                OCSymbolWithQualifiedName struct = ((OCFunctionSymbol)symbol).getParent();
                if (struct != null) {
                    type = struct.getType().resolve(context);
                }
            } else {
                type = symbol.getType().resolve(context);
            }
            if (type != null) {
                type.checkCompatible(OCBracedInitListType.INSTANCE, list, initializer, context).annotate(this.myCppChecker);
            }
            return;
        }
        List<OCExpression> initializers = initializer.getInitializers();
        if (symbol instanceof OCDeclaratorSymbol) {
            OCType type = symbol.getType().resolve(context);
            this.myCppChecker.checkTypeInitialization(initializer, refElement, OCArgumentsList.getArgumentList(initializers), symbol, type, false, initializer);
        } else {
            this.myCppChecker.checkConstructorCall(initializer, initializers, symbol, null);
        }
    }

    @Override
    public void visitNamespaceQualifier(OCCppNamespaceQualifier qualifier) {
        super.visitNamespaceQualifier(qualifier);
        if (qualifier.getParent() instanceof OCReferenceElement) {
            for (OCSymbol symbol : qualifier.resolveToSymbols()) {
                OCVisibility.checkFieldVisibility(symbol, qualifier, null, this);
                OCFileSymbols.markSymbolAsUsed(qualifier.getContainingOCFile(), symbol, qualifier);
            }
        }
    }

    @Override
    public void visitTemplateArgumentsOwner(OCTemplateArgumentsOwner argumentsOwner) {
        super.visitTemplateArgumentsOwner(argumentsOwner);
        OCTypeArgumentList argumentList = argumentsOwner.getTemplateArgumentList();
        List<OCTypeArgument> typeArguments = OCSymbolReferenceResolver.getTypeArguments(argumentsOwner);
        OCTemplateSymbol mainTemplate = null;
        if (argumentList == null || typeArguments == null) {
            return;
        }
        if (argumentsOwner instanceof OCResolvesToSymbol) {
            Object symbol = ((OCResolvesToSymbol)((Object)argumentsOwner)).resolveToSymbol();
            OCTemplateSymbol oCTemplateSymbol = mainTemplate = symbol instanceof OCTemplateSymbol ? (OCTemplateSymbol)symbol : null;
            if (mainTemplate instanceof OCFunctionGroupSymbol) {
                mainTemplate = ((OCFunctionGroupSymbol)mainTemplate).getOverloads().get(0);
            }
        }
        if (mainTemplate instanceof OCFunctionSymbol && ((OCFunctionSymbol)mainTemplate).isCppConstructor()) {
            OCSymbolWithQualifiedName owner2 = ((OCFunctionSymbol)mainTemplate).getResolvedOwner(OCResolveContext.forPsi(argumentsOwner));
            OCTemplateSymbol oCTemplateSymbol = mainTemplate = owner2 instanceof OCTemplateSymbol ? (OCTemplateSymbol)((Object)owner2) : null;
        }
        if (mainTemplate == null || !this.checkArguments(argumentsOwner, argumentList, typeArguments, mainTemplate, false)) {
            for (OCSymbol symbol : argumentsOwner.resolveTemplateDeclarations()) {
                OCTemplateSymbol template;
                if (!(symbol instanceof OCTemplateSymbol) || (template = (OCTemplateSymbol)symbol).getTemplateParameters().isEmpty() || template.getTemplateSpecialization() != null || mainTemplate != null && mainTemplate.getRequiredTemplateArgumentsCnt() <= typeArguments.size() && (mainTemplate.getTemplateParameters().size() >= template.getTemplateParameters().size() || template.getRequiredTemplateArgumentsCnt() > typeArguments.size())) continue;
                mainTemplate = template;
            }
        }
        if (mainTemplate == null || !OCSymbol.NON_FANTOM_SYMBOL_CONDITION.value((Object)mainTemplate)) {
            return;
        }
        this.checkArguments(argumentsOwner, argumentList, typeArguments, mainTemplate, true);
    }

    private boolean checkArguments(@NotNull OCTemplateArgumentsOwner argumentsOwner, @NotNull OCTypeArgumentList<?> argumentList, @NotNull List<OCTypeArgument> typeArguments, @NotNull OCTemplateSymbol<?> mainTemplate, boolean addAnnotations) {
        int requiredArgumentsCnt;
        if (argumentsOwner == null) {
            OCErrorAnnotator.$$$reportNull$$$0(8);
        }
        if (argumentList == null) {
            OCErrorAnnotator.$$$reportNull$$$0(9);
        }
        if (typeArguments == null) {
            OCErrorAnnotator.$$$reportNull$$$0(10);
        }
        if (mainTemplate == null) {
            OCErrorAnnotator.$$$reportNull$$$0(11);
        }
        OCResolveContext context = OCResolveContext.forPsi(argumentList);
        List<OCTypeParameterSymbol> parameters = mainTemplate.getTemplateParameters();
        int maxArgumentsCnt = parameters.size();
        List<?> arguments = argumentList.getArguments();
        boolean isVariableArgs = mainTemplate.isVariadicTemplate();
        if (mainTemplate instanceof OCFunctionSymbol && argumentsOwner instanceof OCFunctionDeclaration) {
            HashMap<OCTypeParameterSymbol, OCTypeArgument> substitutionMap = new HashMap<OCTypeParameterSymbol, OCTypeArgument>();
            OCSymbolWithQualifiedName functionSymbol = (OCSymbolWithQualifiedName)((OCFunctionDeclaration)argumentsOwner).getSymbol();
            if (functionSymbol != null) {
                OCSimpleTypeSubstitution.unify(mainTemplate.getType().resolve(context), functionSymbol.getType().resolve(context), substitutionMap, context);
                for (requiredArgumentsCnt = mainTemplate.getRequiredTemplateArgumentsCnt(); requiredArgumentsCnt > 0 && substitutionMap.containsKey(parameters.get(requiredArgumentsCnt - 1)); --requiredArgumentsCnt) {
                }
            }
        }
        if (typeArguments.size() < requiredArgumentsCnt && !ContainerUtil.exists(typeArguments, typeArgument -> typeArgument.isVariadic())) {
            if (!(argumentsOwner instanceof OCQualifiedExpression) && !(argumentsOwner instanceof OCReferenceElement) || !(mainTemplate instanceof OCFunctionSymbol)) {
                if (addAnnotations) {
                    this.addErrorAnnotation(argumentList, OCInspections.TemplateArgumentsIssues.class, "CIDR", OCBundle.message(requiredArgumentsCnt < parameters.size() ? "inspections.templateArguments.tooFewAtLeast" : "inspections.templateArguments.tooFew", requiredArgumentsCnt));
                }
                return false;
            }
        } else if (!isVariableArgs && arguments.size() > maxArgumentsCnt) {
            if (addAnnotations) {
                this.addErrorAnnotation(argumentList, OCInspections.TemplateArgumentsIssues.class, "CIDR", OCBundle.message(requiredArgumentsCnt < parameters.size() ? "inspections.templateArguments.tooManyAtMost" : "inspections.templateArguments.tooMany", maxArgumentsCnt));
            }
            return false;
        }
        boolean result = true;
        for (int i = 0; i < typeArguments.size(); ++i) {
            OCElement argumentPsi;
            OCTypeParameterSymbol parameter = i >= parameters.size() ? parameters.get(parameters.size() - 1) : parameters.get(i);
            OCTypeArgument argument = typeArguments.get(i);
            OCElement oCElement = argumentPsi = i >= arguments.size() ? (OCElement)arguments.get(arguments.size() - 1) : (OCElement)arguments.get(i);
            if (parameter.isVariadic() && i < parameters.size() - 1) break;
            if (parameter instanceof OCTypeParameterValueSymbol) {
                OCTypeCheckResult typeCheckResult;
                DeepEqual.Equality symbol;
                if (argument instanceof OCType) {
                    OCType resolvedType = ((OCType)argument).resolve(context);
                    if (resolvedType instanceof OCTypeParameterType && ((symbol = ((OCTypeParameterType)resolvedType).getSymbol()) instanceof OCTypeParameterValueSymbol || symbol instanceof OCTypeParameterTypeSymbol && ((OCTypeParameterTypeSymbol)symbol).isSynthetic()) || resolvedType instanceof OCReferenceType || resolvedType instanceof OCVariadicType) continue;
                    if (addAnnotations) {
                        this.addErrorAnnotation(argumentPsi, OCInspections.TemplateArgumentsIssues.class, "CIDR", OCBundle.message("inspections.templateArguments.valueInsteadOfType", new Object[0]));
                    }
                    result = false;
                    continue;
                }
                if (!(argument instanceof OCExpressionTypeArgument)) continue;
                OCType requiredType = ((OCTypeParameterValueSymbol)parameter).getType().resolve(context);
                symbol = ((OCExpressionTypeArgument)argument).getSymbol();
                OCType actualType = ((OCSymbolBase)symbol).getResolvedType(context);
                if (actualType == null || (typeCheckResult = requiredType.checkCompatible(actualType, (OCTypeOwner)((Object)symbol), argumentPsi, context)).getState().isOK() || requiredType instanceof OCIntType && actualType instanceof OCIntType) continue;
                if (addAnnotations) {
                    this.addErrorAnnotation(argumentPsi, OCInspections.TemplateArgumentsIssues.class, "CIDR", typeCheckResult.getMessage());
                }
                result = false;
                continue;
            }
            if (!(parameter instanceof OCTypeParameterTypeSymbol) || !(argument instanceof OCExpressionTypeArgument)) continue;
            if (addAnnotations) {
                this.addErrorAnnotation(argumentPsi, OCInspections.TemplateArgumentsIssues.class, "CIDR", OCBundle.message("inspections.templateArguments.typeInsteadOfValue", new Object[0]));
            }
            result = false;
        }
        return result;
    }

    @Override
    public void visitBoxedExpression(OCBoxedExpression expression) {
        if (!OCCompilerFeatures.supportsObjectLiterals(expression.getContainingOCFile())) {
            this.addErrorAnnotation(expression, "CIDR", "Expression literals are not supported by the compiler");
        } else {
            OCType type;
            OCExpression operand = expression.getOperand();
            if (!(operand == null || (type = operand.getResolvedType()).isNumberCompatible(OCResolveContext.forPsi(expression)) || type.isPointerToChar() || type instanceof OCMagicType)) {
                this.addErrorAnnotation(operand, "err_objc_illegal_boxed_expression_type", "Type '" + type.getName(operand) + "' is illegal for a boxed expression");
            }
        }
        super.visitBoxedExpression(expression);
    }

    @Override
    public void visitGenericSelectionExpression(OCGenericSelectionExpression genericExpression) {
        OCExpression expr;
        boolean containsError = this.checkAssociationList(genericExpression);
        if (!containsError && (expr = genericExpression.getControllingExpression()) != null) {
            boolean noneMatch;
            OCType type = expr.getResolvedType();
            boolean bl = noneMatch = genericExpression.getAssociationByType(type) == null;
            if (noneMatch) {
                this.addErrorAnnotation(expr, "err_generic_sel_no_match", "Controlling expression type '" + OCErrorAnnotator.getTypeName(type, genericExpression) + "' not compatible with any generic association type");
            }
        }
        super.visitGenericSelectionExpression(genericExpression);
    }

    public boolean checkAssociationList(OCGenericSelectionExpression genericExpression) {
        List<OCGenericSelectionAssociation> associations = genericExpression.getAssociations();
        int size = associations.size();
        boolean containsError = false;
        for (int i = size - 1; i >= 0; --i) {
            Optional<OCGenericSelectionAssociation> result;
            OCGenericSelectionAssociation association = associations.get(i);
            boolean isDefaultAssoc = association.isDefault();
            OCType type = isDefaultAssoc ? null : association.getAssociationResolvedType();
            OCTypeElement typeElement = (OCTypeElement)PsiTreeUtil.findChildOfType((PsiElement)association, OCTypeElement.class);
            if (type != null && type.isUnresolved(association)) {
                this.addErrorAnnotation(typeElement, "err_assoc_type_incomplete", "Type '" + type.getBestNameInContext(association) + "' in generic association incomplete");
                containsError = true;
            }
            OCType t = type;
            while (t instanceof OCArrayType) {
                if (!((OCArrayType)t).hasLength()) {
                    this.addErrorAnnotation(typeElement, "err_assoc_type_incomplete", "Type '" + t.getBestNameInContext(association) + "' in generic association incomplete");
                    containsError = true;
                    break;
                }
                t = ((OCArrayType)t).getRefType();
            }
            if (!(result = associations.subList(0, i).stream().filter(a -> {
                if (isDefaultAssoc && a.isDefault()) {
                    return true;
                }
                return type != null && type.equals(a.getAssociationResolvedType(), OCResolveContext.forPsi(a));
            }).findFirst()).isPresent()) continue;
            OCGenericSelectionAssociation duplicate = result.get();
            if (duplicate.isDefault()) {
                this.addErrorAnnotation(association, null, "Duplicate default generic association");
                containsError = true;
                continue;
            }
            this.addErrorAnnotation(typeElement, "err_assoc_compatible_types", "Type '" + OCErrorAnnotator.getTypeName(association) + "' in generic association compatible with previously specified type '" + OCErrorAnnotator.getTypeName(duplicate) + "'");
            containsError = true;
        }
        return containsError;
    }

    @Nullable
    private static String getTypeName(@NotNull OCGenericSelectionAssociation a) {
        if (a == null) {
            OCErrorAnnotator.$$$reportNull$$$0(12);
        }
        if (a.isDefault()) {
            return OCTokenTypes.DEFAULT_KEYWORD.getName();
        }
        OCType type = a.getAssociationResolvedType();
        return type != null ? type.getBestNameInContext(a) : null;
    }

    private static String getTypeName(@NotNull OCType type, @NotNull PsiElement context) {
        if (type == null) {
            OCErrorAnnotator.$$$reportNull$$$0(13);
        }
        if (context == null) {
            OCErrorAnnotator.$$$reportNull$$$0(14);
        }
        type = OCTypeUtils.decayType(type, context.getProject());
        return type.getBestNameInContext(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCErrorAnnotator";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspectionClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentsOwner";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mainTemplate";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCErrorAnnotator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedImportClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnusedImportText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoveImportText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptimizeImportsText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkConditionalStatement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "annotateUnusedImports";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isInspectionEnabled";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "checkArguments";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTypeName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

