/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.UpdateHighlightersUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.symtable.OCSymbolTablesBuildingActivity;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLargeFileHighlighter
extends TextEditorHighlightingPass
implements DumbAware {
    private static final String LANGUAGES_STRING = PlatformUtils.isAppCode() ? "C/Objective-C/C++" : "C/C++";
    private final PsiFile myFile;
    @NotNull
    private Collection<HighlightInfo> myHighlightInfos = Collections.emptyList();

    public OCLargeFileHighlighter(PsiFile file, Document document) {
        super(file.getProject(), document);
        this.myFile = file;
    }

    @Nullable
    private static String findTooLongInlineHeader(@NotNull ASTNode node) {
        if (node == null) {
            OCLargeFileHighlighter.$$$reportNull$$$0(0);
        }
        for (ASTNode child : node.getChildren(null)) {
            if (child.getElementType() == OCTokenTypes.HEADER_TOO_LONG_INLINED_PATH_LITERAL) {
                return child.getText();
            }
            String header = OCLargeFileHighlighter.findTooLongInlineHeader(child);
            if (header == null) continue;
            return header;
        }
        return null;
    }

    public void doCollectInformation(@NotNull ProgressIndicator progress) {
        String message;
        if (progress == null) {
            OCLargeFileHighlighter.$$$reportNull$$$0(1);
        }
        this.myHighlightInfos = Collections.emptyList();
        int textLength = this.myFile.getTextLength();
        if (!OCCodeInsightUtil.isCodeInsightAvailable(this.myFile)) {
            message = "File length (" + textLength + " characters) exceeds configured limit for " + LANGUAGES_STRING + " (" + OCCodeInsightUtil.getMaxFileLength() + " characters). Code insight features are not available.";
        } else {
            String tooLongInlineHeader = OCLargeFileHighlighter.findTooLongInlineHeader((ASTNode)this.myFile.getNode());
            if (tooLongInlineHeader != null) {
                int index = tooLongInlineHeader.indexOf(58);
                String length = "";
                if (index != -1) {
                    length = tooLongInlineHeader.substring(index + 1);
                    tooLongInlineHeader = tooLongInlineHeader.substring(0, index);
                }
                tooLongInlineHeader = OCInclusionContext.extractPath(tooLongInlineHeader, false).getPath();
                message = "File includes inline header (" + tooLongInlineHeader + ") with length (" + length + " characters) that exceeds configured limit for " + LANGUAGES_STRING + " (" + OCCodeInsightUtil.getMaxFileLength() + " characters). Header is not parsed.";
            } else {
                return;
            }
        }
        ArrayList<HighlightInfo> infos = new ArrayList<HighlightInfo>();
        TextRange range = this.myFile.getTextRange();
        HighlightInfo info = HighlightInfo.newHighlightInfo((HighlightInfoType)HighlightInfoType.WARNING).range(range).fileLevelAnnotation().description(message).create();
        if (info == null) {
            return;
        }
        IntentionAction fix = new IntentionAction(){

            @Nls
            @NotNull
            public String getText() {
                if ("Change the maximum file length" == null) {
                    1.$$$reportNull$$$0(0);
                }
                return "Change the maximum file length";
            }

            @Nls
            @NotNull
            public String getFamilyName() {
                String string = LANGUAGES_STRING;
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
                if (project2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
                if (project2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                OCLargeFileHighlighter.this.adjustMaxFileSize();
            }

            public boolean startInWriteAction() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 2: 
                    case 3: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter$1";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getText";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "isAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "invoke";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 2: 
                    case 3: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        info.registerFix(fix, Collections.emptyList(), "Change the maximum file length", range, null);
        infos.add(info);
        this.myHighlightInfos = infos;
    }

    private void adjustMaxFileSize() {
        String result;
        int newValue;
        int initialValue = OCCodeInsightUtil.getMaxFileLength();
        if (initialValue == (newValue = StringUtil.parseInt((String)(result = Messages.showInputDialog((Project)this.myProject, (String)("Enter the new maximum length for " + LANGUAGES_STRING + " files in characters"), (String)"Maximum File Length", null, (String)String.valueOf(initialValue), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return StringUtil.parseInt((String)inputString, (int)-1) > 0;
            }

            public boolean canClose(String inputString) {
                return true;
            }
        })), (int)initialValue))) {
            return;
        }
        OCCodeInsightUtil.setMaxFileLength(newValue);
        this.applyToEditor(Collections.emptyList());
        OCSymbolTablesBuildingActivity activity = OCSymbolTablesBuildingActivity.getInstance(this.myProject);
        if (activity != null) {
            activity.rebuildSymbols(OCSymbolTablesBuildingActivity.Mode.FULL);
        }
    }

    public void doApplyInformationToEditor() {
        this.applyToEditor(this.myHighlightInfos);
    }

    @NotNull
    public Collection<HighlightInfo> getHighlightInfos() {
        Collection<HighlightInfo> collection = this.myHighlightInfos;
        if (collection == null) {
            OCLargeFileHighlighter.$$$reportNull$$$0(2);
        }
        return collection;
    }

    private void applyToEditor(@NotNull Collection<HighlightInfo> infos) {
        if (infos == null) {
            OCLargeFileHighlighter.$$$reportNull$$$0(3);
        }
        if (this.myDocument != null) {
            UpdateHighlightersUtil.setHighlightersToEditor((Project)this.myProject, (Document)this.myDocument, (int)0, (int)this.myDocument.getTextLength(), infos, (EditorColorsScheme)this.getColorsScheme(), (int)this.getId());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCLargeFileHighlighter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findTooLongInlineHeader";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyToEditor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

