/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSink;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorSinkWrapper;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclaration;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTextIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCRemoveElementsIntentionAction;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCStructuredBindingType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import com.jetbrains.cidr.lang.util.OCStructuredBindingUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OCStructuredBindingChecker
extends OCAnnotatorSinkWrapper {
    public OCStructuredBindingChecker(@NotNull OCAnnotatorSink impl) {
        if (impl == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(0);
        }
        super(impl);
    }

    public void checkStructuredBindingDeclaration(@NotNull OCStructuredBindingDeclaration declaration) {
        List<OCDeclarator> declarators;
        OCElement initializer;
        if (declaration == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(1);
        }
        this.checkContext(declaration);
        this.checkDeclarationSpecifiers(declaration);
        OCTypeElement typeElement = declaration.getTypeElement();
        if (typeElement != null) {
            this.checkDeclarationSpecifiers(typeElement);
            this.checkTypeSpecifier(typeElement);
        }
        if ((initializer = declaration.getInitializer()) != null && this.checkInitializer(declaration, initializer) && (declarators = declaration.getDeclarators()).size() > 0) {
            OCType initializerType;
            OCResolveContext context = OCResolveContext.forPsi(declaration);
            OCType declaratorType = declarators.get(0).getType();
            if (declaratorType instanceof OCStructuredBindingType && (initializerType = OCStructuredBindingUtil.resolveInitializerType((OCStructuredBindingType)declaratorType, context)) != null) {
                this.checkStructuredBindingType(declaration, initializer, initializerType, context);
            }
        }
    }

    private void checkContext(@NotNull OCStructuredBindingDeclaration declaration) {
        PsiElement parent;
        if (declaration == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(2);
        }
        if ((parent = declaration.getParent().getParent()) instanceof OCCondition) {
            this.addErrorAnnotation(declaration, "err_decomp_decl_context", "Structured binding not allowed here");
        }
    }

    private void checkDeclarationSpecifiers(@NotNull OCElement element) {
        ASTNode[] specifiers;
        if (element == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(3);
        }
        for (ASTNode specifier : specifiers = element.getNode().getChildren(OCTokenTypes.DECLARATION_SPECIFIERS_IN_TYPES)) {
            PsiElement specifierElement = specifier.getPsi();
            String text = specifierElement.getText();
            Annotation annotation = this.addErrorAnnotation(specifierElement, "err_decomp_decl_spec", "Structured binding cannot be declared with '" + text + "'");
            this.registerQuickFix(annotation, new OCRemoveElementsIntentionAction(specifierElement, "Remove '" + text + "'"));
        }
    }

    private void checkTypeSpecifier(@NotNull OCTypeElement typeElement) {
        OCType type;
        if (typeElement == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(4);
        }
        if (!((type = typeElement.getType()) instanceof OCAutoType)) {
            Annotation annotation = this.addErrorAnnotation(typeElement, "err_decomp_decl_type", "Structured binding must be declared with 'auto'");
            String text = typeElement.getTextWithMacros();
            this.registerQuickFix(annotation, new OCChangeTextIntentionAction(typeElement.getContainingOCFile(), typeElement.getTextOffset(), text.length(), "auto", "Change type '" + text + "' to 'auto'"));
        }
    }

    private boolean checkInitializer(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer) {
        if (declaration == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(5);
        }
        if (initializer == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(6);
        }
        List<OCExpression> expressions = null;
        if (initializer instanceof OCCompoundInitializer) {
            if (declaration.hasEqualsInitializer()) {
                this.addErrorAnnotation(initializer, "CIDR", "Structured binding does not allow initializer list after '='");
                return false;
            }
            expressions = ((OCCompoundInitializer)initializer).getInitializerExpressions();
        } else if (initializer instanceof OCArgumentList) {
            expressions = ((OCArgumentList)initializer).getArguments();
        }
        if (expressions != null) {
            if (expressions.size() == 0) {
                this.addErrorAnnotation(initializer, "err_auto_var_init_no_expression", "Structured binding initializer cannot be empty");
                return false;
            }
            if (expressions.size() > 1) {
                this.addErrorAnnotation(initializer, "err_auto_var_init_multiple_expressions", "Structured binding initializer requires exactly one element");
                return false;
            }
        }
        return true;
    }

    private void checkStructuredBindingType(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCType type, @NotNull OCResolveContext context) {
        if (declaration == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(7);
        }
        if (initializer == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(8);
        }
        if (type == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(9);
        }
        if (context == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(10);
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCArrayType) {
            this.checkArraySize(declaration, initializer, (OCArrayType)type, context);
        } else if (type instanceof OCStructType && ((OCStructType)type).getKind() == OCSymbolKind.STRUCT) {
            OCStructType classType = (OCStructType)type;
            OCStructSymbol tupleSizeSymbol = OCStructuredBindingUtil.getTupleSizeSymbol(classType, context, declaration.getContainingOCFile());
            if (tupleSizeSymbol != null) {
                this.checkTupleLikeType(declaration, initializer, type, tupleSizeSymbol, context);
            } else {
                this.checkNonUnionClassType(declaration, initializer, classType, context);
            }
        } else if (!(type instanceof OCMagicType) && !type.isUnresolved(context)) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_unbindable_type", "'" + type.getName() + "' is not an array or non-union class type");
        }
    }

    private void checkNonUnionClassType(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCStructType classType, @NotNull OCResolveContext context) {
        if (declaration == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(11);
        }
        if (initializer == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(12);
        }
        if (classType == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(13);
        }
        if (context == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(14);
        }
        OCStructuredBindingUtil.MemberCollector memberCollector = new OCStructuredBindingUtil.MemberCollector();
        classType.processMembers(null, memberCollector, context);
        List<OCStructSymbol> baseClassesWithNonStaticMembers = memberCollector.getBaseClassesWithNonStaticMembers();
        if (this.checkBaseClasses(initializer, classType, baseClassesWithNonStaticMembers)) {
            this.checkMembers(declaration, initializer, classType, memberCollector);
        }
    }

    private void checkMembers(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCStructType classType, @NotNull OCStructuredBindingUtil.MemberCollector memberCollector) {
        int expectedSize;
        if (declaration == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(15);
        }
        if (initializer == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(16);
        }
        if (classType == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(17);
        }
        if (memberCollector == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(18);
        }
        if (memberCollector.hasAnonymousUnionMember()) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_anon_union_member", "Cannot bind to type '" + classType.getName() + "': found anonymous union member");
            return;
        }
        OCSymbol[] members = memberCollector.getMembers();
        int size = members.length;
        if (size != (expectedSize = declaration.getNumberOfIdentifiers())) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_wrong_number_bindings", String.format("'" + classType.getName() + "' has wrong number of non-static members: expected %d, got %d", expectedSize, size));
        } else {
            for (OCSymbol member : members) {
                OCVisibility.checkFieldVisibility(member, initializer, classType, this);
            }
        }
    }

    private boolean checkBaseClasses(@NotNull OCElement initializer, @NotNull OCStructType classType, @NotNull List<OCStructSymbol> baseClasses) {
        if (initializer == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(19);
        }
        if (classType == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(20);
        }
        if (baseClasses == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(21);
        }
        if (baseClasses.size() > 1) {
            if (baseClasses.get(0) == classType.getSymbol()) {
                this.addErrorAnnotation(initializer, "err_decomp_decl_multiple_bases_with_members", "Cannot bind to type '" + classType.getName() + "': both it and its base class '" + baseClasses.get(1).getName() + "' have non-static members");
                return false;
            }
            this.addErrorAnnotation(initializer, "err_decomp_decl_multiple_bases_with_members", "Cannot bind to type '" + classType.getName() + "': its base classes '" + baseClasses.get(0).getName() + "' and '" + baseClasses.get(1).getName() + "' have non-static members");
            return false;
        }
        return true;
    }

    private void checkTupleLikeType(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCType type, @NotNull OCStructSymbol tupleSizeSymbol, @NotNull OCResolveContext context) {
        OCDeclaratorSymbol tupleSizeValueSymbol;
        if (declaration == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(22);
        }
        if (initializer == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(23);
        }
        if (type == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(24);
        }
        if (tupleSizeSymbol == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(25);
        }
        if (context == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(26);
        }
        if ((tupleSizeValueSymbol = OCStructuredBindingUtil.getTupleSizeValueSymbol(tupleSizeSymbol, context)) == null || !(tupleSizeValueSymbol.getResolvedType(context) instanceof OCIntType)) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_std_tuple_size_not_constant", "std::tuple_size<" + type.getName() + ">::value is not a valid integral constant expression");
        } else {
            int expectedSize;
            int size;
            Object resolvedValue = OCExpressionEvaluator.evaluate((OCSymbol)tupleSizeValueSymbol, context);
            if (resolvedValue instanceof Number && (size = ((Number)resolvedValue).intValue()) != (expectedSize = declaration.getNumberOfIdentifiers())) {
                this.addErrorAnnotation(initializer, "err_decomp_decl_wrong_number_bindings", String.format("std::tuple_size<" + type.getName() + ">::value does not match: expected %d, got %d", expectedSize, size));
            }
        }
    }

    private void checkArraySize(@NotNull OCStructuredBindingDeclaration declaration, @NotNull OCElement initializer, @NotNull OCArrayType arrayType, @NotNull OCResolveContext context) {
        int expectedSize;
        int size;
        if (declaration == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(27);
        }
        if (initializer == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(28);
        }
        if (arrayType == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(29);
        }
        if (context == null) {
            OCStructuredBindingChecker.$$$reportNull$$$0(30);
        }
        if ((size = arrayType.getLength(context)) >= 0 && size != (expectedSize = declaration.getNumberOfIdentifiers())) {
            this.addErrorAnnotation(initializer, "err_decomp_decl_wrong_number_bindings", String.format("Array size does not match: expected %d, got %d", expectedSize, size));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "impl";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 11: 
            case 15: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 6: 
            case 8: 
            case 12: 
            case 16: 
            case 19: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: 
            case 14: 
            case 26: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberCollector";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClasses";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tupleSizeSymbol";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCStructuredBindingChecker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStructuredBindingDeclaration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkContext";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDeclarationSpecifiers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTypeSpecifier";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "checkInitializer";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "checkStructuredBindingType";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "checkNonUnionClassType";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMembers";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkBaseClasses";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[2] = "checkTupleLikeType";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "checkArraySize";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

