/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.containers.hash.HashMap;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageDescriptor;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInternary;
import gnu.trove.THashSet;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIterator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCClangMessageFinder {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder");
    protected static final String MESSAGES_FILE = "all-messages.txt";
    protected static final String SUPPORTED_IDS_FILE = "supported-ids.txt";
    private static final String[] myHardcodedMessages = new String[]{"expanded from macro '.*'", "arithmetic on pointer to .*, which is not a constant size in non-fragile ABI", "collection expression type '.*' is not a valid object"};
    private final List<OCClangMessageDescriptor> myDescriptors = new ArrayList<OCClangMessageDescriptor>();
    private final Map<String, OCClangMessageDescriptor> myDescriptorsMap = new HashMap();
    private final Map<String, IntArrayList> myWordsIndex = new HashMap();
    private final Set<String> mySupportedIDs;
    private final int myClangVersion;

    @NotNull
    public static OCClangMessageFinder getInstance() {
        OCClangMessageFinder oCClangMessageFinder = (OCClangMessageFinder)ServiceManager.getService(OCClangMessageFinder.class);
        if (oCClangMessageFinder == null) {
            OCClangMessageFinder.$$$reportNull$$$0(0);
        }
        return oCClangMessageFinder;
    }

    private boolean isVersionOrHigher(int version) {
        return this.myClangVersion >= version || this.myClangVersion == -1;
    }

    @NotNull
    public String getMethodNotImplemented() {
        String string = this.isVersionOrHigher(50) ? "warn_undef_method_impl" : "warn_incomplete_impl";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getUsageOfArcObjectInStruct() {
        String string = this.isVersionOrHigher(50) ? "err_arc_objc_object_in_tag" : "err_arc_objc_object_in_struct";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getMissingCase() {
        String string = this.isVersionOrHigher(70) ? "warn_missing_case" : "warn_missing_cases";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getConditionShouldBeScalar() {
        String string = this.isVersionOrHigher(70) ? "err_typecheck_cond_expect_scalar" : "err_typecheck_cond_expect_scalar_or_vector";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getInvalidIntSuffix() {
        String string = this.isVersionOrHigher(73) ? "err_invalid_suffix_constant" : "err_invalid_suffix_integer_constant";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getInvalidFloatSuffix() {
        String string = this.isVersionOrHigher(73) ? "err_invalid_suffix_constant" : "err_invalid_suffix_float_constant";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getReturnStackAddr() {
        String string = this.isVersionOrHigher(73) ? "warn_ret_stack_addr_ref" : "warn_ret_stack_addr";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getReturnTempAddr() {
        String string = this.isVersionOrHigher(73) ? "warn_ret_local_temp_addr_ref" : "warn_ret_local_temp_addr";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getObjcThrowExpectsObject() {
        String string = this.isVersionOrHigher(81) ? "err_objc_throw_expects_object" : "error_objc_throw_expects_object";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(9);
        }
        return string;
    }

    @NotNull
    public String getRethrowUsedOutsideCatch() {
        String string = this.isVersionOrHigher(81) ? "err_rethrow_used_outside_catch" : "error_rethrow_used_outside_catch";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    public String getSynthesizeCategoryDecl() {
        String string = this.isVersionOrHigher(81) ? "err_synthesize_category_decl" : "error_synthesize_category_decl";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(11);
        }
        return string;
    }

    @NotNull
    public String getCategoryProperty() {
        String string = this.isVersionOrHigher(81) ? "err_category_property" : "error_category_property";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getIvarInSuperclassUse() {
        String string = this.isVersionOrHigher(81) ? "err_ivar_in_superclass_use" : "error_ivar_in_superclass_use";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NotNull
    public String getDuplicateIvarUse() {
        String string = this.isVersionOrHigher(81) ? "err_duplicate_ivar_use" : "error_duplicate_ivar_use";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getPropertyImplemented() {
        String string = this.isVersionOrHigher(81) ? "err_property_implemented" : "error_property_implemented";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(15);
        }
        return string;
    }

    @NotNull
    public String getWeakProperty() {
        String string = this.isVersionOrHigher(81) ? "err_weak_property" : "error_weak_property";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public String getIvarUseInClassMethod() {
        String string = this.isVersionOrHigher(81) ? "err_ivar_use_in_class_method" : "error_ivar_use_in_class_method";
        if (string == null) {
            OCClangMessageFinder.$$$reportNull$$$0(17);
        }
        return string;
    }

    public OCClangMessageFinder() {
        this(OCClangMessageFinder.getClangAnnotatorVersion());
    }

    OCClangMessageFinder(int clangVersion) {
        HashSet<String> categoryNames = new HashSet<String>();
        int line = 0;
        try {
            for (Class<?> inspectionClass : OCInspections.class.getDeclaredClasses()) {
                if (!OCInspectionToolProvider.getInstance().isClangCompilerInspection(inspectionClass)) continue;
                categoryNames.add(((OCInspection)((Object)inspectionClass.newInstance())).getDisplayName());
            }
            this.myClangVersion = clangVersion;
            switch (this.myClangVersion) {
                default: {
                    LOG.warn("Unhandled clang version: " + this.myClangVersion);
                }
                case -1: {
                    clangVersion = 91;
                }
                case 60: 
                case 61: 
                case 70: 
                case 73: 
                case 80: 
                case 81: 
                case 90: 
                case 91: 
            }
            String clangVersionPrefix = "apple" + clangVersion + "/";
            String text = FileUtil.loadTextAndClose((InputStream)this.getClass().getResource(clangVersionPrefix + MESSAGES_FILE).openStream());
            String[] lines = StringUtil.splitByLines((String)text);
            THashSet unknownCategories = ContainerUtil.newTroveSet();
            while (line < lines.length) {
                String regex;
                String group;
                boolean added;
                OCClangMessageDescriptor.OCClangMessageKind kind;
                ProgressManager.checkCanceled();
                String[] id = lines[line++];
                String kindString = lines[line++];
                try {
                    kind = OCClangMessageDescriptor.OCClangMessageKind.valueOf(kindString);
                }
                catch (IllegalArgumentException e) {
                    kind = OCClangMessageDescriptor.OCClangMessageKind.Warning;
                    LOG.error("Unknown message kind for version " + clangVersion + ": " + kindString);
                }
                String category = lines[line++];
                if (!(added = this.addDescriptor((String)id, kind, category, group = lines[line++], (regex = lines[line++]).toLowerCase())) || categoryNames.contains(category)) continue;
                unknownCategories.add(category);
            }
            if (!unknownCategories.isEmpty()) {
                LOG.error("--------------------\n\nUnknown message categories for version " + clangVersion + ":\n" + StringUtil.join((Collection)unknownCategories, (String)"\n") + "\n", (Throwable)null);
            }
            LOG.assertTrue(line == lines.length, (Object)("Not all lines have been read for version " + clangVersion));
            text = FileUtil.loadTextAndClose((InputStream)this.getClass().getResource(clangVersionPrefix + SUPPORTED_IDS_FILE).openStream());
            this.mySupportedIDs = new HashSet<String>();
            for (String id : StringUtil.splitByLines((String)text)) {
                if (id.startsWith("//") || id.isEmpty()) continue;
                id = id.trim();
                this.mySupportedIDs.add(id);
                if (this.myDescriptorsMap.containsKey(id)) continue;
                LOG.error("--------------------\n\nCan't find Clang message \"" + id + "\" for version " + clangVersion + "\n", (Throwable)null);
            }
            int index = 0;
            for (String regex : myHardcodedMessages) {
                ProgressManager.checkCanceled();
                String id = "__hardcoded_" + index++;
                this.addDescriptor(id, OCClangMessageDescriptor.OCClangMessageKind.Error, "Empty Category", "Empty Group", regex.toLowerCase());
                this.mySupportedIDs.add(id);
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (RuntimeException e) {
            LOG.error("Error reading messages for version " + clangVersion + ", line " + line, (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            LOG.error("Can't read messages file for version " + clangVersion, (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static int getClangAnnotatorVersion() {
        for (OCAnnotatorHelper helper : OCAnnotator.getAnnotatorHelpers()) {
            int clangVersion = helper.getClangVersion();
            if (clangVersion == -1) continue;
            return clangVersion;
        }
        return -1;
    }

    private boolean addDescriptor(String id, OCClangMessageDescriptor.OCClangMessageKind kind, String category, String group, String regex) {
        if (regex.trim().equals(".*")) {
            return false;
        }
        Pattern pattern = Pattern.compile(regex);
        for (String word : StringUtil.getWordsIn((String)regex)) {
            IntArrayList list = this.myWordsIndex.get(word);
            if (list == null) {
                list = new IntArrayList();
                this.myWordsIndex.put(word, list);
            }
            list.add(this.myDescriptors.size());
        }
        OCClangMessageDescriptor descriptor2 = new OCClangMessageDescriptor(id, kind, OCNamesInternary.intern(category), group, pattern, OCClangMessageFinder.getWordsInPatternCnt(regex));
        this.myDescriptors.add(descriptor2);
        this.myDescriptorsMap.put(descriptor2.getID(), descriptor2);
        return true;
    }

    private static int getWordsInPatternCnt(String regex) {
        int parLevel = 0;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < regex.length(); ++i) {
            char c = regex.charAt(i);
            if (c == '(' && (i <= 0 || regex.charAt(i - 1) != '\\')) {
                ++parLevel;
                continue;
            }
            if (c == ')' && (i <= 0 || regex.charAt(i - 1) != '\\')) {
                --parLevel;
                continue;
            }
            if (parLevel != 0) continue;
            builder.append(c);
        }
        return StringUtil.getWordsIn((String)builder.toString()).size();
    }

    public boolean isMessageIDSupported(String id) {
        return this.mySupportedIDs.contains(id);
    }

    public OCClangMessageDescriptor findMessageDescriptor(String message) {
        return new Finder(message).find();
    }

    @Nullable
    public OCClangMessageDescriptor getSupportedMessageDescriptor(@NotNull String id) {
        OCClangMessageDescriptor descriptor2;
        if (id == null) {
            OCClangMessageFinder.$$$reportNull$$$0(18);
        }
        if ((descriptor2 = this.myDescriptorsMap.get(id)) == null) {
            LOG.error("Can't find clang message " + id);
        }
        if (!this.isMessageIDSupported(id)) {
            LOG.error("Clang message " + id + " is not marked as supported");
        }
        return descriptor2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 18: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 18: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/OCClangMessageFinder";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethodNotImplemented";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsageOfArcObjectInStruct";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMissingCase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConditionShouldBeScalar";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidIntSuffix";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidFloatSuffix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStackAddr";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnTempAddr";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjcThrowExpectsObject";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRethrowUsedOutsideCatch";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSynthesizeCategoryDecl";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCategoryProperty";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIvarInSuperclassUse";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicateIvarUse";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyImplemented";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getWeakProperty";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIvarUseInClassMethod";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/OCClangMessageFinder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getSupportedMessageDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 18: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Finder {
        private String myString;
        private List<String> myWords;

        Finder(String string) {
            this.myString = string.toLowerCase();
            this.myWords = StringUtil.getWordsIn((String)this.myString);
        }

        private OCClangMessageDescriptor find() {
            TIntHashSet allSet = new TIntHashSet(OCClangMessageFinder.this.myDescriptors.size());
            for (int i = 0; i < OCClangMessageFinder.this.myDescriptors.size(); ++i) {
                allSet.add(i);
            }
            if (!this.myWords.isEmpty()) {
                Integer variant = this.process(0, allSet, 0);
                if (variant != null) {
                    return (OCClangMessageDescriptor)OCClangMessageFinder.this.myDescriptors.get(variant);
                }
            } else {
                LOG.warn("No words found in the message \"" + this.myString + "\"");
            }
            return null;
        }

        @Nullable
        private Integer process(int wordIdx, TIntHashSet possiblePatterns, int wordsIncluded) {
            if (wordIdx < this.myWords.size()) {
                Integer result;
                TIntHashSet newVariants = new TIntHashSet(possiblePatterns.toArray());
                IntArrayList list = (IntArrayList)OCClangMessageFinder.this.myWordsIndex.get(this.myWords.get(wordIdx));
                if (list != null) {
                    newVariants.retainAll(list.toArray());
                } else {
                    newVariants.clear();
                }
                if (!newVariants.isEmpty() && (result = this.process(wordIdx + 1, newVariants, wordsIncluded + 1)) != null) {
                    return result;
                }
                result = this.process(wordIdx + 1, possiblePatterns, wordsIncluded);
                if (result != null) {
                    return result;
                }
            } else {
                TIntIterator iterator = possiblePatterns.iterator();
                while (iterator.hasNext()) {
                    if (((OCClangMessageDescriptor)OCClangMessageFinder.this.myDescriptors.get(iterator.next())).getWordsCnt() <= wordsIncluded) continue;
                    iterator.remove();
                }
                if (possiblePatterns.size() > 30) {
                    LOG.error("Too many possible patterns for \"" + this.myString + "\"");
                    return null;
                }
                int[] possibleVariants = possiblePatterns.toArray();
                Arrays.sort(possibleVariants);
                for (int variant : possibleVariants) {
                    if (!((OCClangMessageDescriptor)OCClangMessageFinder.this.myDescriptors.get(variant)).getPattern().matcher(this.myString).matches()) continue;
                    return variant;
                }
            }
            return null;
        }
    }
}

