/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class OCClangMessagesParser {
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.daemon.clang.OCClangMessagesParser");
    private File myClangDir;
    private String myFileName;
    private StringBuilder myBuilder;
    private StreamTokenizer myTokenizer;
    private Stack<String> myCategories;
    private Set<String> mySupportedIDs;
    private Map<String, String> myDiagnosticGroups;
    private Map<String, List<Object>> myClasses;
    private static final boolean VERIFY_IDS_MODE = false;
    private static final boolean ONLY_OUTPUT_SUPPORTED_MESSAGES = false;
    private static final boolean CREATE_INDIVIDUAL_FILES = false;
    private static final String PREFIX = "all";
    private static final String MESSAGES_FILE = "all-messages.txt";
    private static final String INDIVIDUAL_MESSAGES_DIR = "all-messages";
    private static final String SUPPORTED_IDS_FILE = "supported-ids.txt";

    public StringBuilder getBuilder() {
        return this.myBuilder;
    }

    public void setBuilder(StringBuilder builder) {
        this.myBuilder = builder;
    }

    public void parse(String text) throws IOException {
        if (this.myDiagnosticGroups == null) {
            this.myDiagnosticGroups = new HashMap<String, String>();
        }
        if (this.myClasses == null) {
            this.myClasses = new HashMap<String, List<Object>>();
        }
        this.myTokenizer = new StreamTokenizer(new StringReader(text));
        this.myTokenizer.wordChars(95, 95);
        this.myCategories = new Stack();
        this.myCategories.push("Empty Category");
        this.myTokenizer.nextToken();
        while (this.myTokenizer.ttype != -1) {
            if (this.parseLet() || this.parseDef() || this.parseClass()) continue;
            this.error("Let, def, or class expected");
        }
    }

    private boolean parseLet() throws IOException {
        if (!"let".equals(this.getCurWord())) {
            return false;
        }
        this.skipWord();
        String key = this.skipWord();
        this.expectToken('=');
        String value = this.skipQuotedWord();
        while (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            key = this.skipWord();
            this.expectToken('=');
            value = this.skipQuotedWord();
        }
        this.expectWord("in");
        this.expectToken('{');
        boolean isCategoryName = "CategoryName".equals(key);
        if (isCategoryName) {
            this.myCategories.push(value);
        }
        while (this.parseLet() || this.parseDef() || this.parseClass()) {
        }
        if (isCategoryName) {
            this.myCategories.pop();
        }
        this.expectToken('}');
        return true;
    }

    private boolean parseClass() throws IOException {
        if (!"class".equals(this.getCurWord())) {
            return false;
        }
        this.skipWord();
        String className = this.skipWord();
        this.expectToken(':');
        ArrayList<Object> options = new ArrayList<Object>();
        options.add(this.parseOption());
        while (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            options.add(this.parseOption());
        }
        this.expectToken(';');
        this.myClasses.put(className, options);
        return true;
    }

    private boolean parseDef() throws IOException {
        if (!"def".equals(this.getCurWord())) {
            return false;
        }
        this.skipWord();
        String id = null;
        if (this.myTokenizer.ttype != 58) {
            id = this.skipWord();
        }
        this.expectToken(':');
        String kind = null;
        String message = null;
        Object kindOption = this.parseOption();
        while (id != null) {
            if (kindOption instanceof Pair) {
                Pair kindOptionPair = (Pair)kindOption;
                if (!(kindOptionPair.first instanceof String)) {
                    this.error(id + " has no value for message kind");
                }
                if (!(kindOptionPair.second instanceof String)) {
                    this.error(id + " has no value for message text");
                }
                kind = (String)kindOptionPair.first;
                message = (String)kindOptionPair.second;
                break;
            }
            kind = (String)kindOption;
            List classDefinition = this.myClasses.getOrDefault(kind, null);
            if (classDefinition != null && classDefinition.size() >= 1 && (kindOption = classDefinition.get(0)) != null) continue;
            this.warn(id + " has no message text");
            break;
        }
        String group = "Empty Group";
        while (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            Object option = this.parseOption();
            if (id == null || !(option instanceof Pair) || !"InGroup".equals(((Pair)option).first)) continue;
            Object value = ((Pair)option).second;
            if (value instanceof String) {
                if (this.myDiagnosticGroups.containsKey((String)value)) {
                    group = this.myDiagnosticGroups.get((String)value);
                    continue;
                }
                this.error(id + " has no value for diagnostic group " + value);
                continue;
            }
            if (value instanceof Pair && "DiagGroup".equals(((Pair)value).first)) {
                value = ((Pair)value).second;
                if (value instanceof String) {
                    group = (String)value;
                    continue;
                }
                this.error(id + " has no value for option InGroup");
                continue;
            }
            this.error(id + " has no value for option InGroup");
        }
        this.expectToken(';');
        if (id != null && message != null) {
            if ("DiagGroup".equals(kind)) {
                this.myDiagnosticGroups.put(id, message);
            } else {
                this.processMessageType(id, kind, this.myCategories.peek(), group, message);
            }
        }
        return true;
    }

    @Nullable
    private Object parseOption() throws IOException {
        String option;
        Object optionValue = null;
        if (this.myTokenizer.ttype == 34) {
            StringBuilder message = new StringBuilder();
            while (this.myTokenizer.ttype == 34 || this.myTokenizer.ttype == -3) {
                message.append(this.myTokenizer.sval);
                this.myTokenizer.nextToken();
            }
            option = message.toString();
        } else {
            option = this.skipWord();
        }
        if (this.myTokenizer.ttype == 60) {
            this.expectToken('<');
            optionValue = this.parseOption();
            if (this.myTokenizer.ttype == 44) {
                this.expectToken(',');
                this.expectToken('[');
                this.skipWord();
                while (this.myTokenizer.ttype == 44) {
                    this.expectToken(',');
                    this.skipWord();
                }
                this.expectToken(']');
            }
            this.expectToken('>');
        }
        if (optionValue != null) {
            return Pair.create((Object)option, optionValue);
        }
        return option;
    }

    private void processMessageType(String id, String kind, String category, String group, String message) throws IOException {
        StringBuilder builder = this.myBuilder;
        this.myBuilder.append(id).append("\n");
        builder.append(kind).append("\n");
        builder.append(category).append("\n").append(group).append("\n").append(OCClangMessagesParser.convertPattern(message)).append("\n");
    }

    public static String convertPattern(String rawMessage) {
        return new Parser(rawMessage).parse();
    }

    private int getCurLineNo() {
        return this.myTokenizer != null ? this.myTokenizer.lineno() : -1;
    }

    private String getCurWord() {
        if (this.myTokenizer.ttype == -3) {
            return this.myTokenizer.sval;
        }
        return "";
    }

    private String skipWord() throws IOException {
        if (this.myTokenizer.ttype == -3) {
            String sval = this.myTokenizer.sval;
            this.myTokenizer.nextToken();
            return sval;
        }
        this.error("Expected word");
        return null;
    }

    private String skipQuotedWord() throws IOException {
        if (this.myTokenizer.ttype == 34) {
            String sval = this.myTokenizer.sval;
            this.myTokenizer.nextToken();
            return sval;
        }
        this.error("Expected quoted word");
        return null;
    }

    private void expectWord(String wordText) throws IOException {
        if (this.myTokenizer.ttype == -3 && wordText.equals(this.myTokenizer.sval)) {
            this.myTokenizer.nextToken();
        } else {
            this.error("Expected '" + wordText + "'");
        }
    }

    private void expectToken(char token) throws IOException {
        if (this.myTokenizer.ttype == token) {
            this.myTokenizer.nextToken();
        } else {
            this.error("Expected '" + token + "'");
        }
    }

    @Contract(value="_ -> fail")
    private void error(String message) {
        LOG.error(message + " at " + this.myFileName + ":" + this.getCurLineNo());
    }

    private void warn(String message) {
        LOG.warn(message + " at " + this.myFileName + ":" + this.getCurLineNo());
    }

    private void generatePatterns(File clangDirOrFile) throws IOException {
        this.myBuilder = new StringBuilder();
        Object[] files = clangDirOrFile.listFiles();
        if (files != null) {
            Arrays.sort(files);
            this.myClangDir = clangDirOrFile;
            File groupsFile = new File(clangDirOrFile, "DiagnosticGroups.td");
            if (groupsFile.exists()) {
                String messages = FileUtil.loadFile((File)groupsFile);
                this.myFileName = groupsFile.getName();
                this.parse(messages);
            }
            for (Object file : files) {
                if (!((File)file).getName().endsWith("Kinds.td")) continue;
                String messages = FileUtil.loadFile((File)file);
                this.myFileName = ((File)file).getName();
                this.parse(messages);
            }
        } else if (clangDirOrFile.getName().endsWith("td")) {
            this.myClangDir = clangDirOrFile.getParentFile();
            String messages = FileUtil.loadFile((File)clangDirOrFile);
            this.myFileName = clangDirOrFile.getName();
            this.parse(messages);
        }
        File outputFile = new File(this.myClangDir, MESSAGES_FILE);
        FileUtil.writeToFile((File)outputFile, (String)this.myBuilder.toString());
    }

    public static void main(String[] args) throws IOException {
        if (args.length >= 1) {
            for (String arg : args) {
                File clangDir = new File(arg);
                System.out.println("== " + clangDir.getName() + " ==");
                if (!clangDir.exists()) {
                    System.err.println(clangDir.getPath() + " does not exist");
                    return;
                }
                new OCClangMessagesParser().generatePatterns(clangDir);
            }
        } else {
            System.err.println("Usage: <path to .td file or directory with .td files> ...");
        }
    }

    private static class Parser {
        private final String myMessage;
        private final int myLength;
        private int myIndex;
        private final StringBuilder myResult = new StringBuilder();

        public Parser(String message) {
            this.myMessage = message;
            this.myLength = message.length();
        }

        public String parse() {
            while (this.myIndex < this.myLength) {
                char c;
                if ((c = this.myMessage.charAt(this.myIndex++)) == '%') {
                    this.parseOperatorStart();
                    continue;
                }
                this.appendChar(c);
            }
            return this.myResult.toString();
        }

        private void parseOperatorStart() {
            char c;
            if (this.myIndex < this.myLength && this.myMessage.charAt(this.myIndex) == '%') {
                ++this.myIndex;
                this.myResult.append("%");
                return;
            }
            StringBuilder name2 = new StringBuilder();
            while (this.myIndex < this.myLength && (Character.isDigit(c = this.myMessage.charAt(this.myIndex)) || Character.isLetter(c))) {
                name2.append(c);
                ++this.myIndex;
            }
            String operator = name2.toString();
            if (operator.equals("select") || operator.equals("diff") || operator.equals("plural")) {
                assert (this.myIndex < this.myLength);
                assert (this.myMessage.charAt(this.myIndex) == '{');
                ++this.myIndex;
                this.myResult.append("(");
                this.parseOperator(operator.equals("plural"));
            } else {
                this.myResult.append(".*");
            }
        }

        private void parseOperator(boolean plural) {
            boolean startPart = plural;
            while (this.myIndex < this.myLength) {
                char c = this.myMessage.charAt(this.myIndex++);
                if (startPart) {
                    if (Character.isDigit(c) || c == ':') continue;
                    startPart = false;
                }
                if (c == '%') {
                    this.parseOperatorStart();
                    continue;
                }
                if (c == '}') {
                    this.parseOperatorEnd();
                    return;
                }
                if (c == '|') {
                    this.myResult.append("|");
                    startPart = plural;
                    continue;
                }
                this.appendChar(c);
            }
            assert (false);
        }

        private void parseOperatorEnd() {
            char c;
            while (this.myIndex < this.myLength && (Character.isDigit(c = this.myMessage.charAt(this.myIndex)) || c == ',')) {
                ++this.myIndex;
            }
            this.myResult.append(")");
        }

        private void appendChar(char c) {
            if (c == '$') {
                this.myResult.append(".*");
            } else if (c == '(' || c == ')' || c == '+' || c == '*' || c == '?' || c == '.' || c == '[' || c == ']' || c == '{' || c == '}' || c == '|' || c == '\\' || c == '\"') {
                this.myResult.append("\\").append(c);
            } else {
                this.myResult.append(c);
            }
        }
    }
}

