/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyIntentionAction;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyProblemGroup;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.OpenClangTidySettingsAction;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.parser.OCElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCppNamespace;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStatementWithExpression;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyAnnotationApplier {
    public void applyFail(@NotNull PsiFile file, @NotNull String reason, HighlightSeverity severity, @NotNull AnnotationHolder holder) {
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(0);
        }
        if (reason == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(2);
        }
        String message = "Unable to execute Clang-Tidy: " + reason;
        Annotation annotation = holder.createAnnotation(severity, file.getTextRange(), message);
        annotation.registerFix((IntentionAction)new OpenClangTidySettingsAction());
        annotation.setFileLevelAnnotation(true);
    }

    public void applySuccess(@NotNull PsiFile file, @NotNull Document document, @NotNull List<ClangTidyDiagnostic> diagnostics, @NotNull AnnotationHolder holder) {
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(3);
        }
        if (document == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(4);
        }
        if (diagnostics == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(6);
        }
        ProgressManager.checkCanceled();
        for (ClangTidyDiagnostic diagnostic : diagnostics) {
            PsiElement elementToAnnotate = ClangTidyAnnotationApplier.getElementToAnnotate(file, diagnostic.getFileOffset());
            if (elementToAnnotate == null) continue;
            TextRange rangeToHighlight = ClangTidyAnnotationApplier.getRangeToHighlight(elementToAnnotate);
            String diagnosticMessage = ClangTidyAnnotationApplier.getDiagnosticMessage(diagnostic.getMessage(), holder.isBatchMode());
            List<ClangTidyReplacement> replacements = diagnostic.getReplacements();
            String diagnosticName = diagnostic.getDiagnosticName();
            HighlightSeverity highlightSeverity = OCInspectionUtil.getHighlightSeverity(ClangTidyInspection.class, (PsiElement)file, HighlightSeverity.WARNING);
            if (highlightSeverity == null) break;
            Annotation annotation = holder.createAnnotation(highlightSeverity, rangeToHighlight, diagnosticMessage);
            if (annotation == null) continue;
            Object fixToRegister = replacements.isEmpty() ? new EmptyIntentionAction("Clang-Tidy") : new ClangTidyIntentionAction(document, diagnosticMessage, diagnosticName, replacements);
            annotation.registerFix((IntentionAction)fixToRegister);
            annotation.setProblemGroup((ProblemGroup)ClangTidyAnnotationApplier.createProblemGroup(file, diagnosticName));
            if (!(holder instanceof OCAnnotator.AnnotationAndQuickFixHolder)) continue;
            ((OCAnnotator.AnnotationAndQuickFixHolder)holder).createQuickFix(annotation, (IntentionAction)fixToRegister);
        }
    }

    @NotNull
    private static ClangTidyProblemGroup createProblemGroup(@NotNull PsiFile file, @NotNull String checkName) {
        ClangTidyInspection inspection;
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(7);
        }
        if (checkName == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(8);
        }
        boolean canDisableChecks = (inspection = ClangTidyUtil.getInspection(file, file.getProject())) != null && inspection.isUseCustomListOfClangTidyChecks();
        ClangTidyProblemGroup clangTidyProblemGroup = new ClangTidyProblemGroup(checkName, canDisableChecks);
        if (clangTidyProblemGroup == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(9);
        }
        return clangTidyProblemGroup;
    }

    private static String getDiagnosticMessage(@NotNull String message, boolean isBatchMode) {
        if (message == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(10);
        }
        return isBatchMode ? message : "Clang-Tidy: " + message;
    }

    @Nullable
    private static PsiElement getElementToAnnotate(@NotNull PsiFile file, int offset) {
        PsiElement element;
        if (file == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(11);
        }
        PsiElement psiElement = element = file.getTextLength() > offset ? file.findElementAt(offset) : file.getLastChild();
        if (element instanceof PsiComment) {
            return element;
        }
        if (!OCElementUtil.isElementSignificant(element)) {
            element = OCElementUtil.getPrevSignificantSibling(element);
        }
        if (element == null) {
            return null;
        }
        if (ClangTidyAnnotationApplier.isMakeSenseToHighlight(element.getNode().getElementType())) {
            return element;
        }
        if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCall.class}) != null) {
            return element;
        }
        OCElement context = (OCElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{OCStatement.class, OCExpression.class, OCTypeElement.class, OCDeclarator.class, OCDeclaration.class, OCStructLike.class});
        assert (!(context instanceof PsiFile));
        assert (!(element instanceof PsiFile));
        return context != null ? context : element;
    }

    private static boolean isMakeSenseToHighlight(@NotNull IElementType elementType) {
        if (elementType == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(12);
        }
        if (elementType == OCTokenTypes.LBRACE || elementType == OCTokenTypes.RBRACE) {
            return true;
        }
        if (!OCTokenTypes.KEYWORDS.contains(elementType) || OCTokenTypes.SIMPLE_TYPE_SPECIFIERS.contains(elementType)) {
            return false;
        }
        HashSet keywordsToIgnore = ContainerUtil.newHashSet((Object[])new IElementType[]{OCTokenTypes.OPERATOR_CPP_KEYWORD, OCTokenTypes.VIRTUAL_CPP_KEYWORD, OCTokenTypes.EXPLICIT_CPP_KEYWORD, OCTokenTypes.INLINE_KEYWORD, OCTokenTypes.EXTERN_KEYWORD, OCTokenTypes.REGISTER_KEYWORD, OCTokenTypes.STATIC_KEYWORD, OCTokenTypes.CONST_KEYWORD, OCTokenTypes.VOLATILE_KEYWORD});
        return !keywordsToIgnore.contains(elementType);
    }

    @NotNull
    private static TextRange getRangeToHighlight(@NotNull PsiElement element) {
        List<OCDeclarator> declarators;
        PsiElement identifier;
        if (element == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(13);
        }
        OCElementType keyword = null;
        if (element instanceof OCStatementWithExpression) {
            keyword = ((OCStatementWithExpression)element).getKeywordType();
        } else if (element instanceof OCIfStatement) {
            keyword = OCTokenTypes.IF_KEYWORD;
        } else if (element instanceof OCCppNamespace) {
            keyword = OCTokenTypes.NAMESPACE_CPP_KEYWORD;
        }
        if (keyword != null) {
            OCElementType keywordToSearch = keyword;
            Optional<ASTNode> keywordElement = Arrays.stream(element.getNode().getChildren(null)).filter(child -> child.getElementType() == keywordToSearch).findFirst();
            if (keywordElement.isPresent()) {
                TextRange textRange = keywordElement.get().getTextRange();
                if (textRange == null) {
                    ClangTidyAnnotationApplier.$$$reportNull$$$0(14);
                }
                return textRange;
            }
        }
        if (element instanceof OCStructLike && (identifier = ((OCStructLike)element).getNameIdentifier()) != null) {
            TextRange textRange = OCElementUtil.getRangeWithMacros(identifier);
            if (textRange == null) {
                ClangTidyAnnotationApplier.$$$reportNull$$$0(15);
            }
            return textRange;
        }
        if (element instanceof OCDeclaration && (declarators = ((OCDeclaration)element).getDeclarators()).size() == 1 && declarators.get(0).getName() != "<unnamed>") {
            element = declarators.get(0);
        }
        if (element instanceof OCDeclarator && (identifier = ((OCDeclarator)element).getNameIdentifier()) != null) {
            TextRange textRange = OCElementUtil.getRangeWithMacros(identifier);
            if (textRange == null) {
                ClangTidyAnnotationApplier.$$$reportNull$$$0(16);
            }
            return textRange;
        }
        TextRange textRange = OCElementUtil.getRangeWithMacros(element);
        if (textRange == null) {
            ClangTidyAnnotationApplier.$$$reportNull$$$0(17);
        }
        return textRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplier";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationApplier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemGroup";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "applyFail";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applySuccess";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createProblemGroup";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getDiagnosticMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getElementToAnnotate";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isMakeSenseToHighlight";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getRangeToHighlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

