/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessAdapter;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationApplier;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotationHolder;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDocumentListener;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyYamlLoader;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.toolchains.CidrSwitchBuilder;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.error.YAMLException;

public class ClangTidyAnnotator
extends ExternalAnnotator<ClangTidyAnnotatorInfo, ClangTidyAnnotationHolder> {
    public static final Key<Boolean> RUN_IN_UNIT_TEST_MODE = Key.create((String)"CLANG_TIDY_ANNOTATOR_RUN_IN_UNIT_TEST_MODE");
    public static final Key<Boolean> COLLECT_DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_COLLECT_DEBUG_INFORMATION");
    public static final Key<String> DEBUG_INFORMATION = Key.create((String)"CLANG_TIDY_DEBUG_INFORMATION");
    public static final Key<AtomicBoolean> HAS_DOCUMENT_LISTENER = Key.create((String)"CLANG_TIDY_HAS_DOCUMENT_LISTENER");
    private static final Logger LOG = Logger.getInstance((String)"#com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator");
    private static final ClangTidyDocumentListener DOCUMENT_LISTENER = new ClangTidyDocumentListener();

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile file, @NotNull Editor editor, boolean hasErrors) {
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(1);
        }
        return this.collectInformation(file);
    }

    @Nullable
    public ClangTidyAnnotatorInfo collectInformation(@NotNull PsiFile file) {
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(2);
        }
        Project project2 = file.getProject();
        if (ApplicationManager.getApplication().isUnitTestMode() && project2.getUserData(RUN_IN_UNIT_TEST_MODE) != Boolean.TRUE) {
            return null;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String inputFileName = PathUtil.getFileName((String)virtualFile.getPath());
        if (!(file instanceof OCFile)) {
            return null;
        }
        OCFile ocFile = (OCFile)file;
        if (!ocFile.isInProjectSources()) {
            return null;
        }
        OCResolveRootAndConfiguration resolveRootAndConfiguration = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(virtualFile, project2);
        OCResolveConfiguration configuration = resolveRootAndConfiguration.getConfiguration();
        VirtualFile rootVirtualFile = resolveRootAndConfiguration.getRootFile();
        OCLanguageKind languageKind = resolveRootAndConfiguration.getKind();
        if (configuration == null || rootVirtualFile == null) {
            return null;
        }
        OCCompilerSettings compilerSettings = configuration.getCompilerSettings();
        OCCompilerKind compiler = compilerSettings.getCompiler(languageKind);
        File compilerExecutable = compilerSettings.getCompilerExecutable(languageKind);
        CidrCompilerSwitches compilerSwitches = compilerSettings.getCompilerSwitches(languageKind, virtualFile);
        if (compiler == null || compilerExecutable == null || compilerSwitches == null) {
            return null;
        }
        List<HeadersSearchRoot> headerRoots = configuration.getLibraryHeadersRoots(languageKind, rootVirtualFile);
        Document document = PsiDocumentManager.getInstance((Project)project2).getDocument(file);
        if (document == null) {
            return null;
        }
        ClangTidyInspection inspection = ClangTidyUtil.getInspection(ocFile, project2);
        if (inspection == null) {
            return null;
        }
        return new ClangTidyAnnotatorInfo(inputFileName, project2, ocFile, configuration, compilerSettings, compiler, compilerExecutable, compilerSwitches, rootVirtualFile, headerRoots, document, inspection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClangTidyAnnotationHolder doAnnotate(@Nullable ClangTidyAnnotatorInfo info) {
        if (info == null) {
            return null;
        }
        ClangTidyAnnotator.tryRegisterDocumentListener(info);
        File workingDirectory = null;
        try {
            workingDirectory = FileUtil.createTempDirectory((String)"clion-clang-tidy", null, (boolean)true);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClangTidyAnnotator.executeClangTidy(info, workingDirectory);
            return clangTidyAnnotationHolder;
        }
        catch (ExecutionException | IOException | YAMLException exc) {
            LOG.warn(exc);
            ClangTidyAnnotationHolder clangTidyAnnotationHolder = ClangTidyAnnotationHolder.error(exc.getMessage());
            return clangTidyAnnotationHolder;
        }
        finally {
            if (workingDirectory != null) {
                FileUtil.delete((File)workingDirectory);
            }
        }
    }

    public static boolean isAvailable() {
        return ClangTidyAnnotator.isAvailable(ClangTidyAnnotator.getBuiltinClangTidyPath());
    }

    private static ClangTidyAnnotationHolder executeClangTidy(@NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory) throws IOException, ExecutionException {
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(3);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(4);
        }
        boolean collectDebugInformation = info.getFile().getUserData(COLLECT_DEBUG_INFORMATION) == Boolean.TRUE;
        StringBuilder debugInformation = new StringBuilder();
        File clangTidyPath = ClangTidyAnnotator.getClangTidyPath();
        if (!ClangTidyAnnotator.isAvailable(clangTidyPath)) {
            return ClangTidyAnnotationHolder.error("Clang-Tidy is not found or cannot be executed");
        }
        Document document = info.getDocument();
        long modificationStampOnStart = document.getModificationStamp();
        File inputFile = new File(info.getFile().getVirtualFile().getPath());
        File mappingFile = ClangTidyAnnotator.generateMappingFile(inputFile.getName(), info.getDocument(), workingDirectory);
        File vfsOverlay = ClangTidyAnnotator.generateVfsOverlay(inputFile, mappingFile, workingDirectory);
        File outputFile = new File(workingDirectory, "output.yaml");
        File compilationDatabase = ClangTidyAnnotator.createCompilationDatabase(info, workingDirectory, inputFile);
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Compilation Database", FileUtil.loadFile((File)compilationDatabase));
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(clangTidyPath.getAbsolutePath());
        ClangTidyInspection inspection = info.getInspection();
        if (inspection.isUseCustomListOfClangTidyChecks()) {
            commandLine.addParameter("-config=" + ClangTidyUtil.getClangTidyConfig(inspection.getClangTidyChecks(), inspection.getClangTidyCheckOptions()));
        }
        commandLine.addParameter("-p=" + workingDirectory);
        commandLine.addParameter("-vfsoverlay=" + vfsOverlay);
        commandLine.addParameter("-export-fixes=" + outputFile);
        commandLine.addParameter(inputFile.getAbsolutePath());
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Command-Line", commandLine.toString());
        }
        CapturingProcessHandler processHandler = ClangTidyAnnotator.createCapturedProcessHandler(commandLine);
        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
        if (modificationStampOnStart != document.getModificationStamp()) {
            return null;
        }
        if (progressIndicator != null) {
            processHandler.runProcessWithProgressIndicator(progressIndicator);
        } else {
            processHandler.runProcess();
        }
        if (collectDebugInformation) {
            ClangTidyAnnotator.putDebugInformation(debugInformation, "Output", outputFile.exists() ? FileUtil.loadFile((File)outputFile) : "");
            info.getFile().putUserData(DEBUG_INFORMATION, debugInformation.toString());
        }
        List<ClangTidyDiagnostic> diagnostics = outputFile.exists() ? ClangTidyAnnotator.loadDiagnosticsFromYaml(outputFile, info.getDocument(), mappingFile) : Collections.emptyList();
        return ClangTidyAnnotationHolder.success(diagnostics);
    }

    private static File generateMappingFile(@NotNull String fileName, @NotNull Document document, @NotNull File workingDirectory) throws IOException {
        if (fileName == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(5);
        }
        if (document == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(6);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(7);
        }
        File mappingFile = new File(workingDirectory, fileName);
        FileUtil.writeToFile((File)mappingFile, (String)document.getText());
        return mappingFile;
    }

    private static File generateVfsOverlay(@NotNull File sourceFile, @NotNull File mappingFile, @NotNull File workingDirectory) throws IOException {
        if (sourceFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(8);
        }
        if (mappingFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(9);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(10);
        }
        File vfsOverlay = new File(workingDirectory, "overlay.yaml");
        FileUtil.writeToFile((File)vfsOverlay, (String)ClangTidyUtil.generateVfsOverlay(sourceFile, mappingFile));
        return vfsOverlay;
    }

    public void apply(@NotNull PsiFile file, @Nullable ClangTidyAnnotationHolder annotationHolder, @NotNull AnnotationHolder holder) {
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(11);
        }
        if (holder == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(12);
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (annotationHolder == null || document == null) {
            return;
        }
        ClangTidyAnnotationApplier applier = new ClangTidyAnnotationApplier();
        if (annotationHolder.isSuccess()) {
            applier.applySuccess(file, document, annotationHolder.getDiagnostics(), holder);
        } else {
            HighlightSeverity severity = annotationHolder.isError() ? HighlightSeverity.ERROR : HighlightSeverity.WARNING;
            applier.applyFail(file, annotationHolder.getFailReason(), severity, holder);
        }
    }

    @NotNull
    private static File createCompilationDatabase(final @NotNull ClangTidyAnnotatorInfo info, @NotNull File workingDirectory, @NotNull File inputFile) throws IOException {
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(13);
        }
        if (workingDirectory == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(14);
        }
        if (inputFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(15);
        }
        final CidrSwitchBuilder compilerOptions = new CidrSwitchBuilder();
        Application application = ApplicationManager.getApplication();
        final Ref compilerExecutableRef = Ref.create();
        final Ref preprocessorDefinesRef = Ref.create();
        application.runReadAction((ThrowableComputable)new ThrowableComputable<Void, IOException>(){

            public Void compute() {
                if (info.getProject().isDisposed()) {
                    throw new ProcessCanceledException();
                }
                OCResolveConfiguration configuration = info.getConfiguration();
                OCLanguageKind languageKind = info.getLanguageKind();
                VirtualFile rootVirtualFile = info.getRootVirtualFile();
                OCCompilerKind compiler = info.getCompilerKind();
                File compilerExecutable = info.getCompilerExecutable();
                if (compiler == OCCompilerKind.MSVC) {
                    compilerExecutableRef.set((Object)"clang++");
                } else {
                    compilerExecutableRef.set((Object)compilerExecutable.getAbsolutePath());
                }
                ClangTidyAnnotator.addCompilerSwitches(info, compilerOptions);
                ClangTidyAnnotator.addIncludeDirectories(info, compilerOptions);
                preprocessorDefinesRef.set((Object)configuration.getPreprocessorDefines(languageKind, rootVirtualFile));
                return null;
            }
        });
        compilerOptions.addSingleRaw("-ferror-limit=0");
        if (!preprocessorDefinesRef.isNull()) {
            File macrosFile = new File(workingDirectory, "macros");
            FileUtil.writeToFile((File)macrosFile, (String)((String)preprocessorDefinesRef.get()));
            compilerOptions.addSingleRaw("-imacros");
            compilerOptions.addSingleRaw(macrosFile.getAbsolutePath());
        }
        File compilationDatabase = new File(workingDirectory, "compile_commands.json");
        FileWriter writer = new FileWriter(compilationDatabase);
        ClangTidyUtil.writeCompilationDatabase(writer, (String)compilerExecutableRef.get(), workingDirectory.getAbsolutePath(), compilerOptions.getArgs(), inputFile.getAbsolutePath());
        File file = compilationDatabase;
        if (file == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(16);
        }
        return file;
    }

    private static void addCompilerSwitches(@NotNull ClangTidyAnnotatorInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(17);
        }
        if (switchBuilder == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(18);
        }
        switchBuilder.addAll(ClangTidyAnnotator.filterCompilerSwitches(info.getCompilerSwitches()));
    }

    private static CidrCompilerSwitches filterCompilerSwitches(@NotNull CidrCompilerSwitches compilerSwitches) {
        if (compilerSwitches == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(19);
        }
        BiFunction<String, String, Boolean> filter = new BiFunction<String, String, Boolean>(){
            private boolean skipOptionValue = false;

            @Override
            public Boolean apply(String parameter, String nextParameter) {
                if (this.skipOptionValue) {
                    this.skipOptionValue = false;
                    return false;
                }
                if (parameter.equals("-F") || parameter.equals("-I") || parameter.equals("-iquote")) {
                    this.skipOptionValue = true;
                    return false;
                }
                if (parameter.startsWith("-F") || parameter.startsWith("-I") || parameter.startsWith("-iquote")) {
                    return false;
                }
                return true;
            }
        };
        return compilerSwitches.filterOptions(filter);
    }

    private static void addIncludeDirectories(@NotNull ClangTidyAnnotatorInfo info, @NotNull CidrSwitchBuilder switchBuilder) {
        VirtualFile parentDirectory;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(20);
        }
        if (switchBuilder == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(21);
        }
        if ((parentDirectory = info.getRootVirtualFile().getParent()) != null && parentDirectory.isDirectory()) {
            switchBuilder.addSingleRaw("-iquote");
            switchBuilder.addSingleRaw(parentDirectory.getPath());
        }
        for (HeadersSearchRoot root : info.getHeaderRoots()) {
            switchBuilder.addSingleRaw(root.isUserHeaders() ? "-iquote" : (root instanceof FrameworksSearchRoot ? "-F" : "-I"));
            switchBuilder.addSingleRaw(root.getVirtualFile().getPath());
        }
    }

    @Nullable
    private static File getClangTidyPath() {
        File clangTidyPath = (File)ApplicationManager.getApplication().runReadAction(() -> {
            ClangTidySettings settings = ClangTidySettings.getInstance();
            return settings != null && settings.getUseExternalClangTidy() && settings.getExternalClangTidyPath() != null ? new File(settings.getExternalClangTidyPath()) : null;
        });
        if (clangTidyPath == null) {
            clangTidyPath = ClangTidyAnnotator.getBuiltinClangTidyPath();
        }
        return clangTidyPath;
    }

    @Nullable
    public static File getBuiltinClangTidyPath() {
        String clangTidyFileName;
        String string = clangTidyFileName = SystemInfo.isWindows ? "clang-tidy.exe" : "clang-tidy";
        if (PluginManagerCore.isRunningFromSources()) {
            String platform = null;
            if (SystemInfo.isWindows) {
                platform = "win";
            } else if (SystemInfo.isLinux) {
                platform = "linux";
            } else if (SystemInfo.isMac) {
                platform = "mac";
            }
            if (platform == null) {
                return null;
            }
            return new File(PathManager.getHomePath(), "CIDR/clion/bin/clang/" + platform + "/" + clangTidyFileName);
        }
        return new File(PathManager.getBinPath(), "clang/" + clangTidyFileName);
    }

    private static boolean isAvailable(@Nullable File clangTidyPath) {
        try {
            return clangTidyPath != null && clangTidyPath.exists() && clangTidyPath.canExecute();
        }
        catch (SecurityException e) {
            return false;
        }
    }

    private static void putDebugInformation(@NotNull StringBuilder builder, @NotNull String informationHeader, @NotNull String content) {
        if (builder == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(22);
        }
        if (informationHeader == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(23);
        }
        if (content == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(24);
        }
        builder.append("=== ").append(informationHeader).append(" ===").append("\n");
        builder.append(content).append("\n\n");
    }

    @NotNull
    private static List<ClangTidyDiagnostic> loadDiagnosticsFromYaml(@NotNull File outputFile, @NotNull Document document, @NotNull File sourceFile) throws IOException {
        if (outputFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(25);
        }
        if (document == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(26);
        }
        if (sourceFile == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(27);
        }
        String yamlContent = FileUtil.loadFile((File)outputFile);
        ClangTidyYamlLoader yamlLoader = new ClangTidyYamlLoader();
        List<ClangTidyDiagnostic> list = yamlLoader.load(yamlContent, document, sourceFile);
        if (list == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(28);
        }
        return list;
    }

    private static void tryRegisterDocumentListener(@NotNull ClangTidyAnnotatorInfo info) {
        Document document;
        if (info == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(29);
        }
        if (!((document = info.getDocument()) instanceof UserDataHolderEx)) {
            return;
        }
        UserDataHolderEx dataHolder = (UserDataHolderEx)document;
        AtomicBoolean hasDocumentListener = (AtomicBoolean)dataHolder.getUserData(HAS_DOCUMENT_LISTENER);
        if (hasDocumentListener == null && dataHolder.putUserDataIfAbsent(HAS_DOCUMENT_LISTENER, (Object)(hasDocumentListener = new AtomicBoolean(false))) != hasDocumentListener) {
            return;
        }
        if (hasDocumentListener.compareAndSet(false, true)) {
            document.addDocumentListener((DocumentListener)DOCUMENT_LISTENER);
        }
    }

    public String getPairedBatchInspectionShortName() {
        return "ClangTidyInspection";
    }

    @NotNull
    private static CapturingProcessHandler createCapturedProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        if (commandLine == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(30);
        }
        CapturingProcessHandler capturingProcessHandler = new CapturingProcessHandler(commandLine){

            protected CapturingProcessAdapter createProcessAdapter(ProcessOutput processOutput) {
                return new CapturingProcessAdapter(processOutput){

                    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                        if (event == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (outputType == null) {
                            1.$$$reportNull$$$0(1);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "event";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "outputType";
                                break;
                            }
                        }
                        objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator$3$1";
                        objectArray[2] = "onTextAvailable";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                };
            }
        };
        if (capturingProcessHandler == null) {
            ClangTidyAnnotator.$$$reportNull$$$0(31);
        }
        return capturingProcessHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 28: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 28: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 13: 
            case 17: 
            case 20: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 6: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 8: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
            case 16: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "switchBuilder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerSwitches";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "informationHeader";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputFile";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotator";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createCompilationDatabase";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "loadDiagnosticsFromYaml";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "createCapturedProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectInformation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeClangTidy";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateMappingFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateVfsOverlay";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createCompilationDatabase";
                break;
            }
            case 16: 
            case 28: 
            case 31: {
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addCompilerSwitches";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterCompilerSwitches";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "addIncludeDirectories";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "putDebugInformation";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "loadDiagnosticsFromYaml";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "tryRegisterDocumentListener";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "createCapturedProcessHandler";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 28: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

