/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.settings.CPPLanguageConfigurable;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyConfigurable
extends CPPLanguageConfigurable {
    private final ClangTidySettings mySettings = ClangTidySettings.getInstance();
    private JBCheckBox myCheckBox;
    private JBTextField myTextField;

    @Override
    @NotNull
    public String getId() {
        if ("language.cpp.clang-tidy" == null) {
            ClangTidyConfigurable.$$$reportNull$$$0(0);
        }
        return "language.cpp.clang-tidy";
    }

    @Override
    @Nullable
    public JComponent createComponent() {
        this.myCheckBox = new JBCheckBox("Use external Clang-Tidy instead of the built-in one:", this.mySettings.getUseExternalClangTidy());
        this.myTextField = new JBTextField(this.mySettings.getExternalClangTidyPath(), 30);
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileOrExecutableAppDescriptor();
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)this.myTextField, "Clang-Tidy Path", "", descriptor2);
        final TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton((JTextField)this.myTextField, (ActionListener)browseFilesListener);
        textFieldWithBrowseButton.setEnabled(this.myCheckBox.isSelected());
        this.myCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isSelected = ClangTidyConfigurable.this.myCheckBox.isSelected();
                textFieldWithBrowseButton.setEnabled(isSelected);
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)this.myCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        panel.add((Component)textFieldWithBrowseButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        return panel;
    }

    @Override
    public boolean isModified() {
        return this.myCheckBox.isSelected() != this.mySettings.getUseExternalClangTidy() || !this.myTextField.getText().equals(this.mySettings.getExternalClangTidyPath());
    }

    @Override
    public void apply() throws ConfigurationException {
        this.saveSettings();
        ClangTidyConfigurable.rehighlight();
    }

    public void reset() {
        ApplicationManager.getApplication().runReadAction(() -> {
            this.myCheckBox.setSelected(this.mySettings.getUseExternalClangTidy());
            this.myTextField.setText(this.mySettings.getExternalClangTidyPath());
        });
    }

    @Override
    @Nls
    public String getDisplayName() {
        return "Clang-Tidy";
    }

    private void saveSettings() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            this.mySettings.setUseExternalClangTidy(this.myCheckBox.isSelected());
            this.mySettings.setExternalClangTidyPath(this.myTextField.getText());
        });
    }

    private static void rehighlight() {
        Project[] openProjects;
        for (Project project2 : openProjects = ProjectManager.getInstance().getOpenProjects()) {
            if (!project2.isInitialized() || project2.isDisposed()) continue;
            DaemonCodeAnalyzerEx.getInstanceEx((Project)project2).restart();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyConfigurable", "getId"));
    }
}

