/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.util.DocumentUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class ClangTidyIntentionAction
implements IntentionAction {
    @NotNull
    private final String myMessage;
    @NotNull
    private final String myCheckName;
    @NotNull
    private final List<Replacement> myReplacements;

    public ClangTidyIntentionAction(@NotNull Document document, @NotNull String message, @NotNull String checkName, @NotNull List<ClangTidyReplacement> replacements) {
        if (document == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(0);
        }
        if (message == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(1);
        }
        if (checkName == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(2);
        }
        if (replacements == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(3);
        }
        this.myMessage = message;
        this.myCheckName = checkName;
        this.myReplacements = ClangTidyIntentionAction.createReplacements(document, replacements);
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.myMessage;
        if (string == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = this.myCheckName;
        if (string == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(5);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file) {
        if (project2 == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(6);
        }
        return file instanceof OCFile && !this.myReplacements.isEmpty() && this.myReplacements.stream().allMatch(replacement -> replacement != null && replacement.isValid());
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project2 == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(7);
        }
        if (!this.isAvailable(project2, editor, file)) {
            return;
        }
        for (Replacement replacement : this.myReplacements) {
            RangeMarker rangeMarker = replacement.myRangeMarker;
            int startOffset = rangeMarker.getStartOffset();
            int endOffset = rangeMarker.getEndOffset();
            int length = endOffset - startOffset;
            OCChangeUtil.changeText(project2, file, startOffset, length, replacement.myReplacementText, true);
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    private static List<Replacement> createReplacements(@NotNull Document document, @NotNull List<ClangTidyReplacement> replacements) {
        if (document == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(8);
        }
        if (replacements == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(9);
        }
        List<Replacement> list = replacements.stream().map(replacement -> {
            if (document == null) {
                ClangTidyIntentionAction.$$$reportNull$$$0(11);
            }
            int beginOffset = replacement.getBeginOffset();
            int endOffset = replacement.getEndOffset();
            if (!DocumentUtil.isValidOffset((int)beginOffset, (Document)document) || !DocumentUtil.isValidOffset((int)endOffset, (Document)document)) {
                return null;
            }
            RangeMarker rangeMarker = document.createRangeMarker(beginOffset, endOffset);
            String oldText = document.getText(new TextRange(beginOffset, endOffset));
            return new Replacement(rangeMarker, oldText, replacement.getReplacementText());
        }).collect(Collectors.toList());
        if (list == null) {
            ClangTidyIntentionAction.$$$reportNull$$$0(10);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacements";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionAction";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createReplacements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createReplacements";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createReplacements$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class Replacement {
        @NotNull
        private final RangeMarker myRangeMarker;
        @NotNull
        private final String myOldText;
        @NotNull
        private final String myReplacementText;

        public Replacement(@NotNull RangeMarker rangeMarker, @NotNull String oldText, @NotNull String replacementText) {
            if (rangeMarker == null) {
                Replacement.$$$reportNull$$$0(0);
            }
            if (oldText == null) {
                Replacement.$$$reportNull$$$0(1);
            }
            if (replacementText == null) {
                Replacement.$$$reportNull$$$0(2);
            }
            this.myRangeMarker = rangeMarker;
            this.myOldText = oldText;
            this.myReplacementText = replacementText;
        }

        public boolean isValid() {
            if (!this.myRangeMarker.isValid()) {
                return false;
            }
            TextRange textRange = new TextRange(this.myRangeMarker.getStartOffset(), this.myRangeMarker.getEndOffset());
            String actualText = this.myRangeMarker.getDocument().getText(textRange);
            return actualText.equals(this.myOldText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "rangeMarker";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "oldText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "replacementText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyIntentionAction$Replacement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

