/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspection;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;

public class ClangTidyUtil {
    private ClangTidyUtil() {
    }

    @Nullable
    public static ClangTidyInspection getInspection(@NotNull PsiFile file, @NotNull Project project2) {
        if (file == null) {
            ClangTidyUtil.$$$reportNull$$$0(0);
        }
        if (project2 == null) {
            ClangTidyUtil.$$$reportNull$$$0(1);
        }
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)project2)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)project2);
        InspectionProfileImpl profile2 = profileManager.getProfile(currentProfile);
        if (profile2 == null) {
            return null;
        }
        InspectionToolWrapper toolWrapper = profile2.getToolById("ClangTidyInspection", (PsiElement)file);
        return toolWrapper == null || !(toolWrapper.getTool() instanceof ClangTidyInspection) ? null : (ClangTidyInspection)toolWrapper.getTool();
    }

    @NotNull
    public static String disableCheck(@NotNull String configuration, @NotNull String checkName) {
        if (configuration == null) {
            ClangTidyUtil.$$$reportNull$$$0(2);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(3);
        }
        List<String> options = ClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> {
            if (checkName == null) {
                ClangTidyUtil.$$$reportNull$$$0(30);
            }
            return option.equals(checkName);
        });
        if (!ClangTidyUtil.isDisabled(options, checkName)) {
            options.add("-" + checkName);
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static String disableGroup(@NotNull String configuration, @NotNull String groupName) {
        if (configuration == null) {
            ClangTidyUtil.$$$reportNull$$$0(5);
        }
        if (groupName == null) {
            ClangTidyUtil.$$$reportNull$$$0(6);
        }
        List<String> options = ClangTidyUtil.getTrimmedOptions(configuration);
        options.removeIf(option -> {
            if (groupName == null) {
                ClangTidyUtil.$$$reportNull$$$0(29);
            }
            return option.startsWith(groupName) || option.startsWith("-") && option.substring(1).startsWith(groupName);
        });
        if (!ClangTidyUtil.isDisabled(options, groupName)) {
            options.add("-" + groupName + "-*");
        }
        String string = StringUtil.join(options, (String)",");
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public static String getGroupNameForCheck(@NotNull String checkName) {
        int index;
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(8);
        }
        return (index = checkName.indexOf(45)) != -1 ? checkName.substring(0, index) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeCompilationDatabase(@NotNull Writer outputWriter, @NotNull String compilerExecutable, @NotNull String compilerWorkingDirectory, @NotNull List<String> compilerOptions, @NotNull String inputFile) throws IOException {
        if (outputWriter == null) {
            ClangTidyUtil.$$$reportNull$$$0(9);
        }
        if (compilerExecutable == null) {
            ClangTidyUtil.$$$reportNull$$$0(10);
        }
        if (compilerWorkingDirectory == null) {
            ClangTidyUtil.$$$reportNull$$$0(11);
        }
        if (compilerOptions == null) {
            ClangTidyUtil.$$$reportNull$$$0(12);
        }
        if (inputFile == null) {
            ClangTidyUtil.$$$reportNull$$$0(13);
        }
        try (JsonWriter jsonWriter = new JsonWriter(outputWriter);){
            jsonWriter.beginArray();
            jsonWriter.beginObject();
            jsonWriter.name("directory");
            jsonWriter.value(compilerWorkingDirectory);
            jsonWriter.name("arguments");
            jsonWriter.beginArray();
            jsonWriter.value(compilerExecutable);
            for (String compilerOption : compilerOptions) {
                jsonWriter.value(compilerOption);
            }
            jsonWriter.value(inputFile);
            jsonWriter.endArray();
            jsonWriter.name("file");
            jsonWriter.value(inputFile);
            jsonWriter.endObject();
            jsonWriter.endArray();
        }
    }

    private static List<String> getTrimmedOptions(@NotNull String configuration) {
        if (configuration == null) {
            ClangTidyUtil.$$$reportNull$$$0(14);
        }
        List options = StringUtil.split((String)configuration, (String)",");
        options.replaceAll(String::trim);
        return options;
    }

    private static boolean isDisabled(@NotNull List<String> options, @NotNull String checkName) {
        if (options == null) {
            ClangTidyUtil.$$$reportNull$$$0(15);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(16);
        }
        boolean disabled = false;
        for (String option : options) {
            if (option.equals("*")) {
                disabled = false;
                continue;
            }
            if (option.equals("-*")) {
                disabled = true;
                continue;
            }
            if (ClangTidyUtil.groupOrCheckEnabled(option, checkName)) {
                disabled = false;
                continue;
            }
            if (!ClangTidyUtil.groupOrCheckDisabled(option, checkName)) continue;
            disabled = true;
        }
        return disabled;
    }

    private static boolean groupOrCheckEnabled(@NotNull String option, @NotNull String checkName) {
        if (option == null) {
            ClangTidyUtil.$$$reportNull$$$0(17);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(18);
        }
        return option.equals(checkName) || option.length() > 1 && option.endsWith("*") && checkName.startsWith(option.substring(0, option.length() - 1));
    }

    private static boolean groupOrCheckDisabled(@NotNull String option, @NotNull String checkName) {
        if (option == null) {
            ClangTidyUtil.$$$reportNull$$$0(19);
        }
        if (checkName == null) {
            ClangTidyUtil.$$$reportNull$$$0(20);
        }
        if (!option.startsWith("-")) {
            return false;
        }
        if (option.endsWith("*")) {
            return option.length() > 2 && checkName.startsWith(option.substring(1, option.length() - 1));
        }
        return option.length() > 1 && checkName.equals(option.substring(1));
    }

    @NotNull
    public static String getClangTidyConfig(@NotNull String checks, @NotNull List<ClangTidyCheckOption> checkOptions) {
        if (checks == null) {
            ClangTidyUtil.$$$reportNull$$$0(21);
        }
        if (checkOptions == null) {
            ClangTidyUtil.$$$reportNull$$$0(22);
        }
        JsonObject rootObject = new JsonObject();
        rootObject.addProperty("Checks", checks);
        JsonArray checkOptionsObject = new JsonArray();
        for (ClangTidyCheckOption checkOption : checkOptions) {
            checkOptionsObject.add(ClangTidyUtil.toJsonObject(checkOption));
        }
        rootObject.add("CheckOptions", (JsonElement)checkOptionsObject);
        String string = rootObject.toString();
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static String generateVfsOverlay(@NotNull File sourceFile, @NotNull File mappingFile) {
        if (sourceFile == null) {
            ClangTidyUtil.$$$reportNull$$$0(24);
        }
        if (mappingFile == null) {
            ClangTidyUtil.$$$reportNull$$$0(25);
        }
        File parentDirectory = FileUtil.getParentFile((File)sourceFile);
        HashMap<String, Object> data = new HashMap<String, Object>();
        HashMap<String, Object> roots = new HashMap<String, Object>();
        HashMap<String, String> contents = new HashMap<String, String>();
        contents.put("name", sourceFile.getName());
        contents.put("type", "file");
        contents.put("external-contents", mappingFile.getAbsolutePath());
        roots.put("name", parentDirectory != null ? parentDirectory.getAbsolutePath() : "");
        roots.put("type", "directory");
        roots.put("contents", new Object[]{contents});
        data.put("version", "0");
        data.put("roots", new Object[]{roots});
        Yaml yaml = new Yaml();
        String string = yaml.dump(data);
        if (string == null) {
            ClangTidyUtil.$$$reportNull$$$0(26);
        }
        return string;
    }

    @NotNull
    private static JsonElement toJsonObject(@NotNull ClangTidyCheckOption check) {
        if (check == null) {
            ClangTidyUtil.$$$reportNull$$$0(27);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("key", check.getOptionName());
        jsonObject.addProperty("value", check.getOptionValue());
        JsonObject jsonObject2 = jsonObject;
        if (jsonObject2 == null) {
            ClangTidyUtil.$$$reportNull$$$0(28);
        }
        return jsonObject2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 23: 
            case 26: 
            case 28: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 23: 
            case 26: 
            case 28: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 3: 
            case 8: 
            case 16: 
            case 18: 
            case 20: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkName";
                break;
            }
            case 4: 
            case 7: 
            case 23: 
            case 26: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyUtil";
                break;
            }
            case 6: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputWriter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerExecutable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerWorkingDirectory";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerOptions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checks";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkOptions";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappingFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "check";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyUtil";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "disableCheck";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "disableGroup";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangTidyConfig";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "generateVfsOverlay";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "toJsonObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "disableCheck";
                break;
            }
            case 4: 
            case 7: 
            case 23: 
            case 26: 
            case 28: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "disableGroup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getGroupNameForCheck";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "writeCompilationDatabase";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getTrimmedOptions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "groupOrCheckEnabled";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "groupOrCheckDisabled";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getClangTidyConfig";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "generateVfsOverlay";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toJsonObject";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$disableGroup$1";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$disableCheck$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 23: 
            case 26: 
            case 28: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

