/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyReplacement;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class ClangTidyYamlLoader {
    public List<ClangTidyDiagnostic> load(@NotNull String yamlContent, @NotNull Document document, @NotNull File sourceFile) throws IOException {
        Constructor constructor;
        Yaml yaml;
        YamlData yamlData;
        if (yamlContent == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(0);
        }
        if (document == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(1);
        }
        if (sourceFile == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(2);
        }
        if ((yamlData = (YamlData)(yaml = new Yaml((BaseConstructor)(constructor = new Constructor(YamlData.class)))).loadAs(yamlContent, YamlData.class)) == null || yamlData.Diagnostics == null) {
            return Collections.emptyList();
        }
        List<YamlDiagnostic> validDiagnostics = yamlData.Diagnostics.stream().filter(diagnostic -> {
            if (sourceFile == null) {
                ClangTidyYamlLoader.$$$reportNull$$$0(15);
            }
            return ClangTidyYamlLoader.isValid(diagnostic, sourceFile) && !ClangTidyYamlLoader.isSuppressed(diagnostic);
        }).collect(Collectors.toList());
        Map<Integer, Integer> byteOffsetMap = ClangTidyYamlLoader.createByteOffsetMap(validDiagnostics, document);
        return validDiagnostics.stream().map(diagnostic -> ClangTidyYamlLoader.createClangTidyDiagnostic(diagnostic, byteOffsetMap)).filter(diagnostic -> diagnostic != null).collect(Collectors.toList());
    }

    private static ClangTidyDiagnostic createClangTidyDiagnostic(@NotNull YamlDiagnostic diagnostic, @NotNull Map<Integer, Integer> byteOffsetMap) {
        Integer offset;
        if (diagnostic == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(3);
        }
        if (byteOffsetMap == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(4);
        }
        List<ClangTidyReplacement> replacements = Collections.emptyList();
        if (diagnostic.Replacements != null) {
            replacements = diagnostic.Replacements.stream().map(replacement -> {
                if (byteOffsetMap == null) {
                    ClangTidyYamlLoader.$$$reportNull$$$0(14);
                }
                return ClangTidyYamlLoader.createClangTidyReplacement(replacement, byteOffsetMap);
            }).collect(Collectors.toList());
        }
        return (offset = byteOffsetMap.get(diagnostic.FileOffset)) != null && replacements.stream().allMatch(replacement -> replacement != null) ? new ClangTidyDiagnostic(diagnostic.Message, diagnostic.DiagnosticName, diagnostic.FilePath, offset, replacements) : null;
    }

    @Nullable
    private static ClangTidyReplacement createClangTidyReplacement(@NotNull YamlReplacement replacement, @NotNull Map<Integer, Integer> byteOffsetMap) {
        if (replacement == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(5);
        }
        if (byteOffsetMap == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(6);
        }
        Integer beginOffset = byteOffsetMap.get(replacement.Offset);
        Integer endOffset = byteOffsetMap.get(replacement.Offset + replacement.Length);
        return beginOffset != null && endOffset != null ? new ClangTidyReplacement(replacement.FilePath, replacement.ReplacementText, beginOffset, endOffset) : null;
    }

    private static boolean isValid(@Nullable YamlDiagnostic diagnostic, @NotNull File sourceFile) {
        if (sourceFile == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(7);
        }
        return diagnostic != null && StringUtil.isNotEmpty((String)diagnostic.DiagnosticName) && FileUtil.pathsEqual((String)sourceFile.getPath(), (String)diagnostic.FilePath) && StringUtil.isNotEmpty((String)diagnostic.Message) && diagnostic.FileOffset >= 0 && (diagnostic.Replacements == null || diagnostic.Replacements.stream().allMatch(replacement -> ClangTidyYamlLoader.isValid(replacement))) && ClangTidyYamlLoader.appliedToSingleFile(diagnostic);
    }

    private static boolean appliedToSingleFile(@NotNull YamlDiagnostic diagnostic) {
        if (diagnostic == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(8);
        }
        if (diagnostic.Replacements == null || diagnostic.Replacements.isEmpty()) {
            return true;
        }
        return diagnostic.FilePath.equals(diagnostic.Replacements.get((int)0).FilePath) && diagnostic.Replacements.stream().map(replacement -> replacement.FilePath).collect(Collectors.toSet()).size() == 1;
    }

    private static boolean isValid(@Nullable YamlReplacement replacement) {
        return replacement != null && StringUtil.isNotEmpty((String)replacement.FilePath) && replacement.ReplacementText != null && replacement.Length >= 0 && replacement.Offset >= 0;
    }

    private static boolean isSuppressed(@NotNull YamlDiagnostic diagnostic) {
        if (diagnostic == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(9);
        }
        return StringUtil.startsWith((CharSequence)diagnostic.DiagnosticName, (CharSequence)"clang-diagnostic");
    }

    private static Map<Integer, Integer> createByteOffsetMap(@NotNull List<YamlDiagnostic> diagnostics, @NotNull Document document) throws IOException {
        Integer byteOffset;
        if (diagnostics == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(10);
        }
        if (document == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(11);
        }
        byte[] textBytes = document.getText().getBytes(StandardCharsets.UTF_8);
        SortedSet<Integer> byteOffsets = ClangTidyYamlLoader.getByteOffsets(diagnostics);
        HashMap<Integer, Integer> byteOffsetMap = new HashMap<Integer, Integer>();
        int lastCharOffset = 0;
        int lastByteOffset = 0;
        Iterator iterator = byteOffsets.iterator();
        while (iterator.hasNext() && (byteOffset = (Integer)iterator.next()) <= textBytes.length) {
            String slice = new String(textBytes, lastByteOffset, byteOffset - lastByteOffset, StandardCharsets.UTF_8);
            int charOffset = lastCharOffset + slice.length();
            byteOffsetMap.put(byteOffset, charOffset);
            lastCharOffset = charOffset;
            lastByteOffset = byteOffset;
        }
        return byteOffsetMap;
    }

    @NotNull
    private static SortedSet<Integer> getByteOffsets(@NotNull List<YamlDiagnostic> diagnostics) {
        if (diagnostics == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(12);
        }
        TreeSet<Integer> byteOffsets = new TreeSet<Integer>(Comparator.naturalOrder());
        diagnostics.forEach(diagnostic -> {
            byteOffsets.add(diagnostic.FileOffset);
            if (diagnostic.Replacements != null) {
                for (YamlReplacement replacement : diagnostic.Replacements) {
                    byteOffsets.add(replacement.Offset);
                    byteOffsets.add(replacement.Offset + replacement.Length);
                }
            }
        });
        TreeSet<Integer> treeSet = byteOffsets;
        if (treeSet == null) {
            ClangTidyYamlLoader.$$$reportNull$$$0(13);
        }
        return treeSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "yamlContent";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: 
            case 7: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFile";
                break;
            }
            case 3: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 4: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "byteOffsetMap";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyYamlLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyYamlLoader";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getByteOffsets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createClangTidyDiagnostic";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createClangTidyReplacement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appliedToSingleFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSuppressed";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createByteOffsetMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getByteOffsets";
                break;
            }
            case 13: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createClangTidyDiagnostic$3";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "lambda$load$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class YamlReplacement {
        public String FilePath;
        public String ReplacementText;
        public int Offset;
        public int Length;

        YamlReplacement() {
        }
    }

    static class YamlDiagnostic {
        public String Message;
        public String DiagnosticName;
        public String FilePath;
        public int FileOffset;
        public List<YamlReplacement> Replacements;

        YamlDiagnostic() {
        }
    }

    static class YamlData {
        public String MainSourceFile;
        public List<YamlDiagnostic> Diagnostics;

        YamlData() {
        }
    }
}

