/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotatorInfo;

public class ShowClangTidyInfoAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        PsiFile file;
        super.update(e);
        boolean isEnabledAndVisible = true;
        if (!ApplicationManager.getApplication().isInternal() && !Registry.is((String)"cidr.show.clangtidy.info")) {
            isEnabledAndVisible = false;
        }
        if ((file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE)) == null) {
            isEnabledAndVisible = false;
        }
        e.getPresentation().setEnabledAndVisible(isEnabledAndVisible);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(AnActionEvent e) {
        PsiFile file = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        assert (file != null);
        try {
            file.putUserData(ClangTidyAnnotator.COLLECT_DEBUG_INFORMATION, (Object)true);
            ClangTidyAnnotator annotator = new ClangTidyAnnotator();
            ClangTidyAnnotatorInfo info = annotator.collectInformation(file);
            annotator.doAnnotate(info);
            String debugInformation = (String)file.getUserData(ClangTidyAnnotator.DEBUG_INFORMATION);
            if (debugInformation == null) {
                return;
            }
            LightVirtualFile outputFile = new LightVirtualFile("Clang-Tidy Info for " + file.getName(), (FileType)PlainTextFileType.INSTANCE, (CharSequence)debugInformation);
            FileEditorManager.getInstance((Project)file.getProject()).openFile((VirtualFile)outputFile, false);
        }
        finally {
            file.putUserData(ClangTidyAnnotator.COLLECT_DEBUG_INFORMATION, null);
            file.putUserData(ClangTidyAnnotator.DEBUG_INFORMATION, null);
        }
    }
}

