/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCControlFlowGraph {
    private PsiElement myCodeFragment;
    private List<OCNode> myNodes;
    private OCNode myStartNode;
    private LinkedHashSet<OCNode> myExitNodes;
    private OCControlFlowGraph myParentGraph;
    private int myForbidSplitNodesDepth;
    private int myNextNodeId;
    private LinkedHashMap<OCSymbol, LinkedMultiMap<OCInstruction.InstructionKind, OCInstruction>> myInstructions;
    private LinkedHashMap<PsiElement, OCInstruction> myReadInstructions;
    private LinkedHashSet<OCInstruction> myAllInstructions;
    private LinkedHashMap<OCSymbol, OCInstruction> myDeclarators;
    private LinkedHashMap<OCSymbol, OCControlFlowGraph> myClosureVariables;

    public OCControlFlowGraph(@NotNull PsiElement codeFragment, @Nullable OCControlFlowGraph parentGraph) {
        if (codeFragment == null) {
            OCControlFlowGraph.$$$reportNull$$$0(0);
        }
        this.myNodes = new ArrayList<OCNode>();
        this.myExitNodes = new LinkedHashSet();
        this.myInstructions = new LinkedHashMap();
        this.myReadInstructions = new LinkedHashMap();
        this.myAllInstructions = new LinkedHashSet();
        this.myDeclarators = new LinkedHashMap();
        this.myClosureVariables = new LinkedHashMap();
        this.myCodeFragment = codeFragment;
        this.myParentGraph = parentGraph;
    }

    @NotNull
    public List<OCNode> getNodes() {
        List<OCNode> list = this.myNodes;
        if (list == null) {
            OCControlFlowGraph.$$$reportNull$$$0(1);
        }
        return list;
    }

    public int getNumOfNodes() {
        return this.myNodes.size();
    }

    public int getNextNodeId() {
        return this.myNextNodeId++;
    }

    @NotNull
    public OCNode addNode() {
        OCNode oCNode = this.addNode(false);
        if (oCNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(2);
        }
        return oCNode;
    }

    @NotNull
    public OCNode addNode(boolean isFake) {
        if (this.isSplitNodesAllowed() || isFake) {
            OCNode node = new OCNode(this, this.myNodes.size(), this.myNextNodeId++, isFake);
            this.myNodes.add(node);
            OCNode oCNode = node;
            if (oCNode == null) {
                OCControlFlowGraph.$$$reportNull$$$0(3);
            }
            return oCNode;
        }
        OCNode oCNode = this.getLastAddedNode();
        if (oCNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(4);
        }
        return oCNode;
    }

    public void forbidSplittingNodes() {
        ++this.myForbidSplitNodesDepth;
    }

    public void allowSplittingNodes() {
        --this.myForbidSplitNodesDepth;
    }

    public boolean isSplitNodesAllowed() {
        return this.myForbidSplitNodesDepth == 0;
    }

    public void removeNode(@NotNull OCNode node, boolean isFake) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(5);
        }
        if (this.isSplitNodesAllowed() || isFake) {
            assert (this.getLastAddedNode() == node && (node.isEmpty() || node.isFake()));
            this.myNodes.remove(this.getNumOfNodes() - 1);
        }
    }

    public void setStartNode(@NotNull OCNode startNode) {
        if (startNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(6);
        }
        this.myStartNode = startNode;
    }

    @NotNull
    public OCNode getStartNode() {
        OCNode oCNode = this.myStartNode;
        if (oCNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(7);
        }
        return oCNode;
    }

    public void addExitNode(@NotNull OCNode node) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(8);
        }
        this.myExitNodes.add(node);
    }

    @NotNull
    public Set<OCNode> getExitNodes() {
        LinkedHashSet<OCNode> linkedHashSet = this.myExitNodes;
        if (linkedHashSet == null) {
            OCControlFlowGraph.$$$reportNull$$$0(9);
        }
        return linkedHashSet;
    }

    @Nullable
    public OCNode getPreviousNonEmptyNode(@NotNull OCNode node) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(10);
        }
        for (int index = node.getIndex() - 1; index >= 0; --index) {
            if (this.myNodes.get(index).getRange() == null) continue;
            return this.myNodes.get(index);
        }
        return null;
    }

    @NotNull
    public OCNode getLastAddedNode() {
        OCNode oCNode = this.myNodes.get(this.getNumOfNodes() - 1);
        if (oCNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(11);
        }
        return oCNode;
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (kind == null) {
            OCControlFlowGraph.$$$reportNull$$$0(12);
        }
        return this.addInstruction(this.getLastAddedNode(), kind, null, rValue, symbol);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (kind == null) {
            OCControlFlowGraph.$$$reportNull$$$0(13);
        }
        return this.addInstruction(this.getLastAddedNode(), kind, lValue, rValue, symbol);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCNode node, OCInstruction.InstructionKind kind, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(14);
        }
        if (symbol == null) {
            return null;
        }
        OCInstruction instruction = new OCInstruction(kind, node, lValue, rValue, symbol);
        if (kind == OCInstruction.InstructionKind.WRITE) {
            OCInstruction read2 = this.myReadInstructions.get(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue));
            if (read2 != null && read2.getKind() == OCInstruction.InstructionKind.READ) {
                read2.setAssociatedInstruction(instruction);
                instruction.setAssociatedInstruction(read2);
            }
        } else if (kind == OCInstruction.InstructionKind.READ) {
            this.myReadInstructions.put(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue), instruction);
        }
        if (kind == OCInstruction.InstructionKind.DECLARATOR) {
            this.myDeclarators.put(symbol, instruction);
        } else if (!this.myDeclarators.containsKey(symbol)) {
            OCControlFlowGraph parent = this.myParentGraph;
            while (parent != null && !parent.myDeclarators.containsKey(symbol)) {
                parent = parent.myParentGraph;
            }
            if (parent != null) {
                this.myClosureVariables.put(symbol, parent);
            }
        }
        LinkedMultiMap multiMap = this.myInstructions.get(symbol);
        if (multiMap == null) {
            multiMap = new LinkedMultiMap();
            this.myInstructions.put(symbol, (LinkedMultiMap<OCInstruction.InstructionKind, OCInstruction>)multiMap);
        }
        multiMap.putValue((Object)kind, (Object)instruction);
        this.myAllInstructions.add(instruction);
        node.addInstruction(instruction);
        return instruction;
    }

    public void addInstructions(@NotNull OCNode node, @NotNull OCInstruction.InstructionKind kind, @NotNull Collection<OCInstruction> instructions) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(15);
        }
        if (kind == null) {
            OCControlFlowGraph.$$$reportNull$$$0(16);
        }
        if (instructions == null) {
            OCControlFlowGraph.$$$reportNull$$$0(17);
        }
        for (OCInstruction instruction : instructions) {
            OCInstruction newInstruction = this.addInstruction(node, kind, instruction.getLValue(), instruction.getRValue(), instruction.getSymbol());
            if (newInstruction == null) continue;
            OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
            newInstruction.setAssociatedInstruction(associatedInstruction != null ? associatedInstruction : instruction);
        }
    }

    @Nullable
    public MultiMap<OCInstruction.InstructionKind, OCInstruction> getInstructions(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCControlFlowGraph.$$$reportNull$$$0(18);
        }
        return (MultiMap)this.myInstructions.get(symbol);
    }

    public Set<OCInstruction> getAllInstructions() {
        return this.myAllInstructions;
    }

    public OCInstruction getDeclaratorInstruction(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCControlFlowGraph.$$$reportNull$$$0(19);
        }
        return this.myDeclarators.get(symbol);
    }

    public Set<OCSymbol> getLocalSymbols() {
        return this.myDeclarators.keySet();
    }

    public Set<OCSymbol> getClosureSymbols() {
        return this.myClosureVariables.keySet();
    }

    public OCControlFlowGraph getClosureVariableDeclaratorGraph(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCControlFlowGraph.$$$reportNull$$$0(20);
        }
        return this.myClosureVariables.get(symbol);
    }

    @NotNull
    public PsiElement getCodeFragment() {
        PsiElement psiElement = this.myCodeFragment;
        if (psiElement == null) {
            OCControlFlowGraph.$$$reportNull$$$0(21);
        }
        return psiElement;
    }

    @Nullable
    public OCControlFlowGraph getParentGraph() {
        return this.myParentGraph;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<CFG>\n");
        String fileText = this.myCodeFragment.getContainingFile().getText();
        for (OCNode node : this.myNodes) {
            String nodeName = "node";
            if (node == this.myStartNode) {
                nodeName = "start-node";
            } else if (this.myExitNodes.contains(node)) {
                nodeName = "exit-node";
            }
            result.append("  <").append(nodeName).append(" id=\"").append(node.getIndex()).append("\">\n");
            OCElementsRange range = node.getRange();
            if (range != null) {
                TextRange textRange = range.getTextRange();
                result.append(fileText.substring(textRange.getStartOffset(), textRange.getEndOffset()).trim()).append("\n");
            }
            if (node.getJumpTargets() != null) {
                for (OCNode target : node.getJumpTargets()) {
                    result.append("    <target node-id=\"").append(target.getIndex()).append("\"/>\n");
                }
            }
            result.append("  </").append(nodeName).append(">\n");
        }
        result.append("</CFG>\n");
        return result.toString();
    }

    public boolean hasInstructionsInParentGraph(@NotNull OCSymbol symbol, OCInstruction.InstructionKind ... kinds) {
        OCControlFlowGraph parentCfg;
        if (symbol == null) {
            OCControlFlowGraph.$$$reportNull$$$0(22);
        }
        if ((parentCfg = this.getClosureVariableDeclaratorGraph(symbol)) == null) {
            return false;
        }
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = parentCfg.getInstructions(symbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction.InstructionKind kind : kinds) {
            for (OCInstruction instruction : instructions.get((Object)kind)) {
                OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
                if (associatedInstruction != null && associatedInstruction.getNode().getGraph() == this) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 12: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartNode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getExitNodes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastAddedNode";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 21: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setStartNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addExitNode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousNonEmptyNode";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addInstruction";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addInstructions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getInstructions";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaratorInstruction";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getClosureVariableDeclaratorGraph";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "hasInstructionsInParentGraph";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

