/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCDataFlowAlgorithm {
    protected OCControlFlowGraph myCfg;
    protected boolean[] myProcessedNodes;

    protected OCDataFlowAlgorithm(OCControlFlowGraph cfg) {
        this.myCfg = cfg;
        this.myProcessedNodes = new boolean[this.myCfg.getNumOfNodes()];
    }

    public abstract void process();

    protected void traverse(@NotNull OCNode node, @Nullable OCSymbol symbol, @Nullable OCInstruction endInstruction, boolean isForward) {
        if (node == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(0);
        }
        if (this.isNodeProcessed(node, symbol)) {
            return;
        }
        this.markNodeAsProcessed(node, symbol);
        if (!this.processNode(node, symbol, isForward, null, endInstruction)) {
            return;
        }
        List<OCNode> jumpTargets = this.getJumpTargets(node, isForward);
        if (jumpTargets != null) {
            for (OCNode target : jumpTargets) {
                this.traverse(target, symbol, endInstruction, isForward);
            }
        } else if (!this.myCfg.getExitNodes().contains(node)) {
            this.processDeadEnd(node);
        }
        this.nodeProcessed(node);
    }

    protected void traverse(@NotNull OCInstruction instruction, @Nullable OCSymbol symbol, boolean isForward) {
        OCNode node;
        if (instruction == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(1);
        }
        if (!this.processNode(node = instruction.getNode(), symbol, isForward, instruction, null)) {
            return;
        }
        List<OCNode> jumpTargets = this.getJumpTargets(node, isForward);
        if (jumpTargets != null) {
            for (OCNode targetNode : jumpTargets) {
                this.traverse(targetNode, symbol, instruction, isForward);
            }
        }
    }

    protected void traverseFromStart(@Nullable OCSymbol symbol) {
        this.traverse(this.myCfg.getStartNode(), symbol, null, true);
    }

    @NotNull
    protected Collection<OCInstruction> getStartInstructions() {
        ArrayList<OCInstruction> result = new ArrayList<OCInstruction>();
        for (OCInstruction instruction : this.myCfg.getAllInstructions()) {
            if (!this.isStartInstruction(instruction)) continue;
            result.add(instruction);
        }
        ArrayList<OCInstruction> arrayList = result;
        if (arrayList == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(3);
        }
        return instruction.getKind() != OCInstruction.InstructionKind.KILL;
    }

    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(4);
        }
        return false;
    }

    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(5);
        }
        return false;
    }

    protected boolean processInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(6);
        }
        return this.acceptsInstruction(instruction);
    }

    protected boolean processNode(@NotNull OCNode node, @Nullable OCSymbol symbol, boolean isForward, @Nullable OCInstruction startInstruction, @Nullable OCInstruction endInstruction) {
        List instructions;
        if (node == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(7);
        }
        if ((instructions = node.getInstructions()) == null || symbol == null) {
            return true;
        }
        boolean afterInstruction = startInstruction == null;
        for (OCInstruction instruction : isForward ? instructions : ContainerUtil.reverse(instructions)) {
            if (instruction.getSymbolOffset() == symbol.getComplexOffset()) {
                if (startInstruction == instruction) {
                    afterInstruction = true;
                } else if (afterInstruction && !this.processInstruction(instruction)) {
                    return false;
                }
            }
            if (instruction != endInstruction) continue;
            break;
        }
        return true;
    }

    protected boolean isProcessed(@NotNull OCInstruction instruction, boolean isForward) {
        OCNode node;
        List instructions;
        if (instruction == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(8);
        }
        if ((instructions = (node = instruction.getNode()).getInstructions()) == null) {
            return this.isNodeProcessed(node, instruction.getSymbol());
        }
        boolean beforeInstruction = false;
        for (OCInstruction prevInstruction : isForward ? ContainerUtil.reverse(instructions) : instructions) {
            if (prevInstruction.getSymbolOffset() != instruction.getSymbolOffset()) continue;
            if (prevInstruction == instruction) {
                beforeInstruction = true;
                continue;
            }
            if (!beforeInstruction) continue;
            if (this.isStartInstruction(prevInstruction)) {
                return true;
            }
            if (this.acceptsInstruction(prevInstruction)) continue;
            return false;
        }
        return this.isNodeProcessed(node, instruction.getSymbol());
    }

    @NotNull
    protected List<PsiElement> getReachableElements(boolean isForward, @NotNull OCSymbol symbol, boolean nonReachable) {
        if (symbol == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(9);
        }
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = this.myCfg.getInstructions(symbol);
        if (instructions == null) {
            ArrayList<PsiElement> arrayList = result;
            if (arrayList == null) {
                OCDataFlowAlgorithm.$$$reportNull$$$0(10);
            }
            return arrayList;
        }
        for (OCInstruction instruction : instructions.values()) {
            PsiElement element;
            if (!this.isEndInstruction(instruction) || !(nonReachable ^ this.isProcessed(instruction, isForward)) || (element = this.getElementFromInstruction(instruction)) == null) continue;
            result.add(element);
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    @Nullable
    protected PsiElement getElementFromInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(12);
        }
        return instruction.getRValue();
    }

    @Nullable
    protected List<OCNode> getJumpTargets(@NotNull OCNode node, boolean isForward) {
        if (node == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(13);
        }
        return isForward ? node.getJumpTargets() : node.getJumpSources();
    }

    protected void nodeProcessed(@NotNull OCNode node) {
        if (node == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(14);
        }
    }

    protected void processDeadEnd(@NotNull OCNode node) {
        if (node == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(15);
        }
    }

    protected boolean isNodeProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        if (node == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(16);
        }
        return this.myProcessedNodes[node.getIndex()];
    }

    protected void markNodeAsProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        if (node == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(17);
        }
        this.myProcessedNodes[node.getIndex()] = true;
    }

    protected void clearProcessedNodes() {
        for (int i = 0; i < this.myCfg.getNumOfNodes(); ++i) {
            this.myProcessedNodes[i] = false;
        }
    }

    protected static List<OCElementsRange> getRanges(@NotNull List<OCNode> nodes, boolean mergeRanges) {
        if (nodes == null) {
            OCDataFlowAlgorithm.$$$reportNull$$$0(18);
        }
        List<OCElementsRange> rawRanges = ContainerUtil.mapNotNull(nodes, node -> node.getRange());
        return mergeRanges ? OCElementsRange.mergeRanges(rawRanges) : rawRanges;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCDataFlowAlgorithm";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCDataFlowAlgorithm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartInstructions";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachableElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "traverse";
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isStartInstruction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isEndInstruction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processInstruction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isProcessed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getReachableElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromInstruction";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getJumpTargets";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "nodeProcessed";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDeadEnd";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isNodeProcessed";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markNodeAsProcessed";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

